/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.architecturalview;

import com.hello2morrow.sonargraph.core.model.path.ArchitecturalViewsDirectory;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectory;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.ArchitecturalViewPersistenceMessageCause;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;

public final class SessionToArchitecturalViewMigration {
    private static final String SESSIONS = "./Sessions";

    private SessionToArchitecturalViewMigration() {
    }

    private static void removeRecursively(String directoryPath) throws IOException {
        assert (directoryPath != null && directoryPath.length() > 0) : "Parameter 'directoryPath' of method 'removeRecursively' must not be empty";
        Path directory = Paths.get(directoryPath, new String[0]);
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void migrate(SoftwareSystemDirectory systemDirectory, ArchitecturalViewsDirectory targetDirectory, OperationResult result) {
        assert (systemDirectory != null) : "Parameter 'systemDirectory' of method 'migrate' must not be null";
        assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'migrate' must not be null";
        assert (result != null) : "Parameter 'result' of method 'migrate' must not be null";
        TFile sessionsDirectory = new TFile((File)systemDirectory.getDirectoryFile(), SESSIONS);
        if (!sessionsDirectory.exists()) {
            return;
        }
        TFile[] files = sessionsDirectory.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        HashMap<TFile, String> successfullyMigrated = new HashMap<TFile, String>();
        int numberOfXmlFiles = 0;
        TFile[] tFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String nextFileName;
            TFile nextFile = tFileArray[n2];
            if (!nextFile.isDirectory() && (nextFileName = nextFile.getName()).endsWith(".xml")) {
                ++numberOfXmlFiles;
                SessionToArchitecturalViewMigration.migrateContent(nextFile, nextFileName, successfullyMigrated, result);
            }
            ++n2;
        }
        if (successfullyMigrated.isEmpty()) {
            return;
        }
        OperationResult enforce = new OperationResult("Create architectural views target directory");
        targetDirectory.enforceExistence(enforce);
        int numberOfMigratedFiles = 0;
        if (enforce.isSuccess()) {
            TFile parentDirectory = targetDirectory.getDirectoryFile();
            for (Map.Entry nextEntry : successfullyMigrated.entrySet()) {
                if (!SessionToArchitecturalViewMigration.writeMigratedContent(parentDirectory, (TFile)nextEntry.getKey(), (String)nextEntry.getValue(), result)) continue;
                ++numberOfMigratedFiles;
            }
        } else {
            result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.UNABLE_TO_MIGRATE_SESSION_FILE_TO_ARCHTECTURAL_VIEW_FILE, "Failed to migrate " + successfullyMigrated.size() + "' session file(s) - unable to create target directory '" + targetDirectory.getName() + "'.", new Object[0]);
        }
        if (numberOfXmlFiles == numberOfMigratedFiles) {
            try {
                SessionToArchitecturalViewMigration.removeRecursively(sessionsDirectory.getAbsolutePath());
                TrueZipFacade.clear((TFile)sessionsDirectory);
            }
            catch (IOException e) {
                result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.UNABLE_TO_DELETE_SESSIONS_DIRECORY, (Throwable)e, "Exception caught trying to delete directory '" + String.valueOf(sessionsDirectory.getAbsoluteFile()) + "'.", new Object[0]);
            }
        } else {
            result.addInfo((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.NOT_ALL_SESSION_FILES_HAVE_BEEN_MIGRATED_TO_ARCHTECTURAL_VIEW_FILES, numberOfXmlFiles - numberOfMigratedFiles + "file(s) from your directory './Sessions' could not be migrated.\nConsider checking them.");
        }
        TrueZipFacade.sync((TFile)sessionsDirectory);
        TrueZipFacade.sync((TFile)targetDirectory.getDirectoryFile());
    }

    private static void migrateContent(TFile file, String fileName, Map<TFile, String> successfullyMigrated, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'migrateContent' must not be null";
        assert (fileName != null) : "Parameter 'fileName' of method 'migrateContent' must not be null";
        assert (successfullyMigrated != null) : "Parameter 'successfullyMigrated' of method 'migrateContent' must not be null";
        assert (result != null) : "Parameter 'result' of method 'migrateContent' must not be null";
        try {
            String nextContent = FileUtility.getFileContent((TFile)file);
            if (nextContent.indexOf("<session") != -1) {
                String nextMigratedContent = nextContent.replaceAll("<session", "<architecturalView");
                nextMigratedContent = nextMigratedContent.replaceAll("</session", "</architecturalView");
                nextMigratedContent = nextMigratedContent.replaceAll("<path>Session:", "<path>");
                nextMigratedContent = nextMigratedContent.replaceAll("targetParent=\"Session\"", "");
                nextMigratedContent = nextMigratedContent.replaceAll("targetParent=\"Session:", "targetParent=\"");
                nextMigratedContent = nextMigratedContent.replaceAll("<path>", "<element>");
                nextMigratedContent = nextMigratedContent.replaceAll("</path>", "</element>");
                nextMigratedContent = nextMigratedContent.replaceAll("path=\"", "element=\"");
                nextMigratedContent = nextMigratedContent.replaceAll("xsi:type=\"xsdCreateSingleArtifactOperation\"", "xsi:type=\"xsdCreateArtifactOperation\"");
                nextMigratedContent = nextMigratedContent.replaceAll("xsi:type=\"xsdCreateSingleArtifactFromElementsOperation\"", "xsi:type=\"xsdCreateArtifactFromElementsOperation\"");
                nextMigratedContent = nextMigratedContent.replaceAll("xsi:type=\"xsdEditSingleArtifactOperation\"", "xsi:type=\"xsdEditArtifactOperation\"");
                nextMigratedContent = nextMigratedContent.replaceAll("xsi:type=\"xsdCreateMultipleArtifactsForElementsOperation\"", "xsi:type=\"xsdCreateArtifactsForElementsOperation\"");
                nextMigratedContent = nextMigratedContent.replaceAll("xsi:type=\"xsdEditMultipleArtifactsOperation\"", "xsi:type=\"xsdEditArtifactsOperation\"");
                successfullyMigrated.put(file, nextMigratedContent);
            } else {
                result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.UNABLE_TO_MIGRATE_SESSION_FILE_TO_ARCHTECTURAL_VIEW_FILE, "Ignoring '" + fileName + "' - XML 'session' root not found", new Object[0]);
            }
        }
        catch (IOException e) {
            result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.UNABLE_TO_MIGRATE_SESSION_FILE_TO_ARCHTECTURAL_VIEW_FILE, (Throwable)e, "Exception caught during migration of '" + fileName + "'", new Object[0]);
        }
    }

    private static boolean writeMigratedContent(TFile parentDirectory, TFile sessionFile, String content, OperationResult result) {
        assert (parentDirectory != null) : "Parameter 'parentDirectory' of method 'writeMigratedContent' must not be null";
        assert (sessionFile != null) : "Parameter 'sessionFile' of method 'writeMigratedContent' must not be null";
        assert (content != null) : "Parameter 'content' of method 'writeMigratedContent' must not be null";
        assert (result != null) : "Parameter 'result' of method 'writeMigratedContent' must not be null";
        TFile targetArchitecturalViewFile = new TFile((File)parentDirectory, sessionFile.getName());
        boolean success = false;
        if (targetArchitecturalViewFile.exists()) {
            result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.ARCHTECTURAL_VIEW_TARGET_FILE_ALREADY_EXISTS, "Unable to migrate session file '" + sessionFile.getAbsolutePath() + "', target file '" + targetArchitecturalViewFile.getAbsolutePath() + "' already exists.", new Object[0]);
        } else {
            try {
                FileUtility.writeFileContent((String)content, (TFile)targetArchitecturalViewFile);
                result.addInfo((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.SESSION_FILE_MIGRATED_TO_ARCHTECTURAL_VIEW_FILE, "Session file '" + String.valueOf(sessionFile) + "' successfully migrated.");
                success = true;
                try {
                    sessionFile.rm();
                    TrueZipFacade.clear((TFile)sessionFile);
                }
                catch (IOException e) {
                    result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.UNABLE_TO_DELETE_MIGRATE_SESSION_FILE, (Throwable)e, "Exception caught trying to delete migrated file '" + sessionFile.getAbsolutePath() + "'.", new Object[0]);
                }
            }
            catch (IOException e) {
                result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.UNABLE_TO_MIGRATE_SESSION_FILE_TO_ARCHTECTURAL_VIEW_FILE, (Throwable)e, "Exception caught trying to write migrated content '" + sessionFile.getAbsolutePath() + "'.", new Object[0]);
            }
        }
        return success;
    }
}

