/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.dynamic;

import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathType;

public final class RootPathInfo {
    private final String m_path;
    private final RootPathType m_type;
    private final boolean m_isGenerated;

    public RootPathInfo(String absolutePath, RootPathType type) {
        this(absolutePath, type, false);
    }

    public RootPathInfo(String absolutePath, RootPathType type, boolean isGenerated) {
        assert (absolutePath != null && absolutePath.length() > 0) : "Parameter 'absolutePath' of method 'RootPathInfo' must not be empty";
        assert (type != null) : "Parameter 'type' of method 'RootPathInfo' must not be null";
        this.m_path = absolutePath;
        this.m_type = type;
        this.m_isGenerated = isGenerated;
    }

    public String getPath() {
        return this.m_path;
    }

    public boolean isGenerated() {
        return this.m_isGenerated;
    }

    public RootPathType getType() {
        return this.m_type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_path.hashCode();
        result = 31 * result + this.m_type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RootPathInfo other = (RootPathInfo)obj;
        if (!this.m_type.equals((Object)other.m_type)) {
            return false;
        }
        return this.m_path.equals(other.m_path);
    }

    public String toString() {
        return "RootPathInfo [path=" + this.m_path + ", type=" + String.valueOf((Object)this.m_type) + "]";
    }

    public RootPathInfo copy() {
        return new RootPathInfo(this.m_path, this.m_type);
    }
}

