/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.integration.access.model.IElement;
import com.hello2morrow.sonargraph.integration.access.model.Priority;
import com.hello2morrow.sonargraph.integration.access.model.RefactoringStatus;

public final class SystemDiffUtility {
    private SystemDiffUtility() {
    }

    public static IDiffElement.Change calculateChange(IDiffElement element, IDiffElement.Change change) {
        assert (element != null && element instanceof NamedElement) : "Unexpected class in method 'calculateChange': " + String.valueOf(element);
        if (change == IDiffElement.Change.ADDED || change == IDiffElement.Change.REMOVED) {
            return change;
        }
        return SystemDiffUtility.anyChildrenChanged(element) ? IDiffElement.Change.MODIFIED : IDiffElement.Change.UNMODIFIED;
    }

    static boolean anyChildrenChanged(IDiffElement element) {
        return ((NamedElement)((Object)element)).getChildren(IDiffElement.class).stream().anyMatch(c -> c.getChange() != IDiffElement.Change.UNMODIFIED);
    }

    static String getPresentationNameForElement(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof IStandardEnumeration) {
            return ((IStandardEnumeration)element).getPresentationName();
        }
        if (element instanceof NamedElement) {
            return ((NamedElement)element).getPresentationName(true);
        }
        if (element instanceof IElement) {
            return ((IElement)element).getPresentationName();
        }
        return element.toString();
    }

    public static String createChangeDetails(String baseline, String current, IDiffElement.Change change) {
        assert (baseline != null) : "Parameter 'baseline' of method 'createChangeDetails' must not be null";
        assert (current != null) : "Parameter 'current' of method 'createChangeDetails' must not be null";
        assert (change != null) : "Parameter 'change' of method 'createChangeDetails' must not be null";
        StringBuilder result = new StringBuilder();
        String convertedBaseline = baseline.replace('\n', ' ');
        String convertedCurrent = current.replace('\n', ' ');
        switch (change) {
            case RESOLUTION_ADDED: 
            case RESOLUTION_REMOVED: 
            case UNMODIFIED: {
                result.append(" ").append(convertedBaseline);
                break;
            }
            case ADDED: {
                result.append("[ ] -> ").append(convertedCurrent);
                break;
            }
            case REMOVED: {
                result.append(" ").append(convertedBaseline).append(" -> [ ]");
                break;
            }
            case WORSENED: 
            case MODIFIED: 
            case IMPROVED: {
                result.append(convertedBaseline);
                result.append(" -> ").append(convertedCurrent);
            }
        }
        return result.toString();
    }

    public static com.hello2morrow.sonargraph.core.model.element.Priority convertBaselinePriority(Priority priority) {
        assert (priority != null) : "Parameter 'priority' of method 'convertBaselinePriority' must not be null";
        switch (priority) {
            case HIGH: {
                return com.hello2morrow.sonargraph.core.model.element.Priority.HIGH;
            }
            case LOW: {
                return com.hello2morrow.sonargraph.core.model.element.Priority.LOW;
            }
            case MEDIUM: {
                return com.hello2morrow.sonargraph.core.model.element.Priority.MEDIUM;
            }
            case NONE: {
                return com.hello2morrow.sonargraph.core.model.element.Priority.NONE;
            }
        }
        assert (false) : "Unsupported priority: " + String.valueOf(priority);
        return null;
    }

    public static StatusInfo.Status convertBaselineRefactoringStatus(RefactoringStatus status) {
        assert (status != null) : "Parameter 'status' of method 'convertBaselineRefactoringStatus' must not be null";
        switch (status) {
            case APPLICABLE: {
                return StatusInfo.Status.APPLICABLE;
            }
            case LANGUAGE_NOT_AVAILABLE: {
                return StatusInfo.Status.LANGUAGE_NOT_AVAILABLE;
            }
            case NONE: {
                return StatusInfo.Status.NONE;
            }
            case NOT_APPLICABLE: {
                return StatusInfo.Status.NOT_APPLICABLE;
            }
            case NO_ELEMENT_MATCHED: {
                return StatusInfo.Status.NO_ELEMENT_MATCHED;
            }
            case PARTIALLY_APPLICABLE: {
                return StatusInfo.Status.PARTIALLY_APPLICABLE;
            }
            case POTENTIALLY_DONE: {
                return StatusInfo.Status.POTENTIALLY_DONE;
            }
            case TARGET_ROOT_DIRECTORY_NOT_FOUND: {
                return StatusInfo.Status.TARGET_ROOT_DIRECTORY_NOT_FOUND;
            }
        }
        assert (false) : "Unsupported refactoring status " + String.valueOf(status);
        return null;
    }
}

