/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.ISingleElementDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffUtility;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.integration.access.model.IElement;

public abstract class SingleElementDiff<B extends IElement, C extends Element>
extends NamedElement
implements ISingleElementDiff<B, C> {
    private final B m_baseline;
    private final C m_current;
    private final IDiffElement.Change m_change;

    protected SingleElementDiff(NamedElement parent, B baseline, C current, IDiffElement.Change change) {
        super(parent);
        assert (baseline != null || current != null) : "At least one of 'baseline', 'current' of method 'SingleElementDelta' must not be null";
        assert (change != null) : "Parameter 'change' of method 'SingleElementDelta' must not be null";
        this.m_baseline = baseline;
        this.m_current = current;
        this.m_change = change;
    }

    public final boolean persist() {
        return false;
    }

    @Override
    @Property
    public final IDiffElement.Change getChange() {
        return this.m_change;
    }

    @Override
    public IElement getBaselineElement() {
        return this.getBaseline();
    }

    @Override
    public final B getBaseline() {
        return this.m_baseline;
    }

    @Override
    public final NamedElement getElement() {
        return this;
    }

    @Override
    public Element getCurrentElement() {
        return this.getCurrent();
    }

    @Override
    public final C getCurrent() {
        return this.m_current;
    }

    @Override
    @Property
    public String getChangeDescription() {
        if (!this.providesChangeDescription()) {
            return "";
        }
        String baseline = SystemDiffUtility.getPresentationNameForElement(this.m_baseline);
        String current = SystemDiffUtility.getPresentationNameForElement(this.m_current);
        return SystemDiffUtility.createChangeDetails(baseline, current, this.getChange());
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(this.getPresentationName(true));
        result.append(" [");
        result.append(this.getChange().getPresentationName());
        result.append("] ");
        result.append(this.getChangeDescription());
        return result.toString();
    }
}

