/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IIssueFilter;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.IssueList;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.programming.IssueAffectedElementType;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionFilter;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.system.IssueDelta;
import com.hello2morrow.sonargraph.core.model.system.UsedIssueInfo;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VirtualModel
extends NamedElementContainer
implements IVirtualModel,
ElementWithIssues.IIssueManager,
ISoftwareSystemDefinitionElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualModel.class);
    private final Map<ElementWithIssues, List<Issue>> m_elementToIssues = new THashMap();

    public VirtualModel(NamedElement parent) {
        super(parent);
    }

    public abstract String getBasedOnVirtualModel();

    @Override
    public <T extends ElementWithIssues> T mapElement(T element) {
        return element;
    }

    @Override
    public <T extends ElementWithIssues> T getOriginal(T element) {
        assert (element != null) : "Parameter 'element' of method 'getOriginal' must not be null";
        return element;
    }

    @Override
    public RefactoringState getRefactoringState(Element element) {
        return RefactoringState.NONE;
    }

    @Override
    public void elementRemoved(Element element) {
        assert (element != null) : "Parameter 'element' of method 'elementRemoved' must not be null";
    }

    protected void issueRemoved(Issue issue) {
    }

    protected void issueAdded(Issue issue) {
    }

    protected void issuesAdded(Map<ElementWithIssues, List<Issue>> elementIssueMap) {
    }

    protected List<? extends VirtualModel> visitIssuesOfProductionVirtualModels() {
        return Collections.singletonList(this);
    }

    protected final synchronized Map<ElementWithIssues, List<Issue>> getElementWithIssues() {
        return this.m_elementToIssues;
    }

    protected final synchronized List<Issue> getRelevantIssues(Predicate<Issue> filter, Map<ElementWithIssues, List<Issue>> issues, boolean includingForDeletedElements, boolean includingExcluded, boolean includePreviewOnlyIssues) {
        assert (filter != null) : "Parameter 'filter' of method 'getRelevantIssues' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'getRelevantIssues' must not be null";
        if (!issues.isEmpty()) {
            ArrayList<Issue> relevantIssues = new ArrayList<Issue>();
            if (includingForDeletedElements) {
                for (List<Issue> nextIssues : this.m_elementToIssues.values()) {
                    for (Issue nextIssue : nextIssues) {
                        if (!includePreviewOnlyIssues && nextIssue.previewOnly() || !nextIssue.isValid() || !filter.test(nextIssue) || !includingExcluded && nextIssue.isExcluded()) continue;
                        relevantIssues.add(nextIssue);
                    }
                }
            } else {
                for (Map.Entry<ElementWithIssues, List<Issue>> nextEntry : this.m_elementToIssues.entrySet()) {
                    ElementWithIssues nextElement = nextEntry.getKey();
                    if (!nextElement.isValid()) continue;
                    if (nextElement.getRefactoringState().hasBeenDeleted()) {
                        for (Issue nextIssue : nextEntry.getValue()) {
                            if (!includePreviewOnlyIssues && nextIssue.previewOnly() || !nextIssue.isValid() || !nextIssue.getId().getCategory().isGenerated() || !filter.test(nextIssue) || !includingExcluded && nextIssue.isExcluded()) continue;
                            relevantIssues.add(nextIssue);
                        }
                        continue;
                    }
                    for (Issue nextIssue : nextEntry.getValue()) {
                        if (!includePreviewOnlyIssues && nextIssue.previewOnly() || !nextIssue.isValid() || !filter.test(nextIssue) || !includingExcluded && nextIssue.isExcluded()) continue;
                        relevantIssues.add(nextIssue);
                    }
                }
            }
            return relevantIssues;
        }
        return Collections.emptyList();
    }

    @Override
    public final synchronized void accept(IVirtualModel.IIssueVisitor issueVisitor) {
        assert (issueVisitor != null) : "Parameter 'issueVisitor' of method 'accept' must not be null";
        for (VirtualModel virtualModel : this.visitIssuesOfProductionVirtualModels()) {
            for (List<Issue> nextIssues : virtualModel.m_elementToIssues.values()) {
                for (Issue nextIssue : nextIssues) {
                    if (issueVisitor.visit(nextIssue)) continue;
                    return;
                }
            }
        }
    }

    @Override
    public final synchronized <T extends ElementWithIssues> void accept(T element, IVirtualModel.IIssueVisitor issueVisitor) {
        assert (element != null) : "Parameter 'element' of method 'accept' must not be null";
        assert (issueVisitor != null) : "Parameter 'issueVisitor' of method 'accept' must not be null";
        for (VirtualModel virtualModel : this.visitIssuesOfProductionVirtualModels()) {
            List<Issue> nextIssues = virtualModel.m_elementToIssues.get(element.getOriginal());
            if (nextIssues == null) continue;
            for (Issue nextIssue : nextIssues) {
                if (issueVisitor.visit(nextIssue)) continue;
                return;
            }
        }
    }

    public synchronized Collection<Issue> getAllIssues(boolean includingForDeletedElements, boolean includingExcluded, boolean includePreviewOnly) {
        return this.getRelevantIssues(issue -> true, this.m_elementToIssues, includingForDeletedElements, includingExcluded, includePreviewOnly);
    }

    @Override
    public synchronized void addElementIssue(ElementWithIssues element, Issue issue) {
        assert (element != null) : "Parameter 'element' of method 'addElementIssue' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'addElementIssue' must not be null";
        List<Issue> issues = this.m_elementToIssues.get(element.getOriginal());
        if (issues == null) {
            issues = new ArrayList<Issue>(1);
            this.m_elementToIssues.put(element.getOriginal(), issues);
        }
        assert (!issues.contains(issue)) : "Issue already added: " + String.valueOf(issue) + " (" + String.valueOf(element) + ")";
        issues.add(issue);
        this.issueAdded(issue);
    }

    public synchronized void addElementIssues(Map<ElementWithIssues, List<Issue>> elementIssues) {
        assert (elementIssues != null && !elementIssues.isEmpty()) : "Parameter 'elementIssues' of method 'addElementIssues' must not be empty";
        for (Map.Entry<ElementWithIssues, List<Issue>> nextEntry : elementIssues.entrySet()) {
            ElementWithIssues original = nextEntry.getKey().getOriginal();
            List<Issue> issues = this.m_elementToIssues.get(original);
            if (issues == null) {
                this.m_elementToIssues.put(original, nextEntry.getValue());
                continue;
            }
            issues.addAll((Collection<Issue>)nextEntry.getValue());
        }
        this.issuesAdded(elementIssues);
    }

    protected final synchronized boolean removeElementIssue(ElementWithIssues element, Issue issue, boolean notify) {
        assert (element != null) : "Parameter 'element' of method 'removeElementIssue' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'removeElementIssue' must not be null";
        List<Issue> issues = this.m_elementToIssues.get(element.getOriginal());
        if (issues != null && issues.remove(issue)) {
            if (issues.size() == 0) {
                this.m_elementToIssues.remove(element.getOriginal());
            }
            if (notify) {
                this.issueRemoved(issue);
            }
            return true;
        }
        return false;
    }

    @Override
    public final synchronized void removeElementIssue(ElementWithIssues element, Issue issue) {
        assert (element != null) : "Parameter 'element' of method 'removeElementIssue' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'removeElementIssue' must not be null";
        if (!this.removeElementIssue(element, issue, true)) {
            LOGGER.warn("Issue to be removed not found: " + String.valueOf(issue.getId()) + " - requested from: " + ExceptionUtility.collectAll((Throwable)new Throwable()));
        }
    }

    @Override
    public final synchronized void removeIssues(IProviderId ... ids) {
        ArrayList<Issue> issuesRemoved = new ArrayList<Issue>();
        THashSet providers = new THashSet();
        THashSet deleted = new THashSet();
        Arrays.stream(ids).forEach(arg_0 -> VirtualModel.lambda$1((Set)providers, arg_0));
        for (Map.Entry<ElementWithIssues, List<Issue>> entry : this.m_elementToIssues.entrySet()) {
            Iterator<Issue> iter = entry.getValue().iterator();
            while (iter.hasNext()) {
                Issue next = iter.next();
                if (!providers.contains(next.getProvider())) continue;
                issuesRemoved.add(next);
                iter.remove();
            }
            if (!entry.getValue().isEmpty()) continue;
            deleted.add(entry.getKey());
        }
        deleted.forEach(d -> {
            List<Issue> list = this.m_elementToIssues.remove(d);
        });
        if (!issuesRemoved.isEmpty()) {
            this.issuesRemoved(issuesRemoved);
        }
    }

    @Override
    public synchronized boolean hasElementIssues(ElementWithIssues element, Severity severity) {
        assert (element != null) : "Parameter 'element' of method 'hasElementIssues' must not be null";
        assert (severity != null) : "Parameter 'severity' of method 'hasElementIssues' must not be null";
        List<Issue> issues = this.m_elementToIssues.get(element.getOriginal());
        if (issues == null || issues.isEmpty()) {
            return false;
        }
        for (Issue nextIssue : issues) {
            if (!nextIssue.getSeverity().equals((Object)severity) || nextIssue.isExcluded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final synchronized boolean hasUnresolvedErrorIssues(ElementWithIssues element) {
        for (Issue nextIssue : this.getAllElementIssues(element)) {
            if (nextIssue.getResolution() != null || nextIssue.previewOnly() || !nextIssue.getSeverity().equals((Object)Severity.ERROR)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final synchronized boolean hasUnresolvedWarningIssues(ElementWithIssues element) {
        for (Issue nextIssue : this.getAllElementIssues(element)) {
            if (nextIssue.getResolution() != null || nextIssue.previewOnly() || !nextIssue.getSeverity().equals((Object)Severity.WARNING)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean hasUnresolvedIssues(IssueCategory category) {
        assert (category != null) : "Parameter 'category' of method 'hasUnresolvedIssues' must not be null";
        for (List<Issue> nextIssueList : this.m_elementToIssues.values()) {
            for (Issue nextIssue : nextIssueList) {
                if (nextIssue.getResolution() != null || nextIssue.getId().getCategory() != category) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean hasElementIssues(ElementWithIssues element, IssueCategory category) {
        assert (element != null) : "Parameter 'element' of method 'hasElementIssues' must not be null";
        assert (category != null) : "Parameter 'category' of method 'hasElementIssues' must not be null";
        List<Issue> issues = this.m_elementToIssues.get(element.getOriginal());
        if (issues != null && !issues.isEmpty()) {
            for (Issue nextIssue : issues) {
                if (nextIssue.isExcluded() || !category.equals((Object)nextIssue.getId().getCategory())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean hasElementIssues(ElementWithIssues element, IIssueId ... issueIds) {
        assert (element != null) : "Parameter 'element' of method 'hasElementIssues' must not be null";
        List<Issue> issues = this.m_elementToIssues.get(element.getOriginal());
        if (issueIds.length > 0 && issues != null && !issues.isEmpty()) {
            for (Issue nextIssue : issues) {
                if (nextIssue.isExcluded()) continue;
                IIssueId[] iIssueIdArray = issueIds;
                int n = issueIds.length;
                int n2 = 0;
                while (n2 < n) {
                    IIssueId nextIssueId = iIssueIdArray[n2];
                    if (nextIssueId == nextIssue.getId()) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        return issues != null && !issues.isEmpty();
    }

    public synchronized boolean nonExcludedNonPreviewIssuesWithoutResolutionsExist() {
        for (List<Issue> nextIssueList : this.m_elementToIssues.values()) {
            for (Issue nextIssue : nextIssueList) {
                if (!nextIssue.isValid() || nextIssue.previewOnly() || nextIssue.isExcluded() || nextIssue.getResolution() != null) continue;
                return true;
            }
        }
        return false;
    }

    protected final synchronized List<Issue> getRelevantIssues(Predicate<Issue> filter, ElementWithIssues element, List<Issue> issues) {
        assert (filter != null) : "Parameter 'filter' of method 'getRelevantIssues' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getRelevantIssues' must not be null";
        if (issues != null && !issues.isEmpty()) {
            if (element.getRefactoringState().hasBeenDeleted()) {
                ArrayList<Issue> relevantIssues = new ArrayList<Issue>();
                for (Issue nextIssue : issues) {
                    if (!nextIssue.getId().getCategory().isGenerated() || nextIssue.isExcluded() || !filter.test(nextIssue)) continue;
                    relevantIssues.add(nextIssue);
                }
                return relevantIssues;
            }
            return issues.stream().filter(issue -> !issue.isExcluded()).filter(filter).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected synchronized List<Issue> getAllElementIssues(ElementWithIssues element) {
        assert (element != null) : "Parameter 'element' of method 'getAllElementIssues' must not be null";
        return this.getRelevantIssues(issue -> true, element, this.m_elementToIssues.get(element.getOriginal()));
    }

    @Override
    public final synchronized List<Issue> getElementIssues(ElementWithIssues element) {
        return this.getAllElementIssues(element);
    }

    public final synchronized void visitElementIssues(ElementWithIssues element, IVirtualModel.IIssueVisitor visitor) {
        assert (element != null) : "Parameter 'element' of method 'getElementIssues' must not be null";
        assert (visitor != null) : "Parameter 'visitor' of method 'getElementIssues' must not be null";
        for (Issue next : this.getAllElementIssues(element)) {
            if (visitor.visit(next)) continue;
            return;
        }
    }

    @Override
    public final synchronized List<Issue> getElementIssues(ElementWithIssues element, IIssueId ... issueIds) {
        assert (element != null) : "Parameter 'element' of method 'getElementIssues' must not be null";
        assert (issueIds != null && issueIds.length != 0) : "Parameter 'issueIds' of method 'getElementIssues' must not be empty";
        List<Issue> issues = this.getAllElementIssues(element);
        if (issues.isEmpty()) {
            return issues;
        }
        ArrayList<Issue> filteredIssues = new ArrayList<Issue>();
        for (Issue nextIssue : issues) {
            IIssueId nextIssueId = nextIssue.getId();
            IIssueId[] iIssueIdArray = issueIds;
            int n = issueIds.length;
            int n2 = 0;
            while (n2 < n) {
                IIssueId nextIssueIdToMatch = iIssueIdArray[n2];
                if (nextIssueId.equals(nextIssueIdToMatch)) {
                    filteredIssues.add(nextIssue);
                }
                ++n2;
            }
        }
        return filteredIssues;
    }

    @Override
    public final synchronized Issue getElementIssue(ElementWithIssues element, IIssueId issueId) {
        List<Issue> result = this.getElementIssues(element, issueId);
        if (result.isEmpty()) {
            return null;
        }
        assert (result.size() == 1);
        return (Issue)result.iterator().next();
    }

    @Override
    public synchronized void removeElementIssues(ElementWithIssues element) {
        assert (element != null) : "Parameter 'element' of method 'removeIssues' must not be null";
        List<Issue> removed = this.m_elementToIssues.remove(element.getOriginal());
        if (removed != null) {
            for (Issue nextIssue : removed) {
                this.issueRemoved(nextIssue);
            }
        }
    }

    public final synchronized void removeElementIssues(Predicate<Issue> predicate) {
        assert (predicate != null) : "Parameter 'predicate' of method 'removeElementIssues' must not be null";
        ArrayList<Issue> removed = new ArrayList<Issue>();
        Iterator<Map.Entry<ElementWithIssues, List<Issue>>> elementToIssuesIterator = this.m_elementToIssues.entrySet().iterator();
        while (elementToIssuesIterator.hasNext()) {
            Map.Entry<ElementWithIssues, List<Issue>> nextEntry = elementToIssuesIterator.next();
            List<Issue> nextIssueList = nextEntry.getValue();
            assert (!nextIssueList.isEmpty()) : "'nextIssueList' of method 'removeIssues' must not be empty";
            Iterator<Issue> nextIssueIterator = nextIssueList.iterator();
            while (nextIssueIterator.hasNext()) {
                Issue nextIssue = nextIssueIterator.next();
                if (!predicate.test(nextIssue)) continue;
                nextIssueIterator.remove();
                removed.add(nextIssue);
            }
            if (!nextIssueList.isEmpty()) continue;
            elementToIssuesIterator.remove();
        }
        for (Issue nextIssue : removed) {
            this.issueRemoved(nextIssue);
        }
    }

    @Override
    public synchronized void removeElementIssues(IIssueId ... issueIds) {
        assert (issueIds != null) : "Parameter 'issueIds' of method 'removeElementIssues' must not be null";
        if (issueIds.length > 0) {
            ArrayList<Issue> removed = new ArrayList<Issue>();
            Iterator<Map.Entry<ElementWithIssues, List<Issue>>> elementToIssuesIterator = this.m_elementToIssues.entrySet().iterator();
            while (elementToIssuesIterator.hasNext()) {
                Map.Entry<ElementWithIssues, List<Issue>> nextEntry = elementToIssuesIterator.next();
                List<Issue> nextIssueList = nextEntry.getValue();
                assert (!nextIssueList.isEmpty()) : "'nextIssueList' of method 'removeIssues' must not be empty";
                Iterator<Issue> nextIssueIterator = nextIssueList.iterator();
                while (nextIssueIterator.hasNext()) {
                    Issue nextIssue = nextIssueIterator.next();
                    IIssueId[] iIssueIdArray = issueIds;
                    int n = issueIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IIssueId nextIssueId = iIssueIdArray[n2];
                        if (nextIssue.getId().equals(nextIssueId)) {
                            nextIssueIterator.remove();
                            removed.add(nextIssue);
                        }
                        ++n2;
                    }
                }
                if (!nextIssueList.isEmpty()) continue;
                elementToIssuesIterator.remove();
            }
            for (Issue nextIssue : removed) {
                this.issueRemoved(nextIssue);
            }
        }
    }

    @Override
    public synchronized void removeElementIssues(ElementWithIssues element, IIssueId ... issueIds) {
        assert (element != null) : "Parameter 'element' of method 'removeElementIssues' must not be null";
        assert (issueIds != null) : "Parameter 'issueIds' of method 'removeElementIssues' must not be null";
        List<Issue> issues = this.m_elementToIssues.get(element.getOriginal());
        if (issues != null) {
            ArrayList<Issue> removed = new ArrayList<Issue>();
            Iterator<Issue> iterator = issues.iterator();
            while (iterator.hasNext()) {
                Issue nextIssue = iterator.next();
                IIssueId[] iIssueIdArray = issueIds;
                int n = issueIds.length;
                int n2 = 0;
                while (n2 < n) {
                    IIssueId id = iIssueIdArray[n2];
                    if (nextIssue.getId().equals(id)) {
                        iterator.remove();
                        removed.add(nextIssue);
                    }
                    ++n2;
                }
            }
            if (issues.isEmpty()) {
                this.m_elementToIssues.remove(element.getOriginal());
            }
            for (Issue nextIssue : removed) {
                this.issueRemoved(nextIssue);
            }
        }
    }

    synchronized void removeIssuesOfInvalidElements() {
        Iterator<Map.Entry<ElementWithIssues, List<Issue>>> issuesIterator = this.m_elementToIssues.entrySet().iterator();
        ArrayList removed = new ArrayList();
        while (issuesIterator.hasNext()) {
            Map.Entry<ElementWithIssues, List<Issue>> nextEntry = issuesIterator.next();
            if (nextEntry.getKey().isValid()) continue;
            removed.addAll(nextEntry.getValue());
            issuesIterator.remove();
        }
        for (Issue nextIssue : removed) {
            this.issueRemoved(nextIssue);
        }
    }

    public <T extends Resolution> List<T> getResolutions(Class<T> resolutionClass) {
        assert (resolutionClass != null) : "Parameter 'resolutionClass' of method 'getResolutions' must not be null";
        return Collections.emptyList();
    }

    public final <T extends Resolution> List<T> getResolutions(Class<T> resolutionClass, ResolutionFilter filter) {
        assert (resolutionClass != null) : "Parameter 'resolutionClass' of method 'getResolutions' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'getResolutions' must not be null";
        List<T> resolutions = this.getResolutions(resolutionClass);
        if (resolutions.isEmpty()) {
            return resolutions;
        }
        ArrayList<Resolution> filteredResolutions = new ArrayList<Resolution>();
        for (Resolution resolution : resolutions) {
            if (!filter.accept(resolution)) continue;
            filteredResolutions.add(resolution);
        }
        return filteredResolutions;
    }

    public final UsedIssueInfo getUsedIssueInfo() {
        return new UsedIssueInfo(this.getAllIssues(false, false, false), IssueAffectedElementType.values());
    }

    @Override
    public final IssueList getIssueList(IIssueFilter filter) {
        return this.getIssueList(filter, false);
    }

    public final IssueList getIssueList(IIssueFilter filter, boolean includePreviewOnlyIssues) {
        assert (filter != null) : "Parameter 'filter' of method 'getIssueList' must not be null";
        IssueList issueList = new IssueList(filter);
        for (Issue nextIssue : this.getAllIssues(false, false, includePreviewOnlyIssues)) {
            issueList.processIssue(nextIssue);
        }
        return issueList;
    }

    public final IssueList getIssueList(Severity severity, IIssueId ... ids) {
        return this.getIssueList(severity, false, ids);
    }

    public final IssueList getIssueList(Severity severity, boolean includePreviewOnly, IIssueId ... ids) {
        IssueFilter filter = new IssueFilter(new IStandardEnumeration[0]);
        filter.add(ResolutionMode.NONE);
        filter.add(ResolutionMode.TASK);
        filter.add(ResolutionMode.IGNORE);
        if (severity != null) {
            filter.add(severity);
        }
        if (ids != null && ids.length > 0) {
            IIssueId[] iIssueIdArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                IIssueId next = iIssueIdArray[n2];
                filter.add(next);
                ++n2;
            }
        }
        return this.getIssueList(filter, includePreviewOnly);
    }

    public abstract void refactoringsModified();

    public abstract void issuesAdded(List<Issue> var1);

    public abstract void issuesRemoved(List<Issue> var1);

    public abstract boolean isModifiable();

    public abstract IssueDelta consumeIssueDelta();

    public abstract boolean haveIssuesBeenModified();

    public abstract boolean consumeRefactoringsModified();

    public abstract boolean haveRefactoringsBeenModified();

    private static /* synthetic */ void lambda$1(Set set, IProviderId id) {
        boolean bl = set.add(id);
    }
}

