/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureAssignmentElement;
import com.hello2morrow.sonargraph.core.model.architecture.WorkspaceRootComponentContainer;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.ILogicalElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalRoot;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.PhysicalImpactDependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.system.OneEndpoint;
import com.hello2morrow.sonargraph.core.model.system.TwoEndpoints;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhysicalImpactCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhysicalImpactCalculator.class);
    private static final Predicate<ProgrammingElement> PE = pe -> !pe.getRefactoringState().hasBeenDeleted();
    private static final Predicate<ParserDependency> PD_COMPILE_TIME_ONLY = pd -> pd.isCompileTimeDependency() && !pd.getRefactoringState().hasBeenDeleted();
    private static final Predicate<ParserDependency> PD = pd -> !pd.getRefactoringState().hasBeenDeleted();

    private PhysicalImpactCalculator() {
    }

    public static List<NamedElement> getPhysicalNamedElements(NamedElement element) {
        List<NamedElement> physicalNamedElements;
        assert (element != null) : "Parameter 'element' of method 'getPhysicalNamedElements' must not be null";
        if (element instanceof LogicalRoot) {
            NamedElement physicalElement = ((LogicalRoot)element).getPhysicalElement();
            physicalNamedElements = physicalElement == null ? Collections.emptyList() : Collections.singletonList(physicalElement);
        } else if (element instanceof LogicalNamespace) {
            List<LogicalNamespace.ISourceNamespace> sourceNamespaces = ((LogicalNamespace)element).getRepresentativeSourceNamespaces();
            physicalNamedElements = new ArrayList(sourceNamespaces.size());
            for (LogicalNamespace.ISourceNamespace iSourceNamespace : sourceNamespaces) {
                if (iSourceNamespace.getNamedElement().isExcluded()) continue;
                physicalNamedElements.add(iSourceNamespace.getNamedElement());
            }
        } else if (element instanceof LogicalProgrammingElement) {
            List<? extends ProgrammingElement> logicalGroup = ((LogicalProgrammingElement)element).getProgrammingElements();
            physicalNamedElements = new ArrayList(logicalGroup.size());
            for (ProgrammingElement programmingElement : logicalGroup) {
                if (programmingElement.isExcluded()) continue;
                physicalNamedElements.add(programmingElement);
            }
        } else {
            physicalNamedElements = element instanceof IArchitectureAssignmentElement ? Collections.singletonList(((IArchitectureAssignmentElement)((Object)element)).getRepresentedElement()) : Collections.singletonList(element);
        }
        return physicalNamedElements;
    }

    public static Set<ParserDependency> getParserDependencies(NamedElement element, boolean forceRecursive) {
        assert (element != null) : "Parameter 'element' of method 'getParserDependencies' must not be null";
        List<NamedElement> physicalNamedElements = PhysicalImpactCalculator.getPhysicalNamedElements(element);
        THashSet allNodes = new THashSet();
        NamedElement workspace = null;
        THashSet parentModules = new THashSet();
        for (NamedElement next : physicalNamedElements) {
            Module parentModule = next.getParent(Module.class, new Class[0]);
            assert (parentModule != null) : "'parentModule' of method 'getParserDependencies' must not be null";
            parentModules.add(parentModule);
            if (workspace != null) continue;
            workspace = parentModule.getParent(Workspace.class, new Class[0]);
            assert (workspace != null) : "'workspace' of method 'getParserDependencies' must not be null";
        }
        assert (workspace != null) : "'workspace' of method 'getParserDependencies' must not be null";
        boolean flat = forceRecursive ? false : PhysicalImpactDependencyEndpointCollector.isRecursiveElement(element);
        THashSet childProgrammingElements = new THashSet();
        for (NamedElement nextPhysicalNamedElement : physicalNamedElements) {
            allNodes.add(nextPhysicalNamedElement);
            if (flat) {
                childProgrammingElements.addAll(PhysicalImpactDependencyEndpointCollector.getProgrammingElementsFlat(nextPhysicalNamedElement));
                continue;
            }
            childProgrammingElements.addAll(nextPhysicalNamedElement.getChildrenRecursively(ProgrammingElement.class, new Class[0]));
        }
        allNodes.addAll(workspace.getChildren(Module.class));
        ParserDependencyNodeAdapterSet nodeAdapterSet = new ParserDependencyNodeAdapterSet((IWorkerContext)DefaultWorkerContext.INSTANCE, (Collection<? extends NamedElement>)allNodes, new OneEndpoint(element, (Set<Module>)parentModules, physicalNamedElements, (Set<ProgrammingElement>)childProgrammingElements, flat), PE, PD_COMPILE_TIME_ONLY);
        THashSet parserDependencies = new THashSet();
        for (ParserDependencyNodeAdapter nextNode : nodeAdapterSet.getNodes()) {
            for (ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> nextEdge : nextNode.getOutgoingEdges()) {
                parserDependencies.addAll(nextEdge.getDependencies());
            }
        }
        return parserDependencies;
    }

    public static List<Pair<NamedElement, NamedElement>> createCombinations(List<NamedElement> froms, List<NamedElement> tos) {
        assert (froms != null) : "Parameter 'froms' of method 'createCombinations' must not be null";
        assert (tos != null) : "Parameter 'tos' of method 'createCombinations' must not be null";
        if (!froms.isEmpty() && !tos.isEmpty()) {
            ArrayList<Pair<NamedElement, NamedElement>> combinations = new ArrayList<Pair<NamedElement, NamedElement>>(froms.size() * tos.size());
            for (NamedElement nextFrom : froms) {
                for (NamedElement nextTo : tos) {
                    combinations.add((Pair<NamedElement, NamedElement>)new Pair((Object)nextFrom, (Object)nextTo));
                }
            }
            return combinations;
        }
        return Collections.emptyList();
    }

    private static List<NamedElement> getPhysicalNamedElementsForEndpoint(NamedElement element) {
        List<NamedElement> physicalNamedElements;
        assert (element != null) : "Parameter 'element' of method 'getPhysicalNamedElementsForEndpoint' must not be null";
        if (element instanceof LogicalRoot) {
            NamedElement physicalElement = ((LogicalRoot)element).getPhysicalElement();
            physicalNamedElements = physicalElement == null ? Collections.emptyList() : Collections.singletonList(physicalElement);
        } else if (element instanceof LogicalNamespace) {
            List<LogicalNamespace.ISourceNamespace> targetNamespaces = ((LogicalNamespace)element).getRepresentativeSourceNamespaces();
            physicalNamedElements = new ArrayList(targetNamespaces.size());
            for (LogicalNamespace.ISourceNamespace next : targetNamespaces) {
                physicalNamedElements.add(next.getNamedElement());
            }
        } else if (element instanceof LogicalProgrammingElement) {
            List<? extends ProgrammingElement> targetLogicalGroup = ((LogicalProgrammingElement)element).getProgrammingElements();
            physicalNamedElements = new ArrayList<ProgrammingElement>(targetLogicalGroup);
        } else if (element instanceof ILogicalElement) {
            physicalNamedElements = Collections.emptyList();
        } else if (element instanceof Artifact) {
            Artifact artifact = (Artifact)element;
            List<IArchitectureAssignmentElement> assignmentElements = artifact.getChildren(IArchitectureAssignmentElement.class);
            physicalNamedElements = new ArrayList(assignmentElements.size());
            if (artifact.getDomain().isPhysical()) {
                for (IArchitectureAssignmentElement nextAssignmentElement : assignmentElements) {
                    NamedElement nextNamedElement = nextAssignmentElement.getRepresentedElement();
                    physicalNamedElements.add(nextNamedElement);
                }
            } else {
                for (IArchitectureAssignmentElement nextAssignmentElement : assignmentElements) {
                    NamedElement nextNamedElement = nextAssignmentElement.getRepresentedElement();
                    if (nextNamedElement instanceof WorkspaceRootComponentContainer) {
                        physicalNamedElements.add((NamedElement)((WorkspaceRootComponentContainer)nextNamedElement).getRepresentedElement());
                        continue;
                    }
                    if (nextNamedElement instanceof LogicalRoot) {
                        physicalNamedElements.add(((LogicalRoot)nextNamedElement).getPhysicalElement());
                        continue;
                    }
                    LOGGER.error("Unhandled logical element class: " + nextNamedElement.getClass().getSimpleName());
                }
            }
        } else {
            physicalNamedElements = Collections.singletonList(element);
        }
        return physicalNamedElements;
    }

    public static Set<ParserDependency> getParserDependencies(NamedElement from, NamedElement to, boolean firstDependencyOnly, boolean compileTimeOnly) {
        List<NamedElement> allTos;
        assert (from != null) : "Parameter 'from' of method 'getParserDependencies' must not be null";
        assert (to != null) : "Parameter 'to' of method 'getParserDependencies' must not be null";
        IDomainRoot.Domain fromDomain = from.getDomain();
        IDomainRoot.Domain toDomain = to.getDomain();
        if (fromDomain == null || toDomain == null || fromDomain.isLogical() != toDomain.isLogical()) {
            return Collections.emptySet();
        }
        boolean isLogical = fromDomain.isLogical();
        List<NamedElement> allFroms = PhysicalImpactCalculator.getPhysicalNamedElementsForEndpoint(from);
        List<Pair<NamedElement, NamedElement>> physicalFromTo = PhysicalImpactCalculator.createCombinations(allFroms, allTos = PhysicalImpactCalculator.getPhysicalNamedElementsForEndpoint(to));
        if (physicalFromTo.isEmpty()) {
            return Collections.emptySet();
        }
        boolean flat = PhysicalImpactDependencyEndpointCollector.isRecursiveElement(from) || PhysicalImpactDependencyEndpointCollector.isRecursiveElement(to);
        THashSet parserDependencies = new THashSet();
        for (Pair<NamedElement, NamedElement> nextPhysicalFromTo : physicalFromTo) {
            ParserDependencyNodeAdapterSet nodeAdapterSet;
            TwoEndpoints twoEndpoints;
            NamedElement nextTo;
            NamedElement nextFrom = (NamedElement)nextPhysicalFromTo.getFirst();
            if (nextFrom != (nextTo = (NamedElement)nextPhysicalFromTo.getSecond())) {
                twoEndpoints = new TwoEndpoints(nextFrom, nextTo, isLogical ? TwoEndpoints.Mode.EXTERNAL_BY_NAME : TwoEndpoints.Mode.EXTERNAL_BY_INSTANCE, flat, firstDependencyOnly);
                nodeAdapterSet = new ParserDependencyNodeAdapterSet(twoEndpoints, Arrays.asList(nextFrom, nextTo), twoEndpoints, PE, compileTimeOnly ? PD_COMPILE_TIME_ONLY : PD);
            } else {
                twoEndpoints = new TwoEndpoints(nextFrom, nextTo, isLogical ? TwoEndpoints.Mode.INTERNAL_BY_NAME : TwoEndpoints.Mode.INTERNAL_BY_INSTANCE, flat, firstDependencyOnly);
                nodeAdapterSet = new ParserDependencyNodeAdapterSet(twoEndpoints, Collections.singleton(nextFrom), twoEndpoints, PE, compileTimeOnly ? PD_COMPILE_TIME_ONLY : PD);
            }
            ParserDependencyNodeAdapter fromNodeAdapter = (ParserDependencyNodeAdapter)nodeAdapterSet.getNodeAdapterFor(nextFrom);
            Collection<ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>> edges = fromNodeAdapter.getOutgoingEdges();
            assert (edges.size() <= 1) : "No more than one edge expected";
            if (edges.size() == 1) {
                parserDependencies.addAll(edges.iterator().next().getDependencies());
            }
            if (twoEndpoints.hasBeenCanceled()) break;
        }
        return parserDependencies;
    }
}

