/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.EditableModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.IGroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.IScriptApi;
import com.hello2morrow.sonargraph.core.model.script.ScriptContent;
import com.hello2morrow.sonargraph.core.model.script.ScriptResultSet;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import de.schlichtherle.truezip.file.TFile;
import groovy.lang.Script;
import java.util.List;

public final class GroovyScript
extends EditableModifiableFile
implements IGroovyScript,
ISoftwareSystemDefinitionElement {
    private IScriptApi m_scriptApi;
    private ClassLoader m_classLoader;
    private Script m_compiledScript;
    private boolean m_isExecutable;
    private IGroovyScript.Status m_status;

    public GroovyScript(NamedElement parent, TFile file, ScriptContent scriptContent, IModifiablePathListener listener) {
        super(parent, file, listener);
        assert (scriptContent != null) : "Parameter 'scriptContent' of method 'GroovyScript' must not be null";
        this.addChild(new ScriptResultSet(this, this.getIdentifyingPath()));
        scriptContent.setParent(this);
        this.addChild(scriptContent);
        this.m_status = IGroovyScript.Status.NONE;
    }

    @Override
    public String getPresentationKind() {
        return "Script File";
    }

    public void setScriptContent(ScriptContent content, boolean reloaded, boolean needsSave, long timestamp) {
        assert (content != null) : "Parameter 'content' of method 'setScriptContent' must not be null";
        ScriptContent currentContent = this.getUniqueChild(ScriptContent.class);
        if (currentContent != null) {
            currentContent.remove();
        }
        content.setParent(this);
        this.addChild(content);
        if (reloaded) {
            this.reloaded(timestamp, needsSave);
        } else {
            this.modified();
        }
        this.setNeedsSave(needsSave);
    }

    @Override
    public ScriptContent getScriptContent() {
        return this.getUniqueExistingChild(ScriptContent.class);
    }

    public ScriptResultSet getResultSet() {
        return this.getUniqueExistingChild(ScriptResultSet.class);
    }

    @Override
    public void setIsExecutable(boolean isExecutable) {
        this.m_isExecutable = isExecutable;
    }

    @Override
    public boolean isExecutable() {
        return this.m_isExecutable;
    }

    @Override
    public synchronized void setStatus(IGroovyScript.Status status) {
        assert (status != null) : "Parameter 'status' of method 'setStatus' must not be null";
        this.m_status = status;
    }

    public IGroovyScript.Status getStatus() {
        return this.m_status;
    }

    @Override
    public void setCompiledScript(Script script) {
        this.m_compiledScript = script;
    }

    @Override
    public void setScriptApiAndClassLoader(IScriptApi api, ClassLoader classLoader) {
        assert (api != null && classLoader != null || api == null && classLoader == null) : "Both null or both not null";
        this.m_scriptApi = api;
        this.m_classLoader = classLoader;
    }

    @Override
    public IScriptApi getScriptApi() {
        return this.m_scriptApi;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    @Override
    public Script getCompiledScript() {
        return this.m_compiledScript;
    }

    @Override
    public IFileType getFileType() {
        return CoreFileType.GROOVY_SCRIPT;
    }

    @Override
    @Property
    public String getDescription() {
        return this.getScriptContent().getDescription();
    }

    public boolean isRunConfiguration(IModifiableFile modifiableFile) {
        return this.getScriptContent().isRunConfiguration(modifiableFile);
    }

    public List<IRunConfiguration> getRunConfigurations() {
        return this.getScriptContent().getRunConfigurations();
    }

    public List<FileBasedRunConfiguration> getFileBasedRunConfigurations() {
        return this.getScriptContent().getFileBasedRunConfigurations();
    }

    @Override
    public String getSource() {
        return this.getScriptContent().getSource();
    }

    public void defaultConfigAutomationStatusChanged() {
        this.additionalInformationModified();
    }
}

