/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.resolution;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.List;

public enum CycleGroupKind implements IStandardEnumeration
{
    COMPONENT_CYCLES(true),
    LOGICAL_TOPLEVEL_ELEMENT_CYCLES(false),
    PACKAGE_OR_NAMESPACE_CYCLES(false),
    DIRECTORY_CYCLES(true),
    MODULE_CYCLES(true);

    final boolean m_usesPhysicalFilterName;

    private CycleGroupKind(boolean usesPhysicalFilterName) {
        this.m_usesPhysicalFilterName = usesPhysicalFilterName;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return StringUtility.convertConstantNameToPresentationName((String)this.name(), (boolean)false);
    }

    public boolean usesPhysicalFilterName() {
        return this.m_usesPhysicalFilterName;
    }

    public static List<CycleGroupKind> detectableCycleGroups(Language lang) {
        ArrayList<CycleGroupKind> result = new ArrayList<CycleGroupKind>(4);
        result.add(COMPONENT_CYCLES);
        if (lang.hasLogicalModel()) {
            result.add(LOGICAL_TOPLEVEL_ELEMENT_CYCLES);
        }
        if (lang.analyzesNamespaceCycles()) {
            result.add(PACKAGE_OR_NAMESPACE_CYCLES);
        }
        if (lang.analyzesDirectoryCycles()) {
            result.add(DIRECTORY_CYCLES);
        }
        return result;
    }

    public static CycleGroupKind fromName(String name) {
        return switch (name) {
            case "COMPONENT_CYCLE_GROUPS", "COMPONENT_CYCLES" -> COMPONENT_CYCLES;
            case "LOGICAL_TOPLEVEL_ELEMENT_CYCLES", "TOP_LEVEL_ELEMENT_CYCLE_GROUPS" -> LOGICAL_TOPLEVEL_ELEMENT_CYCLES;
            case "PACKAGE_OR_NAMESPACE_CYCLE_GROUPS", "PACKAGE_OR_NAMESPACE_CYCLES" -> PACKAGE_OR_NAMESPACE_CYCLES;
            case "DIRECTORY_CYCLES", "DIRECTORY_CYCLE_GROUPS" -> DIRECTORY_CYCLES;
            case "MODULE_CYCLE_GROUPS", "MODULE_CYCLES" -> MODULE_CYCLES;
            default -> throw new IllegalArgumentException("Unexpected enum value: " + name);
        };
    }
}

