/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.core.model.resolution.GeneratedIssueBasedTaskDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class RefactoringDefinition
extends GeneratedIssueBasedTaskDefinition {
    private final StatusInfo m_statusInfo = new StatusInfo();
    private Set<NamedElement> m_potentiallyDoneElements;

    public RefactoringDefinition(NamedElement parent, Date date, String assignee, String description, Priority priority) {
        super(parent, date, assignee, description, priority);
    }

    @Override
    public final ResolutionKind getKind() {
        return ResolutionKind.REFACTORING;
    }

    @Override
    public String getFullyQualifiedNameToBeMatched(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getFullyQualifiedNameToBeMatched' must not be null";
        return element.getFullyQualifiedName();
    }

    @Override
    public final String getPresentationKind() {
        return "Refactoring";
    }

    @Property
    public abstract RefactoringType getRefactoringType();

    public abstract String getProvider();

    @Override
    public final String getImageResourceName() {
        return this.getRefactoringType().getImageResourceName();
    }

    @Override
    public String toString() {
        return super.toString() + ", Description: " + this.getDescription();
    }

    @Property
    public final StatusInfo.Status getStatus() {
        return this.m_statusInfo.getStatus();
    }

    public final StatusInfo getStatusInfo() {
        return this.m_statusInfo;
    }

    public final void addPotentiallyDoneElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'addPotentiallyDoneElement' must not be null";
        if (this.m_potentiallyDoneElements == null) {
            this.m_potentiallyDoneElements = new LinkedHashSet<NamedElement>();
        }
        this.m_potentiallyDoneElements.add(element);
    }

    public final List<NamedElement> getPotentiallyDoneElements() {
        if (this.m_potentiallyDoneElements != null) {
            ArrayList<NamedElement> potentiallyDone = new ArrayList<NamedElement>();
            this.m_potentiallyDoneElements.forEach(p -> {
                boolean bl = potentiallyDone.add(p.getRepresentative());
            });
            return potentiallyDone;
        }
        return Collections.emptyList();
    }

    @IntProperty(undefinedValue=0)
    public final int getNumberOfPotentiallyDoneElements() {
        return this.m_potentiallyDoneElements != null ? this.m_potentiallyDoneElements.size() : 0;
    }

    @Override
    public void reset(IIssue accessor) {
        this.m_potentiallyDoneElements = null;
        super.reset(accessor);
    }

    @Override
    public List<IIssue> reset() {
        this.m_potentiallyDoneElements = null;
        return super.reset();
    }
}

