/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.GenericStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNameContributor;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.IWorkspaceFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.ISourceElementCountProvider;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotSourceFilePath;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;

public abstract class GenericSourceFile
extends SourceFile
implements IComponent,
ISnapshotSourceFilePath {
    private IModelServiceProvider m_msp;
    private boolean m_excluded;
    private boolean m_ignoreIssues;

    public GenericSourceFile(NamedElement parent) {
        super(parent);
    }

    public GenericSourceFile(IModelServiceProvider msp, NamedElement parent, TFile file) {
        super(parent, file);
        assert (msp != null) : "Parameter 'msp' of method 'GenericSourceFile' must not be null";
        this.m_msp = msp;
    }

    @Override
    public NamedElement getOriginal() {
        return super.getOriginal(this.m_msp);
    }

    @Override
    public NamedElement getRepresentative() {
        return super.getRepresentative(this.m_msp);
    }

    @Override
    public List<NamedElement> getChildren() {
        return this.getChildren(this.m_msp);
    }

    @Override
    public NamedElement getParent() {
        return this.getParent(this.m_msp);
    }

    @Override
    public boolean isExternal() {
        return this.getParent().isExternal();
    }

    @Override
    public void setModelServiceProvider(IModelServiceProvider msp) {
        assert (msp != null) : "Parameter 'msp' of method 'setModelServiceProvider' must not be null";
        this.m_msp = msp;
    }

    @Override
    public Element.IPropertiesManager getPropertiesManager() {
        return this.m_msp.getPropertiesManager();
    }

    @Override
    public ElementWithIssues.IIssueManager getIssueManager() {
        return this.m_msp.getIssueManager();
    }

    @Override
    public IVirtualModel getCurrentModel() {
        return this.m_msp.getCurrentModel();
    }

    @Override
    public void setIsExcluded(boolean excluded) {
        this.m_excluded = excluded;
    }

    @Override
    @Property
    public boolean isExcluded() {
        return this.m_excluded;
    }

    @Override
    public void setIgnoreIssues(boolean ignore) {
        this.m_ignoreIssues = ignore;
    }

    @Override
    @Property
    public boolean ignoreIssues() {
        return this.m_ignoreIssues;
    }

    @Override
    @Property
    public String getWorkspaceFilterName() {
        GenericSourceFile original;
        if (this.isExternal()) {
            return "";
        }
        GenericSourceFile genericSourceFile = original = this.m_msp != null ? this.m_msp.getCurrentModel().getOriginal(this) : this;
        assert (original != null) : "'original' of method 'getWorkspaceFilterName' must not be null";
        IWorkspaceFilterNamePrefixProvider provider = original.getParent(IWorkspaceFilterNamePrefixProvider.class, new Class[0]);
        assert (provider != null) : "'provider' of method 'getWorkspaceFilterName' must not be null";
        return provider.getWorkspaceFilterNamePrefix() + FileUtility.removeExtension((String)original.getName()).substring("./".length());
    }

    @Override
    @Property
    public String getArchitectureFilterName() {
        IArchitectureFilterNamePrefixProvider provider = this.getParent(IArchitectureFilterNamePrefixProvider.class, new Class[0]);
        assert (provider != null) : "Parameter 'provider' of method 'getArchitectureFilterName' must not be null";
        IArchitectureFilterNameContributor contributor = this.getParent(IArchitectureFilterNameContributor.class, new Class[0]);
        return provider.getArchitectureFilterNamePrefix() + (contributor != null ? contributor.getArchitectureFilterNamePart() : "") + FileUtility.removeExtension((String)this.getShortName());
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    @Override
    public int getSize() {
        int sourceElementCount = 0;
        for (ISourceElementCountProvider next : this.getChildrenRecursively(ISourceElementCountProvider.class, new Class[0])) {
            int nextSec = next.getSourceElementCount();
            if (nextSec == -1) continue;
            sourceElementCount += nextSec;
        }
        return sourceElementCount;
    }

    @Override
    public IStructureItem getStructureItem() {
        return GenericStructureItem.SOURCE_FILE;
    }

    @Override
    public final RootDirectoryPath getRootDirectoryPath() {
        return this.getParent(RootDirectoryPath.class, new Class[0]);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitGenericSourceFile(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String toString() {
        if (this.m_msp != null && this.m_msp.getCurrentModel().getOriginal(this) != this) {
            StringBuilder builder = new StringBuilder("[Clone] ");
            builder.append(super.toString());
            return builder.toString();
        }
        return super.toString();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitGenericSourceFile(GenericSourceFile var1);
    }
}

