/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.generic.programming;

import com.hello2morrow.sonargraph.core.model.element.GenericStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElementWithChildren;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class GenericFunctionWithBody
extends ProgrammingElementWithChildren
implements IRoutine {
    private int m_numberOfStatements = -1;
    private int m_numberOfParameters = -1;
    private int m_cyclomaticComplexity = -1;
    private int m_modifiedCyclomaticComplexity = -1;
    private short m_numberOfLogicalOperations = (short)-1;
    private short m_maxNesting = (short)-1;

    public GenericFunctionWithBody(NamedElement parent) {
        super(parent);
    }

    public GenericFunctionWithBody(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber) {
        super(msp, parent, name, lineNumber);
    }

    @Override
    public IStructureItem getStructureItem() {
        return GenericStructureItem.PROGRAMMING_ELEMENT;
    }

    @Override
    public String getImageResourceName() {
        return "Function";
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return super.getFullyQualifiedNamePart() + "-" + Integer.toString(this.getLineNumber());
    }

    @Override
    @IntProperty
    public int getNumberOfParameters() {
        return this.m_numberOfParameters;
    }

    @Override
    @IntProperty
    public int getNumberOfStatements() {
        return this.m_numberOfStatements;
    }

    @Override
    @IntProperty
    public int getCyclomaticComplexity() {
        return this.m_cyclomaticComplexity;
    }

    @Override
    @IntProperty
    public int getExtendedCyclomaticComplexity() {
        if (this.m_cyclomaticComplexity == -1) {
            return -1;
        }
        if (this.m_numberOfLogicalOperations == -1) {
            return this.m_cyclomaticComplexity;
        }
        return this.m_cyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    @Override
    @IntProperty
    public int getModifiedExtendedCyclomaticComplexity() {
        if (this.m_modifiedCyclomaticComplexity == -1) {
            return -1;
        }
        if (this.m_numberOfLogicalOperations == -1) {
            return this.m_modifiedCyclomaticComplexity;
        }
        return this.m_modifiedCyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    @Override
    @IntProperty
    public int getModifiedCyclomaticComplexity() {
        return this.m_modifiedCyclomaticComplexity;
    }

    @Override
    @IntProperty
    public int getSourceElementCount() {
        if (!this.isDefinedInEnclosingElement() || this.isExternal()) {
            return -1;
        }
        return 1 + this.m_numberOfStatements;
    }

    @Override
    @IntProperty
    public int getMaxNesting() {
        return this.m_maxNesting;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    public void setMaxNesting(int maxNesting) {
        this.m_maxNesting = (short)maxNesting;
    }

    public void setNumberOfStatements(int numberOfStatements) {
        this.m_numberOfStatements = numberOfStatements;
    }

    public void setNumberOfParameters(int numberOfParameters) {
        this.m_numberOfParameters = numberOfParameters;
    }

    public void setCyclomaticComplexity(int cyclomaticComplexity) {
        this.m_cyclomaticComplexity = cyclomaticComplexity;
    }

    public void setModifiedCyclomaticComplexity(int modifiedCyclomaticComplexity) {
        this.m_modifiedCyclomaticComplexity = modifiedCyclomaticComplexity;
    }

    public void setNumberOfLogicalOperations(int numberOfLogicalOperations) {
        this.m_numberOfLogicalOperations = (short)numberOfLogicalOperations;
    }

    @Override
    public List<String> getArgumentTypes() {
        return Collections.emptyList();
    }

    @Override
    public String getReturnType() {
        return null;
    }

    @Override
    public boolean isMember() {
        return false;
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_numberOfStatements = reader.readInt();
        this.m_numberOfParameters = reader.readInt();
        this.m_cyclomaticComplexity = reader.readInt();
        this.m_modifiedCyclomaticComplexity = reader.readInt();
        this.m_numberOfLogicalOperations = (short)reader.readInt();
        this.m_maxNesting = reader.getVersion() >= 12 ? reader.readShort() : (short)-1;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeInt(this.m_numberOfStatements);
        writer.writeInt(this.m_numberOfParameters);
        writer.writeInt(this.m_cyclomaticComplexity);
        writer.writeInt(this.m_modifiedCyclomaticComplexity);
        writer.writeInt(this.m_numberOfLogicalOperations);
        writer.writeShort(this.m_maxNesting);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)((Object)visitor)).visitGenericFunction(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitGenericFunction(GenericFunctionWithBody var1);
    }
}

