/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.filter;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;

public abstract class ComponentFilter
extends Filter {
    private int m_numberOfIncludedComponents = -1;
    private int m_numberOfExcludedComponents = -1;

    public ComponentFilter(NamedElement parent) {
        super(parent);
    }

    @Override
    public final boolean invalidatesParserModel() {
        return false;
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return mode != ISnapshotProcessor.Mode.WORKSPACE;
    }

    @Override
    public final void initialize() {
        this.m_numberOfIncludedComponents = 0;
        this.m_numberOfExcludedComponents = 0;
        super.initialize();
    }

    @Override
    public final void clear() {
        this.m_numberOfIncludedComponents = -1;
        this.m_numberOfExcludedComponents = -1;
        super.clear();
    }

    public final int getNumberOfIncludedComponents() {
        return this.m_numberOfIncludedComponents;
    }

    public final int getNumberOfExcludedComponents() {
        return this.m_numberOfExcludedComponents;
    }

    public final boolean includeComponent(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'includeComponent' must not be empty";
        boolean include = super.include(name);
        if (!include) {
            ++this.m_numberOfExcludedComponents;
        } else {
            ++this.m_numberOfIncludedComponents;
        }
        return include;
    }
}

