/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationExecutor;
import com.hello2morrow.sonargraph.core.model.explorationview.OperationInfo;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.util.Collections;
import java.util.List;

public final class RenameElementOperation
extends ArchitecturalViewOperation {
    private final String m_element;
    private final String m_name;
    private OperationInfo m_operationInfo;

    public RenameElementOperation(NamedElement parent, PresentationMode presentationMode, String element, String name) {
        super(parent, presentationMode);
        assert (element != null && element.length() > 0) : "Parameter 'element' of method 'RenameElementOperation' must not be empty";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'RenameElementOperation' must not be empty";
        this.m_element = element;
        this.m_name = name;
    }

    public RenameElementOperation(NamedElement parent, PresentationMode presentationMode, String element, String name, OperationInfo info) {
        this(parent, presentationMode, element, name);
        assert (info != null) : "Parameter 'info' of method 'RenameElementOperation' must not be null";
        this.m_operationInfo = info;
    }

    private RenameElementOperation(NamedElement parent, RenameElementOperation copyOf) {
        super(parent, copyOf);
        assert (copyOf != null) : "Parameter 'copyOf' of method 'RenameElementOperation' must not be null";
        this.m_element = copyOf.m_element;
        this.m_name = copyOf.m_name;
    }

    @Override
    public ArchitecturalViewOperation copy(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'copy' must not be null";
        return new RenameElementOperation(parent, this);
    }

    @Override
    public String getImageResourceName() {
        return "RenameElement";
    }

    @Override
    public String getShortName() {
        return "Rename element";
    }

    public String getElementName() {
        return this.m_element;
    }

    public String getNewName() {
        return this.m_name;
    }

    @Override
    public String getInformation() {
        String additionalInfo = this.m_operationInfo != null ? this.m_operationInfo.getInfo() : "";
        return super.getInformation() + " Rename '" + this.m_element + "' to '" + this.m_name + "'" + (String)(additionalInfo.isEmpty() ? additionalInfo : " [" + additionalInfo + "]");
    }

    @Override
    public boolean containsRefactoring() {
        return this.m_operationInfo != null ? this.m_operationInfo.containsRefactoring() : false;
    }

    @Property
    public List<String> getInformationElement() {
        if (this.m_operationInfo != null) {
            return this.m_operationInfo.getElementInfo();
        }
        return Collections.emptyList();
    }

    @Override
    public void apply(IArchitecturalViewOperationExecutor executor) {
        assert (executor != null) : "Parameter 'executor' of method 'apply' must not be null";
        this.m_operationInfo = executor.renameElement(this, this.m_element, this.m_name);
        assert (this.m_operationInfo != null) : "'m_operationInfo' of method 'apply' must not be null";
    }

    @Override
    public void reset() {
        this.m_operationInfo = null;
        super.reset();
    }
}

