/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class ExplorationViewFocusRequest {
    private final List<ArchitecturalViewNode> m_nodes;
    private final List<ArchitecturalViewNode.ArchitecturalViewDependency> m_dependencies;
    private final Set<ParserDependency> m_parserDependencies;
    private final ExplorationViewRepresentation m_representation;
    private List<ArchitecturalViewNode> m_partialAlternative;

    public ExplorationViewFocusRequest(ExplorationViewRepresentation representation, Collection<ArchitecturalViewNode> nodes, Collection<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, Collection<ParserDependency> parserDependencies) {
        assert (representation != null) : "Parameter 'representation' of method 'ExplorationViewFocusRequest' must not be null";
        assert (nodes != null) : "Parameter 'nodes' of method 'ExplorationViewFocusRequest' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'ExplorationViewFocusRequest' must not be null";
        assert (parserDependencies != null) : "Parameter 'parserDependencies' of method 'ExplorationViewFocusRequest' must not be null";
        assert (!(nodes.isEmpty() && dependencies.isEmpty() && parserDependencies.isEmpty())) : "Focus request is empty";
        this.m_representation = representation;
        this.m_nodes = new ArrayList<ArchitecturalViewNode>(nodes);
        this.m_dependencies = new ArrayList<ArchitecturalViewNode.ArchitecturalViewDependency>(dependencies);
        if (!dependencies.isEmpty() || !parserDependencies.isEmpty()) {
            this.m_parserDependencies = new THashSet();
            dependencies.forEach(d -> {
                boolean bl = this.m_parserDependencies.addAll(d.getParserDependencies());
            });
            this.m_parserDependencies.addAll(parserDependencies);
        } else {
            this.m_parserDependencies = Collections.emptySet();
        }
    }

    public ExplorationViewFocusRequest(ExplorationViewRepresentation representation, Collection<ArchitecturalViewNode> nodes, Collection<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        this(representation, nodes, dependencies, Collections.emptyList());
    }

    public ExplorationViewRepresentation getRepresentation() {
        return this.m_representation;
    }

    public void setPartialAlternative(List<ArchitecturalViewNode> partialAlternative) {
        assert (partialAlternative == null || !partialAlternative.isEmpty()) : "null or not empty expected";
        this.m_partialAlternative = partialAlternative;
    }

    public List<ArchitecturalViewNode> getNodes() {
        return this.m_partialAlternative != null ? this.m_partialAlternative : Collections.unmodifiableList(this.m_nodes);
    }

    public List<ArchitecturalViewNode.ArchitecturalViewDependency> getDependencies() {
        return Collections.unmodifiableList(this.m_dependencies);
    }

    public Set<ParserDependency> getParserDependencies() {
        return Collections.unmodifiableSet(this.m_parserDependencies);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(": ");
        for (ArchitecturalViewNode architecturalViewNode : this.m_nodes) {
            builder.append("\n");
            builder.append(architecturalViewNode.getElementInfo(true, false));
        }
        for (ArchitecturalViewNode.ArchitecturalViewDependency architecturalViewDependency : this.m_dependencies) {
            builder.append("\n");
            builder.append(architecturalViewDependency);
        }
        return builder.toString();
    }
}

