/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class ArchitecturalViewOperationList
extends ArchitecturalViewList {
    public ArchitecturalViewOperationList(NamedElement parent) {
        super(parent);
        assert (parent != null) : "Parameter 'parent' of method 'ArchitecturalViewOperationList' must not be null";
    }

    @Override
    public String getShortName() {
        return "Operations";
    }

    private void updateIndexes() {
        int i = 1;
        for (ArchitecturalViewOperation next : this.getChildren(ArchitecturalViewOperation.class)) {
            next.setIndex(i);
            ++i;
        }
    }

    public void replaceChild(ArchitecturalViewOperation replace, ArchitecturalViewOperation with) {
        assert (replace != null) : "Parameter 'replace' of method 'replaceChild' must not be null";
        assert (with != null) : "Parameter 'with' of method 'replaceChild' must not be null";
        assert (replace != with) : "Same instances";
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        assert (children != null && !children.isEmpty()) : "'children' of method 'replaceChild' must not be empty";
        boolean found = false;
        int index = 0;
        for (NamedElement nextChild : children) {
            if (nextChild == replace) {
                found = true;
                break;
            }
            ++index;
        }
        assert (found) : "To be replaced '" + String.valueOf(replace) + "' not found in: " + Arrays.toString(children.toArray());
        children.set(index, with);
        this.updateIndexes();
    }

    @Override
    public void addChild(NamedElement child) {
        assert (child != null && child instanceof ArchitecturalViewOperation) : "Unexpected class in method 'addChild': " + String.valueOf(child);
        super.addChild(child);
        ((ArchitecturalViewOperation)child).setIndex(this.getNumberOfChildren());
    }

    @Override
    public void removeChild(NamedElement child) {
        assert (child != null && child instanceof ArchitecturalViewOperation) : "Unexpected class in method 'removeChild': " + String.valueOf(child);
        super.removeChild(child);
        this.updateIndexes();
    }

    public List<ArchitecturalViewOperation> getNonInheritedOperations() {
        return this.getChildren(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement element) {
                if (!($assertionsDisabled || element != null && element instanceof ArchitecturalViewOperation)) {
                    throw new AssertionError((Object)("Unexpected class in method 'accept': " + String.valueOf(element)));
                }
                return ((ArchitecturalViewOperation)element).getInheritedFrom() == null;
            }
        }, ArchitecturalViewOperation.class);
    }

    public boolean removeNonInheritedOperations() {
        boolean removedSomething = false;
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children != null && !children.isEmpty()) {
            Iterator<NamedElement> iterator = children.iterator();
            while (iterator.hasNext()) {
                NamedElement next = iterator.next();
                assert (next instanceof ArchitecturalViewOperation) : "Unexpected class in method 'removeNonInheritedOperations': " + String.valueOf(next);
                ArchitecturalViewOperation nextOp = (ArchitecturalViewOperation)next;
                if (nextOp.getInheritedFrom() != null) continue;
                nextOp.setParent(null);
                iterator.remove();
                removedSomething = true;
            }
        }
        return removedSomething;
    }
}

