/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ArchitecturalViewArtifactOperationAvailability {
    private final Set<ArtifactNode> m_ignoreSubTrees = new THashSet();
    private final String m_operation;
    private IAssignableTarget m_assignableTarget;

    public ArchitecturalViewArtifactOperationAvailability(String operation) {
        assert (operation != null && operation.length() > 0) : "Parameter 'operation' of method 'ArchitecturalViewArtifactOperationAvailability' must not be empty";
        this.m_operation = operation;
    }

    public void setAssignableTarget(IAssignableTarget assignableTarget) {
        this.m_assignableTarget = assignableTarget;
    }

    public IAssignableTarget getAssignableTarget() {
        return this.m_assignableTarget;
    }

    public boolean isAvailable() {
        return this.m_assignableTarget != null;
    }

    public void addIgnoreSubTree(Collection<ArtifactNode> startNodes) {
        assert (startNodes != null) : "Parameter 'artifacts' of method 'addIgnoreSubTree' must not be null";
        if (!startNodes.isEmpty()) {
            HashSet<ArtifactNode> combined = new HashSet<ArtifactNode>(this.m_ignoreSubTrees);
            combined.addAll(startNodes);
            this.m_ignoreSubTrees.clear();
            this.m_ignoreSubTrees.addAll(NamedElementUtility.normalize(combined, true, new Class[0]));
        }
    }

    public Set<ArtifactNode> getIgnoreSubTrees() {
        return Collections.unmodifiableSet(this.m_ignoreSubTrees);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.m_operation);
        if (this.isAvailable()) {
            builder.append(" [Available]");
        } else {
            builder.append(" [Not Available]");
        }
        for (ArtifactNode next : this.m_ignoreSubTrees) {
            builder.append("\n").append("Ignored sub tree: ").append(next.getName());
        }
        return builder.toString();
    }
}

