/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.common;

import java.util.Objects;

public abstract class AutoCompletionProposal {
    private final String m_proposal;
    private final String m_presentationProposal;
    private final int m_replacementOffset;
    private final int m_replacementLength;
    private final int m_offsetIncrement;

    public AutoCompletionProposal(String presentationProposal, String proposal, int replacementOffset, int replacementLength, int offsetIncrement) {
        assert (presentationProposal != null && presentationProposal.length() > 0) : "Parameter 'presentationProposal' of method 'AutoCompletionProposal' must not be empty";
        assert (proposal != null && proposal.length() > 0) : "Parameter 'proposal' of method 'AutoCompletionProposal' must not be empty";
        assert (replacementOffset >= 0) : "'replacementOffset' must not be negative";
        assert (replacementLength >= 0) : "'replacementLength' must not be negative";
        assert (offsetIncrement >= 0) : "'offsetIncrement' must not be negative";
        this.m_presentationProposal = presentationProposal;
        this.m_proposal = proposal;
        this.m_replacementOffset = replacementOffset;
        this.m_replacementLength = replacementLength;
        this.m_offsetIncrement = offsetIncrement;
    }

    public AutoCompletionProposal(String proposal, int replacementOffset, int replacementLength, int offsetIncrement) {
        this(proposal, proposal, replacementOffset, replacementLength, offsetIncrement);
    }

    public abstract String getImageResourceName();

    public final String getPresentationProposal() {
        return this.m_presentationProposal;
    }

    public final String getProposal() {
        return this.m_proposal;
    }

    public final int getReplacementOffset() {
        return this.m_replacementOffset;
    }

    public final int getReplacementLength() {
        return this.m_replacementLength;
    }

    public int getOffsetIncrement() {
        return this.m_offsetIncrement;
    }

    public int hashCode() {
        return Objects.hash(this.m_proposal);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AutoCompletionProposal other = (AutoCompletionProposal)obj;
        return Objects.equals(this.m_proposal, other.m_proposal);
    }

    public String toString() {
        return "'" + this.m_proposal + "' (" + this.m_replacementOffset + "/" + this.m_replacementLength + ")";
    }
}

