/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

public final class ArtifactNameUtility {
    private static final String ARTIFACT_NAME_INFO = "Allowed are letters, digits, '_' and '-'. Must begin with a letter.";
    private static final char UNDERSCORE = '_';

    private ArtifactNameUtility() {
    }

    public static String createValidName(String proposal) {
        assert (proposal != null && proposal.length() > 0) : "Parameter 'proposal' of method 'createValidName' must not be empty";
        StringBuilder builder = new StringBuilder();
        char firstChar = proposal.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar)) {
            builder.append('_');
        } else {
            builder.append(firstChar);
        }
        int i = 1;
        while (i < proposal.length()) {
            char c = proposal.charAt(i);
            if (c != '-' && !Character.isJavaIdentifierPart(c)) {
                builder.append('_');
            } else {
                builder.append(c);
            }
            ++i;
        }
        return builder.toString();
    }

    public static String isNameValid(String name) {
        if (name == null || name.isEmpty()) {
            return "Must not be empty";
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return ARTIFACT_NAME_INFO;
        }
        int i = 1;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c != '-' && !Character.isJavaIdentifierPart(c)) {
                return ARTIFACT_NAME_INFO;
            }
            ++i;
        }
        return null;
    }
}

