/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.annotation;

import com.hello2morrow.sonargraph.core.model.annotation.AnnotationValue;
import com.hello2morrow.sonargraph.core.model.annotation.AnnotationValueEntry;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Annotation
extends AnnotationValue
implements AnnotationValue.IAnnotation,
ISnapshotWriter.IWriteStorableContext {
    private String m_annotationClassName;
    private int m_lineNumber;
    private NamedElement m_annotationClass;
    private AnnotationValueEntry m_firstEntry;

    public Annotation() {
    }

    public Annotation(String annotationClassName, int lineNumber) {
        assert (annotationClassName != null && annotationClassName.length() > 0) : "Parameter 'annotationClassName' of method 'Annotation' must not be empty";
        this.m_annotationClassName = annotationClassName.intern();
        this.m_lineNumber = lineNumber;
    }

    @Override
    public void removeInvalidElementReference() {
        if (this.m_annotationClass != null && !this.m_annotationClass.isValid()) {
            this.m_annotationClass = null;
        }
    }

    @Override
    public NamedElement getReferencedElement() {
        return this.m_annotationClass;
    }

    public void addValue(String key, AnnotationValue value) {
        assert (key != null) : "Parameter 'key' of method 'addValue' must not be null";
        assert (value != null) : "Parameter 'value' of method 'addValue' must not be null";
        AnnotationValueEntry newEntry = new AnnotationValueEntry(key, value);
        if (this.m_firstEntry == null) {
            this.m_firstEntry = newEntry;
        } else {
            this.m_firstEntry.add(newEntry);
        }
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    @Override
    public AnnotationValue getValue(String key) {
        assert (key != null && key.length() > 0) : "Parameter 'key' of method 'getValue' must not be empty";
        AnnotationValueEntry entry = this.m_firstEntry;
        while (entry != null) {
            if (entry.getKey().equals(key)) {
                return entry.getValue();
            }
            entry = entry.getNext();
        }
        return null;
    }

    public Map<String, AnnotationValue> getKeyToAnnotationValue() {
        LinkedHashMap<String, AnnotationValue> keyToAnnotationValue = new LinkedHashMap<String, AnnotationValue>();
        AnnotationValueEntry entry = this.m_firstEntry;
        while (entry != null) {
            keyToAnnotationValue.put(entry.getKey(), entry.getValue());
            entry = entry.getNext();
        }
        return keyToAnnotationValue;
    }

    @Override
    public NamedElement getAnnotationClass() {
        return this.m_annotationClass;
    }

    public void setAnnotationClass(NamedElement annotation) {
        this.m_annotationClass = annotation;
    }

    @Override
    public String getAnnotationClassName() {
        return this.m_annotationClassName;
    }

    @Override
    public AnnotationValue.IAnnotation asAnnotation() {
        return this;
    }

    @Override
    public void visitChildren(AnnotationValue.AnnotationVisitor v) {
        AnnotationValueEntry entry = this.m_firstEntry;
        while (entry != null) {
            entry.getValue().accept(v);
            entry = entry.getNext();
        }
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        String key;
        this.m_annotationClassName = reader.readString();
        this.m_annotationClass = reader.read(NamedElement.class, new SnapshotArgument[0]);
        this.m_lineNumber = reader.readInt();
        while ((key = reader.readString()) != null) {
            AnnotationValue value = reader.read(AnnotationValue.class, new SnapshotArgument[0]);
            this.addValue(key, value);
        }
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        assert (writer != null) : "Parameter 'writer' of method 'store' must not be null";
        writer.writeString(this.m_annotationClassName);
        writer.write(this.m_annotationClass, this);
        writer.writeInt(this.m_lineNumber);
        AnnotationValueEntry entry = this.m_firstEntry;
        while (entry != null) {
            writer.writeString(entry.getKey());
            writer.write(entry.getValue(), this);
            entry = entry.getNext();
        }
        writer.writeString(null);
    }

    @Override
    public void addDiagnosticInfo(StringBuilder builder) {
        assert (builder != null) : "Parameter 'builder' of method 'addDiagnosticInfo' must not be null";
        builder.append("Annotation class name: ").append(this.m_annotationClassName).append("\n");
    }

    @Override
    public void accept(AnnotationValue.AnnotationVisitor v) {
        if (v instanceof IVisitor) {
            ((IVisitor)((Object)v)).visitAnnotation(this);
        } else {
            super.accept(v);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('@').append(this.m_annotationClassName);
        if (this.m_firstEntry != null) {
            sb.append('(');
            AnnotationValueEntry entry = this.m_firstEntry;
            while (entry != null) {
                if (entry != this.m_firstEntry) {
                    sb.append(", ");
                }
                sb.append(entry.getKey()).append('=').append(entry.getValue().toString());
                entry = entry.getNext();
            }
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n");
        builder.append("Annotation class name: ");
        builder.append(this.m_annotationClassName);
        builder.append(" [");
        if (this.m_annotationClass == null) {
            builder.append("null");
        } else if (!this.m_annotationClass.isValid()) {
            builder.append("reference not valid");
        } else {
            builder.append("reference is valid - full name: ").append(this.m_annotationClass.getName());
        }
        builder.append("]");
        AnnotationValueEntry entry = this.m_firstEntry;
        while (entry != null) {
            builder.append("\n");
            builder.append("[").append(entry.getKey()).append("] ");
            builder.append(entry.getValue().getDebugInfo());
            entry = entry.getNext();
        }
        return builder.toString();
    }

    public static interface IVisitor {
        public void visitAnnotation(Annotation var1);
    }
}

