/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetNode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetSimpleCycle;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FeedbackArcSetSimpleCyclesDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackArcSetSimpleCyclesDetector.class);

    FeedbackArcSetSimpleCyclesDetector() {
    }

    private static void unblock(IWorkerContext workerContext, FeedbackArcSetNode node, Set<FeedbackArcSetNode> blocked, Map<FeedbackArcSetNode, Set<FeedbackArcSetNode>> blockedNodes) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'unblock' must not be null";
        assert (node != null) : "Parameter 'node' of method 'unblock' must not be null";
        assert (blocked != null) : "Parameter 'blocked' of method 'unblock' must not be null";
        assert (blockedNodes != null) : "Parameter 'blockedNodes' of method 'unblock' must not be null";
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        boolean removed = blocked.remove(node);
        assert (removed);
        Set<FeedbackArcSetNode> depNodes = blockedNodes.remove(node);
        if (depNodes != null) {
            Iterator<FeedbackArcSetNode> iter = depNodes.iterator();
            while (iter.hasNext()) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                FeedbackArcSetNode nextDepNode = iter.next();
                iter.remove();
                if (blocked.contains(nextDepNode)) {
                    FeedbackArcSetSimpleCyclesDetector.unblock(workerContext, nextDepNode, blocked, blockedNodes);
                    continue;
                }
                blockedNodes.remove(nextDepNode);
            }
        }
    }

    private static boolean process(IWorkerContext workerContext, FeedbackArcSetNode startNode, FeedbackArcSetNode currentNode, Set<FeedbackArcSetNode> blocked, Map<FeedbackArcSetNode, Set<FeedbackArcSetNode>> blockedNodes, Data data) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'process' must not be null";
        assert (startNode != null) : "Parameter 'startNode' of method 'process' must not be null";
        assert (currentNode != null) : "Parameter 'currentNode' of method 'process' must not be null";
        assert (data != null) : "Parameter 'data' of method 'process' must not be null";
        assert (blocked != null) : "Parameter 'blocked' of method 'process' must not be null";
        assert (blockedNodes != null) : "Parameter 'blockedNodes' of method 'process' must not be null";
        assert (!blocked.contains(currentNode));
        if (workerContext.hasBeenCanceled()) {
            return true;
        }
        List<FeedbackArcSetNode.Edge> outgoingEdges = data.getOutgoingEdges(currentNode);
        if (outgoingEdges.isEmpty()) {
            return true;
        }
        blocked.add(currentNode);
        boolean unblock = false;
        for (FeedbackArcSetNode.Edge nextOut : outgoingEdges) {
            if (workerContext.hasBeenCanceled()) {
                return true;
            }
            if (data.enterEdge(nextOut)) {
                unblock = true;
            } else if (!blocked.contains(nextOut.getTo()) && FeedbackArcSetSimpleCyclesDetector.process(workerContext, startNode, nextOut.getTo(), blocked, blockedNodes, data)) {
                unblock = true;
            }
            data.leaveEdge(nextOut);
        }
        if (unblock) {
            FeedbackArcSetSimpleCyclesDetector.unblock(workerContext, currentNode, blocked, blockedNodes);
        } else {
            for (FeedbackArcSetNode.Edge nextOut : outgoingEdges) {
                if (workerContext.hasBeenCanceled()) {
                    return true;
                }
                FeedbackArcSetNode nextToNode = nextOut.getTo();
                THashSet depNodes = blockedNodes.get(nextToNode);
                if (depNodes == null) {
                    depNodes = new THashSet(2);
                    blockedNodes.put(nextToNode, (Set<FeedbackArcSetNode>)depNodes);
                }
                depNodes.add((FeedbackArcSetNode)currentNode);
            }
        }
        return unblock;
    }

    static List<FeedbackArcSetSimpleCycle> getMinimalSimpleCycles(IWorkerContext workerContext, Set<FeedbackArcSetNode> cyclicNodes) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getMinimalSimpleCycles' must not be null";
        assert (cyclicNodes != null) : "Parameter 'nodes' of method 'getMinimalSimpleCycles' must not be null";
        assert (cyclicNodes.size() >= 2);
        int numberOfNodes = cyclicNodes.size();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Find minimal simple cycles in " + numberOfNodes + " nodes");
        }
        ArrayList<FeedbackArcSetSimpleCycle> simpleCycles = new ArrayList<FeedbackArcSetSimpleCycle>(100);
        List sortedCyclicNodes = cyclicNodes.stream().sorted(Comparator.comparingInt(FeedbackArcSetNode::getTotalWeightOfUnderlyingOutgoingEdges).thenComparing(FeedbackArcSetNode::getName)).collect(Collectors.toList());
        int currentMaxEdgeWeight = 0;
        while (simpleCycles.isEmpty()) {
            if (workerContext.hasBeenCanceled()) {
                return Collections.emptyList();
            }
            currentMaxEdgeWeight += 15;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Current minimum edge weigth: " + currentMaxEdgeWeight);
            }
            Data data = new Data(workerContext, cyclicNodes, simpleCycles, currentMaxEdgeWeight);
            for (FeedbackArcSetNode nextStartNode : sortedCyclicNodes) {
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                data.startNode(nextStartNode);
                THashSet blocked = new THashSet(100);
                THashMap blockedNodes = new THashMap(100);
                FeedbackArcSetSimpleCyclesDetector.process(workerContext, nextStartNode, nextStartNode, (Set<FeedbackArcSetNode>)blocked, (Map<FeedbackArcSetNode, Set<FeedbackArcSetNode>>)blockedNodes, data);
                data.finishNode(nextStartNode);
            }
        }
        if (workerContext.hasBeenCanceled() || simpleCycles.isEmpty()) {
            return Collections.emptyList();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Find minimal simple cycles in " + numberOfNodes + " nodes  - done [" + simpleCycles.size() + "]");
        }
        return simpleCycles;
    }

    static final class Data {
        private final Set<FeedbackArcSetNode> m_alreadyProcessed = new THashSet();
        private final ArrayDeque<FeedbackArcSetNode.Edge> m_edgeStack = new ArrayDeque();
        private final List<FeedbackArcSetSimpleCycle> m_simpleCycles;
        private final IWorkerContext m_workerContext;
        private FeedbackArcSetNode m_startNode;
        private final Set<FeedbackArcSetNode> m_cyclicNodes;
        private int m_currentMaxEdgeWeight;
        private int m_currentEdgeWeight;

        Data(IWorkerContext workerContext, Set<FeedbackArcSetNode> cyclicNodes, List<FeedbackArcSetSimpleCycle> simpleCycles, int maxEdgeWeight) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'Data' must not be null";
            assert (cyclicNodes != null && cyclicNodes.size() >= 2) : "Parameter 'cyclicNodes' of method 'Data' must at least contain 2 nodes";
            assert (simpleCycles != null && simpleCycles.isEmpty()) : "Parameter 'simpleCycles' of method 'Data' must be empty";
            this.m_workerContext = workerContext;
            this.m_cyclicNodes = cyclicNodes;
            this.m_simpleCycles = simpleCycles;
            this.m_currentMaxEdgeWeight = maxEdgeWeight;
        }

        void startNode(FeedbackArcSetNode startNode) {
            assert (startNode != null) : "Parameter 'startNode' of method 'startNode' must not be null";
            assert (this.m_startNode == null);
            this.m_startNode = startNode;
        }

        boolean enterEdge(FeedbackArcSetNode.Edge nextOut) {
            assert (nextOut != null) : "Parameter 'nextOut' of method 'enter' must not be null";
            assert (this.m_startNode != null) : "Parameter 'm_startNode' of method 'enterEdge' must not be null";
            this.m_edgeStack.push(nextOut);
            this.m_currentEdgeWeight += nextOut.getWeightOfUnderlyingEdge();
            if (this.m_startNode == nextOut.getTo()) {
                boolean add = false;
                if (this.m_currentMaxEdgeWeight > this.m_currentEdgeWeight) {
                    this.m_simpleCycles.clear();
                    this.m_currentMaxEdgeWeight = this.m_currentEdgeWeight;
                    add = true;
                } else if (this.m_currentMaxEdgeWeight == this.m_currentEdgeWeight) {
                    add = true;
                }
                if (add) {
                    ArrayList<FeedbackArcSetNode.Edge> cycleEdges = new ArrayList<FeedbackArcSetNode.Edge>(this.m_edgeStack.size());
                    Iterator<FeedbackArcSetNode.Edge> edgeIter = this.m_edgeStack.descendingIterator();
                    while (edgeIter.hasNext()) {
                        if (this.m_workerContext.hasBeenCanceled()) {
                            return true;
                        }
                        cycleEdges.add(edgeIter.next());
                    }
                    this.m_simpleCycles.add(new FeedbackArcSetSimpleCycle(cycleEdges));
                }
                return true;
            }
            return false;
        }

        void leaveEdge(FeedbackArcSetNode.Edge nextOut) {
            assert (nextOut != null) : "Parameter 'nextOut' of method 'leaveEdge' must not be null";
            FeedbackArcSetNode.Edge removed = this.m_edgeStack.pop();
            assert (nextOut == removed);
            this.m_currentEdgeWeight -= nextOut.getWeightOfUnderlyingEdge();
            if (this.m_edgeStack.isEmpty()) assert (this.m_currentEdgeWeight == 0);
        }

        void finishNode(FeedbackArcSetNode node) {
            assert (node != null) : "Parameter 'node' of method 'finishNode' must not be null";
            assert (this.m_edgeStack.isEmpty());
            this.m_alreadyProcessed.add(node);
            this.m_startNode = null;
        }

        List<FeedbackArcSetNode.Edge> getOutgoingEdges(FeedbackArcSetNode node) {
            assert (node != null) : "Parameter 'node' of method 'getOutgoingEdges' must not be null";
            return node.getOutgoingEdges().stream().filter(e -> {
                FeedbackArcSetNode nextToNode = e.getTo();
                return !this.m_alreadyProcessed.contains(nextToNode) && this.m_cyclicNodes.contains(nextToNode) && this.m_currentEdgeWeight + e.getWeightOfUnderlyingEdge() <= this.m_currentMaxEdgeWeight;
            }).sorted(Comparator.comparingInt(FeedbackArcSetNode.Edge::getWeightOfUnderlyingEdge).thenComparing(FeedbackArcSetNode.Edge::getNameOfUnderlyingFrom).thenComparing(FeedbackArcSetNode.Edge::getNameOfUnderlyingTo)).collect(Collectors.toList());
        }
    }
}

