/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class PhysicalRecursiveElementInclusionCollector
extends NamedElementVisitor
implements Module.IVisitor,
RootDirectoryPath.IVisitor,
PhysicalRecursiveElement.IVisitor {
    private final Map<String, Data> m_nameToData = new THashMap();
    private final Class<?> m_nonRecursiveClass;

    PhysicalRecursiveElementInclusionCollector(Class<?> nonRecursiveClass) {
        assert (nonRecursiveClass != null) : "Parameter 'nonRecursiveClass' of method 'DirectoryFragmentInclusionCollector' must not be null";
        this.m_nonRecursiveClass = nonRecursiveClass;
    }

    @Override
    public void visitNamedElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
    }

    @Override
    public void visitModule(Module element) {
        assert (element != null) : "Parameter 'element' of method 'visitModule' must not be null";
        this.visitChildrenOf(element);
    }

    @Override
    public void visitRootDirectoryPath(RootDirectoryPath element) {
        assert (element != null) : "Parameter 'element' of method 'visitRootDirectoryPath' must not be null";
        this.visitChildrenOf(element);
    }

    @Override
    public void visitPhysicalRecursiveElement(PhysicalRecursiveElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitPhysicalRecursiveElement' must not be null";
        String name = element.getName();
        Data data = this.m_nameToData.get(name);
        if (data == null) {
            data = new Data();
            this.m_nameToData.put(name, data);
        }
        for (NamedElement next : element.getChildren()) {
            if (next.isExcluded()) continue;
            if (next instanceof PhysicalRecursiveElement) {
                if (((PhysicalRecursiveElement)next).isPart()) continue;
                data.incNumberOfRecursiveChildren();
                continue;
            }
            if (this.m_nonRecursiveClass.isAssignableFrom(next.getClass())) {
                data.incNumberOfNonRecursiveChildren();
                continue;
            }
            List<?> nonRecursiveChildren = next.getChildrenRecursively(this.m_nonRecursiveClass, PhysicalRecursiveElement.class, ProgrammingElement.class);
            data.incNumberOfNonRecursiveChildren(nonRecursiveChildren.size());
        }
        this.visitChildrenOf(element);
    }

    Set<String> consumeNames() {
        THashSet names = new THashSet();
        for (Map.Entry<String, Data> nextEntry : this.m_nameToData.entrySet()) {
            if (!nextEntry.getValue().include()) continue;
            names.add(nextEntry.getKey());
        }
        this.m_nameToData.clear();
        return names;
    }

    static final class Data {
        private int m_numberOfRecursiveChildren;
        private int m_numberOfNoneRecursiveChildren;

        Data() {
        }

        void incNumberOfRecursiveChildren() {
            ++this.m_numberOfRecursiveChildren;
        }

        void incNumberOfNonRecursiveChildren() {
            ++this.m_numberOfNoneRecursiveChildren;
        }

        void incNumberOfNonRecursiveChildren(int inc) {
            assert (inc >= 0) : "Parameter 'inc' of method 'incNumberOfNonRecursiveChildren' must not be negative";
            this.m_numberOfNoneRecursiveChildren += inc;
        }

        boolean include() {
            return this.m_numberOfRecursiveChildren > 1 || this.m_numberOfNoneRecursiveChildren > 0;
        }
    }
}

