/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.script.internal;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.metrics.MetricCategory;
import com.hello2morrow.sonargraph.core.model.script.IMetricIdProvider;
import com.hello2morrow.sonargraph.core.model.script.IScriptMetricId;
import com.hello2morrow.sonargraph.core.model.script.MetricSorting;
import com.hello2morrow.sonargraph.core.model.script.ScriptMetricId;
import java.util.HashMap;
import java.util.Map;

public final class ScriptMetricRepository
implements IMetricIdProvider {
    private final Map<String, ScriptMetricId> m_scriptMetrics = new HashMap<String, ScriptMetricId>();

    private boolean numberEquals(Number n1, Number n2) {
        if (n1 == null) {
            return n2 == null;
        }
        if (n2 == null) {
            return false;
        }
        return n1.equals(n2);
    }

    @Override
    public IScriptMetricId getOrCreateScriptMetricId(String identifyingScriptPath, String id, String presentationName, String description, boolean isFloat, Number lowerThreshold, Number upperThreshold, MetricSorting sorting, double minValue, double maxValue, String ... categoryIds) {
        assert (id != null) : "Parameter 'id' of method 'getOrCreateScriptMetricId' must not be null";
        assert (description != null) : "Parameter 'description' of method 'getOrCreateScriptMetricId' must not be null";
        ScriptMetricId result = this.m_scriptMetrics.get(id);
        if (result == null) {
            IMetricCategory[] coreMetricCategories = MetricCategory.values();
            result = new ScriptMetricId(identifyingScriptPath, id, presentationName, description, isFloat, lowerThreshold, upperThreshold, sorting, minValue, maxValue, Severity.WARNING, coreMetricCategories, categoryIds);
            this.m_scriptMetrics.put(id, result);
        } else {
            if (!result.getDescription().equals(description) || !result.getPresentationName().equals(presentationName) || result.isFloat() != isFloat) {
                return null;
            }
            if (!this.numberEquals(result.getLowerThreshold(), upperThreshold) || !this.numberEquals(result.getUpperThreshold(), upperThreshold)) {
                return null;
            }
            if (minValue != result.getMinValue() || maxValue != result.getMaxValue()) {
                return null;
            }
        }
        return result;
    }
}

