/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.script.internal;

import com.hello2morrow.sonargraph.api.IScriptAccess;
import com.hello2morrow.sonargraph.core.api.script.model.ResultAccess;
import com.hello2morrow.sonargraph.core.api.script.model.ScriptAccess;
import com.hello2morrow.sonargraph.core.model.script.IScriptApi;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ScriptApi
implements IScriptApi {
    private final Map<String, StrictPair<Object, Class<?>>> m_roots = new TreeMap();
    private final List<String> m_starImports = new ArrayList<String>();
    private final List<String> m_imports = new ArrayList<String>();
    private final String m_identifyingScriptPath;

    public ScriptApi(String identifyingScriptPath, ScriptAccess script, ResultAccess scriptResultSet) {
        assert (identifyingScriptPath != null && identifyingScriptPath.length() > 0) : "Parameter 'identifyingScriptPath' of method 'ScriptApi' must not be empty";
        assert (script != null) : "Parameter 'script' of method 'ScriptApi' must not be null";
        assert (scriptResultSet != null) : "Parameter 'scriptResultSet' of method 'ScriptApi' must not be null";
        this.m_identifyingScriptPath = identifyingScriptPath;
        this.m_starImports.add("de.schlichtherle.truezip.file");
        this.m_starImports.add("java.util");
        this.m_starImports.add("java.math");
        this.m_starImports.add("java.text");
        this.m_starImports.add("java.io");
        this.m_starImports.add("jxl");
        this.m_starImports.add("groovy.json");
        this.m_starImports.add("groovy.transform");
        this.defineScriptVariable("script", script, IScriptAccess.class);
        this.defineScriptVariable("result", scriptResultSet, ResultAccess.class);
        this.defineScriptVariable("out", new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        }, OutputStream.class);
        for (StrictPair<Object, Class<?>> next : this.m_roots.values()) {
            this.m_imports.add(((Class)next.getSecond()).getName());
        }
        Collections.sort(this.m_imports);
    }

    public String getIndentifyingScriptPath() {
        return this.m_identifyingScriptPath;
    }

    public void defineScriptVariable(String name, Object var, Class<?> clazz) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'defineScriptVariable' must not be empty";
        StrictPair previous = this.m_roots.put(name, new StrictPair(var, clazz));
        assert (previous == null) : "'previous' of method 'ScriptApi' must be null";
    }

    public void addStarImport(String pkgName) {
        this.m_starImports.add(pkgName);
    }

    public boolean isDefined(String varName) {
        return this.m_roots.get(varName) != null;
    }

    public void addImport(String clsName) {
        this.m_imports.add(clsName);
    }

    @Override
    public Version getVersion() {
        return Version.create((int)1, (int)0, (int)0, (int)0);
    }

    @Override
    public List<String> getStarImports() {
        return Collections.unmodifiableList(this.m_starImports);
    }

    @Override
    public List<String> getImports() {
        return Collections.unmodifiableList(this.m_imports);
    }

    @Override
    public Map<String, StrictPair<Object, Class<?>>> getRoots() {
        return Collections.unmodifiableMap(this.m_roots);
    }
}

