/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.controller.system.representation.NonRecursiveModeCollector;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import java.util.Collection;

public final class NonPartChildrenCollector
extends NonRecursiveModeCollector {
    private final boolean m_includeParent;
    private final boolean m_collectIfFlatNotAllowed;

    public NonPartChildrenCollector(NamedElement parent, Collection<NamedElement> collector, boolean includeParent, boolean collectIfFlatNotAllowed) {
        super(parent, collector);
        this.m_includeParent = includeParent;
        this.m_collectIfFlatNotAllowed = collectIfFlatNotAllowed;
    }

    @Override
    public void visitNamedElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        if (this.getParent() == element) {
            if (this.m_includeParent && element instanceof IRecursiveElement && !((IRecursiveElement)((Object)element)).isPart()) {
                this.addCollected(element);
            }
            this.visitChildrenOf(element);
        } else if (element instanceof IRecursiveElement) {
            if (!((IRecursiveElement)((Object)element)).isPart()) {
                this.addCollected(element);
            }
            this.visitChildrenOf(element);
        } else if (this.m_collectIfFlatNotAllowed) {
            this.addCollected(element);
        }
    }
}

