/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.parser;

import com.hello2morrow.sonargraph.core.controller.system.parser.AbstractSourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.parser.ISourceLineProcessor;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.io.IOException;
import java.io.StringReader;

public final class SourceLineProcessor
extends AbstractSourceLineProcessor {
    private State m_currentState;
    private int m_currentOffset;
    private int m_currentStartOffset;
    private int m_linesOfCode;
    private boolean m_lineHasCode;
    private StringBuilder m_collector;

    public SourceLineProcessor() {
        this.reset();
    }

    @Override
    protected void reset() {
        this.m_currentState = State.WORD;
        this.m_linesOfCode = 0;
        this.m_currentOffset = 0;
        this.m_currentStartOffset = 0;
        this.m_lineHasCode = false;
        this.m_collector = new StringBuilder();
    }

    private void dispatchCollectorContent(ISourceLineProcessor.SourceLineVisitor visitor, int removeFromTail) {
        assert (this.m_collector != null) : "Parameter 'm_collector' of method 'dispatchCollectorContent' must not be null";
        assert (this.m_currentState != null) : "Parameter 'm_currentState' of method 'dispatchCollectorContent' must not be null";
        assert (visitor != null) : "Parameter 'visitor' of method 'processCollector' must not be null";
        if (this.m_collector.length() > 0) {
            assert (this.m_collector.length() >= removeFromTail) : "'removeFromTail' to high";
            String content = this.m_collector.substring(0, this.m_collector.length() - removeFromTail);
            if (!content.isEmpty()) {
                switch (this.m_currentState) {
                    case CHAR: {
                        visitor.visitCharLiteral(this.m_currentStartOffset, content);
                        break;
                    }
                    case WORD: {
                        visitor.visitWord(this.m_currentStartOffset, content);
                        break;
                    }
                    case OTHER: {
                        visitor.visitOther(this.m_currentStartOffset, content);
                        break;
                    }
                    case AT: {
                        visitor.visitAt(this.m_currentStartOffset, content);
                        break;
                    }
                    case NUMBER_SIGN: {
                        visitor.visitNumberSign(this.m_currentStartOffset, content);
                        break;
                    }
                    case LINE_COMMENT: {
                        visitor.visitSingleLineComment(this.m_currentStartOffset, content);
                        break;
                    }
                    case MULTI_LINE_COMMENT: {
                        visitor.visitMultiLineComment(this.m_currentStartOffset, content);
                        break;
                    }
                    case STRING: 
                    case MULTI_LINE_STRING: {
                        visitor.visitStringLiteral(this.m_currentStartOffset, content);
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled state: " + String.valueOf((Object)this.m_currentState);
                        break;
                    }
                }
                this.m_collector.delete(0, content.length());
            }
        }
    }

    private int readAndAppend(StringReader reader) {
        assert (reader != null) : "Parameter 'reader' of method 'readAndAppend' must not be null";
        assert (this.m_collector != null) : "Parameter 'm_collector' of method 'append' must not be null";
        int ch = 0;
        try {
            reader.mark(0);
            ch = reader.read();
            if (ch != -1) {
                this.m_collector.append((char)ch);
                ++this.m_currentOffset;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ch;
    }

    private boolean handleWordOrOther(ISourceLineProcessor.SourceLineVisitor visitor, int ch, StringReader reader) {
        assert (this.m_collector.length() >= 1);
        if (ch == 47) {
            ch = this.readAndAppend(reader);
            if (ch == 42) {
                this.dispatchCollectorContent(visitor, 2);
                this.m_currentStartOffset = this.m_currentOffset - 2;
                this.m_currentState = State.MULTI_LINE_COMMENT;
            } else if (ch == 47) {
                this.dispatchCollectorContent(visitor, 2);
                this.m_currentStartOffset = this.m_currentOffset - 2;
                this.m_currentState = State.LINE_COMMENT;
            } else {
                this.m_lineHasCode = true;
            }
        } else if (ch == 34) {
            ch = this.readAndAppend(reader);
            if (ch == 34) {
                ch = this.readAndAppend(reader);
                int remove = ch > 0 ? 3 : 2;
                this.dispatchCollectorContent(visitor, remove);
                this.m_currentStartOffset = this.m_currentOffset - remove;
                if (ch == 34) {
                    this.m_currentState = State.MULTI_LINE_STRING;
                } else {
                    this.m_currentState = State.STRING;
                    this.dispatchCollectorContent(visitor, remove - 2);
                    this.m_currentStartOffset = this.m_currentOffset - (remove - 2);
                    this.m_currentState = State.WORD;
                }
            } else {
                int remove = ch > 0 ? 2 : 1;
                this.dispatchCollectorContent(visitor, remove);
                this.m_currentStartOffset = this.m_currentOffset - remove;
                this.m_currentState = State.STRING;
            }
            this.m_lineHasCode = true;
        } else if (ch == 64) {
            this.dispatchCollectorContent(visitor, 1);
            this.m_currentStartOffset = this.m_currentOffset - 1;
            this.m_currentState = State.AT;
            this.m_lineHasCode = true;
        } else if (ch == 35) {
            this.dispatchCollectorContent(visitor, 1);
            this.m_currentStartOffset = this.m_currentOffset - 1;
            this.m_currentState = State.NUMBER_SIGN;
            this.m_lineHasCode = true;
        } else if (ch == 39) {
            this.dispatchCollectorContent(visitor, 1);
            this.m_currentStartOffset = this.m_currentOffset - 1;
            this.m_currentState = State.CHAR;
            this.m_lineHasCode = true;
        } else {
            if (!StringUtility.isWhitespace((int)ch)) {
                this.m_lineHasCode = true;
                return true;
            }
            this.m_collector.deleteCharAt(this.m_collector.length() - 1);
            this.dispatchCollectorContent(visitor, 0);
            this.m_currentStartOffset = this.m_currentOffset;
        }
        return false;
    }

    private void finishCharacterProcessing(StringReader reader, ISourceLineProcessor.SourceLineVisitor visitor, State state) throws IOException {
        assert (reader != null) : "Parameter 'reader' of method 'finishCharacterProcessing' must not be null";
        assert (visitor != null) : "Parameter 'visitor' of method 'finishCharacterProcessing' must not be null";
        assert (state != null) : "Parameter 'state' of method 'finishCharacterProcessing' must not be null";
        reader.reset();
        this.m_collector.deleteCharAt(this.m_collector.length() - 1);
        this.dispatchCollectorContent(visitor, 0);
        --this.m_currentOffset;
        this.m_currentStartOffset = this.m_currentOffset;
        this.m_currentState = state;
    }

    private void finishEndOfLine(ISourceLineProcessor.SourceLineVisitor visitor, boolean lineHasNonEmptyComment) {
        assert (visitor != null) : "Parameter 'visitor' of method 'finishEndOfLine' must not be null";
        if (this.m_lineHasCode) {
            visitor.visitEndOfLine();
            ++this.m_linesOfCode;
        }
        if (lineHasNonEmptyComment) {
            if (this.m_linesOfCode > 0) {
                visitor.visitEndOfCodeCommentLine();
            }
            visitor.visitEndOfCommentLine();
        }
        if (this.m_currentState != State.MULTI_LINE_COMMENT && this.m_currentState != State.MULTI_LINE_STRING) {
            this.dispatchCollectorContent(visitor, 0);
            this.m_currentState = State.WORD;
        } else {
            this.m_collector.append(StringUtility.DEFAULT_LINE_SEPARATOR);
        }
        ++this.m_currentOffset;
        if (this.m_currentState != State.MULTI_LINE_COMMENT && this.m_currentState != State.MULTI_LINE_STRING) {
            this.m_currentStartOffset = this.m_currentOffset;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void processLine(String line, ISourceLineProcessor.SourceLineVisitor visitor) {
        reader = new StringReader(line);
        this.m_lineHasCode = false;
        lineHasNonEmptyComment = false;
        escapeString = false;
        stringLiteralInMultilineComment = false;
        try {
            block13: while (true) lbl-1000:
            // 25 sources

            {
                if ((ch = this.readAndAppend(reader)) == -1) {
                    this.finishEndOfLine(visitor, lineHasNonEmptyComment);
                    return;
                }
                switch (SourceLineProcessor.$SWITCH_TABLE$com$hello2morrow$sonargraph$core$controller$system$parser$SourceLineProcessor$State()[this.m_currentState.ordinal()]) {
                    case 1: {
                        if (!this.handleWordOrOther(visitor, ch, reader) || visitor.isWordCharacter(ch)) continue block13;
                        this.finishCharacterProcessing(reader, visitor, State.OTHER);
                        ** break;
                    }
                    case 2: {
                        if (!this.handleWordOrOther(visitor, ch, reader) || !Character.isJavaIdentifierStart(ch)) continue block13;
                        this.finishCharacterProcessing(reader, visitor, State.WORD);
                        ** break;
                    }
                    case 7: {
                        if (Character.isJavaIdentifierPart(ch) || ch == 46) continue block13;
                        this.dispatchCollectorContent(visitor, 0);
                        this.m_currentStartOffset = this.m_currentOffset;
                        this.m_currentState = State.WORD;
                        ** break;
                    }
                    case 8: {
                        if (Character.isJavaIdentifierPart(ch)) ** break;
                        this.finishCharacterProcessing(reader, visitor, State.WORD);
                        ** break;
                    }
                    case 3: {
                        if (Character.isWhitespace(ch)) ** break;
                        lineHasNonEmptyComment = true;
                        ** break;
                    }
                    case 4: {
                        if (ch == 34) {
                            v0 = stringLiteralInMultilineComment = stringLiteralInMultilineComment == false;
                        }
                        if (stringLiteralInMultilineComment) ** break;
                        if (ch == 42) {
                            while ((ch = this.readAndAppend(reader)) == 42) {
                            }
                            if (ch == 47) {
                                this.dispatchCollectorContent(visitor, 0);
                                this.m_currentStartOffset = this.m_currentOffset;
                                this.m_currentState = State.WORD;
                                ** break;
                            }
                        }
                        if (ch == -1 || Character.isWhitespace(ch)) continue block13;
                        lineHasNonEmptyComment = true;
                        ** break;
                    }
                    case 9: {
                        if (ch == 34 && (ch = this.readAndAppend(reader)) == 34 && (ch = this.readAndAppend(reader)) == 34) {
                            this.dispatchCollectorContent(visitor, 0);
                            this.m_currentStartOffset = this.m_currentOffset;
                            this.m_currentState = State.WORD;
                            ** break;
                        }
                        this.m_lineHasCode = true;
                        ** break;
                    }
                    case 6: {
                        if (ch == 34) {
                            if (!escapeString) {
                                this.dispatchCollectorContent(visitor, 0);
                                this.m_currentStartOffset = this.m_currentOffset;
                                this.m_currentState = State.WORD;
                                ** break;
                            }
                            escapeString = false;
                            ** break;
                        }
                        if (ch == 92) {
                            escapeString = true;
                            ** break;
                        }
                        escapeString = false;
                        ** break;
                    }
                    case 5: {
                        if (ch == 92) {
                            ch = this.readAndAppend(reader);
                            ** break;
                        }
                        if (ch != 39) ** break;
                        this.dispatchCollectorContent(visitor, 0);
                        this.m_currentStartOffset = this.m_currentOffset;
                        this.m_currentState = State.WORD;
                        continue block13;
                    }
                }
            }
        }
        catch (IOException var8_8) {
            // empty catch block
        }
    }

    static enum State {
        WORD,
        OTHER,
        LINE_COMMENT,
        MULTI_LINE_COMMENT,
        CHAR,
        STRING,
        AT,
        NUMBER_SIGN,
        MULTI_LINE_STRING;

    }
}

