/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusTransitivelyCollector;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.set.hash.THashSet;
import java.util.Set;

final class FocusTransitivelyCollectorLeafBased
extends FocusTransitivelyCollector {
    private final ExplorationViewRepresentation m_representation;
    private final Set<ProgrammingElement> m_alreadySeen = new THashSet();
    private Set<ProgrammingElement> m_in = new THashSet();
    private Set<ProgrammingElement> m_out = new THashSet();

    FocusTransitivelyCollectorLeafBased(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'TransitivelyCollector' must not be null";
        this.m_representation = representation;
    }

    @Override
    void addIn(ProgrammingElement in) {
        assert (in != null) : "Parameter 'in' of method 'addIn' must not be null";
        ArchitecturalViewNode leaf = this.m_representation.getLeafNode(in);
        assert (leaf != null) : "Parameter 'leaf' of method 'addIn' must not be null for: " + in.getDebugInfo();
        for (ProgrammingElement next : leaf.getRelevantProgrammingElements()) {
            if (!this.m_alreadySeen.add(next)) continue;
            this.m_in.add(next);
        }
    }

    @Override
    void addOut(ProgrammingElement out) {
        assert (out != null) : "Parameter 'in' of method 'addOut' must not be null";
        ArchitecturalViewNode leaf = this.m_representation.getLeafNode(out);
        assert (leaf != null) : "Parameter 'leaf' of method 'addOut' must not be null: " + out.getDebugInfo();
        for (ProgrammingElement next : leaf.getRelevantProgrammingElements()) {
            if (!this.m_alreadySeen.add(next)) continue;
            this.m_out.add(next);
        }
    }

    @Override
    Set<ProgrammingElement> consumeIn() {
        Set<ProgrammingElement> in = this.m_in;
        this.m_in = new THashSet();
        return in;
    }

    @Override
    Set<ProgrammingElement> consumeOut() {
        Set<ProgrammingElement> out = this.m_out;
        this.m_out = new THashSet();
        return out;
    }

    @Override
    boolean isEmpty() {
        return this.m_in.isEmpty() && this.m_out.isEmpty();
    }
}

