/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.refactoring.AssignableToArtifactRefactoringDescriptor;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.Set;

final class AssignableToArtifactRenameValidator
implements ITextValidator {
    private final AssignableToArtifactRefactoringDescriptor m_descriptor;
    private final AssignableToArtifactNode m_element;
    private final Set<ArchitecturalViewNode> m_alreadyContained;

    AssignableToArtifactRenameValidator(AssignableToArtifactRefactoringDescriptor descriptor, AssignableToArtifactNode element, Set<ArchitecturalViewNode> alreadyContained) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'AssignableToArtifactRenameValidator' must not be null";
        assert (element != null) : "Parameter 'element' of method 'AssignableToArtifactRenameValidator' must not be null";
        assert (alreadyContained != null) : "Parameter 'alreadyContained' of method 'AssignableToArtifactRenameValidator' must not be null";
        this.m_descriptor = descriptor;
        this.m_element = element;
        this.m_alreadyContained = alreadyContained;
    }

    @Override
    public ValidationResult isValid(String currentInput, String newInput) {
        ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
        if (newInput != null) {
            newInput = newInput.trim();
        }
        if (newInput == null || newInput.isEmpty()) {
            result.addError("Must not be empty");
        } else {
            for (ArchitecturalViewNode nextExistingChild : this.m_alreadyContained) {
                if (nextExistingChild == this.m_element || !newInput.equalsIgnoreCase(this.m_descriptor.getRelevantNamePartForRename(nextExistingChild.getName()))) continue;
                result.addError("Element '" + newInput + "' already exists");
                break;
            }
            if (result.isSuccess() && !this.m_descriptor.isValidNameForRename(newInput)) {
                result.addError("Not a valid name");
            }
        }
        return result;
    }
}

