/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.AbstractIssueDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.DuplicateCodeBlockDiffMatcher;
import com.hello2morrow.sonargraph.core.controller.system.diff.DuplicateCodeBlockOccurrenceMatcher;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffUtility;
import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.BaselineOccurrenceDto;
import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.CurrentOccurrenceDto;
import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.DuplicateDto;
import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.DuplicateOccurrenceDto;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockOccurrenceDiff;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IDuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.integration.access.model.IDuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCodeBlockIssueDiffProcessor
extends AbstractIssueDiffProcessor<IDuplicateCodeBlockIssue, DuplicateCodeBlockIssue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuplicateCodeBlockIssueDiffProcessor.class);
    private static final double SCORE_THRESHOLD = 0.2;

    public DuplicateCodeBlockIssueDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, Set<IIssue> allBaselineIssues, SoftwareSystem softwareSystem, Set<Issue> allCurrentIssues, Map<NamedElement, String> namedElementToFqNameCache) {
        super(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, softwareSystem, allCurrentIssues, namedElementToFqNameCache, IDuplicateCodeBlockIssue.class, DuplicateCodeBlockIssue.class);
    }

    @Override
    protected void computeDiffs(NamedElement parent, List<IDuplicateCodeBlockIssue> baselineIssues, List<DuplicateCodeBlockIssue> currentIssues) {
        assert (parent != null) : "Parameter 'parent' of method 'computeDiffs' must not be null";
        assert (baselineIssues != null) : "Parameter 'baselineIssues' of method 'computeDiffs' must not be null";
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'computeDiffs' must not be null";
        List<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselineDuplicates = this.collectBaselineDuplicateIssues(baselineIssues);
        List<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> currentDuplicates = this.collectCurrentDuplicateIssues(currentIssues);
        this.processExactMatches(parent, baselineDuplicates, currentDuplicates);
        this.processModified(parent, baselineDuplicates, currentDuplicates);
        this.processRemoved(parent, baselineDuplicates);
        this.processAdded(parent, currentDuplicates);
        assert (baselineDuplicates.isEmpty()) : "Not all baseline cycles processed! Remaining: " + String.valueOf(baselineDuplicates.stream().map(pair -> ((DuplicateDto)pair.getFirst()).toString()).collect(Collectors.toList()));
        assert (currentDuplicates.isEmpty()) : "Not all current cycles processed! Remaining: " + String.valueOf(currentDuplicates.stream().map(pair -> ((DuplicateDto)pair.getFirst()).toString()).collect(Collectors.toList()));
    }

    private List<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> collectBaselineDuplicateIssues(List<IDuplicateCodeBlockIssue> baselineIssues) {
        assert (baselineIssues != null) : "Parameter 'baselineIssues' of method 'collectBaselineDuplicateIssues' must not be null";
        ArrayList<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselineDtos = new ArrayList<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>>(baselineIssues.size());
        for (IDuplicateCodeBlockIssue nextBaseline : baselineIssues) {
            List baselineOccurrences = nextBaseline.getOccurrences();
            ArrayList<BaselineOccurrenceDto> occurrenceDtos = new ArrayList<BaselineOccurrenceDto>(baselineOccurrences.size());
            for (IDuplicateCodeBlockOccurrence nextOccurrence : baselineOccurrences) {
                occurrenceDtos.add(new BaselineOccurrenceDto(nextOccurrence));
            }
            Collections.sort(occurrenceDtos);
            DuplicateDto duplicateDto = new DuplicateDto(nextBaseline.getPresentationName(), nextBaseline.getTotalDuplicateLineCount(), occurrenceDtos);
            baselineDtos.add((StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>)new StrictPair(duplicateDto, (Object)nextBaseline));
        }
        Collections.sort(baselineDtos, new Comparator<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>>(){

            @Override
            public int compare(StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> pair1, StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> pair2) {
                return ((DuplicateDto)pair1.getFirst()).compareTo((DuplicateDto)pair2.getFirst());
            }
        });
        return baselineDtos;
    }

    private List<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> collectCurrentDuplicateIssues(List<DuplicateCodeBlockIssue> currentIssues) {
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'collectCurrentDuplicateIssues' must not be null";
        ArrayList<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> currentDtos = new ArrayList<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>>(currentIssues.size());
        for (DuplicateCodeBlockIssue nextCurrent : currentIssues) {
            DuplicateCodeBlock duplicateCodeBlock = (DuplicateCodeBlock)nextCurrent.getAffectedElement();
            List<DuplicateCodeBlockOccurrence> occurrences = duplicateCodeBlock.getChildren(DuplicateCodeBlockOccurrence.class);
            ArrayList<CurrentOccurrenceDto> occurrenceDtos = new ArrayList<CurrentOccurrenceDto>(occurrences.size());
            for (DuplicateCodeBlockOccurrence nextOccurrence : occurrences) {
                CurrentOccurrenceDto occurrenceDto = new CurrentOccurrenceDto(nextOccurrence);
                occurrenceDtos.add(occurrenceDto);
            }
            Collections.sort(occurrenceDtos);
            DuplicateDto duplicateDto = new DuplicateDto(nextCurrent.getAffectedElement().getName(), duplicateCodeBlock.getTotalDuplicateLineCount(), occurrenceDtos);
            currentDtos.add((StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>)new StrictPair(duplicateDto, (Object)nextCurrent));
        }
        Collections.sort(currentDtos, new Comparator<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>>(){

            @Override
            public int compare(StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> pair1, StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> pair2) {
                return ((DuplicateDto)pair1.getFirst()).compareTo((DuplicateDto)pair2.getFirst());
            }
        });
        return currentDtos;
    }

    private void processExactMatches(NamedElement parent, List<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselineDuplicates, List<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> currentDuplicates) {
        assert (baselineDuplicates != null) : "Parameter 'baselineDuplicates' of method 'processExactMatches' must not be null";
        assert (currentDuplicates != null) : "Parameter 'currentDuplicates' of method 'processExactMatches' must not be null";
        if (baselineDuplicates.isEmpty() || currentDuplicates.isEmpty()) {
            return;
        }
        HashSet<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselinesToRemove = new HashSet<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>>();
        HashSet<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> currentsToRemove = new HashSet<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>>();
        block0: for (StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> baselinePair : baselineDuplicates) {
            DuplicateDto baselineDto = (DuplicateDto)baselinePair.getFirst();
            for (StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> currentPair : currentDuplicates) {
                if (currentsToRemove.contains(currentPair)) continue;
                DuplicateDto currentDto = (DuplicateDto)currentPair.getFirst();
                int compare = baselineDto.compareTo(currentDto);
                if (compare == 0) {
                    DuplicateCodeBlockIssueDiff diff = this.determineDiffForExactMatches(parent, baselineDto, (IDuplicateCodeBlockIssue)baselinePair.getSecond(), currentDto, (DuplicateCodeBlockIssue)currentPair.getSecond());
                    if (diff == null) continue;
                    parent.addChild(diff);
                    baselinesToRemove.add(baselinePair);
                    currentsToRemove.add(currentPair);
                    continue block0;
                }
                if (compare < 0) continue block0;
            }
        }
        baselineDuplicates.removeAll(baselinesToRemove);
        currentDuplicates.removeAll(currentsToRemove);
    }

    private DuplicateCodeBlockIssueDiff determineDiffForExactMatches(NamedElement parent, DuplicateDto<BaselineOccurrenceDto> baseline, IDuplicateCodeBlockIssue baselineDuplicateIssue, DuplicateDto<CurrentOccurrenceDto> current, DuplicateCodeBlockIssue currentDuplicateIssue) {
        String changeDescription;
        IDiffElement.Change change;
        assert (parent != null) : "Parameter 'parent' of method 'determineDiff' must not be null";
        assert (baseline != null) : "Parameter 'baseline' of method 'determineDiff' must not be null";
        assert (baselineDuplicateIssue != null) : "Parameter 'baselineDuplicateIssue' of method 'determineDiffForExactMatches' must not be null";
        assert (current != null) : "Parameter 'current' of method 'determineDiff' must not be null";
        assert (currentDuplicateIssue != null) : "Parameter 'currentDuplicateIssue' of method 'determineDiffForExactMatches' must not be null";
        List<BaselineOccurrenceDto> baselineOccurrences = baseline.getOccurrences();
        List<CurrentOccurrenceDto> currentOccurrences = current.getOccurrences();
        assert (baselineOccurrences.size() == currentOccurrences.size()) : "Equal sizes expected, but was " + baselineOccurrences.size() + " (baseline) " + currentOccurrences.size() + " (current)";
        Pair<IDiffElement.Change, String> determineResolutionChange = this.determineResolutionChange(baselineDuplicateIssue, currentDuplicateIssue);
        if (determineResolutionChange.getFirst() != IDiffElement.Change.UNMODIFIED) {
            change = (IDiffElement.Change)((Object)determineResolutionChange.getFirst());
            changeDescription = (String)determineResolutionChange.getSecond();
        } else {
            change = IDiffElement.Change.UNMODIFIED;
            changeDescription = "";
        }
        DuplicateCodeBlockIssueDiff diff = new DuplicateCodeBlockIssueDiff(parent, baselineDuplicateIssue, currentDuplicateIssue, change, changeDescription, DuplicateCodeBlockIssueDiff.DuplicateChange.UNMODIFIED);
        int i = 0;
        while (i < baselineOccurrences.size()) {
            CurrentOccurrenceDto currentOcc;
            BaselineOccurrenceDto baselineOcc = baselineOccurrences.get(i);
            if (baselineOcc.compareTo(currentOcc = currentOccurrences.get(i)) != 0) {
                return null;
            }
            DuplicateCodeBlockOccurrenceDiff occurrenceDiff = new DuplicateCodeBlockOccurrenceDiff(diff, (IDuplicateCodeBlockOccurrence)baselineOcc.getOccurrence(), (DuplicateCodeBlockOccurrence)currentOcc.getOccurrence(), IDiffElement.Change.UNMODIFIED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.UNMODIFIED, "");
            diff.addChild(occurrenceDiff);
            ++i;
        }
        return diff;
    }

    private void processModified(NamedElement parent, List<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselineDuplicates, List<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> currentDuplicates) {
        assert (parent != null) : "Parameter 'parent' of method 'processModified' must not be null";
        assert (baselineDuplicates != null) : "Parameter 'baselineDuplicates' of method 'processModified' must not be null";
        assert (currentDuplicates != null) : "Parameter 'currentDuplicates' of method 'processModified' must not be null";
        ArrayList<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselinesToRemove = new ArrayList<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>>();
        ArrayList<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> currentToRemove = new ArrayList<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>>();
        block0: for (StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> nextCurrentPair : currentDuplicates) {
            ArrayList<ScoreInfo> scoreInfo = new ArrayList<ScoreInfo>();
            for (StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> nextBaselinePair : baselineDuplicates) {
                StrictPair<Double, Integer> score = DuplicateCodeBlockDiffMatcher.match((DuplicateDto)nextBaselinePair.getFirst(), (DuplicateDto)nextCurrentPair.getFirst());
                if (Double.compare((Double)score.getFirst(), 1.0) == 0) {
                    DuplicateCodeBlockIssueDiff diff = this.createDiff(parent, nextBaselinePair, nextCurrentPair);
                    parent.addChild(diff);
                    baselinesToRemove.add(nextBaselinePair);
                    currentToRemove.add(nextCurrentPair);
                    continue block0;
                }
                if (!((Double)score.getFirst() > 0.0)) continue;
                scoreInfo.add(new ScoreInfo((Double)score.getFirst(), (Integer)score.getSecond(), nextBaselinePair, nextCurrentPair));
            }
            if (scoreInfo.size() <= 0) continue;
            scoreInfo.sort(new Comparator<ScoreInfo>(){

                @Override
                public int compare(ScoreInfo o1, ScoreInfo o2) {
                    int compareUnmatched = Integer.compare(o2.getUnmatchedOccurrences(), o1.getUnmatchedOccurrences());
                    if (compareUnmatched == 0) {
                        return Double.compare(o1.getScore(), o2.getScore());
                    }
                    return compareUnmatched;
                }
            });
            ScoreInfo bestMatch = (ScoreInfo)scoreInfo.get(scoreInfo.size() - 1);
            if (bestMatch.getScore() > 0.2) {
                DuplicateCodeBlockIssueDiff diff = this.createDiff(parent, bestMatch.getBaselinePair(), bestMatch.getCurrentPair());
                parent.addChild(diff);
                baselinesToRemove.add(bestMatch.getBaselinePair());
                currentToRemove.add(bestMatch.getCurrentPair());
                continue;
            }
            LOGGER.debug("Ignoring 'modified' match of '{}' and '{}', because score of {} is below threshold", new Object[]{bestMatch.getBaselinePair().getFirst(), bestMatch.getCurrentPair().getFirst(), bestMatch.getScore()});
        }
        baselineDuplicates.removeAll(baselinesToRemove);
        currentDuplicates.removeAll(currentToRemove);
    }

    private DuplicateCodeBlockIssueDiff createDiff(NamedElement parent, StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> baselinePair, StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> currentPair) {
        DuplicateDto baselineDuplicateDto = (DuplicateDto)baselinePair.getFirst();
        IDuplicateCodeBlockIssue baselineIssue = (IDuplicateCodeBlockIssue)baselinePair.getSecond();
        DuplicateDto currentDuplicateDto = (DuplicateDto)currentPair.getFirst();
        DuplicateCodeBlockIssue currentIssue = (DuplicateCodeBlockIssue)currentPair.getSecond();
        ArrayList baselineOccurenceDtos = new ArrayList(baselineDuplicateDto.getOccurrences());
        Pair<IDiffElement.Change, String> resolutionChange = this.determineResolutionChange(baselineIssue, currentIssue);
        IDiffElement.Change change = (IDiffElement.Change)((Object)resolutionChange.getFirst());
        String changeDescription = (String)resolutionChange.getSecond();
        ArrayList<OccurrenceDiffDto> occurrenceDiffDtos = new ArrayList<OccurrenceDiffDto>();
        HashMap baselineOccurrencesToDiffMap = new HashMap();
        for (CurrentOccurrenceDto currentOccurrenceDto : currentDuplicateDto.getOccurrences()) {
            DuplicateOccurrenceDto baselineOccBestMatch = null;
            DuplicateCodeBlockDiffMatcher.OccurrenceMatchResult bestMatchResult = null;
            int i = 0;
            while (i < baselineOccurenceDtos.size()) {
                BaselineOccurrenceDto nextBaselineOcc = (BaselineOccurrenceDto)baselineOccurenceDtos.get(i);
                StrictPair<DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail, Integer> matchInfo = DuplicateCodeBlockOccurrenceMatcher.getChangeDetail(currentOccurrenceDto, nextBaselineOcc);
                if (matchInfo != null) {
                    if (matchInfo.getFirst() == DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.UNMODIFIED) {
                        bestMatchResult = new DuplicateCodeBlockDiffMatcher.OccurrenceMatchResult((DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail)((Object)matchInfo.getFirst()), (Integer)matchInfo.getSecond(), Math.max(currentOccurrenceDto.getBlockSize(), nextBaselineOcc.getBlockSize()), i);
                        baselineOccBestMatch = nextBaselineOcc;
                        break;
                    }
                    if (bestMatchResult == null || (Integer)matchInfo.getSecond() > bestMatchResult.getOverlap()) {
                        bestMatchResult = new DuplicateCodeBlockDiffMatcher.OccurrenceMatchResult((DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail)((Object)matchInfo.getFirst()), (Integer)matchInfo.getSecond(), Math.max(currentOccurrenceDto.getBlockSize(), nextBaselineOcc.getBlockSize()), i);
                        baselineOccBestMatch = nextBaselineOcc;
                    }
                }
                ++i;
            }
            if (baselineOccBestMatch != null && bestMatchResult != null) {
                IDiffElement.Change convertedChange = bestMatchResult.getChangeDetail().convertToChange();
                IDuplicateCodeBlockOccurrence baselineOccurrence = (IDuplicateCodeBlockOccurrence)baselineOccBestMatch.getOccurrence();
                String occChangeDescription = this.createOccurrenceChangeDescription(baselineOccurrence, (DuplicateCodeBlockOccurrence)currentOccurrenceDto.getOccurrence(), convertedChange, bestMatchResult.getChangeDetail());
                OccurrenceDiffDto dto = new OccurrenceDiffDto(baselineOccurrence, (DuplicateCodeBlockOccurrence)currentOccurrenceDto.getOccurrence(), convertedChange, bestMatchResult.getChangeDetail(), occChangeDescription, bestMatchResult.getOverlap());
                ArrayList<OccurrenceDiffDto> baselineMatches = (ArrayList<OccurrenceDiffDto>)baselineOccurrencesToDiffMap.get(baselineOccBestMatch);
                if (baselineMatches == null) {
                    baselineMatches = new ArrayList<OccurrenceDiffDto>();
                    baselineOccurrencesToDiffMap.put(baselineOccBestMatch, baselineMatches);
                } else if (bestMatchResult.getChangeDetail() == DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.UNMODIFIED) {
                    baselineMatches.clear();
                }
                baselineMatches.add(dto);
                continue;
            }
            String occChangeDescription = this.createOccurrenceChangeDescription(null, (DuplicateCodeBlockOccurrence)currentOccurrenceDto.getOccurrence(), IDiffElement.Change.ADDED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.ADDED);
            OccurrenceDiffDto dto = new OccurrenceDiffDto(null, (DuplicateCodeBlockOccurrence)currentOccurrenceDto.getOccurrence(), IDiffElement.Change.ADDED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.ADDED, occChangeDescription, 0);
            occurrenceDiffDtos.add(dto);
        }
        for (Map.Entry entry : baselineOccurrencesToDiffMap.entrySet()) {
            List diffMatches = (List)entry.getValue();
            if (diffMatches.size() > 1) {
                diffMatches.sort(new Comparator<OccurrenceDiffDto>(){

                    @Override
                    public int compare(OccurrenceDiffDto o1, OccurrenceDiffDto o2) {
                        return Integer.compare(o1.getOverlap(), o2.getOverlap());
                    }
                });
            }
            OccurrenceDiffDto baselineOccDto = (OccurrenceDiffDto)diffMatches.get(diffMatches.size() - 1);
            occurrenceDiffDtos.add(baselineOccDto);
            baselineOccurenceDtos.remove(entry.getKey());
        }
        for (BaselineOccurrenceDto baselineOccurrenceDto : baselineOccurenceDtos) {
            String occChangeDescription = this.createOccurrenceChangeDescription((IDuplicateCodeBlockOccurrence)baselineOccurrenceDto.getOccurrence(), null, IDiffElement.Change.REMOVED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.REMOVED);
            OccurrenceDiffDto dto = new OccurrenceDiffDto((IDuplicateCodeBlockOccurrence)baselineOccurrenceDto.getOccurrence(), null, IDiffElement.Change.REMOVED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.REMOVED, occChangeDescription, 0);
            occurrenceDiffDtos.add(dto);
        }
        StrictPair<StrictPair<IDiffElement.Change, String>, DuplicateCodeBlockIssueDiff.DuplicateChange> strictPair = this.createDuplicateChangeDescription(baselineIssue, currentIssue, occurrenceDiffDtos, change, changeDescription);
        DuplicateCodeBlockIssueDiff issueDiff = new DuplicateCodeBlockIssueDiff(parent, baselineIssue, currentIssue, (IDiffElement.Change)((Object)((StrictPair)strictPair.getFirst()).getFirst()), (String)((StrictPair)strictPair.getFirst()).getSecond(), (DuplicateCodeBlockIssueDiff.DuplicateChange)((Object)strictPair.getSecond()));
        for (OccurrenceDiffDto nextDto : occurrenceDiffDtos) {
            DuplicateCodeBlockOccurrenceDiff occDiff = new DuplicateCodeBlockOccurrenceDiff(issueDiff, nextDto.getBaselineOcc(), nextDto.getCurrentOcc(), nextDto.getChange(), nextDto.getChangeDetail(), nextDto.getChangeDescription());
            issueDiff.addChild(occDiff);
        }
        return issueDiff;
    }

    private StrictPair<StrictPair<IDiffElement.Change, String>, DuplicateCodeBlockIssueDiff.DuplicateChange> createDuplicateChangeDescription(IDuplicateCodeBlockIssue baselineIssue, DuplicateCodeBlockIssue currentIssue, List<OccurrenceDiffDto> occurrences, IDiffElement.Change change, String changeDescription) {
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'createDuplicateChangeDescription' must not be null";
        assert (currentIssue != null) : "Parameter 'currentIssue' of method 'createDuplicateChangeDescription' must not be null";
        assert (occurrences != null) : "Parameter 'occurrences' of method 'createDuplicateChangeDescription' must not be null";
        assert (change != null) : "Parameter 'change' of method 'createDuplicateChangeDescription' must not be null";
        assert (changeDescription != null) : "Parameter 'changeDescription' of method 'createDuplicateChangeDescription' must not be null";
        StringBuilder description = new StringBuilder(changeDescription);
        IDiffElement.Change computedChange = change;
        DuplicateCodeBlockIssueDiff.DuplicateChange duplicateChange = DuplicateCodeBlockIssueDiff.DuplicateChange.UNMODIFIED;
        int numberOfBaselineOcc = baselineIssue.getOccurrences().size();
        int numberOfCurrentOcc = ((DuplicateCodeBlock)currentIssue.getAffectedElement()).getTotalNumberOfOccurrences();
        long numberOfRemovedOcc = occurrences.stream().filter(occ -> occ.getChange() == IDiffElement.Change.REMOVED).count();
        long numberOfAddedOcc = occurrences.stream().filter(occ -> occ.getChange() == IDiffElement.Change.ADDED).count();
        int baselineTotalLineCount = baselineIssue.getTotalDuplicateLineCount();
        if (baselineTotalLineCount == -1) {
            baselineTotalLineCount = baselineIssue.getTotalDuplicateLineCount();
        }
        int currentTotalLines = ((DuplicateCodeBlock)currentIssue.getAffectedElement()).getTotalDuplicateLineCount();
        int diffOfTotalLines = currentTotalLines - baselineTotalLineCount;
        int diffOccurrences = numberOfCurrentOcc - numberOfBaselineOcc;
        StringBuilder diffOccString = new StringBuilder();
        if (diffOccurrences != 0) {
            diffOccString.append("(");
            if (diffOccurrences > 0) {
                diffOccString.append("+");
            }
            diffOccString.append(diffOccurrences).append(")");
            duplicateChange = DuplicateCodeBlockIssueDiff.DuplicateChange.OCCURRENCES;
        }
        if (numberOfRemovedOcc > 0L && numberOfRemovedOcc > numberOfAddedOcc) {
            computedChange = IDiffElement.Change.IMPROVED;
            this.addCommaIfNotEmpty(description);
            description.append("Occurrences: ").append(numberOfBaselineOcc).append(" -> ").append(numberOfCurrentOcc);
            description.append(" ").append(diffOccString.toString());
            if (numberOfAddedOcc > 0L) {
                description.append(" [-").append(numberOfRemovedOcc);
                description.append("/+").append(numberOfAddedOcc);
                description.append("])");
            }
        } else if (numberOfAddedOcc > 0L && numberOfAddedOcc > numberOfRemovedOcc) {
            computedChange = IDiffElement.Change.WORSENED;
            this.addCommaIfNotEmpty(description);
            description.append("Occurrences: ").append(numberOfBaselineOcc).append(" -> ").append(numberOfCurrentOcc);
            description.append(" ").append(diffOccString.toString());
            if (numberOfRemovedOcc > 0L) {
                description.append("[");
                description.append("-").append(numberOfRemovedOcc).append("/");
                description.append("+").append(numberOfAddedOcc);
                description.append("])");
            }
        } else {
            assert (numberOfAddedOcc - numberOfRemovedOcc == 0L) : "numberOfAdded must be equal to numberOfRemoved, but was " + numberOfAddedOcc + " != " + numberOfRemovedOcc;
            computedChange = IDiffElement.Change.MODIFIED;
            this.addCommaIfNotEmpty(description);
            description.append("Occurrences: ").append(numberOfBaselineOcc);
            if (numberOfAddedOcc > 0L) {
                description.append(" (").append(diffOccString.toString());
                description.append("-").append(numberOfRemovedOcc);
                description.append("/");
                description.append("+").append(numberOfAddedOcc);
                description.append(")");
            }
        }
        if (diffOfTotalLines != 0) {
            this.addCommaIfNotEmpty(description);
            duplicateChange = DuplicateCodeBlockIssueDiff.DuplicateChange.INVOLVED_LINES;
            assert (baselineTotalLineCount > 0) : "Invalid value of baselineTotalLineCount: " + baselineTotalLineCount;
            description.append("Involved Lines: ").append(NumberUtility.format((Number)baselineTotalLineCount, (boolean)true)).append(" -> ").append(NumberUtility.format((Number)currentTotalLines, (boolean)true));
            description.append(" (");
            if (diffOfTotalLines > 0) {
                description.append("+");
                computedChange = IDiffElement.Change.WORSENED;
            } else {
                computedChange = IDiffElement.Change.IMPROVED;
            }
            description.append(NumberUtility.format((Number)diffOfTotalLines, (boolean)true));
            description.append(")");
        } else {
            this.addCommaIfNotEmpty(description);
            description.append("Involved Lines: ").append(NumberUtility.format((Number)baselineTotalLineCount, (boolean)true));
        }
        if (change == IDiffElement.Change.RESOLUTION_ADDED || change == IDiffElement.Change.RESOLUTION_REMOVED) {
            computedChange = change;
        }
        StrictPair changeAndDescription = new StrictPair((Object)computedChange, (Object)description.toString());
        return new StrictPair((Object)changeAndDescription, (Object)duplicateChange);
    }

    private void addCommaIfNotEmpty(StringBuilder description) {
        assert (description != null) : "Parameter 'description' of method 'addDotIfNotEmpty' must not be null";
        if (description.length() > 0) {
            description.append(", ");
        }
    }

    private String createOccurrenceChangeDescription(IDuplicateCodeBlockOccurrence baseline, DuplicateCodeBlockOccurrence current, IDiffElement.Change change, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail changeDetail) {
        assert (change != null) : "Parameter 'change' of method 'createChangeDescription' must not be null";
        StringBuilder description = new StringBuilder();
        switch (changeDetail) {
            case REMOVED: {
                StringBuilder removed = new StringBuilder().append(baseline.getStartLine()).append("-").append(baseline.getEndLine()).append(" (").append(baseline.getBlockSize()).append(" Lines)");
                description.append(SystemDiffUtility.createChangeDetails(removed.toString(), "", change));
                break;
            }
            case ADDED: {
                StringBuilder added = new StringBuilder().append(current.getBlockBegin()).append("-").append(current.getBlockEnd()).append(" (").append(current.getBlockSize()).append(" Lines)");
                description.append(SystemDiffUtility.createChangeDetails("", added.toString(), change));
                break;
            }
            case UNMODIFIED: {
                description.append(baseline.getStartLine()).append("-").append(baseline.getEndLine());
                description.append(" (").append(current.getBlockSize()).append(" Lines)");
                break;
            }
            case EXTENDED: 
            case REDUCED: {
                description.append(baseline.getStartLine()).append("-").append(baseline.getEndLine());
                description.append(" -> ");
                description.append(current.getBlockBegin()).append("-").append(current.getBlockEnd());
                description.append(" (").append(current.getBlockSize()).append(" Lines, ");
                description.append(changeDetail.getPresentationName()).append(" by ");
                int blockSizeDifference = current.getBlockSize() - baseline.getBlockSize();
                assert (blockSizeDifference != 0) : "Blocksize is unchanged: " + current.getBlockSize();
                description.append(Math.abs(blockSizeDifference));
                description.append(" Lines)");
                break;
            }
            case MOVED: {
                description.append(baseline.getStartLine()).append("-").append(baseline.getEndLine());
                description.append(" -> ");
                description.append(current.getBlockBegin()).append("-").append(current.getBlockEnd());
                description.append(" (").append(current.getBlockSize()).append(" Lines, ");
                description.append(changeDetail.getPresentationName()).append(" by ");
                int startDifference = current.getBlockBegin() - baseline.getStartLine();
                description.append(startDifference);
                description.append(" Lines)");
                break;
            }
            case MODIFIED: {
                description.append(current.getBlockBegin()).append("-").append(current.getBlockEnd());
                description.append(" (").append(current.getBlockSize()).append(" Lines)");
                break;
            }
            default: {
                assert (false) : "Unhandled changeDetail " + changeDetail.getPresentationName();
                break;
            }
        }
        return description.toString();
    }

    private void processRemoved(NamedElement parent, List<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> removed) {
        assert (parent != null) : "Parameter 'parent' of method 'processRemoved' must not be null";
        Iterator<StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue>> baselineIter = removed.iterator();
        while (baselineIter.hasNext()) {
            StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> next = baselineIter.next();
            String changeDescription = SystemDiffUtility.createChangeDetails(this.getBaselineInfo((IDuplicateCodeBlockIssue)next.getSecond()), "", IDiffElement.Change.REMOVED);
            DuplicateCodeBlockIssueDiff diff = new DuplicateCodeBlockIssueDiff(parent, (IDuplicateCodeBlockIssue)next.getSecond(), null, IDiffElement.Change.REMOVED, changeDescription, DuplicateCodeBlockIssueDiff.DuplicateChange.REMOVED);
            for (BaselineOccurrenceDto nextBaselineOcc : ((DuplicateDto)next.getFirst()).getOccurrences()) {
                String occChangeDescription = this.createOccurrenceChangeDescription((IDuplicateCodeBlockOccurrence)nextBaselineOcc.getOccurrence(), null, IDiffElement.Change.REMOVED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.REMOVED);
                DuplicateCodeBlockOccurrenceDiff occDiff = new DuplicateCodeBlockOccurrenceDiff(diff, (IDuplicateCodeBlockOccurrence)nextBaselineOcc.getOccurrence(), null, IDiffElement.Change.REMOVED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.REMOVED, occChangeDescription);
                diff.addChild(occDiff);
            }
            parent.addChild(diff);
            baselineIter.remove();
        }
    }

    private void processAdded(NamedElement parent, List<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> added) {
        assert (parent != null) : "Parameter 'parent' of method 'processAdded' must not be null";
        assert (added != null) : "Parameter 'added' of method 'processAdded' must not be null";
        Iterator<StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue>> iter = added.iterator();
        while (iter.hasNext()) {
            StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> next = iter.next();
            String changeDescription = SystemDiffUtility.createChangeDetails("", this.getCurrentInfo((DuplicateCodeBlockIssue)next.getSecond()), IDiffElement.Change.ADDED);
            DuplicateCodeBlockIssueDiff diff = new DuplicateCodeBlockIssueDiff(parent, null, (DuplicateCodeBlockIssue)next.getSecond(), IDiffElement.Change.ADDED, changeDescription, DuplicateCodeBlockIssueDiff.DuplicateChange.ADDED);
            for (CurrentOccurrenceDto nextOcc : ((DuplicateDto)next.getFirst()).getOccurrences()) {
                String occChangeDescription = this.createOccurrenceChangeDescription(null, (DuplicateCodeBlockOccurrence)nextOcc.getOccurrence(), IDiffElement.Change.ADDED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.ADDED);
                DuplicateCodeBlockOccurrenceDiff occDiff = new DuplicateCodeBlockOccurrenceDiff(diff, null, (DuplicateCodeBlockOccurrence)nextOcc.getOccurrence(), IDiffElement.Change.ADDED, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.ADDED, occChangeDescription);
                diff.addChild(occDiff);
            }
            parent.addChild(diff);
            iter.remove();
        }
    }

    private String getBaselineInfo(IDuplicateCodeBlockIssue baselineDuplicate) {
        assert (baselineDuplicate != null) : "Parameter 'baselineDuplicate' of method 'getBaselineInfo' must not be null";
        int duplicateLineCount = baselineDuplicate.getTotalDuplicateLineCount();
        if (duplicateLineCount == -1) {
            duplicateLineCount = baselineDuplicate.getTotalDuplicateLineCount();
        }
        return this.getDuplicateInfo(baselineDuplicate.getOccurrences().size(), duplicateLineCount);
    }

    private String getCurrentInfo(DuplicateCodeBlockIssue currentDuplicate) {
        assert (currentDuplicate != null) : "Parameter 'currentDuplicate' of method 'getCurrentInfo' must not be null";
        DuplicateCodeBlock duplicate = (DuplicateCodeBlock)currentDuplicate.getAffectedElement();
        int duplicateLineCount = duplicate.getTotalDuplicateLineCount();
        return this.getDuplicateInfo(duplicate.getTotalNumberOfOccurrences(), duplicateLineCount);
    }

    private String getDuplicateInfo(int occurrences, int duplicateLineCount) {
        StringBuilder info = new StringBuilder("Occurrences: ");
        info.append(occurrences);
        info.append(", Involved Lines: ").append(NumberUtility.format((Number)duplicateLineCount, (boolean)true));
        return info.toString();
    }

    private static class OccurrenceDiffDto {
        private final IDuplicateCodeBlockOccurrence m_baselineOcc;
        private final DuplicateCodeBlockOccurrence m_currentOcc;
        private final IDiffElement.Change m_change;
        private final DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail m_changeDetail;
        private final String m_changeDescription;
        private final int m_overlap;

        public OccurrenceDiffDto(IDuplicateCodeBlockOccurrence baselineOcc, DuplicateCodeBlockOccurrence currentOccurrence, IDiffElement.Change change, DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail changeDetail, String changeDescription, int overlap) {
            this.m_baselineOcc = baselineOcc;
            this.m_currentOcc = currentOccurrence;
            this.m_change = change;
            this.m_changeDetail = changeDetail;
            this.m_changeDescription = changeDescription;
            this.m_overlap = overlap;
        }

        public IDuplicateCodeBlockOccurrence getBaselineOcc() {
            return this.m_baselineOcc;
        }

        public DuplicateCodeBlockOccurrence getCurrentOcc() {
            return this.m_currentOcc;
        }

        public IDiffElement.Change getChange() {
            return this.m_change;
        }

        public String getChangeDescription() {
            return this.m_changeDescription;
        }

        public DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail getChangeDetail() {
            return this.m_changeDetail;
        }

        public int getOverlap() {
            return this.m_overlap;
        }
    }

    private static class ScoreInfo {
        private final double m_score;
        private final StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> m_currentPair;
        private final StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> m_baselinePair;
        private final Integer m_unmatchedOccurrences;

        public ScoreInfo(double score, Integer unmatchedOccurrences, StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> baselinePair, StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> currentPair) {
            this.m_score = score;
            this.m_unmatchedOccurrences = unmatchedOccurrences;
            this.m_baselinePair = baselinePair;
            this.m_currentPair = currentPair;
        }

        public double getScore() {
            return this.m_score;
        }

        public Integer getUnmatchedOccurrences() {
            return this.m_unmatchedOccurrences;
        }

        public StrictPair<DuplicateDto<BaselineOccurrenceDto>, IDuplicateCodeBlockIssue> getBaselinePair() {
            return this.m_baselinePair;
        }

        public StrictPair<DuplicateDto<CurrentOccurrenceDto>, DuplicateCodeBlockIssue> getCurrentPair() {
            return this.m_currentPair;
        }
    }
}

