/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.AbstractDiffProcessor;
import com.hello2morrow.sonargraph.core.model.element.IssueType;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.pattern.DependencyIssuePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementFullyQualifiedNamePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementIssuePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.ParserDependencyEndpointPattern;
import com.hello2morrow.sonargraph.core.model.resolution.Matching;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionDefinitionDiff;
import com.hello2morrow.sonargraph.core.persistence.report.ReportXmlWriter;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.foundation.MigrationCheck;
import com.hello2morrow.sonargraph.integration.access.model.DependencyPatternType;
import com.hello2morrow.sonargraph.integration.access.model.ElementPatternType;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyPattern;
import com.hello2morrow.sonargraph.integration.access.model.IElementPattern;
import com.hello2morrow.sonargraph.integration.access.model.IMatching;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;

abstract class AbstractResolutionDiffProcessor<B extends IResolution, C extends Resolution>
extends AbstractDiffProcessor {
    private final ResolutionType m_resolutionType;
    private final Class<B> m_baselineResolutionClass;
    private final Class<C> m_currentResolutionClass;

    public AbstractResolutionDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, SoftwareSystem currentSystem, ResolutionType baselineResolutionType, Class<B> baselineResolutionClass, Class<C> currentResolutionClass) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem);
        assert (baselineResolutionType != null) : "Parameter 'baselineResolutionType' of method 'AbstractResolutionDiffProcessor' must not be null";
        assert (baselineResolutionClass != null) : "Parameter 'baselineResolutionClass' of method 'AbstractResolutionDiffProcessor' must not be null";
        assert (currentResolutionClass != null) : "Parameter 'currentResolutionClass' of method 'AbstractResolutionDiffProcessor' must not be null";
        this.m_resolutionType = baselineResolutionType;
        this.m_baselineResolutionClass = baselineResolutionClass;
        this.m_currentResolutionClass = currentResolutionClass;
    }

    @Override
    public void process(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'process' must not be null";
        Map<MatchingInfoDto, B> baselineResolutionMap = this.collectBaselineResolutions();
        Map<MatchingInfoDto, C> currentResolutionMap = this.collectCurrentResolutions();
        for (Map.Entry<MatchingInfoDto, B> nextBaselineEntry : baselineResolutionMap.entrySet()) {
            MatchingInfoDto baselineMatchingDto = nextBaselineEntry.getKey();
            IResolution baseline = (IResolution)nextBaselineEntry.getValue();
            Resolution current = (Resolution)currentResolutionMap.remove(baselineMatchingDto);
            if (current != null) {
                ResolutionDefinitionDiff<IResolution, Resolution> diff;
                StringJoiner changeDescriptionParts = new StringJoiner(". ", "", ".");
                if (baseline.getMatchingElementsCount() != current.getMatchingElementsCount()) {
                    changeDescriptionParts.add("Matched: " + baseline.getMatchingElementsCount() + " -> " + current.getMatchingElementsCount());
                }
                if (!baseline.getDescription().equals(current.getDescription())) {
                    changeDescriptionParts.add("Description: " + baseline.getDescription() + " -> " + current.getDescription());
                }
                this.addToChangeDescription(baseline, current, changeDescriptionParts);
                if (changeDescriptionParts.length() == 1) {
                    String description = this.createDescriptionForSingleMatchedElement(IDiffElement.Change.UNMODIFIED, baseline, current);
                    diff = description != null ? this.createDiff(parent, baseline, current, IDiffElement.Change.UNMODIFIED, description) : this.createDiff(parent, baseline, current, IDiffElement.Change.UNMODIFIED);
                } else {
                    String changeDescription = changeDescriptionParts.toString();
                    diff = this.createDiff(parent, baseline, current, IDiffElement.Change.MODIFIED, changeDescription);
                }
                assert (diff != null) : "No diff created by " + this.getClass().getSimpleName();
                parent.addChild(diff);
                continue;
            }
            String description = this.createDescriptionForSingleMatchedElement(IDiffElement.Change.REMOVED, baseline, current);
            ResolutionDefinitionDiff<IResolution, Resolution> removed = description != null ? this.createDiff(parent, baseline, current, IDiffElement.Change.REMOVED, description) : this.createDiff(parent, baseline, current, IDiffElement.Change.REMOVED);
            parent.addChild(removed);
        }
        for (Resolution nextCurrentResolution : currentResolutionMap.values()) {
            String description = this.createDescriptionForSingleMatchedElement(IDiffElement.Change.ADDED, null, nextCurrentResolution);
            ResolutionDefinitionDiff<Object, Resolution> added = description != null ? this.createDiff(parent, null, nextCurrentResolution, IDiffElement.Change.ADDED, description) : this.createDiff(parent, null, nextCurrentResolution, IDiffElement.Change.ADDED);
            parent.addChild(added);
        }
    }

    protected String createDescriptionForSingleMatchedElement(IDiffElement.Change change, B baseline, C current) {
        assert (change != null) : "Parameter 'change' of method 'createDescriptionForSingleMatchedElement' must not be null";
        return null;
    }

    protected void addToChangeDescription(B baseline, C current, StringJoiner changeDescriptionParts) {
        assert (baseline != null) : "Parameter 'baseline' of method 'addToChangeDescription' must not be null";
        assert (current != null) : "Parameter 'current' of method 'addToChangeDescription' must not be null";
        assert (changeDescriptionParts != null) : "Parameter 'changeDescriptionParts' of method 'addToChangeDescription' must not be null";
    }

    protected abstract ResolutionDefinitionDiff<B, C> createDiff(NamedElement var1, B var2, C var3, IDiffElement.Change var4, String var5);

    protected abstract ResolutionDefinitionDiff<B, C> createDiff(NamedElement var1, B var2, C var3, IDiffElement.Change var4);

    protected final Map<MatchingInfoDto, B> collectBaselineResolutions() {
        List resolutions = this.getBaselineSystemInfoProcessor().getResolutions(r -> r.getType() == this.m_resolutionType, this.m_baselineResolutionClass);
        LinkedHashMap<MatchingInfoDto, IResolution> resolutionMap = new LinkedHashMap<MatchingInfoDto, IResolution>();
        for (IResolution next : resolutions) {
            ElementPatternDto patternDto;
            ArrayList<ElementPatternDto> elementPatterns;
            MatchingDto matchingDto = null;
            IMatching matching = next.getMatching();
            if (matching != null) {
                elementPatterns = new ArrayList<ElementPatternDto>();
                for (IElementPattern nextPattern : matching.getPatterns()) {
                    patternDto = new ElementPatternDto(nextPattern.getType().getStandardName(), nextPattern.getPattern());
                    elementPatterns.add(patternDto);
                }
                matchingDto = new MatchingDto(matching.getInfo(), elementPatterns);
            }
            elementPatterns = new ArrayList();
            for (IElementPattern nextPattern : next.getElementPatterns()) {
                patternDto = new ElementPatternDto(nextPattern.getType().getStandardName(), nextPattern.getPattern());
                elementPatterns.add(patternDto);
            }
            ArrayList<DependencyPatternDto> dependencyPatterns = new ArrayList<DependencyPatternDto>();
            for (IDependencyPattern nextPattern : next.getDependencyPatterns()) {
                DependencyPatternDto patternDto2 = new DependencyPatternDto(nextPattern.getType().getStandardName(), nextPattern.getFromPattern(), nextPattern.getToPattern());
                dependencyPatterns.add(patternDto2);
            }
            resolutionMap.put(new MatchingInfoDto(next.getCreationDate().getTime(), matchingDto, elementPatterns, dependencyPatterns, next.getDescriptor()), next);
        }
        return resolutionMap;
    }

    protected final Map<MatchingInfoDto, C> collectCurrentResolutions() {
        List<C> unfilteredResolutions = this.getSoftwareSystem().getCurrentModel().getResolutions(this.m_currentResolutionClass);
        List resolutions = unfilteredResolutions.stream().filter(r -> r.getClass().equals(this.m_currentResolutionClass)).collect(Collectors.toList());
        LinkedHashMap<MatchingInfoDto, Resolution> resolutionMap = new LinkedHashMap<MatchingInfoDto, Resolution>();
        boolean isResolutionMigrationNeeded = MigrationCheck.isPreUnificationOfIssueIds((String)this.getBaselineSystem().getVersion());
        for (Resolution next : resolutions) {
            ArrayList<ElementPatternDto> elementPatterns;
            MatchingDto matchingDto = null;
            Matching matching = next.getUniqueChild(Matching.class);
            if (matching != null) {
                elementPatterns = new ArrayList<ElementPatternDto>();
                for (String string : matching.getElementFqNames()) {
                    ElementPatternDto patternDto = new ElementPatternDto(ElementPatternType.FULLY_QUALIFIED_NAME.getStandardName(), string);
                    elementPatterns.add(patternDto);
                }
                matchingDto = new MatchingDto(matching.getInformation(), elementPatterns);
            }
            elementPatterns = new ArrayList();
            for (NamedElementIssuePattern namedElementIssuePattern : next.getChildren(NamedElementIssuePattern.class)) {
                ElementPatternType type = namedElementIssuePattern instanceof NamedElementFullyQualifiedNamePattern ? ElementPatternType.FULLY_QUALIFIED_NAME : ElementPatternType.WILDCARD;
                ElementPatternDto patternDto = new ElementPatternDto(type.getStandardName(), namedElementIssuePattern.getPattern());
                elementPatterns.add(patternDto);
            }
            ArrayList<DependencyPatternDto> arrayList = new ArrayList<DependencyPatternDto>();
            for (DependencyIssuePattern nextPattern : next.getChildren(DependencyIssuePattern.class)) {
                DependencyPatternType type = nextPattern instanceof ParserDependencyEndpointPattern ? DependencyPatternType.PARSER_DEPENDENCY_ENDPOINT : DependencyPatternType.WILDCARD;
                DependencyPatternDto patternDto = new DependencyPatternDto(type.getStandardName(), nextPattern.getFromPattern(), nextPattern.getToPattern());
                arrayList.add(patternDto);
            }
            IssueType type = next.getUniqueChild(IssueType.class);
            assert (type != null) : "Missing issue type for resolution " + String.valueOf(next);
            String descriptor = isResolutionMigrationNeeded ? ReportXmlWriter.createDeprecatedIssueDescriptor(type) : ReportXmlWriter.createIssueDescriptor(type);
            resolutionMap.put(new MatchingInfoDto(next.getDate().getTime(), matchingDto, elementPatterns, arrayList, descriptor), next);
        }
        return resolutionMap;
    }

    private static final class DependencyPatternDto {
        private final String m_type;
        private final String m_fromPattern;
        private final String m_toPattern;

        public DependencyPatternDto(String type, String fromPattern, String toPattern) {
            assert (type != null && type.length() > 0) : "Parameter 'type' of method 'DependencyPatternDto' must not be empty";
            assert (fromPattern != null && fromPattern.length() > 0) : "Parameter 'fromPattern' of method 'DependencyPatternDto' must not be empty";
            assert (toPattern != null && toPattern.length() > 0) : "Parameter 'toPattern' of method 'DependencyPatternDto' must not be empty";
            this.m_type = type;
            this.m_fromPattern = fromPattern;
            this.m_toPattern = toPattern;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DependencyPatternDto [m_type=");
            builder.append(this.m_type);
            builder.append(", m_fromPattern=");
            builder.append(this.m_fromPattern);
            builder.append(", m_toPattern=");
            builder.append(this.m_toPattern);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_fromPattern == null ? 0 : this.m_fromPattern.hashCode());
            result = 31 * result + (this.m_toPattern == null ? 0 : this.m_toPattern.hashCode());
            result = 31 * result + (this.m_type == null ? 0 : this.m_type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyPatternDto other = (DependencyPatternDto)obj;
            if (this.m_fromPattern == null ? other.m_fromPattern != null : !this.m_fromPattern.equals(other.m_fromPattern)) {
                return false;
            }
            if (this.m_toPattern == null ? other.m_toPattern != null : !this.m_toPattern.equals(other.m_toPattern)) {
                return false;
            }
            return !(this.m_type == null ? other.m_type != null : !this.m_type.equals(other.m_type));
        }
    }

    private static final class ElementPatternDto {
        private final String m_pattern;
        private final String m_type;

        public ElementPatternDto(String type, String pattern) {
            assert (type != null && type.length() > 0) : "Parameter 'type' of method 'ElementPattern' must not be empty";
            assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'ElementPattern' must not be empty";
            this.m_type = type;
            this.m_pattern = pattern;
        }

        public String getPattern() {
            return this.m_pattern;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ElementPatternDto [m_type=");
            builder.append(this.m_type);
            builder.append(", m_pattern=");
            builder.append(this.m_pattern);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_pattern == null ? 0 : this.m_pattern.hashCode());
            result = 31 * result + (this.m_type == null ? 0 : this.m_type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ElementPatternDto other = (ElementPatternDto)obj;
            if (this.m_pattern == null ? other.m_pattern != null : !this.m_pattern.equals(other.m_pattern)) {
                return false;
            }
            return !(this.m_type == null ? other.m_type != null : !this.m_type.equals(other.m_type));
        }
    }

    private static final class MatchingDto {
        private final List<ElementPatternDto> m_elementPatterns;
        private final String m_info;

        public MatchingDto(String info, List<ElementPatternDto> elementPatterns) {
            assert (info != null) : "Parameter 'info' of method 'MatchinInfoDto' must not be null";
            assert (elementPatterns != null && !elementPatterns.isEmpty()) : "Parameter 'elementPatterns' of method 'MatchinInfoDto' must not be empty";
            this.m_info = info;
            LinkedHashMap<String, ElementPatternDto> patterns = new LinkedHashMap<String, ElementPatternDto>();
            for (ElementPatternDto next : elementPatterns) {
                if (patterns.containsKey(next.getPattern())) continue;
                patterns.put(next.getPattern(), next);
            }
            this.m_elementPatterns = new ArrayList(patterns.values());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MatchingDto [m_info=");
            builder.append(this.m_info);
            builder.append(", m_elementPatterns=");
            builder.append(this.m_elementPatterns);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_elementPatterns == null ? 0 : this.m_elementPatterns.hashCode());
            result = 31 * result + (this.m_info == null ? 0 : this.m_info.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchingDto other = (MatchingDto)obj;
            if (this.m_elementPatterns == null ? other.m_elementPatterns != null : !this.m_elementPatterns.equals(other.m_elementPatterns)) {
                return false;
            }
            return !(this.m_info == null ? other.m_info != null : !this.m_info.equals(other.m_info));
        }
    }

    private static final class MatchingInfoDto {
        private final long m_timestamp;
        private final String m_descriptor;
        private final MatchingDto m_matching;
        private final List<ElementPatternDto> m_elementPatterns;
        private final List<DependencyPatternDto> m_dependencyPatterns;

        public MatchingInfoDto(long timestamp, MatchingDto matching, List<ElementPatternDto> elementPatterns, List<DependencyPatternDto> dependencyPatterns, String descriptor) {
            this.m_timestamp = timestamp;
            this.m_matching = matching;
            this.m_elementPatterns = elementPatterns;
            this.m_dependencyPatterns = dependencyPatterns;
            this.m_descriptor = descriptor;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MatchingInfoDto [m_descriptor=");
            builder.append(this.m_descriptor);
            builder.append(", m_matching=");
            builder.append(this.m_matching);
            builder.append(", m_timestamp=");
            builder.append(this.m_timestamp);
            builder.append(", m_elementPatterns=");
            builder.append(this.m_elementPatterns);
            builder.append(", m_dependencyPatterns=");
            builder.append(this.m_dependencyPatterns);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.m_timestamp ^ this.m_timestamp >>> 32);
            result = 31 * result + (this.m_descriptor == null ? 0 : this.m_descriptor.hashCode());
            result = 31 * result + (this.m_dependencyPatterns == null ? 0 : this.m_dependencyPatterns.hashCode());
            result = 31 * result + (this.m_elementPatterns == null ? 0 : this.m_elementPatterns.hashCode());
            result = 31 * result + (this.m_matching == null ? 0 : this.m_matching.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchingInfoDto other = (MatchingInfoDto)obj;
            if (this.m_timestamp != other.m_timestamp) {
                return false;
            }
            if (this.m_descriptor == null ? other.m_descriptor != null : !this.m_descriptor.equals(other.m_descriptor)) {
                return false;
            }
            if (this.m_dependencyPatterns == null ? other.m_dependencyPatterns != null : !this.m_dependencyPatterns.equals(other.m_dependencyPatterns)) {
                return false;
            }
            if (this.m_elementPatterns == null ? other.m_elementPatterns != null : !this.m_elementPatterns.equals(other.m_elementPatterns)) {
                return false;
            }
            return !(this.m_matching == null ? other.m_matching != null : !this.m_matching.equals(other.m_matching));
        }
    }
}

