/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.size;

import com.hello2morrow.sonargraph.core.controller.system.analysis.SizeComputationUtility;
import com.hello2morrow.sonargraph.core.controller.system.analysis.ThresholdAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IThresholdController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.size.SizeMetricsAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodeOrganizationAnalyzerAdapter
extends AnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.CODE_ORGANIZATION;
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeOrganizationAnalyzerAdapter.class);
    private final IMetricDescriptor m_locInLargeFiles;
    private final IMetricDescriptor m_locInLargeFilesPercent;
    private final IMetricDescriptor m_locInLargeFilesIgnored;
    private final IMetricDescriptor m_locInLargeFilesIgnoredPercent;
    private final IMetricDescriptor m_locInLargeFilesToFix;
    private final IMetricDescriptor m_locInLargeFilesToFixPercent;

    public CodeOrganizationAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider coreMetricProvider = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_locInLargeFiles = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_LINES_OF_CODE_IN_LARGE_FILES, CoreMetricLevel.SYSTEM);
        this.m_locInLargeFilesPercent = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_LINES_OF_CODE_IN_LARGE_FILES_PERCENT, CoreMetricLevel.SYSTEM);
        this.m_locInLargeFilesIgnored = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_LINES_OF_CODE_IN_LARGE_FILES_IGNORED, CoreMetricLevel.SYSTEM);
        this.m_locInLargeFilesIgnoredPercent = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_LINES_OF_CODE_IN_LARGE_FILES_IGNORED_PERCENT, CoreMetricLevel.SYSTEM);
        this.m_locInLargeFilesToFix = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_LINES_OF_CODE_IN_LARGE_FILES_TO_FIX, CoreMetricLevel.SYSTEM);
        this.m_locInLargeFilesToFixPercent = this.addMetricDescriptorIfNotExistent(coreMetricProvider, CoreMetricId.CORE_LINES_OF_CODE_IN_LARGE_FILES_TO_FIX_PERCENT, CoreMetricLevel.SYSTEM);
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        AnalyzerResult sizeMetricsResult = this.getController().getResultFor(SizeMetricsAdapter.ID);
        assert (sizeMetricsResult != null) : "Missing size metrics result";
        AnalyzerResult thresholdResult = this.getController().getResultFor(ThresholdAnalyzerAdapter.ID);
        assert (thresholdResult != null) : "Missing threshold result";
        List<AnalyzerResult> requiredResults = Arrays.asList(sizeMetricsResult, thresholdResult);
        CodeOrganizationJob job = new CodeOrganizationJob(this.getGroup(), result, this.getController(), requiredResults);
        job.start();
    }

    @Override
    public boolean canStoreResult() {
        return true;
    }

    private class CodeOrganizationJob
    extends AnalyzerJob {
        private static final int LOC_THRESHOLD_DEFAULT_UPPER = 1000;

        private CodeOrganizationJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, List<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
        }

        @Override
        protected void internalRun() {
            CoreMetricId locMetricId;
            SoftwareSystem softwareSystem;
            IMetricAccessor metricAccessor = this.getInstallation().getExtension(IMetricAccessor.class);
            Number locFullyAnalyzed = metricAccessor.getMetricValue(softwareSystem = this.getSoftwareSystem(), softwareSystem, CoreMetricLevel.SYSTEM, locMetricId = CoreMetricId.CORE_LINES_OF_CODE_FULLY_ANALYZED, false);
            if (locFullyAnalyzed == null) {
                LOGGER.error("Value for metric 'fully analyzed lines of code' is missing");
                return;
            }
            int locInLargeFiles = 0;
            int locInLargeFilesIgnored = 0;
            int locInLargeFilesToBeFixed = 0;
            MetricProvider coreMetricProvider = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
            IMetricDescriptor locSourceFileDescriptor = CodeOrganizationAnalyzerAdapter.this.findMetricDescriptor(coreMetricProvider, CoreMetricId.CORE_LINES_OF_CODE, CoreMetricLevel.SOURCE_FILE);
            assert (locSourceFileDescriptor != null) : "Missing metric descriptor for 'lines of code' on level 'source file'";
            IThresholdController thresholdController = this.getSoftwareSystem().getExtension(IThresholdController.class);
            Map<IMetricDescriptor, IMetricThreshold> thresholds = thresholdController.getThresholdsFor(Collections.singletonList(locSourceFileDescriptor));
            IMetricThreshold threshold = thresholds.get(locSourceFileDescriptor);
            boolean maxLocThresholdDefined = threshold != null && threshold.getUpperThreshold() != null;
            int maxLocPerFileThresholdValue = maxLocThresholdDefined ? threshold.getUpperThreshold().intValue() : 1000;
            for (Module nextModule : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                if (this.getWorkerContext().hasBeenCanceled()) {
                    return;
                }
                for (IComponent nextComponent : nextModule.getChildrenRecursively(IComponent.class, IComponent.class)) {
                    if (nextComponent.ignoreIssues()) continue;
                    for (SourceFile nextSource : SizeComputationUtility.getInternalNotExcludedSourceFiles(nextComponent)) {
                        if (this.getWorkerContext().hasBeenCanceled()) {
                            return;
                        }
                        int loc = nextSource.getLinesOfCode();
                        if (!maxLocThresholdDefined) {
                            if (loc <= maxLocPerFileThresholdValue) continue;
                            locInLargeFiles += loc;
                            continue;
                        }
                        ThresholdViolationIssue issue = nextSource.getIssues(CoreIssueId.THRESHOLD_VIOLATION).stream().filter(i -> i instanceof ThresholdViolationIssue).map(i -> (ThresholdViolationIssue)i).filter(t -> t.getMetricDescriptor() == locSourceFileDescriptor).findFirst().orElse(null);
                        if (issue == null) continue;
                        IMetricThreshold metricThreshold = issue.getThreshold();
                        assert (metricThreshold != null) : "Parameter 'metricThreshold' of method 'internalRun' must not be null";
                        if (metricThreshold.getUpperThreshold().intValue() >= loc) continue;
                        locInLargeFiles += loc;
                        IResolution resolution = issue.getResolution();
                        if (resolution instanceof IgnoreDefinition) {
                            locInLargeFilesIgnored += loc;
                            continue;
                        }
                        if (!(resolution instanceof TaskDefinition)) continue;
                        locInLargeFilesToBeFixed += loc;
                    }
                }
            }
            CodeOrganizationAnalyzerAdapter.this.storeMetricValue(this.getResult(), softwareSystem, locInLargeFiles, CodeOrganizationAnalyzerAdapter.this.m_locInLargeFiles);
            CodeOrganizationAnalyzerAdapter.this.storeMetricValue(this.getResult(), softwareSystem, Float.valueOf(this.percentage(locInLargeFiles, locFullyAnalyzed.intValue())), CodeOrganizationAnalyzerAdapter.this.m_locInLargeFilesPercent);
            CodeOrganizationAnalyzerAdapter.this.storeMetricValue(this.getResult(), softwareSystem, locInLargeFilesIgnored, CodeOrganizationAnalyzerAdapter.this.m_locInLargeFilesIgnored);
            CodeOrganizationAnalyzerAdapter.this.storeMetricValue(this.getResult(), softwareSystem, Float.valueOf(this.percentage(locInLargeFilesIgnored, locFullyAnalyzed.intValue())), CodeOrganizationAnalyzerAdapter.this.m_locInLargeFilesIgnoredPercent);
            CodeOrganizationAnalyzerAdapter.this.storeMetricValue(this.getResult(), softwareSystem, locInLargeFilesToBeFixed, CodeOrganizationAnalyzerAdapter.this.m_locInLargeFilesToFix);
            CodeOrganizationAnalyzerAdapter.this.storeMetricValue(this.getResult(), softwareSystem, Float.valueOf(this.percentage(locInLargeFilesToBeFixed, locFullyAnalyzed.intValue())), CodeOrganizationAnalyzerAdapter.this.m_locInLargeFilesToFixPercent);
        }
    }
}

