/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAnalyzer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.ICycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class WorkspaceCycleAnalyzerAdapter
implements ICycleAnalyzerAdapter {
    private final Set<IWorkspaceDependencyElement> m_cyclicNodes = new LinkedHashSet<IWorkspaceDependencyElement>();
    private final Map<IWorkspaceDependencyElement, Integer> m_nodeToGroup = new THashMap();
    private final List<IWorkspaceDependencyElement> m_elements;

    public WorkspaceCycleAnalyzerAdapter(List<IWorkspaceDependencyElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'WorkspaceCycleAnalyzerAdapter' must not be empty";
        this.m_elements = elements;
    }

    public void compute(IWorkerContext workerContext) {
        CycleAnalyzer.compute(this, workerContext);
    }

    @Override
    public boolean calculateLevels() {
        return false;
    }

    @Override
    public Collection<? extends INode<?>> getNodes() {
        return this.m_elements;
    }

    public Set<IWorkspaceDependencyElement> getCyclicNodes() {
        return Collections.unmodifiableSet(this.m_cyclicNodes);
    }

    @Override
    public boolean isCyclic(INode<?> node) {
        assert (node != null) : "Parameter 'node' of method 'isCyclic' must not be null";
        return this.m_cyclicNodes.contains(node);
    }

    @Override
    public void setGroupIndex(INode<?> node, int cycleGroupIndex, boolean isCyclic) {
        assert (node != null) : "Parameter 'node' of method 'setCycleGroup' must not be null";
        this.m_nodeToGroup.put((IWorkspaceDependencyElement)node, cycleGroupIndex);
        if (isCyclic) {
            this.m_cyclicNodes.add((IWorkspaceDependencyElement)node);
        }
    }

    @Override
    public int getGroupIndex(INode<?> node) {
        assert (node != null) : "Parameter 'node' of method 'getCycleGroup' must not be null";
        Integer group = this.m_nodeToGroup.get(node);
        return group != null ? group : -1;
    }

    @Override
    public void setLevel(INode<?> node, int level) {
        assert (node != null) : "Parameter 'node' of method 'setLevel' must not be null";
    }
}

