/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.analysis.ModuleCycleGroup;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependencyNotDefined;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependencyNotImplemented;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class ModuleCyclesInSystemAnalyzer
extends CyclesAnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.MODULE_CYCLES_SYSTEM;
    private final IMetricDescriptor m_numberOfCyclicModules;

    public ModuleCyclesInSystemAnalyzer(IAnalyzerController listener) {
        super(listener, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_numberOfCyclicModules = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CYCLIC_MODULES, CoreMetricLevel.SYSTEM, null);
    }

    @Override
    protected List<IIssueId> getIssueIds(AnalyzerResult result) {
        ArrayList<IIssueId> ids = new ArrayList<IIssueId>(super.getIssueIds(result));
        ids.add(CoreIssueId.WORKSPACE_DEPENDENCY_NOT_IMPLEMENTED);
        ids.add(CoreIssueId.WORKSPACE_DEPENDENCY_NOT_DEFINED);
        return ids;
    }

    @Override
    protected IIssueId getIssueId() {
        return ModuleCycleGroup.ISSUE_ID;
    }

    @Override
    public void runJobs(AnalyzerResult result) {
        ModuleCyclesInSystemJob job = new ModuleCyclesInSystemJob(this.getGroup(), result, this.getController());
        job.start();
    }

    private class ModuleCyclesInSystemJob
    extends CyclesAnalyzerAdapter.CyclesAnalyzerJob {
        private ModuleCyclesInSystemJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(ModuleCyclesInSystemAnalyzer.this, group, result, controller);
        }

        protected Collection<NamedElement> getNamedElements() {
            ArrayList<NamedElement> modules = new ArrayList<NamedElement>();
            for (Module nextModule : this.getSoftwareSystem().getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                if (this.getWorkerContext().hasBeenCanceled() || nextModule.isAutomatic()) continue;
                modules.add(nextModule);
            }
            return modules;
        }

        @Override
        protected NodeAdapterSet<ParserDependencyNodeAdapter> createNodeAdapterSet(Collection<? extends NamedElement> elements) {
            NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet = super.createNodeAdapterSet(elements);
            for (ParserDependencyNodeAdapter nextFromNode : nodeAdapterSet.getNodes()) {
                NamedElement nextUnderlyingObject = nextFromNode.getUnderlyingObject();
                assert (nextUnderlyingObject != null && nextUnderlyingObject instanceof Module) : "Unexpected class in method 'createNodeAdapterSet': " + String.valueOf(nextUnderlyingObject);
                Collection<ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>> nextExistingOutgoingEdges = nextFromNode.getOutgoingEdges();
                Module nextFromModule = (Module)nextUnderlyingObject;
                HashSet notDefinedTos = new HashSet();
                nextExistingOutgoingEdges.forEach(o -> {
                    Module toModule = (Module)((ParserDependencyNodeAdapter)o.getTo()).getUnderlyingObject();
                    if (!toModule.isAutomatic()) {
                        notDefinedTos.add(((ParserDependencyNodeAdapter)o.getTo()).getUnderlyingObject());
                    }
                });
                for (WorkspaceDependency nextOutgoing : nextFromModule.getOutgoingWorkspaceDependencies()) {
                    NamedElement nextTo = (NamedElement)nextOutgoing.getTo().getUnderlyingObject();
                    ParserDependencyNodeAdapter nextToNodeAdapter = nodeAdapterSet.getNodeAdapterFor(nextTo);
                    if (nextToNodeAdapter != null) {
                        boolean implemented = false;
                        for (ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> nextExistingOutgoing : nextExistingOutgoingEdges) {
                            if (((ParserDependencyNodeAdapter)nextExistingOutgoing.getTo()).getUnderlyingObject() != nextTo) continue;
                            implemented = true;
                            break;
                        }
                        if (!implemented) {
                            nextOutgoing.addIssue(new WorkspaceDependencyNotImplemented(nextOutgoing));
                        }
                    }
                    notDefinedTos.remove(nextOutgoing.getTo().getNamedElement());
                }
                for (NamedElement nextNotDefinedTo : notDefinedTos) {
                    ParserDependencyNodeAdapter nextToNodeAdapter = nodeAdapterSet.getNodeAdapterFor(nextNotDefinedTo);
                    if (nextToNodeAdapter == null || nextFromModule.isAutomatic()) continue;
                    nextFromModule.addIssue(new WorkspaceDependencyNotDefined(nextFromModule, "Uses '" + nextNotDefinedTo.getName() + "'", nextNotDefinedTo.getFullyQualifiedName()));
                }
            }
            return nodeAdapterSet;
        }

        @Override
        protected AnalyzerCycleGroup createCycleGroup(boolean isCritical) {
            return new ModuleCycleGroup(null, this.getSoftwareSystem(), isCritical);
        }

        @Override
        protected boolean discardIfContainedInOneModule() {
            return false;
        }

        @Override
        protected void finished(AnalyzerResult result) {
            assert (result != null) : "Parameter 'result' of method 'finished' must not be null";
            super.finished(result);
            int cyclicModules = 0;
            for (ModuleCycleGroup cg : result.getChildren(ModuleCycleGroup.class)) {
                cyclicModules += cg.getNumberOfCyclicElements();
            }
            ModuleCyclesInSystemAnalyzer.this.storeMetricValue(result, this.getSoftwareSystem(), cyclicModules, ModuleCyclesInSystemAnalyzer.this.m_numberOfCyclicModules);
        }

        @Override
        protected List<IType> getTypes(NamedElement namedElement) {
            assert (false) : "Unexpected call";
            return null;
        }
    }
}

