/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.controller.system.analysis.SizeComputationUtility;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.LogicalToplevelElementCyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.base.IMetricAwareLanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.RelativeCyclicityMetricIds;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssueSourceFilesParticipationInfo;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntanglementAnalyzerAdapter
extends AnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.ENTANGLEMENT;
    private static final Logger LOGGER = LoggerFactory.getLogger(EntanglementAnalyzerAdapter.class);
    private final IMetricDescriptor m_biggestCycleLoc;
    private final IMetricDescriptor m_entangledLinesOfCodePercent;
    private final IMetricDescriptor m_entangledLinesOfCode;
    private final IMetricDescriptor m_entangledLinesOfCodeCriticalPercent;
    private final IMetricDescriptor m_entangledLinesOfCodeCritical;
    private final IMetricDescriptor m_entangledLinesOfCodePercentIgnored;
    private final IMetricDescriptor m_entangledLinesOfCodeIgnored;
    private final IMetricDescriptor m_entangledLinesOfCodeCriticalPercentIgnored;
    private final IMetricDescriptor m_entangledLinesOfCodeCriticalIgnored;
    private final IMetricDescriptor m_entangledLinesOfCodePercentToFix;
    private final IMetricDescriptor m_entangledLinesOfCodeToFix;
    private final IMetricDescriptor m_entangledLinesOfCodeCriticalPercentToFix;
    private final IMetricDescriptor m_entangledLinesOfCodeCriticalToFix;
    private final IMetricDescriptor m_entanglement;
    private final IMetricDescriptor m_moduleEntanglement;

    public EntanglementAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_biggestCycleLoc = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_BIGGEST_CYCLE_LOC, CoreMetricLevel.SYSTEM);
        this.m_entangledLinesOfCodePercent = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_ENTANGLED_LINES_OF_CODE_PERCENT, CoreMetricLevel.SYSTEM);
        this.m_entangledLinesOfCode = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_ENTANGLED_LINES_OF_CODE, CoreMetricLevel.SYSTEM);
        this.m_entangledLinesOfCodeCriticalPercent = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_PERCENT, CoreMetricLevel.SYSTEM);
        this.m_entangledLinesOfCodeCritical = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CRITICAL_ENTANGLED_LINES_OF_CODE, CoreMetricLevel.SYSTEM);
        this.m_entangledLinesOfCodePercentIgnored = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_ENTANGLED_LINES_OF_CODE_PERCENT_IGNORED, CoreMetricLevel.SYSTEM);
        this.m_entangledLinesOfCodeIgnored = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_ENTANGLED_LINES_OF_CODE_IGNORED, CoreMetricLevel.SYSTEM);
        this.m_entangledLinesOfCodeCriticalPercentIgnored = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_PERCENT_IGNORED, CoreMetricLevel.SYSTEM);
        this.m_entangledLinesOfCodeCriticalIgnored = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_IGNORED, CoreMetricLevel.SYSTEM);
        this.m_entangledLinesOfCodePercentToFix = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_ENTANGLED_LINES_OF_CODE_PERCENT_TO_FIX, CoreMetricLevel.SYSTEM);
        this.m_entangledLinesOfCodeToFix = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_ENTANGLED_LINES_OF_CODE_TO_FIX, CoreMetricLevel.SYSTEM);
        this.m_entangledLinesOfCodeCriticalPercentToFix = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_PERCENT_TO_FIX, CoreMetricLevel.SYSTEM);
        this.m_entangledLinesOfCodeCriticalToFix = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CRITICAL_ENTANGLED_LINES_OF_CODE_TO_FIX, CoreMetricLevel.SYSTEM);
        this.m_entanglement = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_RELATIVE_ENTANGLEMENT, CoreMetricLevel.SYSTEM);
        this.m_moduleEntanglement = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_RELATIVE_ENTANGLEMENT, CoreMetricLevel.MODULE);
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        IAnalyzerController controller = this.getController();
        boolean isLogicalToplevelElementCyclesAnalyzerActive = false;
        ArrayList<AnalyzerResult> requiredResults = new ArrayList<AnalyzerResult>();
        AnalyzerExecutionLevel currentLevel = controller.getAnalyzerExecutionLevel();
        for (IAnalyzerId nextId : controller.getCurrentlyAvailableAnalyzerIds()) {
            if (nextId.getGroup() != AnalyzerGroup.CYCLES && nextId.getGroup() != AnalyzerGroup.CYCLE_METRICS || nextId.getExecutionLevel().ordinal() < currentLevel.ordinal()) continue;
            if (nextId == CoreAnalyzerId.LOGICAL_TOPLEVEL_ELEMENT_CYCLES) {
                LogicalToplevelElementCyclesAnalyzerAdapter logicalToplevelElementCyclesAnalyzerAdapter = controller.getAnalyzerAadpter(LogicalToplevelElementCyclesAnalyzerAdapter.class);
                assert (logicalToplevelElementCyclesAnalyzerAdapter != null) : "Parameter 'logicalToplevelElementCyclesAnalyzerAdapter' of method 'runJobs' must not be null";
                if (!logicalToplevelElementCyclesAnalyzerAdapter.canRun()) continue;
                isLogicalToplevelElementCyclesAnalyzerActive = true;
            }
            requiredResults.add(controller.getResultFor(nextId));
        }
        EntanglementAnalyzerJob job = new EntanglementAnalyzerJob(this.getGroup(), result, this.getController(), requiredResults, isLogicalToplevelElementCyclesAnalyzerActive);
        job.start();
    }

    @Override
    public boolean canStoreResult() {
        return true;
    }

    private final class EntanglementAnalyzerJob
    extends AnalyzerJob {
        private final boolean m_isLogicalToplevelElementCyclesAnalyzerActive;

        private EntanglementAnalyzerJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, Collection<AnalyzerResult> requiredResults, boolean isLogicalToplevelElementCyclesAnalyzerActive) {
            super(group, result, controller, requiredResults);
            this.m_isLogicalToplevelElementCyclesAnalyzerActive = isLogicalToplevelElementCyclesAnalyzerActive;
            if (LOGGER.isDebugEnabled()) {
                requiredResults.forEach(r -> LOGGER.debug("Entanglement analyzer requires: " + String.valueOf(r.getId())));
            }
        }

        List<CycleGroupIssueSourceFilesParticipationInfo> getSourceFileParticipationInfo(IWorkerContext workerContext) {
            assert (workerContext != null) : "Parameter 'wo' of method 'getSourceFileParticipationInfo' must not be null";
            ArrayList<CycleGroupIssueSourceFilesParticipationInfo> info = new ArrayList<CycleGroupIssueSourceFilesParticipationInfo>(2);
            for (AnalyzerResult nextResult : this.getRequiredResults()) {
                CycleGroupIssueSourceFilesParticipationInfo nextInfo;
                if (this.getWorkerContext().hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                IAnalyzerId nextAnalyzerId = nextResult.getId();
                if (!CoreAnalyzerId.COMPONENT_CYCLES_SYSTEM.equals(nextAnalyzerId) && !CoreAnalyzerId.COMPONENT_CYCLES_MODULE.equals(nextAnalyzerId) && !CoreAnalyzerId.LOGICAL_TOPLEVEL_ELEMENT_CYCLES.equals(nextAnalyzerId) || (nextInfo = nextResult.getUniqueChild(CycleGroupIssueSourceFilesParticipationInfo.class)) == null || !nextInfo.isProcessed()) continue;
                LOGGER.debug("Using cycle source file info: " + String.valueOf(nextAnalyzerId));
                info.add(nextInfo);
            }
            return info;
        }

        private void calculateRelativeEntanglementSystem(IWorkerContext workerContext, SoftwareSystem softwareSystem, IMetricAccessor metricAccessor, Set<RelativeCyclicityMetricIds> relativeCyclicityMetricIds, AnalyzerResult result) {
            Number relativeCyclicityLogicalToplevelElementsSystem;
            assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateRelativeEntanglementSystem' must not be null";
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'calculateRelativeEntanglementSystem' must not be null";
            assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'calculateRelativeEntanglementSystem' must not be null";
            assert (relativeCyclicityMetricIds != null) : "Parameter 'relativeCyclicityMetricIds' of method 'calculateRelativeEntanglementSystem' must not be null";
            assert (result != null) : "Parameter 'result' of method 'calculateRelativeEntanglementSystem' must not be null";
            Number relativeCyclicityComponentsSystem = metricAccessor.getMetricValue(softwareSystem, softwareSystem, CoreMetricId.CORE_RELATIVE_CYCLICITY_COMPONENTS);
            if (relativeCyclicityComponentsSystem == null) {
                LOGGER.error("Metric '" + String.valueOf(CoreMetricId.CORE_RELATIVE_CYCLICITY_COMPONENTS) + " (System)' is missing");
                return;
            }
            if (this.m_isLogicalToplevelElementCyclesAnalyzerActive) {
                relativeCyclicityLogicalToplevelElementsSystem = metricAccessor.getMetricValue(softwareSystem, softwareSystem, CoreMetricId.CORE_RELATIVE_CYCLICITY_LOGICAL_TOPLEVEL_ELEMENT);
                if (relativeCyclicityLogicalToplevelElementsSystem == null) {
                    LOGGER.error("Metric '" + String.valueOf(CoreMetricId.CORE_RELATIVE_CYCLICITY_LOGICAL_TOPLEVEL_ELEMENT) + " (System)' is missing");
                    return;
                }
            } else {
                relativeCyclicityLogicalToplevelElementsSystem = null;
            }
            float sumOfRelativeCyclicityPrimaryCycles = relativeCyclicityComponentsSystem.floatValue();
            int contributionsPrimaryCycles = 1;
            LOGGER.debug("Metric '" + String.valueOf(CoreMetricId.CORE_RELATIVE_CYCLICITY_COMPONENTS) + " (System)' added to sum of relative cyclicities: " + relativeCyclicityComponentsSystem.floatValue());
            if (relativeCyclicityLogicalToplevelElementsSystem != null) {
                sumOfRelativeCyclicityPrimaryCycles += relativeCyclicityLogicalToplevelElementsSystem.floatValue();
                ++contributionsPrimaryCycles;
                LOGGER.debug("Metric '" + String.valueOf(CoreMetricId.CORE_RELATIVE_CYCLICITY_LOGICAL_TOPLEVEL_ELEMENT) + " (System)' added to sum of relative cyclicities: " + relativeCyclicityLogicalToplevelElementsSystem.floatValue());
            }
            float relativeCyclicityPrimaryCycles = sumOfRelativeCyclicityPrimaryCycles / (float)contributionsPrimaryCycles;
            float sumOfRelativeCyclicitySecondaryCycles = 0.0f;
            int contributionsScondaryCycles = 0;
            for (RelativeCyclicityMetricIds nextMetrics : relativeCyclicityMetricIds) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                Number nextNumberOfElementsMetricValue = metricAccessor.getMetricValue(softwareSystem, softwareSystem, nextMetrics.getNumberOfElementsMetricId());
                if (nextNumberOfElementsMetricValue == null) {
                    LOGGER.error("Metric '" + String.valueOf(nextMetrics.getNumberOfElementsMetricId()) + " (System)' is missing");
                    continue;
                }
                if (nextNumberOfElementsMetricValue.intValue() <= 1) continue;
                Number nextAverageRelativeCyclicityMetricValue = metricAccessor.getMetricValue(softwareSystem, softwareSystem, nextMetrics.getAverageRelativeCyclicityMetricId());
                if (nextAverageRelativeCyclicityMetricValue == null) {
                    LOGGER.error("Metric '" + String.valueOf(nextMetrics.getAverageRelativeCyclicityMetricId()) + " (System)' is missing");
                    continue;
                }
                sumOfRelativeCyclicitySecondaryCycles += nextAverageRelativeCyclicityMetricValue.floatValue();
                ++contributionsScondaryCycles;
                LOGGER.debug("Metric '" + String.valueOf(nextMetrics.getAverageRelativeCyclicityMetricId()) + " (System)' added to sum of relative cyclicities: " + nextAverageRelativeCyclicityMetricValue.floatValue());
            }
            if (contributionsScondaryCycles > 0) {
                float relativeCyclicitySecondaryCycles = sumOfRelativeCyclicitySecondaryCycles / (float)contributionsScondaryCycles;
                float averageRelativeCyclicity = relativeCyclicityPrimaryCycles * 0.6f + relativeCyclicitySecondaryCycles * 0.4f;
                EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, Float.valueOf(averageRelativeCyclicity), EntanglementAnalyzerAdapter.this.m_entanglement);
            } else {
                EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, Float.valueOf(relativeCyclicityPrimaryCycles), EntanglementAnalyzerAdapter.this.m_entanglement);
            }
        }

        private void calculateRelativeEntanglementModule(IWorkerContext workerContext, SoftwareSystem softwareSystem, IMetricAccessor metricAccessor, Set<RelativeCyclicityMetricIds> relativeCyclicityMetricIds, AnalyzerResult result) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateRelativeEntanglementModule' must not be null";
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'calculateRelativeEntanglementModule' must not be null";
            assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'calculateRelativeEntanglementModule' must not be null";
            assert (relativeCyclicityMetricIds != null) : "Parameter 'relativeCyclicityMetricIds' of method 'calculateRelativeEntanglementModule' must not be null";
            assert (result != null) : "Parameter 'result' of method 'calculateRelativeEntanglementModule' must not be null";
            for (Module module : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                Number relativeCyclicityLogicalToplevelElementsModule;
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                LOGGER.debug("Calculating relative entanglement for module {}", (Object)module.getShortName());
                Number relativeCyclicityComponentsModule = metricAccessor.getMetricValue(softwareSystem, module, CoreMetricId.CORE_RELATIVE_CYCLICITY_COMPONENTS);
                if (relativeCyclicityComponentsModule == null) {
                    LOGGER.error("Mising module metric {}", (Object)CoreMetricId.CORE_RELATIVE_CYCLICITY_COMPONENTS);
                    continue;
                }
                LOGGER.debug("Metric '" + String.valueOf(CoreMetricId.CORE_RELATIVE_CYCLICITY_COMPONENTS) + " (Module)' added to sum of relative cyclicities: " + relativeCyclicityComponentsModule.floatValue());
                if (this.m_isLogicalToplevelElementCyclesAnalyzerActive) {
                    relativeCyclicityLogicalToplevelElementsModule = metricAccessor.getMetricValue(softwareSystem, module, CoreMetricId.CORE_RELATIVE_CYCLICITY_LOGICAL_TOPLEVEL_ELEMENT);
                    if (relativeCyclicityLogicalToplevelElementsModule == null) {
                        LOGGER.error("Metric '" + String.valueOf(CoreMetricId.CORE_RELATIVE_CYCLICITY_LOGICAL_TOPLEVEL_ELEMENT) + " (Md)' is missing");
                        continue;
                    }
                    LOGGER.debug("Metric '" + String.valueOf(CoreMetricId.CORE_RELATIVE_CYCLICITY_LOGICAL_TOPLEVEL_ELEMENT) + " (Module)' added to sum of relative cyclicities: " + relativeCyclicityLogicalToplevelElementsModule.floatValue());
                } else {
                    relativeCyclicityLogicalToplevelElementsModule = null;
                }
                float relativeCyclicityModuleRealCycles = relativeCyclicityComponentsModule.floatValue();
                if (relativeCyclicityLogicalToplevelElementsModule != null) {
                    relativeCyclicityModuleRealCycles += relativeCyclicityLogicalToplevelElementsModule.floatValue();
                    relativeCyclicityModuleRealCycles /= 2.0f;
                }
                int contributionsScondaryCycles = 0;
                float sumOfRelativeCyclicitySecondaryCycles = 0.0f;
                for (RelativeCyclicityMetricIds nextMetrics : relativeCyclicityMetricIds) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    Number nextNumberOfElementsMetricValue = metricAccessor.getMetricValue(softwareSystem, module, nextMetrics.getNumberOfElementsMetricId());
                    if (nextNumberOfElementsMetricValue == null) {
                        LOGGER.error("Metric '" + String.valueOf(nextMetrics.getNumberOfElementsMetricId()) + " (Module)' is missing");
                        continue;
                    }
                    if (nextNumberOfElementsMetricValue.intValue() <= 1) continue;
                    Number nextRelativeCyclicityMetricValue = metricAccessor.getMetricValue(softwareSystem, module, nextMetrics.getRelativeCyclicityMetricId());
                    if (nextRelativeCyclicityMetricValue == null) {
                        LOGGER.error("Metric '" + String.valueOf(nextMetrics.getRelativeCyclicityMetricId()) + " (Module)' is missing");
                        continue;
                    }
                    sumOfRelativeCyclicitySecondaryCycles += nextRelativeCyclicityMetricValue.floatValue();
                    ++contributionsScondaryCycles;
                    LOGGER.debug("Metric '" + String.valueOf(nextMetrics.getRelativeCyclicityMetricId()) + " (Module)' added to sum of relative cyclicities: " + nextRelativeCyclicityMetricValue.floatValue());
                }
                if (contributionsScondaryCycles > 0) {
                    float relativeCyclicitySecondaryCycles = sumOfRelativeCyclicitySecondaryCycles / (float)contributionsScondaryCycles;
                    float averageRelativeCyclicity = relativeCyclicityModuleRealCycles * 0.6f + relativeCyclicitySecondaryCycles * 0.4f;
                    EntanglementAnalyzerAdapter.this.storeMetricValue(result, module, Float.valueOf(averageRelativeCyclicity), EntanglementAnalyzerAdapter.this.m_moduleEntanglement);
                    continue;
                }
                EntanglementAnalyzerAdapter.this.storeMetricValue(result, module, Float.valueOf(relativeCyclicityModuleRealCycles), EntanglementAnalyzerAdapter.this.m_moduleEntanglement);
            }
        }

        @Override
        protected void internalRun() {
            IMetricAccessor metricAccessor = this.getInstallation().getExtension(IMetricAccessor.class);
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            IWorkerContext workerContext = this.getWorkerContext();
            AnalyzerResult result = this.getResult();
            Number fullyAnalyzedLocValueSystem = metricAccessor.getMetricValue(softwareSystem, softwareSystem, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_LINES_OF_CODE_FULLY_ANALYZED, false);
            if (fullyAnalyzedLocValueSystem != null) {
                int fullyAnalyzedLocSystem = fullyAnalyzedLocValueSystem.intValue();
                if (fullyAnalyzedLocSystem > 0) {
                    THashSet criticallyEntangledSources = new THashSet();
                    THashSet entangledSources = new THashSet();
                    THashSet criticallyEntangledSourcesIgnored = new THashSet();
                    THashSet entangledSourcesIgnored = new THashSet();
                    THashSet criticallyEntangledSourcesToFix = new THashSet();
                    THashSet entangledSourcesToFix = new THashSet();
                    int biggestCycleLoc = 0;
                    List<CycleGroupIssueSourceFilesParticipationInfo> sourceFileParticipationInfo = this.getSourceFileParticipationInfo(workerContext);
                    if (!sourceFileParticipationInfo.isEmpty()) {
                        for (CycleGroupIssueSourceFilesParticipationInfo info : sourceFileParticipationInfo) {
                            if (workerContext.hasBeenCanceled()) {
                                return;
                            }
                            for (Map.Entry<CycleGroupIssue, List<SourceFile>> nextEntry : info.getCycleGroupToSourceFiles().entrySet()) {
                                if (workerContext.hasBeenCanceled()) {
                                    return;
                                }
                                CycleGroupIssue cycleIssue = nextEntry.getKey();
                                List<SourceFile> sources = nextEntry.getValue();
                                AnalyzerCycleGroup cycle = cycleIssue.getAffectedElement();
                                IResolution resolution = cycleIssue.getResolution();
                                if (cycle.getLinesOfCodeOfInvolvedSourceFiles() > biggestCycleLoc) {
                                    biggestCycleLoc = cycle.getLinesOfCodeOfInvolvedSourceFiles();
                                }
                                entangledSources.addAll(sources);
                                if (cycle.isCritical()) {
                                    criticallyEntangledSources.addAll(sources);
                                }
                                if (resolution instanceof IgnoreDefinition) {
                                    entangledSourcesIgnored.addAll(sources);
                                    if (!cycle.isCritical()) continue;
                                    criticallyEntangledSourcesIgnored.addAll(sources);
                                    continue;
                                }
                                if (!(resolution instanceof TaskDefinition)) continue;
                                entangledSourcesToFix.addAll(sources);
                                if (!cycle.isCritical()) continue;
                                criticallyEntangledSourcesToFix.addAll(sources);
                            }
                        }
                        EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, biggestCycleLoc, EntanglementAnalyzerAdapter.this.m_biggestCycleLoc);
                        int entangledLoc = SizeComputationUtility.computeLinesOfCode((Collection<SourceFile>)entangledSources);
                        EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, Float.valueOf(this.percentage(entangledLoc, fullyAnalyzedLocSystem)), EntanglementAnalyzerAdapter.this.m_entangledLinesOfCodePercent);
                        EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, entangledLoc, EntanglementAnalyzerAdapter.this.m_entangledLinesOfCode);
                        int criticallyEntangledLoc = SizeComputationUtility.computeLinesOfCode((Collection<SourceFile>)criticallyEntangledSources);
                        EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, Float.valueOf(this.percentage(criticallyEntangledLoc, fullyAnalyzedLocSystem)), EntanglementAnalyzerAdapter.this.m_entangledLinesOfCodeCriticalPercent);
                        EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, criticallyEntangledLoc, EntanglementAnalyzerAdapter.this.m_entangledLinesOfCodeCritical);
                        int entangledLocIgnored = SizeComputationUtility.computeLinesOfCode((Collection<SourceFile>)entangledSourcesIgnored);
                        EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, Float.valueOf(this.percentage(entangledLocIgnored, fullyAnalyzedLocSystem)), EntanglementAnalyzerAdapter.this.m_entangledLinesOfCodePercentIgnored);
                        EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, entangledLocIgnored, EntanglementAnalyzerAdapter.this.m_entangledLinesOfCodeIgnored);
                        int criticallyEntangledLocIgnored = SizeComputationUtility.computeLinesOfCode((Collection<SourceFile>)criticallyEntangledSourcesIgnored);
                        EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, Float.valueOf(this.percentage(criticallyEntangledLocIgnored, fullyAnalyzedLocSystem)), EntanglementAnalyzerAdapter.this.m_entangledLinesOfCodeCriticalPercentIgnored);
                        EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, criticallyEntangledLocIgnored, EntanglementAnalyzerAdapter.this.m_entangledLinesOfCodeCriticalIgnored);
                        int entangledLocToFix = SizeComputationUtility.computeLinesOfCode((Collection<SourceFile>)entangledSourcesToFix);
                        EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, Float.valueOf(this.percentage(entangledLocToFix, fullyAnalyzedLocSystem)), EntanglementAnalyzerAdapter.this.m_entangledLinesOfCodePercentToFix);
                        EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, entangledLocToFix, EntanglementAnalyzerAdapter.this.m_entangledLinesOfCodeToFix);
                        int criticallyEntangledLocToFix = SizeComputationUtility.computeLinesOfCode((Collection<SourceFile>)criticallyEntangledSourcesToFix);
                        EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, Float.valueOf(this.percentage(criticallyEntangledLocToFix, fullyAnalyzedLocSystem)), EntanglementAnalyzerAdapter.this.m_entangledLinesOfCodeCriticalPercentToFix);
                        EntanglementAnalyzerAdapter.this.storeMetricValue(result, softwareSystem, criticallyEntangledLocToFix, EntanglementAnalyzerAdapter.this.m_entangledLinesOfCodeCriticalToFix);
                    }
                } else {
                    LOGGER.debug("Value for metric '" + String.valueOf(CoreMetricId.CORE_LINES_OF_CODE_FULLY_ANALYZED) + " (System)' is not greater than 0");
                }
            } else {
                LOGGER.error("Metric '" + String.valueOf(CoreMetricId.CORE_LINES_OF_CODE_FULLY_ANALYZED) + " (System)' is missing");
            }
            THashSet relativeCyclicityMetricIds = new THashSet();
            EntanglementAnalyzerAdapter.this.getController().getUsedLanguageProviders().forEach(arg_0 -> EntanglementAnalyzerJob.lambda$1((Set)relativeCyclicityMetricIds, arg_0));
            this.calculateRelativeEntanglementSystem(workerContext, softwareSystem, metricAccessor, (Set<RelativeCyclicityMetricIds>)relativeCyclicityMetricIds, result);
            this.calculateRelativeEntanglementModule(workerContext, softwareSystem, metricAccessor, (Set<RelativeCyclicityMetricIds>)relativeCyclicityMetricIds, result);
        }

        private static /* synthetic */ void lambda$1(Set set, IMetricAwareLanguageProvider lp) {
            boolean bl = set.addAll(lp.getRelativeCyclicityMetricIds());
        }
    }
}

