/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.coupling;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.coupling.AbstractCohesionAndCouplingMetricsAdapter;
import com.hello2morrow.sonargraph.core.controller.system.base.IMetricAwareLanguageProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.graph.ConnectedComponentComputer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IConnectedComponentComputerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.IField;
import com.hello2morrow.sonargraph.core.model.programming.IMethod;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.InternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public final class CohesionAndCouplingMetricsSystem
extends AbstractCohesionAndCouplingMetricsAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.COHESION_AND_COUPLING_METRICS_SYSTEM;
    private final Map<Language, IMetricDescriptor> m_languageToRelationalCohesionSystem = new THashMap();
    private final IMetricDescriptor m_lCOM4;
    private final IMetricDescriptor m_logicalCohesionSystem;
    private final IMetricDescriptor m_logicalCouplingSystem;
    private final IMetricDescriptor m_physicalCohesionSystem;
    private final IMetricDescriptor m_physicalCouplingSystem;

    private static Predicate<NamedElement> createLcom4Predicate() {
        return new Predicate<NamedElement>(){

            @Override
            public boolean test(NamedElement namedElement) {
                if (!($assertionsDisabled || namedElement != null && namedElement instanceof IType)) {
                    throw new AssertionError((Object)("Unexpected class in method 'enclosing_method': " + String.valueOf(namedElement)));
                }
                IType type = (IType)((Object)namedElement);
                return type.isClass() && !((NamedElement)((Object)type)).isExcluded() && !((NamedElement)((Object)type)).getRefactoringState().hasBeenDeleted();
            }
        };
    }

    public CohesionAndCouplingMetricsSystem(IAnalyzerController controller) {
        super(controller, ID);
        Predicate<NamedElement> lCOM4Predicate = CohesionAndCouplingMetricsSystem.createLcom4Predicate();
        Predicate<NamedElement> systemFilter = e -> e instanceof LogicalSystemProgrammingElement;
        Predicate<NamedElement> systemNamespaceFilter = e -> e instanceof LogicalSystemNamespace;
        Predicate<NamedElement> typeFilter = e -> ((LogicalProgrammingElement)e).getPrimaryProgrammingElement() instanceof IType && !(e.getParent() instanceof LogicalProgrammingElement);
        Predicate<NamedElement> typeFilterSystem = systemFilter.and(typeFilter);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_lCOM4 = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_LCOM4, CoreMetricLevel.TYPE, lCOM4Predicate);
        this.m_logicalCohesionSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_LOGICAL_COHESION_SYSTEM, CoreMetricLevel.LOGICAL_PROGRAMMING_ELEMENT, typeFilterSystem);
        this.m_logicalCouplingSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_LOGICAL_COUPLING_SYSTEM, CoreMetricLevel.LOGICAL_PROGRAMMING_ELEMENT, typeFilterSystem);
        this.m_physicalCohesionSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_PHYSICAL_COHESION, CoreMetricLevel.COMPONENT, null);
        this.m_physicalCouplingSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_PHYSICAL_COUPLING, CoreMetricLevel.COMPONENT, null);
        for (Language nextUsedLanguage : controller.getSoftwareSystem().getUsedLanguages()) {
            IMetricAwareLanguageProvider nextLanguageProvider = controller.getLanguageProvider(nextUsedLanguage);
            if (nextLanguageProvider.getNamespaceMetricLevel() == null) continue;
            this.m_languageToRelationalCohesionSystem.put(nextUsedLanguage, this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_RELATIONAL_COHESION_SYSTEM, nextLanguageProvider.getNamespaceMetricLevel(), systemNamespaceFilter, nextUsedLanguage));
        }
    }

    @Override
    public void languageAdded(IMetricAwareLanguageProvider languageProvider) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageAdded' must not be null";
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        Language language = languageProvider.getLanguage();
        if (languageProvider.getNamespaceMetricLevel() != null) {
            Predicate<NamedElement> systemNamespaceFilter = e -> e instanceof LogicalSystemNamespace;
            this.m_languageToRelationalCohesionSystem.put(language, this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_RELATIONAL_COHESION_SYSTEM, languageProvider.getNamespaceMetricLevel(), systemNamespaceFilter, language));
        }
    }

    @Override
    public void languageRemoved(IMetricAwareLanguageProvider languageProvider) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageRemoved' must not be null";
        Language language = languageProvider.getLanguage();
        IMetricDescriptor removedSystemScope = this.m_languageToRelationalCohesionSystem.remove(language);
        assert (removedSystemScope != null) : "'removedSystemScope' of method 'languageRemoved' must not be null";
        this.remove(Collections.singletonList(removedSystemScope));
    }

    @Override
    public void runJobs(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        CohesionAndCouplingMetricsSystemJob job = new CohesionAndCouplingMetricsSystemJob(this.getGroup(), result, this.getController());
        job.start();
    }

    private final class CohesionAndCouplingMetricsSystemJob
    extends AbstractCohesionAndCouplingMetricsAdapter.CohesionAndCouplingMetricsJob
    implements IConnectedComponentComputerAdapter {
        private final Map<Language, ValueList> m_languageToRelationalCohessionValueListSystem;
        private final ValueList m_valueListLCOM4;
        private final ValueList m_valueListLogicalCohesionSystem;
        private final ValueList m_valueListLogicalCouplingSystem;
        private final ValueList m_valueListPhysicalCohesion;
        private final ValueList m_valueListPhysicalCoupling;
        private NodeAdapterSet<ParserDependencyNodeAdapter> m_currentLCOM4NodeAdapterSet;
        private NamedElement m_currentLCOM4Type;

        protected CohesionAndCouplingMetricsSystemJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(CohesionAndCouplingMetricsSystem.this, group, result, controller);
            this.m_languageToRelationalCohessionValueListSystem = new THashMap();
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            this.m_valueListLCOM4 = CohesionAndCouplingMetricsSystem.this.createValueList(result, CohesionAndCouplingMetricsSystem.this.m_lCOM4, softwareSystem);
            this.m_valueListLogicalCohesionSystem = CohesionAndCouplingMetricsSystem.this.createValueList(result, CohesionAndCouplingMetricsSystem.this.m_logicalCohesionSystem, softwareSystem);
            this.m_valueListLogicalCouplingSystem = CohesionAndCouplingMetricsSystem.this.createValueList(result, CohesionAndCouplingMetricsSystem.this.m_logicalCouplingSystem, softwareSystem);
            this.m_valueListPhysicalCohesion = CohesionAndCouplingMetricsSystem.this.createValueList(result, CohesionAndCouplingMetricsSystem.this.m_physicalCohesionSystem, softwareSystem);
            this.m_valueListPhysicalCoupling = CohesionAndCouplingMetricsSystem.this.createValueList(result, CohesionAndCouplingMetricsSystem.this.m_physicalCouplingSystem, softwareSystem);
            for (Map.Entry<Language, IMetricDescriptor> nextEntry : CohesionAndCouplingMetricsSystem.this.m_languageToRelationalCohesionSystem.entrySet()) {
                this.m_languageToRelationalCohessionValueListSystem.put(nextEntry.getKey(), CohesionAndCouplingMetricsSystem.this.createValueList(result, nextEntry.getValue(), softwareSystem));
            }
        }

        @Override
        public void components(Set<List<INode<?>>> components) {
            assert (components != null) : "Parameter 'components' of method 'components' must not be null";
            this.m_valueListLCOM4.addValue(this.m_currentLCOM4Type, components.size());
        }

        private void calculateLCOM4(List<RootDirectoryPath> rootDirectoryPaths) {
            assert (rootDirectoryPaths != null && !rootDirectoryPaths.isEmpty()) : "Parameter 'rootDirectoryPaths' of method 'calculateLCOM4' must not be empty";
            IWorkerContext workerContext = this.getWorkerContext();
            workerContext.setNumberOfSteps(2, new int[]{5, 95});
            workerContext.working("Collect top level types", true);
            Predicate<NamedElement> lCom4Predicate = CohesionAndCouplingMetricsSystem.createLcom4Predicate();
            ArrayList<NamedElement> relevantTypes = new ArrayList<NamedElement>();
            for (RootDirectoryPath nextRootDirectoryPath : rootDirectoryPaths) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                for (IType nextType : nextRootDirectoryPath.getChildrenRecursively(IType.class, new Class[0])) {
                    if (!lCom4Predicate.test(nextType.getNamedElement())) continue;
                    relevantTypes.add(nextType.getNamedElement());
                }
            }
            workerContext.endStep();
            if (!workerContext.hasBeenCanceled() && relevantTypes.size() > 0) {
                workerContext.beginSubTask("Calculate LCOM4");
                workerContext.setNumberOfSteps(relevantTypes.size());
                for (NamedElement nextRelevantType : relevantTypes) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    this.m_currentLCOM4Type = nextRelevantType;
                    ArrayList<ProgrammingElement> nextElements = new ArrayList<ProgrammingElement>();
                    for (ProgrammingElement next : this.m_currentLCOM4Type.getChildren(ProgrammingElement.class)) {
                        IMethod nextMethod;
                        if (workerContext.hasBeenCanceled()) {
                            return;
                        }
                        if (!next.isDefinedInEnclosingElement()) continue;
                        if (next instanceof IType) {
                            nextElements.add(next);
                            continue;
                        }
                        if (next instanceof IField) {
                            nextElements.add(next);
                            continue;
                        }
                        if (!(next instanceof IMethod) || (nextMethod = (IMethod)((Object)next)).isAbstract() || nextMethod.isInitializer() || nextMethod.isDestructor() || nextMethod.isOverriding() || nextMethod.getNumberOfStatements() <= 0) continue;
                        nextElements.add(next);
                    }
                    if (nextElements.isEmpty()) {
                        this.m_valueListLCOM4.addValue(this.m_currentLCOM4Type, 1);
                    } else {
                        this.m_currentLCOM4NodeAdapterSet = new ParserDependencyNodeAdapterSet((IWorkerContext)DefaultWorkerContext.INSTANCE, nextElements, new DependencyEndpointCollector(), PE, PD);
                        new ConnectedComponentComputer(this.m_currentLCOM4NodeAdapterSet.getNodes(), this.getWorkerContext(), this);
                        this.m_currentLCOM4NodeAdapterSet = null;
                        this.m_currentLCOM4Type = null;
                    }
                    workerContext.endStep();
                }
                workerContext.endSubTask();
            }
        }

        private void calculatePhysicalCohesionAndCoupling(List<? extends NamedElement> container, ValueList cohesion, ValueList coupling, IWorkerContext workerContext) {
            assert (container != null && !container.isEmpty()) : "Parameter 'container' of method 'calculateComponentCohesionAndCoupling' must not be empty";
            assert (cohesion != null) : "Parameter 'cohesion' of method 'calculateComponentCohesionAndCoupling' must not be null";
            assert (coupling != null) : "Parameter 'coupling' of method 'calculateComponentCohesionAndCoupling' must not be null";
            workerContext.setNumberOfSteps(2);
            workerContext.beginBlockOfWork(container.size());
            workerContext.working("Calculating cohesion", true);
            ArrayList<NamedElement> allComponents = new ArrayList<NamedElement>();
            THashMap componentToContainer = new THashMap();
            for (NamedElement namedElement : container) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                List<IComponent> nextComponents = namedElement.getChildren(IComponent.class);
                ArrayList<NamedElement> nextNonExcludedComponentsAsNamedElements = new ArrayList<NamedElement>(nextComponents.size());
                for (IComponent nextComponent : nextComponents) {
                    if (nextComponent.isExcluded()) continue;
                    nextNonExcludedComponentsAsNamedElements.add(nextComponent.getNamedElement());
                    allComponents.add(nextComponent.getNamedElement());
                    componentToContainer.put(nextComponent.getNamedElement(), namedElement);
                }
                ParserDependencyNodeAdapterSet nodeAdapterSet = new ParserDependencyNodeAdapterSet((IWorkerContext)DefaultWorkerContext.INSTANCE, nextNonExcludedComponentsAsNamedElements, new DependencyEndpointCollector(), PE, PD);
                for (ParserDependencyNodeAdapter nextNodeAdapter : nodeAdapterSet.getNodes()) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    cohesion.addValue(nextNodeAdapter.getUnderlyingObject(), nextNodeAdapter.getNumberOfIncomingEdges() + nextNodeAdapter.getNumberOfOutgoingEdges());
                }
                workerContext.workItemCompleted();
            }
            workerContext.working("Calculating coupling", true);
            if (!componentToContainer.isEmpty()) {
                ParserDependencyNodeAdapterSet parserDependencyNodeAdapterSet = new ParserDependencyNodeAdapterSet((IWorkerContext)DefaultWorkerContext.INSTANCE, allComponents, new PhysicalCouplingCollector((Map<NamedElement, NamedElement>)componentToContainer), PE, PD);
                for (ParserDependencyNodeAdapter nextNodeAdapter : parserDependencyNodeAdapterSet.getNodes()) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    coupling.addValue(nextNodeAdapter.getUnderlyingObject(), nextNodeAdapter.getNumberOfIncomingEdges() + nextNodeAdapter.getNumberOfOutgoingEdges());
                }
            }
            workerContext.endStep();
        }

        @Override
        public void internalRun() {
            IWorkerContext workerContext = this.getWorkerContext();
            ArrayList<RootDirectoryPath> rootDirectoryPaths = new ArrayList<RootDirectoryPath>();
            ArrayList<DirectoryPath> directoryPaths = new ArrayList<DirectoryPath>();
            ArrayList<NamespaceFragment> physicalNamespaces = new ArrayList<NamespaceFragment>();
            for (Module nextModule : this.getSoftwareSystem().getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                List<RootDirectoryPath> nextRootDirectoryPaths = nextModule.getChildren(RootDirectoryPath.class);
                rootDirectoryPaths.addAll(nextRootDirectoryPaths);
                directoryPaths.addAll(nextRootDirectoryPaths);
                for (RootDirectoryPath nextRootDirectoryPath : nextRootDirectoryPaths) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    directoryPaths.addAll(nextRootDirectoryPath.getChildrenRecursively(DirectoryPath.class, IComponent.class));
                    physicalNamespaces.addAll(nextRootDirectoryPath.getChildrenRecursively(NamespaceFragment.class, IComponent.class));
                }
            }
            if (workerContext.hasBeenCanceled() || rootDirectoryPaths.isEmpty()) {
                return;
            }
            ArrayList<LogicalNamespace> internalLogicalSystemNamespaces = new ArrayList<LogicalNamespace>();
            for (InternalLogicalNamespaceRoot nextInternalLogicalNamespaceRoot : this.getSoftwareSystem().getUniqueExistingChild(LogicalSystemNamespaces.class).getChildren(InternalLogicalNamespaceRoot.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                internalLogicalSystemNamespaces.addAll(nextInternalLogicalNamespaceRoot.getNonPartLogicalNamespaces());
            }
            int numberOfSteps = 1;
            if (!directoryPaths.isEmpty()) {
                ++numberOfSteps;
            }
            if (!physicalNamespaces.isEmpty()) {
                ++numberOfSteps;
            }
            if (!internalLogicalSystemNamespaces.isEmpty()) {
                ++numberOfSteps;
            }
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.setNumberOfSteps(numberOfSteps);
            workerContext.beginSubTask("Calculate LCOM4");
            this.calculateLCOM4(rootDirectoryPaths);
            workerContext.endSubTask();
            if (!workerContext.hasBeenCanceled() && !directoryPaths.isEmpty()) {
                workerContext.beginSubTask("Calculate physical cohesion and coupling");
                this.calculatePhysicalCohesionAndCoupling(directoryPaths, this.m_valueListPhysicalCohesion, this.m_valueListPhysicalCoupling, workerContext);
                workerContext.endSubTask();
            }
            if (!workerContext.hasBeenCanceled() && !physicalNamespaces.isEmpty()) {
                workerContext.beginSubTask("Calculate pysical cohesion and coupling");
                this.calculatePhysicalCohesionAndCoupling(physicalNamespaces, this.m_valueListPhysicalCohesion, this.m_valueListPhysicalCoupling, workerContext);
                workerContext.endSubTask();
            }
            if (!workerContext.hasBeenCanceled() && !internalLogicalSystemNamespaces.isEmpty()) {
                workerContext.beginSubTask("Calculate namespace (system based) cohesion and coupling");
                this.calculateLogicalCohesionAndCoupling(internalLogicalSystemNamespaces, this.m_valueListLogicalCohesionSystem, this.m_valueListLogicalCouplingSystem, this.m_languageToRelationalCohessionValueListSystem, workerContext);
                workerContext.endSubTask();
            }
        }
    }

    private static final class PhysicalCouplingCollector
    extends DependencyEndpointCollector {
        private final Map<NamedElement, NamedElement> m_componentToContainer;

        PhysicalCouplingCollector(Map<NamedElement, NamedElement> componentToContainer) {
            assert (componentToContainer != null && !componentToContainer.isEmpty()) : "Parameter 'componentToContainer' of method 'CouplingCollector' must not be empty";
            this.m_componentToContainer = componentToContainer;
        }

        @Override
        public boolean addDependency(NamedElement from, NamedElement to, Dependency dependency) {
            boolean add = super.addDependency(from, to, dependency);
            if (add) {
                NamedElement fromContainer = this.m_componentToContainer.get(from);
                assert (fromContainer != null) : "'fromContainer' of method 'addDependency' must not be null";
                NamedElement toContainer = this.m_componentToContainer.get(to);
                assert (toContainer != null) : "'toContainer' of method 'addDependency' must not be null";
                add = fromContainer != toContainer;
            }
            return add;
        }
    }
}

