/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.base;

import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.plugin.IAnalyzerPluginContext;
import com.hello2morrow.sonargraph.plugin.IModelPluginContext;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import gnu.trove.map.hash.THashMap;
import java.util.Map;

public final class PluginContextAdapter
implements IModelPluginContext,
IAnalyzerPluginContext {
    private final IWorkerContext m_workerContext;
    private final Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess> m_access;

    public PluginContextAdapter(IWorkerContext workerContext, Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess> access) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'PluginContextAdapter' must not be null";
        this.m_workerContext = workerContext;
        this.m_access = new THashMap(access);
        for (Map.Entry<Class<? extends IPluginCoreAccess>, IPluginCoreAccess> nextEntry : this.m_access.entrySet()) {
            assert (nextEntry.getKey().isAssignableFrom(nextEntry.getValue().getClass())) : "Inconsistent entry: " + nextEntry.getKey().getName() + "/" + nextEntry.getValue().getClass().getName();
        }
    }

    public <T extends IPluginCoreAccess> T getAccess(Class<T> access) {
        assert (access != null) : "Parameter 'access' of method 'getAccess' must not be null";
        for (Map.Entry<Class<? extends IPluginCoreAccess>, IPluginCoreAccess> nextEntry : this.m_access.entrySet()) {
            if (!nextEntry.getKey().equals(access)) continue;
            return (T)nextEntry.getValue();
        }
        return null;
    }

    public boolean hasBeenCanceled() {
        return this.m_workerContext.hasBeenCanceled();
    }

    public void started(SonargraphPlugin plugin) {
        assert (plugin != null) : "Parameter 'plugin' of method 'started' must not be null";
        this.m_workerContext.beginSubTask(plugin.getPresentationName());
    }

    public void finished() {
        this.m_workerContext.endSubTask();
    }

    public void setNumberOfSteps(int numberOfSteps) {
        this.m_workerContext.setNumberOfSteps(numberOfSteps);
    }

    public void beginBlockOfWork(int workItems) {
        this.m_workerContext.beginBlockOfWork(workItems);
    }

    public void workItemCompleted() {
        this.m_workerContext.workItemCompleted();
    }

    public void working(String message) {
        this.m_workerContext.working(message, true);
    }
}

