/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class SizeComputationUtility {
    private SizeComputationUtility() {
    }

    public static List<SourceFile> getInternalNotExcludedSourceFiles(IComponent component) {
        assert (component != null) : "Parameter 'component' of method 'getSourceFiles' must not be null";
        if (component instanceof SourceFile) {
            return Collections.singletonList((SourceFile)((Object)component));
        }
        if (component instanceof NamedElement) {
            return ((NamedElement)((Object)component)).getChildren(SourceFile.class).stream().filter(s -> !s.isExternal() && !s.isExcluded()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<SourceFile> getInternalNotExcludedSourceFiles(NamedElement element) {
        assert (element != null) : "Parameter 'namedElement' of method 'getSourceFile' must not be null";
        assert (element.isValid()) : "Not a valid element: " + String.valueOf(element);
        if ((element = element.getElement()) instanceof LogicalProgrammingElement) {
            element = ((LogicalProgrammingElement)element).getPrimaryProgrammingElement();
        }
        if (element instanceof SourceFile) {
            return Collections.singletonList((SourceFile)element);
        }
        if (element instanceof IComponent) {
            return SizeComputationUtility.getInternalNotExcludedSourceFiles((IComponent)((Object)element));
        }
        SourceFile parent = element.getParent(SourceFile.class, IComponent.class);
        if (parent != null) {
            return Collections.singletonList(parent);
        }
        assert (false) : "Unexpected element: " + element.getClass().getCanonicalName();
        return null;
    }

    public static int computeLinesOfCode(Collection<SourceFile> sources) {
        assert (sources != null) : "Parameter 'sources' of method 'computeLinesOfCode' must not be null";
        return sources.parallelStream().mapToInt(s -> s.getLinesOfCode()).filter(loc -> loc >= 0).sum();
    }
}

