/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.WriteExecutor;
import com.hello2morrow.sonargraph.core.model.common.BackgroundTaskException;
import com.hello2morrow.sonargraph.core.model.common.SonargraphException;
import com.hello2morrow.sonargraph.core.model.event.ExceptionEvent;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.snapshot.SnapshotWriter;
import com.hello2morrow.sonargraph.foundation.activity.CancellableWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

final class WriteSnapshotExecutor
extends WriteExecutor {
    private final SoftwareSystem m_softwareSystem;
    private CancellableWorkerContext m_workerContext;
    private OperationResult m_result;

    WriteSnapshotExecutor(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'WriteSnapshotExecutor' must not be null";
        this.m_softwareSystem = softwareSystem;
    }

    final void run(final ISnapshotProcessor.Mode mode) {
        this.m_workerContext = new CancellableWorkerContext();
        this.execute(this.m_workerContext, "Snapshot Writer", new Runnable(){

            @Override
            public void run() {
                SnapshotWriter writer = new SnapshotWriter(WriteSnapshotExecutor.this.m_softwareSystem, mode);
                WriteSnapshotExecutor.this.m_result = new OperationResult("Write snapshot");
                writer.writeSnapshot((IWorkerContext)WriteSnapshotExecutor.this.m_workerContext, WriteSnapshotExecutor.this.m_result);
            }
        });
    }

    @Override
    protected void handleException(String context, Throwable throwable) {
        assert (context != null && context.length() > 0) : "Parameter 'context' of method 'handleException' must not be empty";
        assert (throwable != null) : "Parameter 'throwable' of method 'handleException' must not be null";
        assert (this.m_result != null) : "Parameter 'm_result' of method 'handleException' must not be null";
        this.m_result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, throwable);
    }

    @Override
    protected void executionFinished() {
        assert (this.m_workerContext != null) : "Parameter 'm_workerContext' of method 'executionFinished' must not be null";
        assert (this.m_result != null) : "Parameter 'm_result' of method 'executionFinished' must not be null";
        if (!this.m_workerContext.hasBeenCanceled() && !this.m_result.isSuccess()) {
            SonargraphException.Severity severity = this.m_result.getErrorCauses().contains(IOMessageCause.WRITE_ERROR) ? SonargraphException.Severity.WARNING : SonargraphException.Severity.ERROR;
            EventManager.getInstance().dispatch((Object)this, (Event)new ExceptionEvent(this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class), new BackgroundTaskException(this.m_result.toString(), null, severity)));
        }
        this.m_workerContext = null;
        this.m_result = null;
    }
}

