/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.AnalyzerExtension;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderMessageCause;
import com.hello2morrow.sonargraph.core.controller.system.ModuleNameValidator;
import com.hello2morrow.sonargraph.core.controller.system.RootDirectoryPathValidator;
import com.hello2morrow.sonargraph.core.controller.system.VirtualModelExtension;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceDependencyElementIdValidator;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtensionMessageCause;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceModification;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceProvider;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.WorkspaceCycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ISnapshotController;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.FullyQualifiedNameFilter;
import com.hello2morrow.sonargraph.core.model.element.IImportedModule;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.Pattern;
import com.hello2morrow.sonargraph.core.model.filter.PatternType;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.IManualWorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.UnresolvedWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependencyElementIdFilter;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependencyNotDefined;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependencyNotImplemented;
import com.hello2morrow.sonargraph.core.model.system.AssignmentInfo;
import com.hello2morrow.sonargraph.core.model.system.AssignmentInfoComparator;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkspaceExtension
extends WorkspaceProvider
implements IWorkspaceExtension,
ISoftwareSystemLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkspaceExtension.class);
    private final IFinishModelProcessor m_finishModelProcessor;

    public WorkspaceExtension(LanguageProviderAccessor accessor, Installation installation, SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor) {
        super(accessor, installation, softwareSystem);
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'WorkspaceExtension' must not be null";
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_finishModelProcessor.addListener(this);
    }

    public Module createModule(Module.IModuleType moduleType, String moduleName, String description, EnumSet<Modification> modification) {
        AnalyzerExtension analyzerExtension;
        assert (moduleType != null) : "Parameter 'moduleType' of method 'createModule' must not be null";
        assert (this.getModuleNameValidator().isValid(null, moduleName).isSuccess()) : "Module name not valid: " + moduleName;
        assert (modification != null) : "Parameter 'modification' of method 'createModuleInternal' must not be null";
        LanguageProvider languageProvider = this.getAccessor().getLanguageProvider(moduleType.getLanguage());
        assert (languageProvider != null) : "'languageProvider' of method 'createModule' must not be null";
        modification.add(Modification.WORKSPACE_SETUP_MODIFIED);
        if (!this.getSoftwareSystem().getUniqueExistingChild(Workspace.class).hasChildren(false, languageProvider.getModuleClass())) {
            languageProvider.aboutToCreateFirstModule(this.getSoftwareSystem());
            analyzerExtension = this.getSoftwareSystem().getExtension(AnalyzerExtension.class);
            analyzerExtension.languageAdded(languageProvider, null);
            modification.add(Modification.AVAILABLE_LANGUAGES_MODIFIED);
        } else {
            analyzerExtension = null;
        }
        Module module = languageProvider.createModule(this.getSoftwareSystem(), moduleType, StringUtility.createTimebasedId((String)moduleName), moduleName, description);
        assert (module != null) : "'module' of method 'createModule' must not be null";
        if (analyzerExtension != null) {
            analyzerExtension.runAutomatedAnalyzers(null);
        }
        return module;
    }

    @Override
    public OperationResultWithOutcome<Module> createModule(IWorkerContext workerContext, Module.IModuleType moduleType, String moduleName, String description) {
        assert (moduleType != null) : "Parameter 'moduleType' of method 'createModule' must not be null";
        assert (this.getModuleNameValidator().isValid(null, moduleName).isSuccess()) : "Module name not valid: " + moduleName;
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create Module: " + moduleType.getPresentationName());
        EnumSet<Modification> modification = EnumSet.noneOf(Modification.class);
        Module module = this.createModule(moduleType, moduleName, description, modification);
        result.setOutcome((Object)module);
        this.getSoftwareSystem().setNeedsSave(true);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), modification, (OperationResult)result);
        return result;
    }

    static OperationResultWithOutcome<Module> createModule(LanguageProviderAccessor languageProviderAccessor, SoftwareSystem softwareSystem, String languageStandardName, String moduleTypeStandardName, String id, String moduleName, String description) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'createModule' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createModule' must not be null";
        assert (languageStandardName != null && languageStandardName.length() > 0) : "Parameter 'languageStandardName' of method 'createModule' must not be empty";
        assert (moduleTypeStandardName != null && moduleTypeStandardName.length() > 0) : "Parameter 'moduleTypeStandardName' of method 'createModule' must not be empty";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create module for language '" + languageStandardName + "'");
        Language language = languageProviderAccessor.getLanguage(languageStandardName);
        if (language == null) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.LANGUAGE_NOT_AVAILABLE, "Language '" + languageStandardName + "' not available.", new Object[0]);
            return result;
        }
        if (!new WorkspaceDependencyElementIdValidator(softwareSystem).isValid(null, id).isSuccess()) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_CREATE_MODULE, "Not a valid module id '" + moduleName + "' ", new Object[0]);
            return result;
        }
        if (!new ModuleNameValidator(softwareSystem).isValid(null, moduleName).isSuccess()) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_CREATE_MODULE, "Not a valid module name '" + moduleName + "' ", new Object[0]);
            return result;
        }
        LanguageProvider languageProvider = languageProviderAccessor.getLanguageProvider(language);
        assert (languageProvider != null) : "'languageProvider' of method 'createModule' must not be null";
        Module.IModuleType moduleType = languageProvider.getModuleType(moduleTypeStandardName);
        if (moduleType == null) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_CREATE_MODULE, "Unknown module type: " + moduleTypeStandardName, new Object[0]);
            String msg = "Module type '" + moduleTypeStandardName + "' is not supported.";
            LOGGER.error(msg);
            return result;
        }
        if (!softwareSystem.getUniqueExistingChild(Workspace.class).hasChildren(false, languageProvider.getModuleClass())) {
            languageProvider.aboutToCreateFirstModule(softwareSystem);
        }
        result.setOutcome((Object)languageProvider.createModule(softwareSystem, moduleType, id, moduleName, description));
        Module module = (Module)result.getOutcome();
        assert (module != null) : "'module' of method 'createModule' must not be null";
        return result;
    }

    static OperationResultWithOutcome<WorkspaceDependency> createWorkspaceDependency(LanguageProviderAccessor languageProviderAccessor, SoftwareSystem softwareSystem, String languageStandardName, String fromId, String toId, String toName, String type, WorkspaceDependency.AdditionalDependencyData dependencyData) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'createWorkspaceDependency' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createWorkspaceDependency' must not be null";
        assert (languageStandardName != null && languageStandardName.length() > 0) : "Parameter 'languageStandardName' of method 'createWorkspaceDependency' must not be empty";
        assert (fromId != null && fromId.length() > 0) : "Parameter 'fromId' of method 'createWorkspaceDependency' must not be empty";
        assert (toId != null && toId.length() > 0) : "Parameter 'toId' of method 'createWorkspaceDependency' must not be empty";
        assert (toName != null) : "Parameter 'toName' of method 'createWorkspaceDependency' must not be null";
        assert (type != null && type.length() > 0) : "Parameter 'type' of method 'createWorkspaceDependency' must not be empty";
        assert (dependencyData != null) : "Parameter 'dependencyData' of method 'createWorkspaceDependency' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome(String.format("Create workspace dependency from '%s' to '%s'", fromId, toId));
        Language language = languageProviderAccessor.getLanguage(languageStandardName);
        if (language == null) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.LANGUAGE_NOT_AVAILABLE, "Language '" + languageStandardName + "' not available.", new Object[0]);
            return result;
        }
        Module module = softwareSystem.getUniqueExistingChild(Workspace.class).getUniqueChild(new WorkspaceDependencyElementIdFilter(fromId), Module.class);
        if (module == null) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.MODULE_NOT_FOUND, "Module '" + fromId + "' not available as origin of dependency.", new Object[0]);
            return result;
        }
        LanguageProvider languageProvider = languageProviderAccessor.getLanguageProvider(language);
        assert (languageProvider != null) : "'languageProvider' of method 'createWorkspaceDependency' must not be null";
        WorkspaceDependency dependency = languageProvider.createWorkspaceDependency(softwareSystem, module, toId, toName, type, dependencyData);
        if (dependency != null) {
            result.setOutcome((Object)dependency);
        } else {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.UNABLE_TO_CREATE_WORKSPACE_DEPENDENCY, "Type '" + type + "' unknown.", new Object[0]);
        }
        return result;
    }

    public static void setNeedsReparse(SoftwareSystem softwareSystem, OperationResult result) {
        WorkspaceExtension workspaceExtension;
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'setNeedsReparse' must not be null";
        assert (result != null) : "Parameter 'result' of method 'setNeedsReparse' must not be null";
        if (!softwareSystem.needsReparse() && (workspaceExtension = softwareSystem.getExtension(WorkspaceExtension.class)) != null && workspaceExtension.isRefreshPossible()) {
            softwareSystem.setNeedsReparse(true);
            if (softwareSystem.isClearable()) {
                result.addInfo((OperationResult.IMessageCause)WorkspaceExtensionMessageCause.SYSTEM_NEEDS_REPARSE, "Workspace setup has changed.");
            }
        }
    }

    @Override
    public OperationResult editModule(IWorkerContext workerContext, Module module, String name, String description) {
        boolean moduleNameChanged;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editModule' must not be null";
        assert (module != null) : "Parameter 'module' of method 'editModule' must not be null";
        String currentModuleName = module.getName();
        assert (this.getModuleNameValidator().isValid(currentModuleName, name).isSuccess()) : "Module editing not possible: " + name;
        assert (!module.getName().equals(name) || !module.getDescription().equals(description)) : "Neither name nor decription changed for: " + String.valueOf(module);
        boolean bl = moduleNameChanged = !currentModuleName.equals(name);
        if (moduleNameChanged) {
            this.getSoftwareSystem().getExtension(IAnalyzerController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
            this.getSoftwareSystem().getExtension(ISnapshotController.class).cancelSaveSnapshot();
        }
        OperationResult result = this.editModuleWithoutNotifications(workerContext, module, name, description);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED), result);
        if (moduleNameChanged) {
            this.getSoftwareSystem().getExtension(ISnapshotController.class).saveSnapshot();
            this.getSoftwareSystem().getExtension(IAnalyzerController.class).runAutomatedAnalyzers(workerContext);
        }
        return result;
    }

    public OperationResult editModuleWithoutNotifications(IWorkerContext workerContext, Module module, String name, String description) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editModuleWithoutNotifications' must not be null";
        assert (module != null) : "Parameter 'module' of method 'editModuleWithoutNotifications' must not be null";
        String currentModuleName = module.getName();
        assert (this.getModuleNameValidator().isValid(currentModuleName, name).isSuccess()) : "Module editing not possible: " + name;
        assert (!module.getName().equals(name) || !module.getDescription().equals(description)) : "Neither name nor decription changed for: " + String.valueOf(module);
        boolean moduleNameChanged = !currentModuleName.equals(name);
        OperationResult result = new OperationResult("Edit module");
        EnumSet<Modification> modifications = EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED);
        module.setDescription(description);
        if (moduleNameChanged) {
            String oldFqName = module.getFullyQualifiedName();
            module.setName(name);
            String newFqName = module.getFullyQualifiedName();
            this.getSoftwareSystem().getExtension(VirtualModelExtension.class).mapResolutionPatterns(Collections.singletonMap(oldFqName, newFqName), modifications, true, true, null);
            this.refreshWorkspaceDependencies(modifications);
        }
        this.getSoftwareSystem().setNeedsSave(true);
        return result;
    }

    @Override
    public OperationResult createRootDirectoryPath(IWorkerContext workerContext, Module module, TFile file) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createRootDirectoryPath' must not be null";
        assert (module != null) : "Parameter 'module' of method 'createRootDirectoryPath' must not be null";
        assert (!(module instanceof IImportedModule)) : "Creation of rootDirectoryPath is not possible for imported modules";
        assert (file != null) : "Parameter 'file' of method 'createRootDirectoryPath' must not be null";
        OperationResult result = new OperationResult("Create Root Directory Path");
        LanguageProvider languageProvider = this.getAccessor().getLanguageProvider(module.getLanguage());
        assert (languageProvider != null) : "'languageProvider' of method 'createRootDirectoryPath' must not be null";
        if (languageProvider.setNeedsReparseOnWorkspaceModification(WorkspaceModification.ROOT_DIRECTORY_CREATED)) {
            WorkspaceExtension.setNeedsReparse(this.getSoftwareSystem(), result);
        }
        this.createRootDirectoryPathInternal(module, file, false);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED), result);
        return result;
    }

    @Override
    public OperationResult editRootDirectoryPath(IWorkerContext workerContext, RootDirectoryPath rootDirectoryPath, TFile newPath) {
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'editRootDirectoryPath' must not be null";
        assert (rootDirectoryPath.isValid()) : "Not valid: " + String.valueOf(rootDirectoryPath);
        Module module = rootDirectoryPath.getParent(Module.class, new Class[0]);
        assert (module != null) : "'module' of method 'editRootDirectoryPath' must not be null";
        assert (module.getChildren().contains(rootDirectoryPath)) : "Not found in module: " + String.valueOf(rootDirectoryPath);
        assert (rootDirectoryPath.getParent(SoftwareSystem.class, new Class[0]) == this.getSoftwareSystem()) : "Not found in system: " + String.valueOf(rootDirectoryPath);
        assert (this.getRootDirectoryPathValidator(rootDirectoryPath).isValid(rootDirectoryPath.getFile(), newPath).isSuccess()) : "Not a valid root: " + String.valueOf(newPath);
        this.getSoftwareSystem().getExtension(IAnalyzerController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
        this.getSoftwareSystem().getExtension(ISnapshotController.class).cancelSaveSnapshot();
        OperationResult result = new OperationResult("Edit Root Directory Path");
        rootDirectoryPath.setPath(newPath);
        RootDirectoryPath originalRootDirectoryPath = rootDirectoryPath.getOriginal();
        if (originalRootDirectoryPath != rootDirectoryPath) {
            originalRootDirectoryPath.setPath(newPath);
        }
        RootDirectoryPathValidator.validate(rootDirectoryPath);
        this.getSoftwareSystem().setNeedsSave(true);
        WorkspaceExtension.setNeedsReparse(this.getSoftwareSystem(), result);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED), result);
        this.getSoftwareSystem().getExtension(ISnapshotController.class).saveSnapshot();
        this.getSoftwareSystem().getExtension(IAnalyzerController.class).runAutomatedAnalyzers(workerContext);
        return result;
    }

    public RootDirectoryPath createRootDirectoryPathInternal(Module module, TFile file, boolean setNeedsReparse) {
        assert (module != null) : "Parameter 'module' of method 'createRootDirectoryPath' must not be null";
        ValidationResult result = this.getRootDirectoryPathValidator(module).isValid(null, file);
        assert (result.isSuccess()) : "Not a valid root: " + String.valueOf(file) + ", result: " + String.valueOf(result);
        RootDirectoryPath rootDirectoryPath = module.createRootDirectoryPath(this.getSoftwareSystem(), module, file);
        module.addChild(rootDirectoryPath);
        SoftwareSystem softwareSystem = module.getParent(SoftwareSystem.class, new Class[0]);
        assert (softwareSystem != null) : "'softwareSystem' of method 'createRootDirectoryPathInternal' must not be null";
        softwareSystem.setNeedsSave(true);
        if (setNeedsReparse) {
            softwareSystem.setNeedsReparse(true);
        }
        return rootDirectoryPath;
    }

    @Override
    public OperationResult createPattern(IWorkerContext workerContext, PatternType type, String pattern, Filter filter) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createPattern' must not be null";
        assert (type != null) : "Parameter 'type' of method 'createPattern' must not be null";
        assert (pattern != null) : "Parameter 'pattern' of method 'createPattern' must not be null";
        assert (this.getPatternValidator(filter).isValid(null, pattern).isSuccess()) : "Not valid: " + pattern;
        assert (filter != null) : "Parameter 'filter' of method 'createPattern' must not be null";
        OperationResult result = new OperationResult("Create " + type.getPresentationName() + " pattern");
        this.getSoftwareSystem().getExtension(IAnalyzerController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
        this.getSoftwareSystem().getExtension(ISnapshotController.class).cancelSaveSnapshot();
        switch (type) {
            case EXCLUDE: {
                WildcardPatternExclude wildcardPatternExclude = new WildcardPatternExclude(filter, pattern);
                filter.addChild(wildcardPatternExclude);
                break;
            }
            case INCLUDE: {
                WildcardPatternInclude wildcardPatternInclude = new WildcardPatternInclude(filter, pattern);
                filter.addChild(wildcardPatternInclude);
                List<WildcardPattern> patterns = filter.getChildren(WildcardPattern.class);
                int posOfFirstExcludePattern = -1;
                int i = 0;
                while (i < patterns.size()) {
                    if (patterns.get(i) instanceof WildcardPatternExclude) {
                        posOfFirstExcludePattern = i;
                        break;
                    }
                    ++i;
                }
                if (posOfFirstExcludePattern == -1) break;
                filter.moveChild(WildcardPattern.class, wildcardPatternInclude, posOfFirstExcludePattern);
                break;
            }
            default: {
                assert (false) : "Unhandled type: " + String.valueOf((Object)type);
                break;
            }
        }
        this.getSoftwareSystem().setNeedsSave(true);
        if (filter.invalidatesParserModel()) {
            WorkspaceExtension.setNeedsReparse(this.getSoftwareSystem(), result);
        }
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.WORKSPACE_MODIFIED, Modification.WORKSPACE_FILTER_MODIFIED), result);
        this.getSoftwareSystem().getExtension(ISnapshotController.class).saveSnapshot();
        this.getSoftwareSystem().getExtension(IAnalyzerController.class).runAutomatedAnalyzers(workerContext);
        return result;
    }

    @Override
    public OperationResult editPattern(IWorkerContext workerContext, Pattern pattern, String newPattern) {
        assert (pattern != null) : "Parameter 'pattern' of method 'editPattern' must not be null";
        assert (this.getPatternValidator(pattern.getParent(Filter.class, new Class[0])).isValid(pattern.getName(), newPattern).isSuccess()) : "Not valid: " + newPattern;
        OperationResult result = new OperationResult("Edit pattern");
        this.getSoftwareSystem().getExtension(ISnapshotController.class).cancelSaveSnapshot();
        this.getSoftwareSystem().getExtension(IAnalyzerController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
        pattern.setName(newPattern);
        this.getSoftwareSystem().setNeedsSave(true);
        Filter parentFilter = pattern.getParent(Filter.class, new Class[0]);
        assert (parentFilter != null) : "Parameter 'parentFilter' of method 'editPattern' must not be null";
        if (parentFilter.invalidatesParserModel()) {
            WorkspaceExtension.setNeedsReparse(this.getSoftwareSystem(), result);
        }
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.WORKSPACE_MODIFIED, Modification.WORKSPACE_FILTER_MODIFIED), result);
        this.getSoftwareSystem().getExtension(ISnapshotController.class).saveSnapshot();
        this.getSoftwareSystem().getExtension(IAnalyzerController.class).runAutomatedAnalyzers(workerContext);
        return result;
    }

    @Override
    public OperationResult moveModulesTo(IWorkerContext workerContext, List<Module> modules, int pos) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'moveModulesTo' must not be null";
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'moveModulesTo' must not be empty";
        OperationResult result = new OperationResult("Mode Modules To");
        Workspace workspace = modules.get(0).getParent(Workspace.class, new Class[0]);
        assert (workspace != null) : "'workspace' of method 'moveModulesTo' must not be null";
        assert (workspace == modules.get(0).getParent()) : "Structure changed";
        TreeMap<AssignmentInfo<NamedElement>, Module> assignmentInfoToMovedModules = new TreeMap<AssignmentInfo<NamedElement>, Module>(new AssignmentInfoComparator(Module.class));
        boolean setNeedsReparse = false;
        int numberOfMoved = 0;
        for (Module module : modules) {
            assert (module.getParent() == workspace) : "Workspace does not match: " + String.valueOf(module);
            Module previous = assignmentInfoToMovedModules.put(new AssignmentInfo<Workspace>(workspace, pos + numberOfMoved), module);
            assert (previous == null) : "'previous' of method 'moveModulesTo' must be null";
            ++numberOfMoved;
            LanguageProvider languageProvider = this.getAccessor().getLanguageProvider(module.getLanguage());
            assert (languageProvider != null) : "'languageProvider' of method 'createRootDirectoryPath' must not be null";
            if (!languageProvider.setNeedsReparseOnWorkspaceModification(WorkspaceModification.MODULE_ORDER_MODIFIED)) continue;
            setNeedsReparse = true;
        }
        for (Map.Entry entry : assignmentInfoToMovedModules.entrySet()) {
            Module nextModule = (Module)entry.getValue();
            workspace.moveChild(Module.class, nextModule, ((AssignmentInfo)entry.getKey()).getPos());
        }
        SoftwareSystem softwareSystem = workspace.getParent(SoftwareSystem.class, new Class[0]);
        assert (softwareSystem != null) : "'softwareSystem' of method 'moveModulesTo' must not be null";
        softwareSystem.setNeedsSave(true);
        if (setNeedsReparse) {
            WorkspaceExtension.setNeedsReparse(this.getSoftwareSystem(), result);
        }
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED), result);
        return result;
    }

    @Override
    public OperationResult moveRootDirectoryPathsTo(IWorkerContext workerContext, List<RootDirectoryPath> rootDirectoryPaths, Module module, int pos) {
        assert (rootDirectoryPaths != null && !rootDirectoryPaths.isEmpty()) : "Parameter 'rootDirectoryPaths' of method 'moveTo' must not be empty";
        assert (module != null) : "Parameter 'module' of method 'moveRootDirectoryPathsTo' must not be null";
        OperationResult result = new OperationResult("Move Root Directory Paths To");
        TreeMap<AssignmentInfo<NamedElement>, RootDirectoryPath> assignmentInfoToRootDirectoryPath = new TreeMap<AssignmentInfo<NamedElement>, RootDirectoryPath>(new AssignmentInfoComparator(RootDirectoryPath.class));
        int numberOfMoved = 0;
        for (RootDirectoryPath rootDirectoryPath : rootDirectoryPaths) {
            RootDirectoryPath previous = assignmentInfoToRootDirectoryPath.put(new AssignmentInfo<Module>(module, pos + numberOfMoved), rootDirectoryPath);
            assert (previous == null) : "'previous' of method 'moveRootDirectoryPathsTo' must be null";
            ++numberOfMoved;
        }
        if (!assignmentInfoToRootDirectoryPath.isEmpty()) {
            for (Map.Entry entry : assignmentInfoToRootDirectoryPath.entrySet()) {
                Module nextModule = (Module)((AssignmentInfo)entry.getKey()).getNamedElement();
                nextModule.moveChild(RootDirectoryPath.class, (NamedElement)entry.getValue(), ((AssignmentInfo)entry.getKey()).getPos());
            }
            this.getSoftwareSystem().setNeedsSave(true);
            LanguageProvider languageProvider = this.getAccessor().getLanguageProvider(module.getLanguage());
            assert (languageProvider != null) : "'languageProvider' of method 'createRootDirectoryPath' must not be null";
            if (languageProvider.setNeedsReparseOnWorkspaceModification(WorkspaceModification.ROOT_DIRECTORY_ORDER_MODIFIED)) {
                WorkspaceExtension.setNeedsReparse(this.getSoftwareSystem(), result);
            }
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED), result);
        }
        return result;
    }

    @Override
    public OperationResult movePatternsTo(IWorkerContext workerContext, List<Pattern> patterns, Filter targetFilter, int targetPos) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'movePatternsTo' must not be null";
        assert (patterns != null && !patterns.isEmpty()) : "Parameter 'patterns' of method 'movePatternsTo' must not be empty";
        assert (targetFilter != null) : "Parameter 'targetFilter' of method 'movePatternsTo' must not be null";
        assert (targetPos >= -1) : "Invalid target pos: " + targetPos;
        OperationResult result = new OperationResult("Move Patterns To");
        Workspace workspace = this.getSoftwareSystem().getUniqueExistingChild(Workspace.class);
        assert (workspace != null) : "'workspace' of method 'movePatternsTo' must not be null";
        boolean invalidatesParserModel = false;
        for (Pattern nextPattern : patterns) {
            Filter nextFilter = nextPattern.getParent(Filter.class, new Class[0]);
            assert (nextFilter != null) : "'nextFilter' of method 'movePatternsTo' must not be null";
            assert (nextFilter.hasAsParent(workspace, false)) : "Different worksopace";
            if (nextFilter == targetFilter || !nextFilter.invalidatesParserModel() && !targetFilter.invalidatesParserModel()) continue;
            invalidatesParserModel = true;
        }
        if (!invalidatesParserModel) {
            this.getSoftwareSystem().getExtension(IAnalyzerController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
        }
        int numberOfIncludes = targetFilter.getChildren(WildcardPatternInclude.class).size();
        int numberOfExcludes = targetFilter.getChildren(WildcardPatternExclude.class).size();
        int offsetInIncludeBlock = 0;
        if (targetPos != -1 && targetPos < numberOfIncludes) {
            offsetInIncludeBlock = targetPos;
        }
        int offsetInExcludeBlock = 0;
        if (targetPos != -1 && targetPos > numberOfIncludes && targetPos <= numberOfIncludes + numberOfExcludes) {
            offsetInExcludeBlock = targetPos - numberOfIncludes;
        }
        int addedIncludes = 0;
        int addedExcludes = 0;
        for (Pattern nextPattern : patterns) {
            if (nextPattern instanceof WildcardPatternInclude) {
                targetFilter.moveChild(Pattern.class, nextPattern, offsetInIncludeBlock + addedIncludes);
                ++addedIncludes;
                continue;
            }
            assert (nextPattern instanceof WildcardPatternExclude) : "Unexpected class: " + nextPattern.getClass().getName();
            targetFilter.moveChild(Pattern.class, nextPattern, offsetInExcludeBlock + numberOfIncludes + addedIncludes + addedExcludes);
            ++addedExcludes;
        }
        if (invalidatesParserModel) {
            WorkspaceExtension.setNeedsReparse(this.getSoftwareSystem(), result);
        }
        this.getSoftwareSystem().setNeedsSave(true);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED), result);
        if (!invalidatesParserModel) {
            this.getSoftwareSystem().getExtension(IAnalyzerController.class).runAutomatedAnalyzers(workerContext);
        }
        return result;
    }

    void availableLanguagesModifiedInUndoRedo(Set<Language> added, Set<Language> removed, OperationResult result) {
        LanguageProvider nextLanguageProvider;
        assert (added != null) : "Parameter 'added' of method 'availableLanguagesModifiedInUndoRedo' must not be null";
        assert (removed != null) : "Parameter 'removed' of method 'availableLanguagesModifiedInUndoRedo' must not be null";
        assert (!added.isEmpty() || !removed.isEmpty()) : "No modified languages";
        assert (result != null) : "Parameter 'result' of method 'availableLanguagesModifiedInUndoRedo' must not be null";
        AnalyzerExtension analyzerExtension = this.getSoftwareSystem().getExtension(AnalyzerExtension.class);
        for (Language nextLanguage : removed) {
            nextLanguageProvider = this.getAccessor().getLanguageProvider(nextLanguage);
            assert (nextLanguageProvider != null) : "'nextLanguageProvider' of method 'availableLanguagesModified' must not be null";
            analyzerExtension.languageRemoved(nextLanguageProvider);
        }
        for (Language nextLanguage : added) {
            nextLanguageProvider = this.getAccessor().getLanguageProvider(nextLanguage);
            assert (nextLanguageProvider != null) : "'nextLanguageProvider' of method 'availableLanguagesModified' must not be null";
            analyzerExtension.languageAdded(nextLanguageProvider, result);
        }
    }

    public ModifiableModel switchToFactsModel() {
        ModifiableModel modifiableModel;
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        if (softwareSystem.isClearable() && (modifiableModel = softwareSystem.getCurrentModel(ModifiableModel.class)) != null) {
            for (Module nextModule : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                for (RootDirectoryPath nextRootDirectoryPath : nextModule.getChildren(RootDirectoryPath.class)) {
                    if (nextRootDirectoryPath.getOriginal() == nextRootDirectoryPath) continue;
                    modifiableModel.setNeedsApplication();
                    softwareSystem.getExtension(VirtualModelExtension.class).switchToModel(softwareSystem.getParserModel(), null);
                    return modifiableModel;
                }
            }
        }
        return null;
    }

    public void finishSwitchToFactsModel(ModifiableModel modifiableModel, EnumSet<Modification> modifications) {
        assert (modifiableModel != null) : "Parameter 'modifiableModel' of method 'finishSwitchToFactsModel' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'finishSwitchToFactsModel' must not be null";
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        assert (softwareSystem.getParserModel() == softwareSystem.getCurrentModel()) : "Current model not the facts model";
        softwareSystem.setModel(modifiableModel);
        modifications.add(Modification.VIRTUAL_MODEL_CHANGED);
    }

    public OperationResult delete(IWorkerContext workerContext, List<? extends Element> workspaceElements, boolean isNestedOperation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'delete' must not be null";
        assert (workspaceElements != null && !workspaceElements.isEmpty()) : "Parameter 'workspaceElements' of method 'delete' must not be empty";
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        softwareSystem.getExtension(ISnapshotController.class).cancelSaveSnapshot();
        softwareSystem.getExtension(IAnalyzerController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
        OperationResult result = new OperationResult("Delete workspace elements");
        Set<NamedElement> namedElementsToBeDeleted = this.getNamedElements(workspaceElements);
        Set<IManualWorkspaceDependency> manualWorkspaceDependenciesToBeDeleted = this.getManualWorkspaceDependencies(workspaceElements, namedElementsToBeDeleted);
        Set<NamedElement> namedElementsToBeDeletedChildrenRemoved = NamedElementUtility.normalize(namedElementsToBeDeleted, true, new Class[0]);
        THashSet modulesToBeDeleted = new THashSet();
        THashMap moduleToAboutToBeDeletedElements = new THashMap();
        boolean refreshWorkspaceDependencies = false;
        boolean needsReparse = false;
        if (!manualWorkspaceDependenciesToBeDeleted.isEmpty()) {
            refreshWorkspaceDependencies = true;
            for (IManualWorkspaceDependency next : manualWorkspaceDependenciesToBeDeleted) {
                LanguageProvider nextLanguageProvider = this.getAccessor().getLanguageProvider(next.getLanguage());
                assert (nextLanguageProvider != null) : "'nextLanguageProvider' of method 'setNeedsReparse' must not be null";
                if (!nextLanguageProvider.setNeedsReparseOnWorkspaceModification(WorkspaceModification.MODULE_DEPENDENCY_DELETED)) continue;
                needsReparse = true;
                break;
            }
        }
        ArrayList<Pattern> deletedPatterns = new ArrayList<Pattern>();
        for (NamedElement nextToBeDeleted : namedElementsToBeDeletedChildrenRemoved) {
            if (nextToBeDeleted instanceof Pattern) {
                deletedPatterns.add((Pattern)nextToBeDeleted);
                Pattern nextPattern = (Pattern)nextToBeDeleted;
                Filter nextFilter = nextPattern.getParent(Filter.class, ParentMode.ONLY_DIRECT_PARENT);
                assert (nextFilter != null) : "'nextFilter' of method 'delete' must not be null";
                if (!nextFilter.invalidatesParserModel()) continue;
                needsReparse = true;
                continue;
            }
            if (nextToBeDeleted instanceof Module) {
                modulesToBeDeleted.add((Module)nextToBeDeleted);
                if (this.isRefreshPossible((Module)nextToBeDeleted)) {
                    needsReparse = true;
                }
                if (((Module)nextToBeDeleted).hasWorkspaceDependencies()) {
                    refreshWorkspaceDependencies = true;
                }
            } else {
                needsReparse = true;
            }
            Module nextModule = nextToBeDeleted.getParent(Module.class, ParentMode.SELF_OR_FIRST_PARENT);
            assert (nextModule != null) : "'nextModule' of method 'delete' must not be null for: " + nextToBeDeleted.getClass().getName();
            ArrayList<NamedElement> aboutToBeDeletedElements = (ArrayList<NamedElement>)moduleToAboutToBeDeletedElements.get(nextModule);
            if (aboutToBeDeletedElements == null) {
                aboutToBeDeletedElements = new ArrayList<NamedElement>();
                moduleToAboutToBeDeletedElements.put(nextModule, aboutToBeDeletedElements);
            }
            aboutToBeDeletedElements.add(nextToBeDeleted);
        }
        ModifiableModel modifiableModel = this.switchToFactsModel();
        deletedPatterns.forEach(p -> p.remove());
        WorkspaceExtension.removeWorkspaceDependencies(this.getSoftwareSystem(), manualWorkspaceDependenciesToBeDeleted, (Set<Module>)modulesToBeDeleted);
        for (UnresolvedWorkspaceDependencyElement nextUnresolved : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(UnresolvedWorkspaceDependencyElement.class)) {
            assert (nextUnresolved.getIncomingEdges().size() > 0) : "UnresolvedWorkspaceDependencyElement with no incoming workspace dependencies must have been removed.";
        }
        VirtualModel virtualModel = softwareSystem.getCurrentModel();
        THashSet languageProvidersOfDeletedElements = new THashSet();
        for (Map.Entry nextEntry : moduleToAboutToBeDeletedElements.entrySet()) {
            Module nextModule = (Module)nextEntry.getKey();
            LanguageProvider nextLanguageProvider = this.getAccessor().getLanguageProvider(nextModule.getType().getLanguage());
            assert (nextLanguageProvider != null) : "Parameter 'nextLanguageProvider' of method 'delete' must not be null";
            languageProvidersOfDeletedElements.add(nextLanguageProvider);
            List toBeDeleted = (List)nextEntry.getValue();
            nextLanguageProvider.aboutToDeleteWorkspaceElements(workerContext, softwareSystem, nextModule, Collections.unmodifiableList(toBeDeleted));
            for (NamedElement nextToBeDeleted : toBeDeleted) {
                nextToBeDeleted.getOriginal().remove();
                virtualModel.elementRemoved(nextToBeDeleted);
            }
        }
        EnumSet<Modification> modification = EnumSet.of(Modification.WORKSPACE_MODIFIED);
        if (refreshWorkspaceDependencies) {
            this.refreshWorkspaceDependencies(modification);
        }
        if (!deletedPatterns.isEmpty()) {
            modification.add(Modification.WORKSPACE_FILTER_MODIFIED);
        }
        softwareSystem.setNeedsSave(true);
        AnalyzerExtension analyzerExtension = softwareSystem.getExtension(AnalyzerExtension.class);
        for (LanguageProvider nextLanguageProvider : languageProvidersOfDeletedElements) {
            if (softwareSystem.getUniqueExistingChild(Workspace.class).hasChildren(false, nextLanguageProvider.getModuleClass())) continue;
            nextLanguageProvider.lastModuleDeleted(softwareSystem);
            analyzerExtension.languageRemoved(nextLanguageProvider);
            modification.add(Modification.AVAILABLE_LANGUAGES_MODIFIED);
        }
        if (needsReparse && !isNestedOperation) {
            WorkspaceExtension.setNeedsReparse(softwareSystem, result);
        } else {
            softwareSystem.setNeedsReparse(needsReparse && this.isRefreshPossible());
        }
        softwareSystem.setIsClearable(this.isClearable());
        if (modifiableModel != null) {
            this.finishSwitchToFactsModel(modifiableModel, modification);
        }
        if (!isNestedOperation) {
            this.m_finishModelProcessor.finishModification(workerContext, softwareSystem, modification, result);
            analyzerExtension.runAutomatedAnalyzers(workerContext);
        }
        return result;
    }

    @Override
    public OperationResult delete(IWorkerContext workerContext, List<? extends Element> workspaceElements) {
        return this.delete(workerContext, workspaceElements, false);
    }

    @Override
    public void cleared(IWorkerContext workerContext, SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToBeDisptached, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'cleared' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'cleared' must not be null";
        assert (eventsToBeDisptached != null) : "Parameter 'eventsToBeDisptached' of method 'cleared' must not be null";
        this.refreshWorkspaceDependencies(null);
    }

    @Override
    public OperationResult createManualDependency(IWorkerContext workerContext, IWorkspaceDependencyElement from, IWorkspaceDependencyElement to) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createManualDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'createDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'createDependency' must not be null";
        assert (from != to) : "Same instance";
        OperationResult result = new OperationResult("Create workspace dependency");
        Language language = ((NamedElement)from.getUnderlyingObject()).getLanguage();
        assert (language != null) : "Parameter 'language' of method 'createDependency' must not be null";
        LanguageProvider languageProvider = this.getAccessor().getLanguageProvider(language);
        assert (languageProvider != null) : "'languageProvider' of method 'createManualDependency' must not be null";
        OperationResult.IMessageCause notPossible = languageProvider.manualWorkspaceDependencyCreationSupported(from, to);
        if (notPossible == null) {
            AnalyzerExtension analyzerExtension = this.getSoftwareSystem().getExtension(AnalyzerExtension.class);
            Set<IAnalyzerId> toRestart = analyzerExtension.cancelAndResetAnalyzers(Collections.singleton(CoreAnalyzerId.MODULE_CYCLES_SYSTEM));
            EnumSet<Modification> modifications = EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED);
            WorkspaceDependency created = languageProvider.createManualWorkspaceDependency(this.getSoftwareSystem(), from, to);
            from.addOutgoingWorkspaceDependency(created);
            WorkspaceCycleAnalyzerAdapter analyzerAdapter = this.refreshWorkspaceDependencies(modifications);
            assert (analyzerAdapter != null) : "Parameter 'analyzerAdapter' of method 'createManualDependency' must not be null";
            Set<IWorkspaceDependencyElement> cyclic = analyzerAdapter.getCyclicNodes();
            if (!cyclic.isEmpty()) {
                result.addError((OperationResult.IMessageCause)LanguageProviderMessageCause.WORKSPACE_DEPENDENCY_CAUSES_CYCLE);
                from.removeOutgoingWorkspaceDependency(created);
                this.refreshWorkspaceDependencies(modifications);
            }
            this.getSoftwareSystem().setNeedsSave(true);
            if (languageProvider.setNeedsReparseOnWorkspaceModification(WorkspaceModification.MODULE_DEPENDENCY_CREATED)) {
                WorkspaceExtension.setNeedsReparse(this.getSoftwareSystem(), result);
            }
            analyzerExtension.runAnalyzers(toRestart);
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), modifications, result);
        } else {
            result.addError(notPossible);
        }
        return result;
    }

    @Override
    public OperationResult addMissingWorkspaceDependencies(IWorkerContext workerContext, List<WorkspaceDependencyNotDefined> issues) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'addMissingWorkspaceDependency' must not be null";
        assert (issues != null && !issues.isEmpty()) : "Parameter 'issues' of method 'addMissingWorkspaceDependency' must not be empty";
        OperationResult result = new OperationResult("Create missing workspace dependencies");
        ArrayList<StrictPair> fromToList = new ArrayList<StrictPair>();
        for (WorkspaceDependencyNotDefined nextIssue : issues) {
            assert (nextIssue.getAffectedElement() instanceof IWorkspaceDependencyElement) : "Unexpected class: " + nextIssue.getAffectedElement().getClass().getCanonicalName();
            IWorkspaceDependencyElement from = (IWorkspaceDependencyElement)((Object)nextIssue.getAffectedElement());
            Workspace workspace = this.getSoftwareSystem().getUniqueExistingChild(Workspace.class);
            IWorkspaceDependencyElement to = workspace.getUniqueChild(new FullyQualifiedNameFilter(nextIssue.getNotDefinedToFqName()), IWorkspaceDependencyElement.class);
            assert (to instanceof Module) : "Unexpected class: " + to.getClass().getCanonicalName();
            Language language = from.getLanguage();
            assert (language != null) : "Parameter 'language' of method 'createDependency' must not be null";
            LanguageProvider languageProvider = this.getAccessor().getLanguageProvider(language);
            assert (languageProvider != null) : "'languageProvider' of method 'createManualDependency' must not be null";
            OperationResult.IMessageCause notPossible = languageProvider.manualWorkspaceDependencyCreationSupported(from, to);
            if (notPossible == null) {
                fromToList.add(new StrictPair((Object)from, (Object)to));
                continue;
            }
            result.addError(notPossible, "Cannot create workspace dependency " + from.getName() + " -> " + to.getName(), new Object[0]);
        }
        if (fromToList.isEmpty()) {
            return result;
        }
        AnalyzerExtension analyzerExtension = this.getSoftwareSystem().getExtension(AnalyzerExtension.class);
        Set<IAnalyzerId> toRestart = analyzerExtension.cancelAndResetAnalyzers(Collections.singleton(CoreAnalyzerId.MODULE_CYCLES_SYSTEM));
        EnumSet<Modification> modifications = EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED);
        for (StrictPair next : fromToList) {
            IWorkspaceDependencyElement from = (IWorkspaceDependencyElement)next.getFirst();
            IWorkspaceDependencyElement to = (IWorkspaceDependencyElement)next.getSecond();
            Language language = from.getLanguage();
            LanguageProvider languageProvider = this.getAccessor().getLanguageProvider(language);
            WorkspaceDependency created = languageProvider.createManualWorkspaceDependency(this.getSoftwareSystem(), from, to);
            from.addOutgoingWorkspaceDependency(created);
            WorkspaceCycleAnalyzerAdapter analyzerAdapter = this.refreshWorkspaceDependencies(modifications);
            assert (analyzerAdapter != null) : "Parameter 'analyzerAdapter' of method 'createManualDependency' must not be null";
            Set<IWorkspaceDependencyElement> cyclic = analyzerAdapter.getCyclicNodes();
            if (!cyclic.isEmpty()) {
                result.addError((OperationResult.IMessageCause)LanguageProviderMessageCause.WORKSPACE_DEPENDENCY_CAUSES_CYCLE);
                from.removeOutgoingWorkspaceDependency(created);
                this.refreshWorkspaceDependencies(modifications);
                continue;
            }
            this.getSoftwareSystem().setNeedsSave(true);
            if (!languageProvider.setNeedsReparseOnWorkspaceModification(WorkspaceModification.MODULE_DEPENDENCY_CREATED)) continue;
            WorkspaceExtension.setNeedsReparse(this.getSoftwareSystem(), result);
        }
        analyzerExtension.runAnalyzers(toRestart);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), modifications, result);
        return result;
    }

    @Override
    public OperationResult removeUnimplementedWorkspaceDependencies(IWorkerContext workerContext, List<WorkspaceDependencyNotImplemented> issues) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'removeUnimplementedWorkspaceDependencies' must not be null";
        assert (issues != null && issues.size() > 0) : "Parameter 'issues' of method 'removeUnimplementedWorkspaceDependencies' must not be empty";
        OperationResult result = new OperationResult("Remove unimplemented workspace dependencies");
        THashSet workspaceDependenciesToBeDeleted = new THashSet();
        for (WorkspaceDependencyNotImplemented next : issues) {
            Dependency dependency = next.getAffectedElement();
            if (dependency instanceof IManualWorkspaceDependency) {
                workspaceDependenciesToBeDeleted.add((IManualWorkspaceDependency)((Object)dependency));
                continue;
            }
            IWorkspaceDependencyElement from = (IWorkspaceDependencyElement)dependency.getFrom();
            IWorkspaceDependencyElement to = (IWorkspaceDependencyElement)dependency.getTo();
            result.addError((OperationResult.IMessageCause)LanguageProviderMessageCause.NO_MANUAL_WORKSPACE_DEPENDENCY, "Dependency " + from.getName() + " -> " + to.getName() + " cannot be removed.", new Object[0]);
        }
        if (workspaceDependenciesToBeDeleted.isEmpty()) {
            return result;
        }
        AnalyzerExtension analyzerExtension = this.getSoftwareSystem().getExtension(AnalyzerExtension.class);
        Set<IAnalyzerId> toRestart = analyzerExtension.cancelAndResetAnalyzers(Collections.singleton(CoreAnalyzerId.MODULE_CYCLES_SYSTEM));
        EnumSet<Modification> modifications = EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED);
        WorkspaceExtension.removeWorkspaceDependencies(this.getSoftwareSystem(), (Set<IManualWorkspaceDependency>)workspaceDependenciesToBeDeleted, Collections.emptySet());
        this.getSoftwareSystem().setNeedsSave(true);
        analyzerExtension.runAnalyzers(toRestart);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), modifications, result);
        return result;
    }
}

