/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.IssueFilter;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependencyElementIdFilter;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettingsSignature;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettingsSignatureWithTimestamp;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SoftwareSystemDataTransferExtension
extends Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoftwareSystemDataTransferExtension.class);
    private final LanguageProviderAccessor m_lpAccessor;

    public SoftwareSystemDataTransferExtension(LanguageProviderAccessor languageProviderAccessor) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'WorkspaceDataTransfer' must not be null";
        this.m_lpAccessor = languageProviderAccessor;
    }

    private void transferFilters(Filter fromSource, Filter fromTarget, EnumSet<Modification> modifications) {
        assert (fromSource != null) : "Parameter 'fromSource' of method 'transferFilters' must not be null";
        assert (fromTarget != null) : "Parameter 'fromTarget' of method 'transferFilters' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'transferFilters' must not be null";
        if (!Filter.areEqual(fromTarget, fromSource)) {
            modifications.add(Modification.WORKSPACE_MODIFIED);
            modifications.add(Modification.WORKSPACE_FILTER_MODIFIED);
        }
        fromTarget.removeChildren(new Class[0]);
        for (NamedElement nextFilterChild : new ArrayList<NamedElement>(fromSource.getChildren())) {
            nextFilterChild.changeParent(fromTarget, true);
        }
    }

    private void reoderModules(SoftwareSystem source, SoftwareSystem target) {
        Workspace sourceWorkspace = source.getUniqueExistingChild(Workspace.class);
        Workspace targetWorkspace = target.getUniqueExistingChild(Workspace.class);
        List<Module> sourceModules = SoftwareSystemDataTransferExtension.getPhysicalModules(source);
        List<Module> targetModules = SoftwareSystemDataTransferExtension.getPhysicalModules(target);
        int i = 0;
        while (i < sourceModules.size()) {
            Module sourceModule = sourceModules.get(i);
            Module targetModule = targetModules.get(i);
            if (!sourceModule.getName().equals(targetModule.getName())) {
                int index = sourceWorkspace.getIndexOf(Module.class, sourceModule);
                targetModule = targetWorkspace.getUniqueChild(new WorkspaceDependencyElementIdFilter(sourceModule.getId()), Module.class);
                targetWorkspace.moveChild(Module.class, targetModule, index);
            }
            ++i;
        }
    }

    private static boolean checkIfWorkspaceFilterMatch(SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        WorkspaceFilter targetWorkspaceFilter;
        assert (source != null) : "Parameter 'source' of method 'checkIfWorkspaceFilterMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfWorkspaceFilterMatch' must not be null";
        WorkspaceFilter sourceWorkspaceFilter = source.getUniqueExistingChild(Workspace.class).getWorkspaceFilter();
        if (Filter.areEqual(sourceWorkspaceFilter, targetWorkspaceFilter = target.getUniqueExistingChild(Workspace.class).getWorkspaceFilter())) {
            return true;
        }
        if (result != null) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.WORKSPACE_FILTER_CHANGED);
        }
        return false;
    }

    private static boolean checkIfEssentialWorkspaceInfoMatches(LanguageProviderAccessor languageProviderAccessor, SoftwareSystem source, SoftwareSystem target, boolean checkWorkspaceFilter, OperationResult result) {
        if (checkWorkspaceFilter && !SoftwareSystemDataTransferExtension.checkIfWorkspaceFilterMatch(source, target, result)) {
            return false;
        }
        if (!SoftwareSystemDataTransferExtension.checkIfModulesMatch(source, target, result)) {
            return false;
        }
        if (!SoftwareSystemDataTransferExtension.checkIfRootsMatch(source, target, result)) {
            return false;
        }
        if (!SoftwareSystemDataTransferExtension.checkIfExternalsMatch(source, target, result)) {
            return false;
        }
        return SoftwareSystemDataTransferExtension.checkIfWorkspaceDependenciesMatch(languageProviderAccessor, source, target, result);
    }

    private static boolean checkIfModulesMatch(SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        assert (source != null) : "Parameter 'source' of method 'checkIfModulesMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfModulesMatch' must not be null";
        List<Module> sourceModules = SoftwareSystemDataTransferExtension.getPhysicalModules(source);
        List<Module> targetModules = SoftwareSystemDataTransferExtension.getPhysicalModules(target);
        if (sourceModules.size() != targetModules.size()) {
            if (result != null) {
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.NUMBER_OF_MODULES_CHANGED);
            }
            return false;
        }
        for (Module targetModule : targetModules) {
            Module sourceModule = source.getUniqueExistingChild(Workspace.class).getUniqueChild(new WorkspaceDependencyElementIdFilter(targetModule.getId()), Module.class);
            if (sourceModule != null) continue;
            if (result != null) {
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.MODULE_NOT_FOUND, "Module '" + targetModule.getName() + "' not found.", new Object[0]);
            }
            return false;
        }
        return true;
    }

    static boolean checkIfModuleOrderMatch(LanguageProviderAccessor languageProviderAccessor, SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'checkIfModuleOrderMatch' must not be null";
        assert (source != null) : "Parameter 'source' of method 'checkIfModulesMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfModulesMatch' must not be null";
        List<Module> sourceModules = SoftwareSystemDataTransferExtension.getPhysicalModules(source);
        List<Module> targetModules = SoftwareSystemDataTransferExtension.getPhysicalModules(target);
        int i = 0;
        while (i < targetModules.size()) {
            Module targetModule = targetModules.get(i);
            Module sourceModule = sourceModules.get(i);
            LanguageProvider lp = languageProviderAccessor.getLanguageProvider(targetModule.getLanguage());
            if (lp.moduleOrderIsRelevant() && !targetModule.getId().equals(sourceModule.getId())) {
                if (result != null) {
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.MODULE_ORDER_CHANGED, "Position of module '" + sourceModule.getName() + "' changed.", new Object[0]);
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean checkIfModuleSettingsMatch(SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        assert (source != null) : "Parameter 'source' of method 'checkIfModuleSettingsMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfModuleSettingsMatch' must not be null";
        assert (source != target) : "Same systems";
        int differences = 0;
        for (Module nextTargetModule : SoftwareSystemDataTransferExtension.getPhysicalModules(target)) {
            Module sourceModule = source.getUniqueExistingChild(Workspace.class).getUniqueChild(new WorkspaceDependencyElementIdFilter(nextTargetModule.getId()), Module.class);
            if (sourceModule != null && nextTargetModule.getClass().equals(sourceModule.getClass())) {
                ModuleSettings nextTargetSettings = nextTargetModule.getUniqueChild(ModuleSettings.class);
                ModuleSettings nextSourceSettings = sourceModule.getUniqueChild(ModuleSettings.class);
                if (nextTargetSettings == null || nextSourceSettings == null) continue;
                ModuleSettingsSignature targetSignature = nextTargetSettings.getUniqueChild(ModuleSettingsSignature.class);
                ModuleSettingsSignature sourceSignature = nextSourceSettings.getUniqueChild(ModuleSettingsSignature.class);
                if (targetSignature == null || sourceSignature == null || targetSignature.getName().equals(sourceSignature.getName())) continue;
                if (sourceSignature instanceof ModuleSettingsSignatureWithTimestamp && targetSignature instanceof ModuleSettingsSignatureWithTimestamp) {
                    String sourcePlainSignature = ((ModuleSettingsSignatureWithTimestamp)sourceSignature).getPlainString();
                    String targetPlainSignature = ((ModuleSettingsSignatureWithTimestamp)targetSignature).getPlainString();
                    LOGGER.info("Module signature changed for module '{}' from '{}' (source) to '{}' (target)", new Object[]{nextTargetModule.getName(), sourcePlainSignature, targetPlainSignature});
                } else {
                    LOGGER.info("Module signature changed for module '{}'", (Object)nextTargetModule.getName());
                }
                ++differences;
            }
            if (result != null) {
                result.addWarning((OperationResult.IMessageCause)SoftwareSystemMessageCause.MODULE_SETTINGS_CHANGED, "Settings of module '" + nextTargetModule.getName() + "' changed.", new Object[0]);
                continue;
            }
            return false;
        }
        return differences == 0;
    }

    static boolean checkIfExternalsMatch(SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        assert (source != null) : "Parameter 'source' of method 'checkIfExternalsMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfExternalsMatch' must not be null";
        assert (source != target) : "Same systems";
        List<External> sourceExternals = source.getUniqueExistingChild(Workspace.class).getChildren(External.class);
        List<External> targetExternals = target.getUniqueExistingChild(Workspace.class).getChildren(External.class);
        for (External nextTagetExternal : targetExternals) {
            External matchingExternal = null;
            for (External nextSourceExternal : sourceExternals) {
                if (!nextSourceExternal.getClass().equals(nextTagetExternal.getClass())) continue;
                matchingExternal = nextSourceExternal;
                break;
            }
            if (matchingExternal != null) continue;
            if (result != null) {
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.EXTERNAL_NOT_FOUND, "External '" + String.valueOf(nextTagetExternal) + "' not found.", new Object[0]);
                continue;
            }
            return false;
        }
        return true;
    }

    private static List<Module> getPhysicalModules(SoftwareSystem system) {
        return system.getUniqueExistingChild(Workspace.class).getChildren(Module.class).stream().filter(m -> !m.isAutomatic()).collect(Collectors.toList());
    }

    static boolean checkIfWorkspaceDependenciesMatch(LanguageProviderAccessor lpAccessor, SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        assert (lpAccessor != null) : "Parameter 'lpAccessor' of method 'checkIfWorkspaceDependenciesMatch' must not be null";
        assert (source != null) : "Parameter 'source' of method 'checkIfWorkspaceDependenciesMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfWorkspaceDependenciesMatch' must not be null";
        assert (source != target) : "Same systems";
        List<Module> sourceModules = SoftwareSystemDataTransferExtension.getPhysicalModules(source);
        List<Module> targetModules = SoftwareSystemDataTransferExtension.getPhysicalModules(target);
        assert (sourceModules.size() == targetModules.size()) : "checkIfModulesMatch() must have been called previously.";
        for (Module nextTargetModule : targetModules) {
            LanguageProvider lp = lpAccessor.getLanguageProvider(nextTargetModule.getLanguage());
            if (!lp.checkWorkspaceDependenciesFromSnapshot()) continue;
            String moduleId = nextTargetModule.getId();
            Module sourceModule = source.getUniqueExistingChild(Workspace.class).getUniqueChild(new WorkspaceDependencyElementIdFilter(moduleId), Module.class);
            assert (sourceModule != null) : "checkIfModulesMatch() must have been called previously.";
            ArrayList<WorkspaceDependency> targetDependencies = new ArrayList<WorkspaceDependency>(nextTargetModule.getOutgoingWorkspaceDependencies());
            SoftwareSystemDataTransferExtension.removeInternalWorkspaceDependenciesFromList(targetDependencies);
            ArrayList<WorkspaceDependency> sourceDependencies = new ArrayList<WorkspaceDependency>(sourceModule.getOutgoingWorkspaceDependencies());
            SoftwareSystemDataTransferExtension.removeInternalWorkspaceDependenciesFromList(sourceDependencies);
            if (sourceDependencies.size() != targetDependencies.size()) {
                if (result != null) {
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.WORKSPACE_DEPENDENCIES_DO_NOT_MATCH, "Number of workspace dependencies changed.", new Object[0]);
                }
                return false;
            }
            for (WorkspaceDependency dep : targetDependencies) {
                LanguageProvider languageProvider = lpAccessor.getLanguageProvider(dep.getFrom().getLanguage());
                IWorkspaceDependencyElement endpoint = languageProvider.findEndpointOfExistingDependency(source.getUniqueExistingChild(Workspace.class), sourceModule, dep.getType(), dep.getToId(), dep.getToName(), dep.getAdditionalDependencyData());
                if (endpoint != null) continue;
                if (result != null) {
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.WORKSPACE_DEPENDENCIES_DO_NOT_MATCH, "Workspace dependency '" + dep.toString() + "' not found.", new Object[0]);
                }
                return false;
            }
        }
        return true;
    }

    private static void removeInternalWorkspaceDependenciesFromList(List<WorkspaceDependency> dependencies) {
        Iterator<WorkspaceDependency> iter = dependencies.iterator();
        while (iter.hasNext()) {
            WorkspaceDependency next = iter.next();
            if (!next.isForInternalUse()) continue;
            iter.remove();
        }
    }

    static boolean checkIfRootsMatch(SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        assert (source != null) : "Parameter 'source' of method 'checkIfRootsMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfRootsMatch' must not be null";
        assert (source != target) : "Same systems";
        for (Module nextTargetModule : SoftwareSystemDataTransferExtension.getPhysicalModules(target)) {
            Module nextSourceModule = source.getUniqueExistingChild(Workspace.class).getUniqueChild(new WorkspaceDependencyElementIdFilter(nextTargetModule.getId()), Module.class);
            assert (nextSourceModule != null) : "module '" + nextTargetModule.getName() + "' must exist";
            List<RootDirectoryPath> sourceRoots = nextSourceModule.getRelevantRootDirectoryPaths();
            List<RootDirectoryPath> targetRoots = nextTargetModule.getRelevantRootDirectoryPaths();
            if (sourceRoots.size() != targetRoots.size()) {
                if (result != null) {
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.ROOT_DIRECTORIES_DONT_MATCH, "Number of root directories for module '" + nextTargetModule.getName() + "' does not match", new Object[0]);
                    continue;
                }
                return false;
            }
            int i = 0;
            while (i < targetRoots.size()) {
                RootDirectoryPath nextTargetRoot = targetRoots.get(i);
                RootDirectoryPath nextSourceRoot = sourceRoots.get(i);
                if (!nextTargetRoot.getClass().equals(nextSourceRoot.getClass()) || !nextTargetRoot.getName().equals(nextSourceRoot.getName())) {
                    if (result != null) {
                        result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.ROOT_DIRECTORIES_DONT_MATCH, "Root directory '" + nextTargetRoot.getName() + "' changed.", new Object[0]);
                    } else {
                        return false;
                    }
                }
                if (nextTargetRoot.isEnabled() != nextSourceRoot.isEnabled()) {
                    if (result != null) {
                        result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.ROOT_DIRECTORIES_DONT_MATCH, "Enabled state of root directory '" + nextTargetRoot.getName() + "' changed.", new Object[0]);
                    } else {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    private static void assureFilterOrder(Workspace workspace) {
        IssueFilter issueFilter;
        ProductionCodeFilter productionCodeFilter;
        assert (workspace != null) : "Parameter 'workspace' of method 'assureFilterOrder' must not be null";
        WorkspaceFilter fileFilter = workspace.getWorkspaceFilter();
        int index = workspace.getIndexOf(NamedElement.class, fileFilter);
        if (index != 0) {
            workspace.moveChild(NamedElement.class, fileFilter, 0);
        }
        if ((index = workspace.getIndexOf(NamedElement.class, productionCodeFilter = workspace.getProductionCodeFilter())) != 1) {
            workspace.moveChild(NamedElement.class, productionCodeFilter, 1);
        }
        if ((index = workspace.getIndexOf(NamedElement.class, issueFilter = workspace.getIssueFilter())) != 2) {
            workspace.moveChild(NamedElement.class, issueFilter, 2);
        }
    }

    private static void performTransfer(LanguageProviderAccessor languageProviderAccessor, SoftwareSystem systemFromSnapshot, SoftwareSystem systemFromFile, Workspace workspaceFromSnapshot, Workspace workspaceFromFile, boolean attachOnly, boolean enableWorkspaceFilter) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'performTransfer' must not be null";
        assert (systemFromSnapshot != null) : "Parameter 'systemFromSnapshot' of method 'performTransfer' must not be null";
        assert (systemFromFile != null) : "Parameter 'systemFromFile' of method 'performTransfer' must not be null";
        assert (workspaceFromSnapshot != null) : "Parameter 'workspaceFromSnapshot' of method 'performTransfer' must not be null";
        assert (workspaceFromFile != null) : "Parameter 'workspaceFromFile' of method 'performTransfer' must not be null";
        workspaceFromSnapshot.removeChildren(ProductionCodeFilter.class, IssueFilter.class);
        workspaceFromFile.getProductionCodeFilter().changeParent(workspaceFromSnapshot, true);
        workspaceFromFile.getIssueFilter().changeParent(workspaceFromSnapshot, true);
        Set<Language> usedLanguages = attachOnly ? systemFromSnapshot.getUsedLanguages() : systemFromFile.getUsedLanguages();
        for (LanguageProvider nextLanguageProvider : languageProviderAccessor.getLanguageProviders(usedLanguages)) {
            nextLanguageProvider.moveSoftwareSystemElements(workspaceFromFile, workspaceFromSnapshot);
        }
        workspaceFromFile.remove();
        workspaceFromSnapshot.changeParent(systemFromFile, true);
        workspaceFromSnapshot.getWorkspaceFilter().setEnabled(enableWorkspaceFilter);
        SoftwareSystemDataTransferExtension.assureFilterOrder(workspaceFromSnapshot);
        systemFromFile.setIsClearable(systemFromSnapshot.isClearable());
        systemFromFile.getParserModel().initializeFrom(systemFromSnapshot.getParserModel());
    }

    public static void transferDataInSnapshotApply(LanguageProviderAccessor languageProviderAccessor, SoftwareSystem systemFromSnapshot, SoftwareSystem systemFromFile, OperationResult result) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'transferDataInSnapshotApply' must not be null";
        assert (systemFromSnapshot != null) : "Parameter 'systemFromSnapshot' of method 'transferDataInSnapshotApply' must not be null";
        assert (systemFromFile != null) : "Parameter 'systemFromFile' of method 'transferDataInSnapshotApply' must not be null";
        assert (systemFromSnapshot != systemFromFile) : "systemFromSnapshot and systemFromFile are the same instance";
        assert (result != null) : "Parameter 'result' of method 'transferDataInSnapshotApply' must not be null";
        Workspace workspaceFromSnapshot = systemFromSnapshot.getUniqueExistingChild(Workspace.class);
        assert (workspaceFromSnapshot != null) : "'workspaceFromSnapshot' of method 'transferDataInSnapshotApply' must not be null";
        Workspace workspaceFromFile = systemFromFile.getUniqueExistingChild(Workspace.class);
        assert (workspaceFromFile != null) : "'workspaceFromFile' of method 'transferDataInSnapshotApply' must not be null";
        boolean enableWorkspaceFilter = systemFromFile.getUniqueExistingChild(Workspace.class).getWorkspaceFilter().isEnabled();
        SoftwareSystemDataTransferExtension.checkIfEssentialWorkspaceInfoMatches(languageProviderAccessor, systemFromSnapshot, systemFromFile, enableWorkspaceFilter, result);
        if (result.isFailure()) {
            return;
        }
        SoftwareSystemDataTransferExtension.checkIfModuleOrderMatch(languageProviderAccessor, systemFromSnapshot, systemFromFile, result);
        if (result.isFailure()) {
            return;
        }
        languageProviderAccessor.getLanguageProviders(systemFromFile.getUsedLanguages()).forEach(lp -> lp.checkSoftwareSystemSettings(workspaceFromSnapshot, workspaceFromFile, result));
        if (result.isFailure()) {
            return;
        }
        boolean moduleSettingsMatch = SoftwareSystemDataTransferExtension.checkIfModuleSettingsMatch(systemFromSnapshot, systemFromFile, result);
        if (result.isFailure()) {
            return;
        }
        boolean installationConfigurationChanged = false;
        for (LanguageProvider nextUsedLanguageProvider : languageProviderAccessor.getLanguageProviders(systemFromFile.getUsedLanguages())) {
            boolean bl = installationConfigurationChanged = installationConfigurationChanged || nextUsedLanguageProvider.hasInstallationConfigurationChanged(systemFromSnapshot, result);
        }
        if (result.isFailure()) {
            return;
        }
        SoftwareSystemDataTransferExtension.performTransfer(languageProviderAccessor, systemFromSnapshot, systemFromFile, workspaceFromSnapshot, workspaceFromFile, false, enableWorkspaceFilter);
        systemFromFile.setNeedsReparse(systemFromSnapshot.needsReparse() || installationConfigurationChanged || !moduleSettingsMatch || result.isFailure());
    }

    public static void transferDataInAttachSnapshot(LanguageProviderAccessor languageProviderAccessor, SoftwareSystem systemFromSnapshot, SoftwareSystem systemFromFile) {
        Workspace workspaceFromSnapshot = systemFromSnapshot.getUniqueExistingChild(Workspace.class);
        assert (workspaceFromSnapshot != null) : "'workspaceFromSnapshot' of method 'transferDataInSnapshotApply' must not be null";
        Workspace workspaceFromFile = systemFromFile.getUniqueExistingChild(Workspace.class);
        assert (workspaceFromFile != null) : "'workspaceFromFile' of method 'transferDataInSnapshotApply' must not be null";
        boolean enableWorkspaceFilter = systemFromFile.getUniqueExistingChild(Workspace.class).getWorkspaceFilter().isEnabled();
        SoftwareSystemDataTransferExtension.performTransfer(languageProviderAccessor, systemFromSnapshot, systemFromFile, workspaceFromSnapshot, workspaceFromFile, true, enableWorkspaceFilter);
        systemFromFile.setNeedsReparse(false);
    }

    EnumSet<Modification> transferDataInSoftwareSystemRestore(LanguageProviderAccessor languageProviderAccessor, SoftwareSystem restoredSystem, SoftwareSystem previousSystem) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'transferDataInSoftwareSystemRestore' must not be null";
        assert (restoredSystem != null) : "Parameter 'restoredSystem' of method 'transferDataInSoftwareSystemRestore' must not be null";
        assert (previousSystem != null) : "Parameter 'previousSystem' of method 'transferDataInSoftwareSystemRestore' must not be null";
        assert (restoredSystem != previousSystem) : "Same software systems";
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        if (!previousSystem.getDescription().equals(restoredSystem.getDescription())) {
            previousSystem.setDescription(restoredSystem.getDescription());
            modifications.add(Modification.SYSTEM_MODIFIED);
        }
        Workspace workspaceFromRestoredSystem = restoredSystem.getUniqueExistingChild(Workspace.class);
        Workspace workspaceFromPreviousSystem = previousSystem.getUniqueExistingChild(Workspace.class);
        boolean enableWorkspaceFilter = previousSystem.getUniqueExistingChild(Workspace.class).getWorkspaceFilter().isEnabled();
        if (!SoftwareSystemDataTransferExtension.checkIfEssentialWorkspaceInfoMatches(languageProviderAccessor, restoredSystem, previousSystem, enableWorkspaceFilter, null)) {
            workspaceFromPreviousSystem.remove();
            workspaceFromRestoredSystem.changeParent(previousSystem, true);
            workspaceFromRestoredSystem.getWorkspaceFilter().setEnabled(enableWorkspaceFilter);
            for (Module nextModule : workspaceFromRestoredSystem.getChildren(Module.class)) {
                nextModule.getChildren(RootDirectoryPath.class).forEach(r -> r.setModelServiceProvider(previousSystem));
            }
            modifications.add(Modification.WORKSPACE_MODIFIED);
            return modifications;
        }
        this.transferFilters(workspaceFromRestoredSystem.getWorkspaceFilter(), workspaceFromPreviousSystem.getWorkspaceFilter(), modifications);
        this.transferFilters(workspaceFromRestoredSystem.getProductionCodeFilter(), workspaceFromPreviousSystem.getProductionCodeFilter(), modifications);
        this.transferFilters(workspaceFromRestoredSystem.getIssueFilter(), workspaceFromPreviousSystem.getIssueFilter(), modifications);
        for (LanguageProvider nextUsedLanguageProvider : this.m_lpAccessor.getLanguageProviders(previousSystem.getUsedLanguages())) {
            modifications.addAll(nextUsedLanguageProvider.moveSoftwareSystemElements(workspaceFromRestoredSystem, workspaceFromPreviousSystem));
        }
        if (!SoftwareSystemDataTransferExtension.checkIfModuleOrderMatch(languageProviderAccessor, restoredSystem, previousSystem, null)) {
            this.reoderModules(restoredSystem, previousSystem);
            modifications.add(Modification.WORKSPACE_MODIFIED);
        }
        if (!SoftwareSystemDataTransferExtension.checkIfModuleSettingsMatch(restoredSystem, previousSystem, null)) {
            previousSystem.setNeedsReparse(true);
            modifications.add(Modification.WORKSPACE_MODIFIED);
        } else {
            previousSystem.getParserModel().initializeFrom(restoredSystem.getParserModel());
        }
        return modifications;
    }
}

