/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IRefactoringProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringAdapter;
import com.hello2morrow.sonargraph.core.controller.system.RefactoringProcessorUtility;
import com.hello2morrow.sonargraph.core.controller.system.RefactoringUtilities;
import com.hello2morrow.sonargraph.core.controller.system.ToBeMovedRenamedElementsCollector;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.architecture.LogicalNamespaceContainer;
import com.hello2morrow.sonargraph.core.model.architecture.RecursiveElementComponentContainer;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IDependency;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.ILogicalElement;
import com.hello2morrow.sonargraph.core.model.element.INamedElementNode;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.IRefactoringTarget;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.element.StructureMode;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.refactoring.DeleteRefactoringData;
import com.hello2morrow.sonargraph.core.model.refactoring.DeleteRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.DeletionVisitor;
import com.hello2morrow.sonargraph.core.model.refactoring.IRefactoringAdapter;
import com.hello2morrow.sonargraph.core.model.refactoring.LanguageSpecificRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringInfo;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringData;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringStateHandler;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.core.model.refactoring.RenameRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.PhysicalImpactCalculator;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RefactoringProcessor
implements IRefactoringProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefactoringProcessor.class);
    private static final String ARCHITECTURE_DOMAIN_PREFIX = "Files:BaseDirectory:SystemDirectory:Architecture:";
    private static final String LOGICAL_SYSTEM_DOMAIN_PREFIX = "Logical system namespaces:";
    private static final String LOGICAL_MODULE_DOMAIN_PREFIX = "Logical module namespaces";
    private final Map<Language, Map<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>>> m_languageToRefactorables = new THashMap();
    private final Map<Language, Predicate<IRefactorable>> m_languageToPredicate = new THashMap();
    private final LanguageProviderAccessor m_accessor;
    private final SoftwareSystem m_softwareSystem;
    private final INamedElementResolver m_resolver;

    RefactoringProcessor(LanguageProviderAccessor accessor, SoftwareSystem softwareSystem, INamedElementResolver resolver) {
        assert (accessor != null) : "Parameter 'accessor' of method 'RefactoringProcessor' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'RefactoringProcessor' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'RefactoringProcessor' must not be null";
        this.m_accessor = accessor;
        this.m_softwareSystem = softwareSystem;
        this.m_resolver = resolver;
        for (LanguageProvider next : this.m_accessor.getAvailableLanguageProviders()) {
            Language nextLanguage = next.getLanguage();
            LanguageProviderRefactoringAdapter nextRefactoringAdapter = next.getRefactoringAdapter();
            Map<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>> nextRefactorables = nextRefactoringAdapter.getRefactorables();
            assert (nextRefactorables != null) : "'nextRefactorables' of method 'RefactoringProcessor' must not be null";
            this.m_languageToRefactorables.put(nextLanguage, nextRefactorables);
            Predicate<IRefactorable> nextPredicate = nextRefactoringAdapter.getRefactorableInclusionPredicate();
            assert (nextPredicate != null) : "'nextPredicate' of method 'RefactoringProcessor' must not be null";
            this.m_languageToPredicate.put(nextLanguage, nextPredicate);
        }
    }

    private List<Element> normalizeContainedNamedElements(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'normalizeContainedNamedElements' must not be empty";
        ArrayList<NamedElement> namedElements = new ArrayList<NamedElement>(elements.size());
        for (Element nextElement : elements) {
            if (!(nextElement instanceof NamedElement)) continue;
            namedElements.add((NamedElement)nextElement);
        }
        if (!namedElements.isEmpty()) {
            ArrayList<Element> normalizedElements = new ArrayList<Element>(elements);
            Set normalizedNamedElements = NamedElementUtility.normalize(namedElements, true, new Class[0]);
            Iterator elementIterator = normalizedElements.iterator();
            while (elementIterator.hasNext()) {
                Element next = (Element)elementIterator.next();
                if (!(next instanceof NamedElement) || normalizedNamedElements.contains(next)) continue;
                elementIterator.remove();
            }
            return normalizedElements;
        }
        return elements;
    }

    private void internalCollectElementsForDeleteRefactoring(DeleteRefactoringData data, Set<ElementWithIssues> wildcards, Set<NamedElement> fqNames, Set<Pair<NamedElement, NamedElement>> endpoints, Set<ParserDependency> forEndpoints, Set<ParserDependency> forDependencies) {
        assert (data != null) : "Parameter 'data' of method 'collectElementsForDeleteRefactoring' must not be null";
        assert (wildcards != null) : "Parameter 'wildcards' of method 'collectElementsForDeleteRefactoring' must not be null";
        assert (fqNames != null) : "Parameter 'fqNames' of method 'collectElementsForDeleteRefactoring' must not be null";
        assert (endpoints != null) : "Parameter 'endpoints' of method 'collectElementsForDeleteRefactoring' must not be null";
        assert (forDependencies != null) : "Parameter 'forDependencies' of method 'internalCollectElementsForDeleteRefactoring' must not be null";
        boolean includeRecursiveElementChildren = data.includeRecursiveElementChildren();
        boolean collectParserDependencies = true;
        boolean collectViolatingParserDependencies = false;
        DeleteRefactoringData.EdgeOption option = data.getEdgeOption();
        if (option != null) {
            switch (option) {
                case DELETE_PARSER_DEPENDENCIES: {
                    collectParserDependencies = true;
                    break;
                }
                case DELETE_VIOLATING_PARSER_DEPENDENCIES: {
                    collectParserDependencies = true;
                    collectViolatingParserDependencies = true;
                    break;
                }
                case DELETE_PARSER_DEPENDENCIES_BASED_ON_ENDPOINTS: {
                    collectParserDependencies = false;
                    break;
                }
                default: {
                    assert (false) : "Unhandled option: " + String.valueOf((Object)option);
                    break;
                }
            }
        }
        block11: for (Element nextElement : data.getElements()) {
            if (nextElement instanceof INamedElementNode) {
                nextElement = ((INamedElementNode)((Object)nextElement)).getNamedElement();
            }
            if (nextElement instanceof NamedElement) {
                IDomainRoot.Domain nextDomain = ((NamedElement)nextElement).getDomain();
                assert (nextDomain != null) : "'nextDomain' of method 'collectElementsForDeleteRefactoring' must not be null";
                switch (nextDomain) {
                    case ARCHITECTURE_LOGICAL: {
                        if (nextElement instanceof AssignedElement) {
                            for (NamedElement nextPhysical : PhysicalImpactCalculator.getPhysicalNamedElements(((AssignedElement)nextElement).getRepresentedElement())) {
                                fqNames.add(nextPhysical);
                                if (forEndpoints == null) continue;
                                forEndpoints.addAll(PhysicalImpactCalculator.getParserDependencies(nextPhysical, includeRecursiveElementChildren));
                            }
                            continue block11;
                        }
                        if (!(nextElement instanceof LogicalNamespaceContainer)) continue block11;
                        for (NamedElement nextPhysical : PhysicalImpactCalculator.getPhysicalNamedElements(((LogicalNamespaceContainer)nextElement).getRepresentedElement())) {
                            fqNames.add(nextPhysical);
                            if (forEndpoints == null) continue;
                            forEndpoints.addAll(PhysicalImpactCalculator.getParserDependencies(nextPhysical, includeRecursiveElementChildren));
                        }
                        continue block11;
                    }
                    case ARCHITECTURE_PHYSICAL: {
                        if (nextElement instanceof AssignedElement) {
                            fqNames.add(((AssignedElement)nextElement).getRepresentedElement());
                            if (forEndpoints == null) continue block11;
                            forEndpoints.addAll(PhysicalImpactCalculator.getParserDependencies(((AssignedElement)nextElement).getRepresentedElement(), includeRecursiveElementChildren));
                            continue block11;
                        }
                        if (!(nextElement instanceof RecursiveElementComponentContainer)) continue block11;
                        fqNames.add((NamedElement)((RecursiveElementComponentContainer)nextElement).getRepresentedElement());
                        if (forEndpoints == null) continue block11;
                        forEndpoints.addAll(PhysicalImpactCalculator.getParserDependencies(((RecursiveElementComponentContainer)nextElement).getRepresentedElement(), includeRecursiveElementChildren));
                        continue block11;
                    }
                    case LOGICAL_SYSTEM_SCOPE: 
                    case LOGICAL_MODULE_SCOPE: {
                        for (NamedElement nextPhysical : PhysicalImpactCalculator.getPhysicalNamedElements((NamedElement)nextElement)) {
                            fqNames.add(nextPhysical);
                            if (forEndpoints == null) continue;
                            forEndpoints.addAll(PhysicalImpactCalculator.getParserDependencies(nextPhysical, includeRecursiveElementChildren));
                        }
                        continue block11;
                    }
                    case PHYSICAL: {
                        fqNames.add((NamedElement)nextElement);
                        if (forEndpoints == null) continue block11;
                        forEndpoints.addAll(PhysicalImpactCalculator.getParserDependencies((NamedElement)nextElement, includeRecursiveElementChildren));
                        continue block11;
                    }
                    default: {
                        assert (false) : "Unhandled domain: " + String.valueOf((Object)nextDomain);
                        continue block11;
                    }
                }
            }
            if (nextElement instanceof ParserDependency) {
                RefactoringProcessorUtility.collectDependencyForDeleteRefactoring(collectViolatingParserDependencies ? data.getViolating() : Collections.singletonList((ParserDependency)nextElement), endpoints, forDependencies, forEndpoints == null);
                continue;
            }
            if (!(nextElement instanceof IDependency)) continue;
            if (collectParserDependencies) {
                RefactoringProcessorUtility.collectDependencyForDeleteRefactoring(collectViolatingParserDependencies ? data.getViolating() : ((IDependency)((Object)nextElement)).getDependencies(), endpoints, forDependencies, forEndpoints == null);
                continue;
            }
            RefactoringProcessorUtility.collectRepresentationDependencyForDeleteRefactoring((IDependency)((Object)nextElement), endpoints, forDependencies, forEndpoints == null);
        }
    }

    @Override
    public void collectElementsForDeleteRefactoring(DeleteRefactoringData data, Set<ElementWithIssues> wildcards, Set<NamedElement> fqNames, Set<Pair<NamedElement, NamedElement>> endpoints, Set<ParserDependency> parserDependencies) {
        assert (data != null) : "Parameter 'data' of method 'collectElementsForDeleteRefactoring' must not be null";
        assert (wildcards != null) : "Parameter 'wildcards' of method 'collectElementsForDeleteRefactoring' must not be null";
        assert (fqNames != null) : "Parameter 'fqNames' of method 'collectElementsForDeleteRefactoring' must not be null";
        assert (endpoints != null) : "Parameter 'endpoints' of method 'collectElementsForDeleteRefactoring' must not be null";
        assert (parserDependencies != null) : "Parameter 'parserDependencies' of method 'collectElementsForDeleteRefactoring' must not be null";
        this.internalCollectElementsForDeleteRefactoring(data, wildcards, fqNames, endpoints, parserDependencies, parserDependencies);
    }

    @Override
    public DeleteRefactoringData isDeleteRefactoringPossible(List<Element> elementsToDelete, StructureMode structureMode) {
        assert (elementsToDelete != null && !elementsToDelete.isEmpty()) : "Parameter 'elementsToDelete' of method 'isDeleteRefactoringPossible' must not be empty";
        assert (structureMode != null) : "Parameter 'structureMode' of method 'isDeleteRefactoringPossible' must not be null";
        ModifiableModel modifiableModel = this.m_softwareSystem.getCurrentModel(ModifiableModel.class);
        if (modifiableModel != null) {
            List<Element> elements = this.normalizeContainedNamedElements(elementsToDelete);
            Class clazz = null;
            RefactoringProcessorUtility.ElementInfo elementInfo = new RefactoringProcessorUtility.ElementInfo();
            Boolean enableEndpointOption = null;
            for (Element nextElement : elements) {
                if (nextElement instanceof INamedElementNode) {
                    nextElement = ((INamedElementNode)((Object)nextElement)).getNamedElement();
                }
                if (nextElement.isExternal() || modifiableModel.getRefactoringState(nextElement).hasBeenDeleted()) {
                    return null;
                }
                if (nextElement instanceof NamedElement) {
                    if (clazz == null) {
                        clazz = NamedElement.class;
                    } else if (!clazz.equals(NamedElement.class)) {
                        return null;
                    }
                    if (!RefactoringProcessorUtility.isDeletable((NamedElement)nextElement)) {
                        return null;
                    }
                    RefactoringProcessorUtility.collectElementInfo((NamedElement)nextElement, elementInfo);
                    continue;
                }
                if (nextElement instanceof ParserDependency) {
                    if (clazz == null) {
                        clazz = ParserDependency.class;
                    } else if (!clazz.equals(ParserDependency.class)) {
                        return null;
                    }
                    if (!((ParserDependency)nextElement).isArchitectureRelevant()) {
                        return null;
                    }
                    enableEndpointOption = Boolean.FALSE;
                    continue;
                }
                if (nextElement instanceof IDependency && ((IDependency)((Object)nextElement)).getFirstDependency() instanceof ParserDependency) {
                    NamedElement toEndPoint;
                    if (clazz == null) {
                        clazz = IDependency.class;
                    } else if (!clazz.equals(IDependency.class)) {
                        return null;
                    }
                    boolean containsAtLeastOneArchitectureRelevantDependency = false;
                    for (Dependency dependency : ((IDependency)((Object)nextElement)).getDependencies()) {
                        assert (dependency instanceof ParserDependency) : "Unexpected class in method 'isDeleteRefactoringPossible': " + String.valueOf(dependency);
                        if (!((ParserDependency)dependency).isArchitectureRelevant()) continue;
                        containsAtLeastOneArchitectureRelevantDependency = true;
                        break;
                    }
                    if (!containsAtLeastOneArchitectureRelevantDependency) {
                        return null;
                    }
                    NamedElement namedElement = ((IDependency)((Object)nextElement)).getFromEndPoint();
                    if (namedElement == (toEndPoint = ((IDependency)((Object)nextElement)).getToEndPoint())) {
                        return null;
                    }
                    Boolean nextEnableEndpointOption = RefactoringProcessorUtility.acceptRepresentationDependencyEndpointsForDeleteRefactoring(namedElement, toEndPoint);
                    if (nextEnableEndpointOption == null) {
                        return null;
                    }
                    RefactoringProcessorUtility.collectElementInfo(namedElement, elementInfo);
                    RefactoringProcessorUtility.collectElementInfo(toEndPoint, elementInfo);
                    if (enableEndpointOption == null) {
                        enableEndpointOption = nextEnableEndpointOption;
                        continue;
                    }
                    if (nextEnableEndpointOption != Boolean.FALSE) continue;
                    enableEndpointOption = Boolean.FALSE;
                    continue;
                }
                return null;
            }
            DeleteRefactoringData data = RefactoringProcessorUtility.createDeleteRefactoringData(clazz, elements, elementInfo, enableEndpointOption, structureMode);
            LinkedHashSet<ElementWithIssues> wildcards = new LinkedHashSet<ElementWithIssues>();
            LinkedHashSet<NamedElement> fqNames = new LinkedHashSet<NamedElement>();
            LinkedHashSet<Pair<NamedElement, NamedElement>> linkedHashSet = new LinkedHashSet<Pair<NamedElement, NamedElement>>();
            LinkedHashSet<ParserDependency> forDependencies = new LinkedHashSet<ParserDependency>();
            this.internalCollectElementsForDeleteRefactoring(data, wildcards, fqNames, linkedHashSet, null, forDependencies);
            if (!wildcards.isEmpty() || !fqNames.isEmpty() | !forDependencies.isEmpty()) {
                return data;
            }
        }
        return null;
    }

    @Override
    public boolean isMoveRenameRefactoringPossible(String language, NamedElement element) {
        assert (language != null) : "Parameter 'language' of method 'isMoveRenameRefactoringPossible' must not be null";
        assert (element != null) : "Parameter 'element' of method 'isMoveRenameRefactoringPossible' must not be null";
        LanguageProvider languageProvider = this.m_accessor.getLanguageProvider(language);
        if (languageProvider != null) {
            Map<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>> refactorables = this.m_languageToRefactorables.get(languageProvider.getLanguage());
            assert (refactorables != null) : "'refactorables' of method 'isMoveRenameRefactoringPossible' must not be null";
            if (refactorables.containsKey(element.getClass())) {
                Predicate<IRefactorable> predicate = this.m_languageToPredicate.get(languageProvider.getLanguage());
                assert (predicate != null) : "'predicate' of method 'isMoveRenameRefactoringPossible' must not be null";
                return predicate.test((IRefactorable)((Object)element));
            }
        }
        return false;
    }

    @Override
    public MoveRenameRefactoringInfo isMoveRenameRefactoringPossible(List<Element> toBeMovedRenamed) {
        assert (toBeMovedRenamed != null && !toBeMovedRenamed.isEmpty()) : "Parameter 'toBeMovedRenamed' of method 'isMoveRenameRefactoringPossible' must not be empty";
        ModifiableModel modifiableModel = this.m_softwareSystem.getCurrentModel(ModifiableModel.class);
        if (modifiableModel == null) {
            LOGGER.debug("Move/rename of " + toBeMovedRenamed.size() + " element(s) not possible because not modifiable model applied.");
            return null;
        }
        List<Element> elements = this.normalizeContainedNamedElements(toBeMovedRenamed);
        ToBeMovedRenamedElementsCollector collector = new ToBeMovedRenamedElementsCollector(this.m_languageToRefactorables, this.m_languageToPredicate, elements.size());
        for (Element nextElement : elements) {
            String addElement = collector.addElement(nextElement);
            if (addElement == null) continue;
            LOGGER.debug("Move/rename of " + toBeMovedRenamed.size() + " element(s) not possible because: " + addElement);
            return null;
        }
        Language language = collector.getLanguage();
        LanguageProvider languageProvider = this.m_accessor.getLanguageProvider(language);
        assert (languageProvider != null) : "'languageProvider' of method 'isMoveRenameRefactoringPossible' must not be null";
        List<NamedElement> namedElements = collector.getNamedElements();
        assert (namedElements != null && !namedElements.isEmpty()) : "'namedElements' of method 'isMoveRenameRefactoringPossible' must not be empty";
        LanguageProviderRefactoringAdapter refactoringAdapter = languageProvider.getRefactoringAdapter();
        MoveRenameRefactoringElementType refactoringElementType = collector.getRefactoringElementType();
        String elementTypePresentationName = RefactoringUtilities.getKind(refactoringElementType, language);
        if (namedElements.size() == 1) {
            return new MoveRenameRefactoringInfo(language, RefactoringType.MOVE_RENAME, refactoringElementType, elementTypePresentationName, namedElements);
        }
        if (!refactoringAdapter.containsElementWithCollidingRelevantName(namedElements)) {
            return new MoveRenameRefactoringInfo(language, RefactoringType.MOVE, refactoringElementType, elementTypePresentationName, namedElements);
        }
        return null;
    }

    @Override
    public MoveRenameRefactoringInfo isPossibleMoveRefactoringTarget(MoveRenameRefactoringInfo info, Element potentialTarget) {
        assert (info != null) : "Parameter 'info' of method 'isPossibleMoveRefactoringTarget' must not be null";
        assert (potentialTarget != null) : "Parameter 'potentialTarget' of method 'isPossibleMoveRefactoringTarget' must not be null";
        ModifiableModel modifiableModel = this.m_softwareSystem.getCurrentModel(ModifiableModel.class);
        if (modifiableModel != null) {
            LanguageProvider languageProvider = this.m_accessor.getLanguageProvider(info.getLanguage());
            assert (languageProvider != null) : "'languageProvider' of method 'getMoveRenameRefactoringData' must not be null";
            LanguageProviderRefactoringAdapter refactoringAdapter = languageProvider.getRefactoringAdapter();
            IRefactoringTarget refactoringTarget = refactoringAdapter.isPossibleMoveRefactoringTarget(info.getElements(), potentialTarget, this.m_languageToRefactorables.get(info.getLanguage()), null);
            if (refactoringTarget != null) {
                info.setRefactoringTarget(refactoringTarget);
                return info;
            }
        }
        return null;
    }

    @Override
    public RefactoringData getMoveRenameRefactoringData(MoveRenameRefactoringInfo info) {
        assert (info != null) : "Parameter 'info' of method 'getMoveRenameRefactoringData' must not be null";
        assert (info.getRefactoringType() != RefactoringType.NONE && info.getRefactoringType() != RefactoringType.DELETE) : "Not a move/rename refactoring: " + String.valueOf((Object)info.getRefactoringType());
        Language language = info.getLanguage();
        LanguageProvider languageProvider = this.m_accessor.getLanguageProvider(language);
        assert (languageProvider != null) : "'languageProvider' of method 'getMoveRenameRefactoringData' must not be null";
        LanguageProviderRefactoringAdapter refactoringAdapter = languageProvider.getRefactoringAdapter();
        RefactoringData refactoringData = refactoringAdapter.getMoveRenameRefactoringData(this.m_softwareSystem.getUniqueExistingChild(Workspace.class), info, this.m_languageToRefactorables.get(info.getLanguage()));
        IRefactoringTarget refactoringTarget = info.getRefactoringTarget();
        if (refactoringTarget != null) {
            NamedElement refactoringTargetAsNamedElement = refactoringTarget.getNamedElement();
            List<NamedElement> namedElements = refactoringData.getElements();
            RootDirectoryPath targetRootDirectoryPath = refactoringTargetAsNamedElement.getParent(RootDirectoryPath.class, ParentMode.SELF_OR_FIRST_PARENT);
            assert (targetRootDirectoryPath != null) : "'targetRootDirectoryPath' of method 'getMoveRenameRefactoringData' must not be null";
            String moveToParentName = RefactoringUtilities.getMoveToParentName(namedElements, refactoringTargetAsNamedElement, info.getRefactoringElementType(), language);
            refactoringData.setTargetRootDirectoryPath(targetRootDirectoryPath);
            refactoringData.setTargetParentName(moveToParentName);
        } else {
            refactoringData.validate();
        }
        return refactoringData;
    }

    private LanguageProviderRefactoringAdapter getLanguageProviderRefactoringAdapter(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getLanguageProviderRefactoringAdapter' must not be null";
        Language language = element.getLanguage();
        assert (language != null) : "Parameter 'language' of method 'getLanguageProviderRefactoringAdapter' must not be null";
        LanguageProvider languageProvider = this.m_accessor.getLanguageProvider(language);
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'getLanguageProviderRefactoringAdapter' must not be null";
        return languageProvider.getRefactoringAdapter();
    }

    private LanguageProviderRefactoringAdapter getLanguageProviderRefactoringAdapter(LanguageSpecificRefactoringDefinition definition, StatusInfo statusInfo) {
        assert (definition != null) : "Parameter 'definition' of method 'getLanguageProviderRefactoringAdapter' must not be null";
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'getLanguageProviderRefactoringAdapter' must not be null";
        LanguageProvider languageProvider = this.m_accessor.getLanguageProvider(definition.getDefinedForLanguage());
        if (languageProvider != null) {
            return languageProvider.getRefactoringAdapter();
        }
        statusInfo.languageNotAvailable(definition.getDefinedForLanguage());
        return null;
    }

    private void processApplicabilityState(RefactoringDefinition definition, List<String> nonMatchingNamedElementFqNames, StatusInfo statusInfo, int notFound) {
        assert (definition != null) : "Parameter 'definition' of method 'processApplicabilityState' must not be null";
        assert (nonMatchingNamedElementFqNames != null) : "Parameter 'nonMatchingNamedElementFqNames' of method 'processApplicabilityState' must not be null";
        if (definition.getNumberOfPotentiallyDoneElements() == nonMatchingNamedElementFqNames.size()) {
            statusInfo.setStatus(StatusInfo.Status.POTENTIALLY_DONE);
        } else if (notFound == nonMatchingNamedElementFqNames.size()) {
            statusInfo.setStatus(StatusInfo.Status.NO_ELEMENT_MATCHED);
        } else {
            statusInfo.setStatus(StatusInfo.Status.PARTIALLY_APPLICABLE);
        }
    }

    private void processApplicability(RefactoringDefinition definition, List<NamedElement> matchedNamedElements, List<String> nonMatchingNamedElementFqNames) {
        assert (definition != null) : "Parameter 'definition' of method 'processApplicability' must not be null";
        assert (matchedNamedElements != null) : "Parameter 'matchedNamedElements' of method 'processApplicability' must not be null";
        assert (nonMatchingNamedElementFqNames != null) : "Parameter 'nonMatchingNamedElementFqNames' of method 'processApplicability' must not be null";
        StatusInfo statusInfo = definition.getStatusInfo();
        StatusInfo.Status status = statusInfo.getStatus();
        if (status == StatusInfo.Status.NONE) {
            if (matchedNamedElements.size() == 0) {
                statusInfo.setStatus(StatusInfo.Status.NOT_APPLICABLE);
            } else if (nonMatchingNamedElementFqNames.size() == 0) {
                statusInfo.setStatus(StatusInfo.Status.APPLICABLE);
            } else {
                statusInfo.setStatus(StatusInfo.Status.PARTIALLY_APPLICABLE);
            }
        }
    }

    private RootDirectoryPath getTargetRootDirectory(MoveRefactoringDefinition definition) {
        assert (definition != null) : "Parameter 'definition' of method 'getTargetRootDirectory' must not be null";
        RootDirectoryPath targetRootDirectory = this.m_resolver.resolve(this.m_softwareSystem, definition.getTargetRootDirectoryFqName(), RootDirectoryPath.class);
        if (targetRootDirectory == null || !targetRootDirectory.isEnabled()) {
            Workspace workspace = this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
            int length = workspace.getFullyQualifiedName().length();
            definition.getStatusInfo().targetRootDirectoryNotFound(definition.getTargetRootDirectoryFqName().substring(length + 1));
        }
        return targetRootDirectory;
    }

    private boolean usesInvalidMatchingPattern(List<String> nonMatchingNamedElementFqNames, List<Pair<String, String>> nonMatchingDependencyFqNames, StatusInfo statusInfo) {
        assert (nonMatchingNamedElementFqNames != null) : "Parameter 'usesInvalidMatchingPattern' of method 'processInvalidPatterns' must not be null";
        assert (nonMatchingDependencyFqNames != null) : "Parameter 'usesInvalidMatchingPattern' of method 'processInvalidPatterns' must not be null";
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'usesInvalidMatchingPattern' must not be null";
        if (!nonMatchingNamedElementFqNames.isEmpty()) {
            for (String string : nonMatchingNamedElementFqNames) {
                if (!string.startsWith(ARCHITECTURE_DOMAIN_PREFIX) && !string.startsWith(LOGICAL_SYSTEM_DOMAIN_PREFIX) && !string.startsWith(LOGICAL_MODULE_DOMAIN_PREFIX)) continue;
                statusInfo.invalidMatchingPatternUsed();
                return true;
            }
        }
        if (!nonMatchingDependencyFqNames.isEmpty()) {
            for (Pair pair : nonMatchingDependencyFqNames) {
                String nextFrom = (String)pair.getFirst();
                String nextTo = (String)pair.getSecond();
                if (!nextFrom.startsWith(ARCHITECTURE_DOMAIN_PREFIX) && !nextFrom.startsWith(LOGICAL_SYSTEM_DOMAIN_PREFIX) && !nextFrom.startsWith(LOGICAL_MODULE_DOMAIN_PREFIX) && !nextTo.startsWith(ARCHITECTURE_DOMAIN_PREFIX) && !nextTo.startsWith(LOGICAL_SYSTEM_DOMAIN_PREFIX) && !nextTo.startsWith(LOGICAL_MODULE_DOMAIN_PREFIX)) continue;
                statusInfo.invalidMatchingPatternUsed();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<NamedElement> delete(DeleteRefactoringDefinition definition, List<NamedElement> matchedNamedElements, List<Dependency> matchedDependencies, List<String> nonMatchingNamedElementFqNames, List<Pair<String, String>> nonMatchingDependencyFqNames, RefactoringStateHandler refactoringStateHandler) {
        assert (definition != null) : "Parameter 'definition' of method 'delete' must not be null";
        assert (matchedNamedElements != null) : "Parameter 'matchedNamedElements' of method 'delete' must not be null";
        assert (matchedDependencies != null) : "Parameter 'matchedDependencies' of method 'delete' must not be null";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'delete' must not be null";
        StatusInfo statusInfo = definition.getStatusInfo();
        THashSet additional = Collections.emptySet();
        if (!matchedNamedElements.isEmpty() || !matchedDependencies.isEmpty()) {
            LOGGER.debug("Apply delete refactoring to " + matchedNamedElements.size() + " matched named elements and " + matchedDependencies.size() + " matched dependencies.");
            if (!matchedNamedElements.isEmpty()) {
                additional = new THashSet();
                Object var9_9 = null;
                DeletionVisitor deletionVisitor = null;
                for (NamedElement nextNamedElement : matchedNamedElements) {
                    void var9_10;
                    assert (!(nextNamedElement instanceof ILogicalElement)) : "Logical element: " + String.valueOf(nextNamedElement);
                    assert (!refactoringStateHandler.hasBeenDirectlyDeleted(nextNamedElement)) : "'element' of method 'deleteElement' already (directly) deleted: " + String.valueOf(nextNamedElement);
                    assert (refactoringStateHandler.mapElement(nextNamedElement) == nextNamedElement) : "You must delete the clone of 'element', if there is one";
                    if (var9_10 == null) {
                        assert (deletionVisitor == null) : "Parameter 'deletionVisitor' of method 'delete' must  be null";
                        LanguageProviderRefactoringAdapter languageProviderRefactoringAdapter = this.getLanguageProviderRefactoringAdapter(nextNamedElement);
                        deletionVisitor = languageProviderRefactoringAdapter.createDeletionVisitor(refactoringStateHandler, definition.isIncludingRecursiveElementChildren());
                        assert (deletionVisitor != null) : "Parameter 'deletionVisitor' of method 'deleteElement' must not be null";
                    }
                    boolean alreadyIndirectlyDeleted = refactoringStateHandler.hasBeenIndirectlyDeleted(nextNamedElement);
                    refactoringStateHandler.setDirectlyDeleted(nextNamedElement);
                    if (alreadyIndirectlyDeleted) continue;
                    assert (deletionVisitor != null);
                    NamedElement namedElement = nextNamedElement;
                    namedElement.accept(deletionVisitor);
                    NamedElement currentParent = namedElement.getParent();
                    while (currentParent != null && (currentParent.removeOnLastChildRemoval() || currentParent instanceof IComponent) && refactoringStateHandler.allChildrenDeleted(currentParent)) {
                        if (!refactoringStateHandler.hasBeenDeleted(currentParent)) {
                            refactoringStateHandler.setIndirectlyDeleted(currentParent);
                        }
                        currentParent = currentParent.getParent();
                    }
                    additional.addAll(deletionVisitor.reset());
                }
            }
            if (!matchedDependencies.isEmpty()) {
                for (Dependency dependency : matchedDependencies) {
                    assert (!(dependency instanceof ILogicalElement)) : "Logical element: " + String.valueOf(dependency);
                    assert (!refactoringStateHandler.hasBeenDirectlyDeleted(dependency)) : "'element' of method 'delete' already (directly) deleted: " + String.valueOf(dependency);
                    assert (refactoringStateHandler.mapElement(dependency) == dependency) : "You must delete the clone of 'element', if there is one";
                    refactoringStateHandler.setDirectlyDeleted(dependency);
                }
            }
            if (!nonMatchingNamedElementFqNames.isEmpty() || !nonMatchingDependencyFqNames.isEmpty()) {
                statusInfo.setStatus(StatusInfo.Status.PARTIALLY_APPLICABLE);
            } else {
                statusInfo.setStatus(StatusInfo.Status.APPLICABLE);
            }
        } else if (this.usesInvalidMatchingPattern(nonMatchingNamedElementFqNames, nonMatchingDependencyFqNames, statusInfo)) {
            statusInfo.setStatus(StatusInfo.Status.NOT_APPLICABLE);
        } else {
            statusInfo.setStatus(StatusInfo.Status.POTENTIALLY_DONE);
        }
        for (String string : nonMatchingNamedElementFqNames) {
            NamedElement nextResolved = this.m_resolver.resolve(this.m_softwareSystem, string);
            if (nextResolved == null) continue;
            definition.addPotentiallyDoneElement(nextResolved.getRepresentative());
        }
        for (Pair pair : nonMatchingDependencyFqNames) {
            NamedElement nextResolvedFrom = null;
            String nextFromFqName = (String)pair.getFirst();
            boolean done = false;
            while (!done) {
                nextResolvedFrom = this.m_resolver.resolve(this.m_softwareSystem, nextFromFqName);
                if (nextResolvedFrom != null) {
                    done = true;
                    continue;
                }
                int pos = nextFromFqName.lastIndexOf(58);
                if (pos == -1) {
                    done = true;
                    continue;
                }
                if (!"Workspace".equals(nextFromFqName = nextFromFqName.substring(0, pos))) continue;
                done = true;
            }
            if (nextResolvedFrom == null) continue;
            definition.addPotentiallyDoneElement(nextResolvedFrom.getRepresentative());
        }
        return additional;
    }

    private void processPotentiallyDoneState(LanguageSpecificRefactoringDefinition definition, List<String> nonMatchingNamedElementFqNames, IRefactoringAdapter refactoringAdapter) {
        assert (definition != null) : "Parameter 'definition' of method 'processPotentiallyDoneState' must not be null";
        assert (nonMatchingNamedElementFqNames != null && !nonMatchingNamedElementFqNames.isEmpty()) : "Parameter 'nonMatchingNamedElementFqNames' of method 'processPotentiallyDoneState' must not be empty";
        assert (refactoringAdapter != null) : "Parameter 'refactoringAdapter' of method 'processPotentiallyDoneState' must not be null";
        StatusInfo statusInfo = definition.getStatusInfo();
        int notFound = 0;
        for (String nextNonMatchingFqName : nonMatchingNamedElementFqNames) {
            String nextTargetFqName = definition.getTargetFqName(nextNonMatchingFqName, refactoringAdapter);
            if (nextTargetFqName != null) {
                NamedElement nextResolved = this.m_resolver.resolve(this.m_softwareSystem, nextTargetFqName);
                if (nextResolved != null) {
                    definition.addPotentiallyDoneElement(nextResolved.getRepresentative());
                    continue;
                }
                ++notFound;
                continue;
            }
            ++notFound;
        }
        this.processApplicabilityState(definition, nonMatchingNamedElementFqNames, statusInfo, notFound);
    }

    @Override
    public Set<NamedElement> rename(RenameRefactoringDefinition definition, List<NamedElement> matchedNamedElements, List<String> nonMatchingNamedElementFqNames, RefactoringStateHandler refactoringStateHandler) {
        assert (definition != null) : "Parameter 'definition' of method 'rename' must not be null";
        assert (matchedNamedElements != null) : "Parameter 'matchedNamedElements' of method 'rename' must not be null";
        assert (nonMatchingNamedElementFqNames != null) : "Parameter 'nonMatchingNamedElementFqNames' of method 'rename' must not be null";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'rename' must not be null";
        StatusInfo statusInfo = definition.getStatusInfo();
        statusInfo.reset();
        LanguageProviderRefactoringAdapter refactoringAdapter = this.getLanguageProviderRefactoringAdapter(definition, statusInfo);
        if (statusInfo.getStatus() == StatusInfo.Status.NONE) {
            assert (refactoringAdapter != null) : "'refactoringAdapter' of method 'rename' must not be null";
            if (!matchedNamedElements.isEmpty()) {
                LOGGER.debug("Apply rename refactoring to " + matchedNamedElements.size() + " matched named elements - new name: '" + definition.getNewName() + "'.");
                Set<NamedElement> additional = refactoringAdapter.rename(this.m_softwareSystem, definition.getRefactoringElementType(), matchedNamedElements, definition.getNewName(), refactoringStateHandler, statusInfo);
                this.processApplicability(definition, matchedNamedElements, nonMatchingNamedElementFqNames);
                return additional;
            }
            this.processPotentiallyDoneState(definition, nonMatchingNamedElementFqNames, refactoringAdapter);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<NamedElement> moveRename(MoveRenameRefactoringDefinition definition, List<NamedElement> matchedNamedElements, List<String> nonMatchingNamedElementFqNames, RefactoringStateHandler refactoringStateHandler) {
        assert (definition != null) : "Parameter 'definition' of method 'moveRename' must not be null";
        assert (matchedNamedElements != null) : "Parameter 'matchedNamedElements' of method 'moveRename' must not be null";
        assert (nonMatchingNamedElementFqNames != null) : "Parameter 'nonMatchingNamedElementFqNames' of method 'moveRename' must not be null";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'moveRename' must not be null";
        StatusInfo statusInfo = definition.getStatusInfo();
        statusInfo.reset();
        RootDirectoryPath targetRootDirectory = this.getTargetRootDirectory(definition);
        if (targetRootDirectory != null) {
            LanguageProviderRefactoringAdapter refactoringAdapter = this.getLanguageProviderRefactoringAdapter(definition, statusInfo);
            if (statusInfo.getStatus() == StatusInfo.Status.NONE) {
                assert (refactoringAdapter != null) : "'refactoringAdapter' of method 'moveRename' must not be null";
                if (!matchedNamedElements.isEmpty()) {
                    LOGGER.debug("Apply move/rename refactoring to '" + matchedNamedElements.size() + "' - move to parent: '" + definition.getMoveToParentName() + "' with new name: '" + definition.getNewName() + "'.");
                    Set<NamedElement> additional = refactoringAdapter.moveRename(this.m_softwareSystem, definition.getRefactoringElementType(), matchedNamedElements, targetRootDirectory, definition.getMoveToParentName(), definition.getNewName(), refactoringStateHandler, statusInfo);
                    if (statusInfo.getStatus() == StatusInfo.Status.NONE) {
                        this.processApplicability(definition, matchedNamedElements, nonMatchingNamedElementFqNames);
                        return additional;
                    }
                    return Collections.emptySet();
                }
                this.processPotentiallyDoneState(definition, nonMatchingNamedElementFqNames, refactoringAdapter);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public Set<NamedElement> move(MoveRefactoringDefinition definition, List<NamedElement> matchedNamedElements, List<String> nonMatchingNamedElementFqNames, RefactoringStateHandler refactoringStateHandler) {
        assert (definition != null) : "Parameter 'definition' of method 'move' must not be null";
        assert (matchedNamedElements != null) : "Parameter 'matchedNamedElements' of method 'move' must not be null";
        assert (nonMatchingNamedElementFqNames != null) : "Parameter 'nonMatchingNamedElementFqNames' of method 'move' must not be null";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'move' must not be null";
        StatusInfo statusInfo = definition.getStatusInfo();
        statusInfo.reset();
        RootDirectoryPath targetRootDirectory = this.getTargetRootDirectory(definition);
        if (targetRootDirectory != null) {
            LanguageProviderRefactoringAdapter refactoringAdapter = this.getLanguageProviderRefactoringAdapter(definition, statusInfo);
            if (statusInfo.getStatus() == StatusInfo.Status.NONE) {
                assert (refactoringAdapter != null) : "'refactoringAdapter' of method 'move' must not be null";
                if (!matchedNamedElements.isEmpty()) {
                    LOGGER.debug("Apply move refactoring to " + matchedNamedElements.size() + " named elements - move to parent: '" + definition.getMoveToParentName() + "'.");
                    Set<NamedElement> additional = refactoringAdapter.move(this.m_softwareSystem, definition.getRefactoringElementType(), matchedNamedElements, targetRootDirectory, definition.getMoveToParentName(), refactoringStateHandler, statusInfo);
                    if (statusInfo.getStatus() == StatusInfo.Status.NONE) {
                        this.processApplicability(definition, matchedNamedElements, nonMatchingNamedElementFqNames);
                        return additional;
                    }
                }
                this.processPotentiallyDoneState(definition, nonMatchingNamedElementFqNames, refactoringAdapter);
            }
        }
        return Collections.emptySet();
    }
}

