/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IQualityModelProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.QualityModelImportExtension;
import com.hello2morrow.sonargraph.core.controller.system.QualityModelMessageCause;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtension;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerExecutionController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IQualityModelImportExportExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.ExportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class QualityModelImportExportExtension
extends QualityModelImportExtension
implements IQualityModelImportExportExtension {
    private final IFinishModelProcessor m_finishModelProcessor;
    private final SoftwareSystem m_softwareSystem;

    public QualityModelImportExportExtension(LanguageProviderAccessor languageProviderAccessor, SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor) {
        super(languageProviderAccessor);
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'QualityModelExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'QualityModelExtension' must not be null";
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_softwareSystem = softwareSystem;
    }

    @Override
    public IPathValidator getExportQualityModelValidator() {
        return new IPathValidator(){

            @Override
            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput != null && newInput.getPath().isEmpty()) {
                    result.addError("Must not be empty");
                } else if (newInput == null || !newInput.exists()) {
                    result.addError("Invalid path");
                } else if (!newInput.isDirectory()) {
                    result.addError("Is not a directory");
                } else if (!newInput.canWrite()) {
                    result.addError("No write permission");
                }
                return result;
            }

            @Override
            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.DIRECTORY;
            }
        };
    }

    @Override
    public ExportQualityModel getExportQualityModel() {
        ArrayList<IModifiableFile> availableFiles = new ArrayList<IModifiableFile>();
        for (IQualityModelProvider nextProvider : this.m_softwareSystem.getExtensions(IQualityModelProvider.class)) {
            availableFiles.addAll(nextProvider.getAvailableFiles());
        }
        ExportQualityModel model = new ExportQualityModel(availableFiles);
        for (IModifiableFile next : availableFiles) {
            model.addCandidate(next, this.extractDescription(next.getFile(), next.getFileType()));
        }
        return model;
    }

    OperationResult importQualityModel(IWorkerContext workerContext, ImportQualityModel importModel, EnumSet<Modification> modifications) {
        assert (workerContext != null) : "Parameter 'context' of method 'importQualityModel' must not be null";
        assert (importModel != null) : "Parameter 'importModel' of method 'enclosing_method' must not be null";
        OperationResult result = new OperationResult("Import quality model");
        List<IQualityModelProvider> providers = this.m_softwareSystem.getExtensions(IQualityModelProvider.class);
        for (IQualityModelProvider nextProvider : providers) {
            nextProvider.checkOutOfSync(result);
        }
        if (result.isFailure()) {
            return result;
        }
        if (modifications != null) {
            this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
        }
        if (importModel.discardCurrentContent()) {
            workerContext.working("Remove existing system files", true);
            for (IQualityModelProvider nextProvider : providers) {
                nextProvider.discardFiles(workerContext, modifications, result);
            }
        }
        workerContext.working("Import system files", true);
        for (IQualityModelProvider nextProvider : providers) {
            nextProvider.importFiles(workerContext, importModel, modifications, result);
        }
        for (IQualityModelProvider nextProvider : providers) {
            nextProvider.importFinished(workerContext, modifications, result);
        }
        if (modifications != null) {
            if (modifications.contains((Object)Modification.WORKSPACE_MODIFIED) || modifications.contains((Object)Modification.WORKSPACE_SETUP_MODIFIED)) {
                WorkspaceExtension.setNeedsReparse(this.m_softwareSystem, result);
            }
            this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, modifications, result);
            this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).runAutomatedAnalyzers(workerContext);
        }
        return result;
    }

    @Override
    public OperationResult importQualityModel(IWorkerContext context, ImportQualityModel importModel) {
        return this.importQualityModel(context, importModel, EnumSet.noneOf(Modification.class));
    }

    @Override
    public OperationResult exportQualityModel(ExportQualityModel exportModel) {
        assert (exportModel != null && exportModel.isValid()) : "Parameter 'exportModel' of method 'exportQualityModel' must not be null and must contain some elements to export";
        OperationResult result = new OperationResult("Export quality model");
        try {
            TFile qualityModelFile = new TFile(exportModel.getFilePath()).getCanonicalFile();
            if (qualityModelFile.exists()) {
                qualityModelFile.rm_r();
            }
            block2: for (ExportQualityModel.ExportQualityModelCandidate nextCandidate : exportModel.getCandidates()) {
                if (!nextCandidate.isIncluded()) continue;
                for (IQualityModelProvider nextProvider : this.m_softwareSystem.getExtensions(IQualityModelProvider.class)) {
                    IModifiableFile nextModifiableFile;
                    if (!nextProvider.exports(nextModifiableFile = nextCandidate.getModifiableFile())) continue;
                    TFile nextExportFile = new TFile((File)qualityModelFile, nextProvider.getExportBaseDirectory() + "/" + nextModifiableFile.getIdentifyingPath()).getNormalizedFile();
                    nextExportFile.getParentFile().mkdirs();
                    nextProvider.exportFile(nextCandidate.getModifiableFile(), nextExportFile, result);
                    continue block2;
                }
            }
            TrueZipFacade.clear((TFile)qualityModelFile);
            result.addInfo((OperationResult.IMessageCause)QualityModelMessageCause.QUALITY_MODEL_EXPORTED_TO_FILE, "File: " + FileUtility.getIdentifyingPath((TFile)qualityModelFile));
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ex);
        }
        return result;
    }

    @Override
    public ImportQualityModel createQualityModel(TFile filePath) {
        assert (filePath != null) : "Parameter 'filePath' of method 'createQualityModel' must not be null";
        ArrayList<IModifiableFile> availableFiles = new ArrayList<IModifiableFile>();
        for (IQualityModelProvider nextProvider : this.m_softwareSystem.getExtensions(IQualityModelProvider.class)) {
            availableFiles.addAll(nextProvider.getAvailableFiles());
        }
        ImportQualityModel importQualityModel = new ImportQualityModel(availableFiles);
        this.collectCandidates(filePath, importQualityModel);
        return importQualityModel;
    }

    @Override
    public boolean isExportPossible() {
        for (IQualityModelProvider nextProvider : this.m_softwareSystem.getExtensions(IQualityModelProvider.class)) {
            if (nextProvider.getAvailableFiles().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

