/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.MetricsExtension;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerExecutionController;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateResultElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentIssueQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentSystemConditionsResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.DiffAgainstBaselineConditionsResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateResultElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IssueDiffAgainstBaselineConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.MetricValueDiffQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.MetricValueDiffQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilter;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilterInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilterResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResultContainer;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGates;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueDiffAgainstBaselineConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueQualityGateConditionInfo;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class QualityGateProvider
extends Extension
implements IQualityGateProvider {
    private static final Set<IIssueId> ISSUE_IDS_SUPPORTING_RELAXED = new HashSet<IIssueId>();
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;
    private final QualityGates m_qualityGates;

    static {
        ISSUE_IDS_SUPPORTING_RELAXED.add(CoreIssueId.THRESHOLD_VIOLATION);
        ISSUE_IDS_SUPPORTING_RELAXED.add(CoreIssueId.DUPLICATE_CODE_BLOCK);
        ISSUE_IDS_SUPPORTING_RELAXED.add(CoreIssueId.COMPONENT_CYCLE_GROUP);
        ISSUE_IDS_SUPPORTING_RELAXED.add(CoreIssueId.NAMESPACE_CYCLE_GROUP);
        ISSUE_IDS_SUPPORTING_RELAXED.add(CoreIssueId.DIRECTORY_CYCLE_GROUP);
        ISSUE_IDS_SUPPORTING_RELAXED.add(CoreIssueId.MODULE_CYCLE_GROUP);
        ISSUE_IDS_SUPPORTING_RELAXED.add(CoreIssueId.MODULE_CYCLE_GROUP);
    }

    public QualityGateProvider(Installation installation, SoftwareSystem softwareSystem) {
        assert (installation != null) : "Parameter 'installation' of method 'QualityGateExtension' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'QualityGateExtension' must not be null";
        this.m_installation = installation;
        this.m_softwareSystem = softwareSystem;
        this.m_qualityGates = softwareSystem.getUniqueExistingChild(Files.class).getQualityGatesDirectory();
    }

    protected final QualityGates getQualityGatesDirectory() {
        return this.m_qualityGates;
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    protected final Installation getInstallation() {
        return this.m_installation;
    }

    @Override
    public final boolean isRelaxedSupportedByIssueType(String issueType) {
        assert (issueType != null) : "Parameter 'issueType' of method 'isRelaxedSupportedByIssueType' must not be null";
        if (issueType.equalsIgnoreCase("Any")) {
            return true;
        }
        Predicate<IIssueId> predicate = issueType.indexOf(":") < 0 ? id -> id.getStandardName().equals(issueType) : id -> id.getQualifiedName().equals(issueType);
        return ISSUE_IDS_SUPPORTING_RELAXED.stream().anyMatch(predicate);
    }

    @Override
    public final ITextValidator getNameValidator() {
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput != null) {
                    newInput = newInput.trim();
                } else {
                    result.addError("Input not valid");
                }
                if (!FileUtility.isValidName((String)newInput)) {
                    result.addError("Input not valid");
                } else if (newInput.endsWith(CoreFileType.QUALITY_GATE.getDefaultExtension())) {
                    result.addError("Extension will be added automatically");
                } else if (result.inputModified()) {
                    for (QualityGate next : QualityGateProvider.this.m_qualityGates.getChildren(QualityGate.class)) {
                        if (!FileUtility.getFileNameWithoutExtension((TFile)next.getFile()).equalsIgnoreCase(newInput)) continue;
                        result.addError("Quality gate with name '" + newInput + "' already exists");
                        break;
                    }
                }
                return result;
            }
        };
    }

    @Override
    public final boolean isPossibleDirectory(DirectoryPath path) {
        assert (path != null) : "Parameter 'path' of method 'isPossibleDirectory' must not be null";
        return path == this.m_qualityGates;
    }

    @Override
    public final boolean mayBeAddedToCheck(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'mayBeAddedToCheck' must not be empty";
        for (Element next : elements) {
            if (!(next instanceof QualityGate)) {
                return false;
            }
            QualityGate file = (QualityGate)next;
            if (!file.isChecked() && file.canBeChecked()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean mayBeRemovedFromCheck(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'mayBeRemovedFromCheck' must not be empty";
        for (Element next : elements) {
            if (next instanceof QualityGate && ((QualityGate)next).isChecked()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final List<QualityGate> getAvailableQualityGates() {
        return new ArrayList<QualityGate>(this.getQualityGatesDirectory().getChildren(QualityGate.class));
    }

    @Override
    public final List<Severity> getSeveritiesForIssueType(String issueType) {
        List<Severity> all = Arrays.asList(Severity.values());
        if (issueType == null) {
            return all;
        }
        if (issueType.length() == 0 || issueType.equalsIgnoreCase("Any")) {
            return all;
        }
        for (IIssueId next : this.getAvailableIssueIds()) {
            if (!next.getQualifiedName().equalsIgnoreCase(issueType)) continue;
            return next.getSupportedSeverities();
        }
        return all;
    }

    private Set<IIssueId> getAvailableIssueIds() {
        return this.getInstallation().getAvailableIssueIds().stream().filter(issueId -> !issueId.previewOnly() && !issueId.getCategory().isGenerated()).collect(Collectors.toSet());
    }

    @Override
    public final IQualityGateConditionInfo getEditableInfoForCondition(IQualityGateCondition condition) {
        IQualityGateConditionInfo conditionInfo;
        assert (condition != null) : "Parameter 'condition' of method 'getEditableInfoForCondition' must not be null";
        if (condition instanceof CurrentIssueQualityGateCondition) {
            CurrentIssueQualityGateCondition currentCondition = (CurrentIssueQualityGateCondition)condition;
            conditionInfo = new CurrentIssueQualityGateConditionInfo(currentCondition.getIssueType(), currentCondition.getSeverityList(), currentCondition.getResolutionList(), currentCondition.getLimit(), currentCondition.getOperator());
        } else if (condition instanceof ThresholdIssueQualityGateCondition) {
            ThresholdIssueQualityGateCondition thresholdCondition = (ThresholdIssueQualityGateCondition)condition;
            conditionInfo = new ThresholdIssueQualityGateConditionInfo(thresholdCondition.getIssueType(), thresholdCondition.getSeverityList(), thresholdCondition.getResolutionList(), thresholdCondition.getMetricId(), thresholdCondition.getOperator(), thresholdCondition.getLimit());
        } else if (condition instanceof IssueDiffAgainstBaselineCondition) {
            IssueDiffAgainstBaselineCondition issueCondition = (IssueDiffAgainstBaselineCondition)condition;
            conditionInfo = issueCondition.getCheck() != null ? new IssueDiffAgainstBaselineConditionInfo(issueCondition.getIssueType(), issueCondition.getSeverityList(), issueCondition.getResolutionList(), issueCondition.getCheck()) : new IssueDiffAgainstBaselineConditionInfo(issueCondition.getIssueType(), issueCondition.getSeverityList(), issueCondition.getResolutionList());
        } else if (condition instanceof ThresholdIssueDiffAgainstBaselineCondition) {
            ThresholdIssueDiffAgainstBaselineCondition tc = (ThresholdIssueDiffAgainstBaselineCondition)condition;
            conditionInfo = new ThresholdIssueDiffAgainstBaselineConditionInfo(tc.getIssueType(), tc.getSeverityList(), tc.getResolutionList(), tc.getMetricId(), tc.getOperator(), tc.getDiffThreshold(), tc.getDiffThresholdRelative(), tc.getCheck());
        } else if (condition instanceof MetricValueDiffQualityGateCondition) {
            MetricValueDiffQualityGateCondition mc = (MetricValueDiffQualityGateCondition)condition;
            conditionInfo = new MetricValueDiffQualityGateConditionInfo(mc.getMetricId(), mc.getOperator(), mc.getDiffThreshold(), mc.getDiffThresholdRelative());
        } else {
            assert (false) : "Unsupported condition: " + condition.getClass().getCanonicalName();
            conditionInfo = null;
        }
        return conditionInfo;
    }

    @Override
    public final QualityGateExcludeFilterInfo getEditableInfoForFilter(QualityGateExcludeFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'getEditableInfoForFilter' must not be null";
        return new QualityGateExcludeFilterInfo(filter.getIssueType(), filter.getSeverityList(), filter.getResolutionList(), filter.getMetricId());
    }

    @Override
    public final List<IQualityGateElement> getDeletableElements(List<Element> elements) {
        assert (elements != null && elements.size() > 0) : "Parameter 'elements' of method 'getDeletableElements' must not be empty";
        ArrayList<IQualityGateElement> deletables = new ArrayList<IQualityGateElement>();
        for (Element next : elements) {
            assert (next.isValid()) : "Element not valid: " + next.getDebugInfo();
            if (!(next instanceof AbstractQualityGateElement)) continue;
            deletables.add((IQualityGateElement)((Object)next));
        }
        return deletables;
    }

    @Override
    public final String getPrintoutFor(QualityGate qualityGate) {
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'getPrintoutFor' must not be null";
        StringBuilder printout = new StringBuilder();
        IQualityGateResultElement resultElement = qualityGate.getResultElement();
        QualityGateResult result = (QualityGateResult)resultElement;
        printout.append("[").append(result.getResultStatus().getPresentationName()).append("]");
        printout.append(" Quality Gate '").append(qualityGate.getShortName()).append("'");
        this.appendMatchingElementsResult(qualityGate, printout, result.getUniqueChild(CurrentSystemConditionsResult.class));
        this.appendMatchingElementsResult(qualityGate, printout, result.getUniqueChild(DiffAgainstBaselineConditionsResult.class));
        return printout.toString();
    }

    private void appendMatchingElementsResult(QualityGate qualityGate, StringBuilder printout, QualityGateResultContainer<?> conditionsResult) {
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'appendMatchingElementsResult' must not be null";
        assert (printout != null) : "Parameter 'printout' of method 'appendMatchingElementsResult' must not be null";
        String tab = "    ";
        if (conditionsResult != null && conditionsResult.hasChildren()) {
            printout.append('\n');
            printout.append("    ").append("[").append(conditionsResult.getResultStatus().getPresentationName()).append("] ").append(conditionsResult.getPresentationName(false)).append(":");
            for (AbstractQualityGateResultElement matchResult : conditionsResult.getChildren(AbstractQualityGateResultElement.class)) {
                NamedElement matchingElement = matchResult.getQualityGateElement();
                printout.append('\n').append("    ").append("    ");
                if (matchResult instanceof QualityGateExcludeFilterResult) {
                    printout.append("Filter ");
                } else {
                    printout.append("[").append(matchResult.getResultStatus().getPresentationName()).append("]");
                    printout.append(" Condition ");
                }
                printout.append("\"").append(matchingElement.getPresentationName(false)).append("\"");
                printout.append(" [").append(matchResult.getInformation()).append("]");
            }
        }
    }

    @Override
    public final StrictPair<Set<IIssueId>, Set<IMetricDescriptor>> getAvailableIssueIdsAndMetricDescriptors(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getAvailableIssueIdsAndMetricDescriptors' must not be null";
        workerContext.setNumberOfSteps(2, new int[]{50, 50});
        workerContext.beginSubTask("Waiting for analyzers to complete...");
        IAnalyzerExecutionController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerExecutionController.class);
        analyzerExtension.waitForAnalyzersToComplete(workerContext);
        workerContext.endSubTask();
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        workerContext.beginSubTask("Collecting information about available metrics and issues...");
        Set<IIssueId> issueIds = this.getAvailableIssueIds();
        Set<IMetricDescriptor> metricDescriptors = this.getInstallation().getExtension(MetricsExtension.class).getAvailableMetricDescriptors();
        workerContext.endSubTask();
        return new StrictPair(issueIds, metricDescriptors);
    }
}

