/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.MoveRenameElementCheck;
import com.hello2morrow.sonargraph.core.controller.system.RefactoringUtilities;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElementContainer;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ICloneable;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.INamedElementNode;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.IRefactoringTarget;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.refactoring.DeletionVisitor;
import com.hello2morrow.sonargraph.core.model.refactoring.ICollisionValidator;
import com.hello2morrow.sonargraph.core.model.refactoring.IRefactoringAdapter;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRefactoringData;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringData;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringInfo;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringData;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringStateHandler;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.core.model.refactoring.RenameRefactoringData;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LanguageProviderRefactoringAdapter
implements IRefactoringAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageProviderRefactoringAdapter.class);

    protected LanguageProviderRefactoringAdapter() {
    }

    protected abstract Language getLanguage();

    protected abstract Class<? extends Module> getModuleClass();

    protected abstract Map<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>> getRefactorables();

    protected Predicate<IRefactorable> getRefactorableInclusionPredicate() {
        return r -> true;
    }

    protected abstract NamespaceFragment createNamespaceFragment(IModelServiceProvider var1, NamedElement var2, String var3);

    protected abstract DirectoryFragment createDirectoryFragment(IModelServiceProvider var1, NamedElement var2, String var3);

    protected abstract ITextValidator getRenameRefactoringValidator(NamedElement var1);

    protected abstract ITextValidator getMoveToParentNameRefactoringValidator(List<NamedElement> var1, MoveRenameRefactoringElementType var2);

    protected abstract Set<NamedElement> rename(IModelServiceProvider var1, MoveRenameRefactoringElementType var2, List<NamedElement> var3, String var4, RefactoringStateHandler var5, StatusInfo var6);

    protected abstract Set<NamedElement> moveRename(IModelServiceProvider var1, MoveRenameRefactoringElementType var2, List<NamedElement> var3, RootDirectoryPath var4, String var5, String var6, RefactoringStateHandler var7, StatusInfo var8);

    protected abstract Set<NamedElement> move(IModelServiceProvider var1, MoveRenameRefactoringElementType var2, List<NamedElement> var3, RootDirectoryPath var4, String var5, RefactoringStateHandler var6, StatusInfo var7);

    protected NamedElement.IFilter getTargetRootDirectoryFilter() {
        return new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                return true;
            }
        };
    }

    protected DeletionVisitor createDeletionVisitor(RefactoringStateHandler refactoringStateHandler, boolean includeRecursiveElementChildren) {
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'createDeletionVisitor' must not be null";
        return new DeletionVisitor(refactoringStateHandler, includeRecursiveElementChildren);
    }

    protected Object checkAdditionalCollisions(MoveRenameRefactoringElementType refactoringElementType, List<NamedElement> namedElements, RootDirectoryPath targetDirectory, String targetParentName, String targetName, Set<String> collidingInfo, Object cache) {
        assert (refactoringElementType != null) : "Parameter 'refactoringElementType' of method 'checkAdditionalCollisions' must not be null";
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'checkAdditionalCollisions' must not be empty";
        assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'checkAdditionalCollisions' must not be null";
        assert (targetParentName != null) : "Parameter 'targetParentName' of method 'checkAdditionalCollisions' must not be null";
        assert (targetName != null) : "Parameter 'targetName' of method 'checkAdditionalCollisions' must not be null";
        assert (collidingInfo != null) : "Parameter 'collidingInfo' of method 'checkAdditionalCollisions' must not be null";
        return null;
    }

    private Map<Module, List<RootDirectoryPath>> getAvailableTargetRootDirectories(Workspace workspace) {
        assert (workspace != null) : "Parameter 'workspace' of method 'getAvailableTargetRootDirectories' must not be null";
        NamedElement.IFilter filter = this.getTargetRootDirectoryFilter();
        LinkedHashMap<Module, List<RootDirectoryPath>> availableTargetRootDirectories = new LinkedHashMap<Module, List<RootDirectoryPath>>();
        for (Module module : workspace.getChildren(this.getModuleClass())) {
            List<RootDirectoryPath> nextRootDirectoryPaths = module.getChildren(filter, RootDirectoryPath.class);
            if (nextRootDirectoryPaths.isEmpty()) continue;
            availableTargetRootDirectories.put(module, nextRootDirectoryPaths);
        }
        assert (!availableTargetRootDirectories.isEmpty()) : "availableTargetRootDirectories must not be empty";
        return availableTargetRootDirectories;
    }

    protected final IRefactoringTarget getMoveToParent(RootDirectoryPath rootDirectory, String parentName) {
        assert (rootDirectory != null) : "Parameter 'rootDirectory' of method 'getMoveToParent' must not be null";
        assert (parentName != null) : "Parameter 'parentName' of method 'getMoveToParent' must not be null";
        if (!parentName.isEmpty()) {
            Language language = this.getLanguage();
            if (language.namespaceAndDirectoryStructureMatches()) {
                return RefactoringUtilities.findRefactoringTarget(rootDirectory, parentName, language.getNamespaceSeparator());
            }
            if (".".equals(parentName)) {
                return rootDirectory;
            }
            return RefactoringUtilities.findRefactoringTarget(rootDirectory, parentName.startsWith("./") ? parentName.substring("./".length()) : parentName, "/");
        }
        return rootDirectory;
    }

    protected final String getRelevantRenameName(NamedElement element) {
        String name;
        assert (element != null && element instanceof IRefactorable) : "Unexpected class in method 'getRelevantRenameName': " + String.valueOf(element);
        LOGGER.debug("Get relevant rename name of '" + element.getPresentationName(true) + "' [" + element.getClass().getSimpleName() + "']");
        if (element instanceof SourceFile) {
            String shortName = element.getShortName();
            int pos = shortName.lastIndexOf(46);
            assert (pos != -1) : "Source file extension expected: " + shortName;
            name = shortName.substring(0, pos);
        } else {
            name = element.getRawPresentationName(true);
        }
        LOGGER.debug("Get relevant rename name of '" + element.getPresentationName(true) + "' [" + element.getClass().getSimpleName() + "'] - done: " + name);
        return name;
    }

    @Override
    public final String getTargetElementName(String name, String newName, MoveRenameRefactoringElementType elementType) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getRenamedTargetElementName' must not be empty";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'getRenamedTargetElementName' must not be empty";
        assert (elementType != null) : "Parameter 'elementType' of method 'getRenamedTargetElementName' must not be null";
        LOGGER.debug("Get target element name [name='" + name + "', newName='" + newName + "', elementType='" + elementType.getPresentationName() + "']");
        String targetElementName = switch (elementType) {
            case MoveRenameRefactoringElementType.COMPONENT -> {
                int pos = name.lastIndexOf(46);
                yield pos != -1 ? newName + name.substring(pos) : newName;
            }
            case MoveRenameRefactoringElementType.ELEMENT, MoveRenameRefactoringElementType.NAMESPACE, MoveRenameRefactoringElementType.DIRECTORY -> newName;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unhandled refactoring element type: " + String.valueOf((Object)elementType)));
                }
                yield newName;
            }
        };
        LOGGER.debug("Get target element name [name='" + name + "', newName='" + newName + "', elementType='" + elementType.getPresentationName() + "'] - done: " + targetElementName);
        return targetElementName;
    }

    @Override
    public final String getMoveToParentFqName(String name, MoveRenameRefactoringElementType elementType) {
        assert (name != null) : "Parameter 'name' of method 'getMoveToParentFqName' must not be null";
        assert (elementType != null) : "Parameter 'elementType' of method 'getMoveToParentFqName' must not be null";
        LOGGER.debug("Get move to parent fq name [name='" + name + "', elementType='" + elementType.getPresentationName() + "']");
        String moveToParentFqName = this.getLanguage().namespaceAndDirectoryStructureMatches() ? name.replace('.', ':') : name.replace('/', ':');
        LOGGER.debug("Get move to parent fq name [name='" + name + "', elementType='" + elementType.getPresentationName() + "'] - done: " + moveToParentFqName);
        return moveToParentFqName;
    }

    private NamedElement getExisting(NamedElement parent, Class<? extends NamedElement> clazzToBeRefactored, String newName) {
        assert (parent != null) : "Parameter 'parent' of method 'getExisting' must not be null";
        assert (clazzToBeRefactored != null) : "Parameter 'clazzToBeRefactored' of method 'getExisting' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'getExisting' must not be empty";
        for (NamedElement namedElement : parent.getChildren(clazzToBeRefactored)) {
            String nextExisting = this.getRelevantRenameName(namedElement);
            if (!nextExisting.equals(newName)) continue;
            return namedElement;
        }
        return null;
    }

    private void addCollidingTargetInfo(StatusInfo statusInfo, NamedElement targetParent, String targetName) {
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'addCollidingTargetInfo' must not be null";
        assert (targetParent != null) : "Parameter 'targetParent' of method 'addCollidingTargetInfo' must not be null";
        assert (targetName != null && targetName.length() > 0) : "Parameter 'targetName' of method 'addCollidingTargetInfo' must not be empty";
        statusInfo.addCollisionInfo("'" + targetName + "' in '" + targetParent.getName() + "' already exists");
    }

    protected final boolean checkCollisions(List<NamedElement> namedElements, final StatusInfo statusInfo, NamedElement inParent, String newName, MoveRenameRefactoringElementType elementType, NamedElement target) {
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'checkCollissions' must not be empty";
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'checkCollisions' must not be null";
        assert (elementType != null) : "Parameter 'elementType' of method 'checkCollisions' must not be null";
        LOGGER.debug("Check collisions for '" + String.valueOf((Object)elementType) + "'");
        boolean success = MoveRenameElementCheck.check(namedElements, target, new MoveRenameElementCheck.IConsumer(){

            @Override
            public void elementsInvalid(String info) {
                if (!($assertionsDisabled || info != null && info.length() > 0)) {
                    throw new AssertionError((Object)"Parameter 'info' of method 'elementsInvalid' must not be empty");
                }
                statusInfo.elementsInvalidInfo(info);
            }
        });
        if (success && (inParent != null || newName != null)) {
            if (newName == null && (elementType == MoveRenameRefactoringElementType.COMPONENT || elementType == MoveRenameRefactoringElementType.ELEMENT)) {
                THashSet names = new THashSet();
                for (NamedElement nextNamedElement : namedElements) {
                    String nextRelevantRenameName = this.getRelevantRenameName(nextNamedElement);
                    if (names.add(nextRelevantRenameName)) continue;
                    statusInfo.addCollisionInfo("'" + nextRelevantRenameName + "' more than once found in to be refactored elements");
                    success = false;
                }
            }
            if (elementType == MoveRenameRefactoringElementType.ELEMENT) {
                if (this.getLanguage().namespaceAndDirectoryStructureMatches()) {
                    for (NamedElement nextNamedElement : namedElements) {
                        String string = nextNameToCheck = newName != null ? newName : this.getRelevantRenameName(nextNamedElement);
                        assert (nextNameToCheck.length() > 0) : "'nextNameToCheck' of method 'checkCollisions' must not be empty";
                        NamedElement namedElement = nextParentToCheck = inParent != null ? inParent : (NamedElement)nextNamedElement.getParent(RefactoringUtilities.getPhysicalRecursiveComponentParentClass(this.getLanguage()), new Class[0]);
                        if (nextParentToCheck == null) {
                            nextParentToCheck = nextNamedElement.getParent(RootDirectoryPath.class, new Class[0]);
                        }
                        assert (nextParentToCheck != null) : "'nextParentToCheck' of method 'checkCollisions' must not be null";
                        for (IComponent nextComponent : nextParentToCheck.getChildren(IComponent.class)) {
                            NamedElement nextExistingTarget = this.getExisting(nextComponent.getNamedElement(), nextNamedElement.getClass(), nextNameToCheck);
                            if (nextExistingTarget == null) continue;
                            this.addCollidingTargetInfo(statusInfo, nextParentToCheck, nextNameToCheck);
                            success = false;
                        }
                    }
                } else {
                    for (NamedElement nextNamedElement : namedElements) {
                        String string = nextNameToCheck = newName != null ? newName : this.getRelevantRenameName(nextNamedElement);
                        assert (nextNameToCheck.length() > 0) : "'nextNameToCheck' of method 'checkCollisions' must not be empty";
                        nextParentToCheck = inParent != null ? inParent : nextNamedElement.getParent();
                        NamedElement nextExistingTarget = this.getExisting(nextParentToCheck, nextNamedElement.getClass(), nextNameToCheck);
                        if (nextExistingTarget == null) continue;
                        this.addCollidingTargetInfo(statusInfo, nextParentToCheck, nextNameToCheck);
                        success = false;
                    }
                }
            } else if (elementType == MoveRenameRefactoringElementType.COMPONENT) {
                for (NamedElement nextNamedElement : namedElements) {
                    String string = nextNameToCheck = newName != null ? newName : this.getRelevantRenameName(nextNamedElement);
                    assert (nextNameToCheck.length() > 0) : "'nextNameToCheck' of method 'checkCollisions' must not be empty";
                    nextParentToCheck = inParent != null ? inParent : nextNamedElement.getParent();
                    NamedElement nextExistingTarget = this.getExisting(nextParentToCheck, nextNamedElement.getClass(), nextNameToCheck);
                    if (nextExistingTarget == null) continue;
                    this.addCollidingTargetInfo(statusInfo, nextParentToCheck, nextNameToCheck);
                    success = false;
                }
            } else {
                assert (elementType == MoveRenameRefactoringElementType.DIRECTORY || elementType == MoveRenameRefactoringElementType.NAMESPACE) : "Unexpected refactoring element type in checkCollisions(): " + String.valueOf((Object)elementType);
                for (NamedElement nextNamedElement : namedElements) {
                    String string = nextNameToCheck = newName != null ? newName : this.getRelevantRenameName(nextNamedElement);
                    assert (nextNameToCheck.length() > 0) : "'nextNameToCheck' of method 'checkCollisions' must not be empty";
                    nextParentToCheck = inParent != null ? inParent : nextNamedElement.getParent();
                    NamedElement nextExistingTarget = this.getExisting(nextParentToCheck, nextNamedElement.getClass(), nextNameToCheck);
                    if (nextExistingTarget == null) continue;
                    if (nextExistingTarget == nextNamedElement) {
                        this.addCollidingTargetInfo(statusInfo, nextParentToCheck, nextNameToCheck);
                        success = false;
                        continue;
                    }
                    if (this.performCollisionCheckRecursively(nextNamedElement, nextExistingTarget, statusInfo)) continue;
                    success = false;
                }
            }
        }
        LOGGER.debug("Check collisions for '" + String.valueOf((Object)elementType) + "' - done: " + String.valueOf(statusInfo));
        return success;
    }

    final boolean containsElementWithCollidingRelevantName(List<NamedElement> toBeMovedRenamed) {
        assert (toBeMovedRenamed != null && !toBeMovedRenamed.isEmpty()) : "Parameter 'namedElements' of method 'containsElementWithCollidingRelevantName' must not be empty";
        THashSet names = new THashSet();
        for (NamedElement nextNamedElement : toBeMovedRenamed) {
            String nextRelevantRenameName = this.getRelevantRenameName(nextNamedElement);
            if (names.add(nextRelevantRenameName)) continue;
            return true;
        }
        return false;
    }

    protected final boolean createNewPhysicalRecursiveTarget(PhysicalRecursiveElement toBeMoved, String moveToParentName) {
        assert (toBeMoved != null) : "Parameter 'toBeMoved' of method 'createNewRecursiveTarget' must not be null";
        assert (moveToParentName != null) : "Parameter 'moveToParentName' of method 'createNewRecursiveTarget' must not be null";
        return moveToParentName.startsWith(toBeMoved.getName());
    }

    private void performCollisionCheckRecursively(NamedElement source, NamedElement target, Set<String> collidingInfo, MoveRenameRefactoringElementType elementType) {
        assert (source != null) : "Parameter 'source' of method 'performCollisionCheckRecursively' must not be null";
        assert (target != null) : "Parameter 'target' of method 'performCollisionCheckRecursively' must not be null";
        assert (source != target) : "Same instances";
        assert (collidingInfo != null) : "Parameter 'collidingInfo' of method 'performCollisionCheckRecursively' must not be null";
        assert (elementType != null) : "Parameter 'elementType' of method 'performCollisionCheckRecursively' must not be null";
        THashMap existingRelevantNameToComponent = new THashMap();
        for (IComponent nextTargetComponent : target.getChildren(IComponent.class)) {
            NamedElement nextTargetComponentAsNamedElement = nextTargetComponent.getNamedElement();
            existingRelevantNameToComponent.put(this.getRelevantRenameName(nextTargetComponentAsNamedElement), nextTargetComponentAsNamedElement);
        }
        for (IComponent nextSourceComponent : source.getChildren(IComponent.class)) {
            String nextRelevantSourceComponentName = this.getRelevantRenameName(nextSourceComponent.getNamedElement());
            NamedElement nextCollidingTargetComponentAsNamedElement = (NamedElement)existingRelevantNameToComponent.get(nextRelevantSourceComponentName);
            if (nextCollidingTargetComponentAsNamedElement == null) continue;
            collidingInfo.add("Colliding target '" + nextCollidingTargetComponentAsNamedElement.getName() + "'");
        }
        THashMap nameToPhysicalRecursiveElementOfTarget = new THashMap();
        for (PhysicalRecursiveElement next : target.getChildren(PhysicalRecursiveElement.class)) {
            nameToPhysicalRecursiveElementOfTarget.put(this.getRelevantRenameName(next), next);
        }
        for (PhysicalRecursiveElement next : source.getChildren(PhysicalRecursiveElement.class)) {
            String nextName = this.getRelevantRenameName(next);
            PhysicalRecursiveElement nextCollidingInTarget = (PhysicalRecursiveElement)nameToPhysicalRecursiveElementOfTarget.get(nextName);
            if (nextCollidingInTarget == null) continue;
            this.performCollisionCheckRecursively(next, nextCollidingInTarget, collidingInfo, elementType);
        }
    }

    private boolean performCollisionCheckRecursively(NamedElement source, NamedElement target, StatusInfo statusInfo) {
        NamedElement nextComponentAsNamedElement;
        assert (source != null) : "Parameter 'source' of method 'performCollisionCheckRecursively' must not be null";
        assert (target != null) : "Parameter 'target' of method 'performCollisionCheckRecursively' must not be null";
        assert (source != target) : "Same instances";
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'performCollisionCheckRecursively' must not be null";
        boolean success = true;
        THashMap existingComponents = new THashMap();
        for (IComponent nextComponent : target.getChildren(IComponent.class)) {
            nextComponentAsNamedElement = nextComponent.getNamedElement();
            existingComponents.put(this.getRelevantRenameName(nextComponentAsNamedElement), nextComponentAsNamedElement);
        }
        for (IComponent nextComponent : source.getChildren(IComponent.class)) {
            nextComponentAsNamedElement = nextComponent.getNamedElement();
            String nextNameToCheck = this.getRelevantRenameName(nextComponentAsNamedElement);
            NamedElement nextExistingColliding = (NamedElement)existingComponents.get(nextNameToCheck);
            if (nextExistingColliding == null) continue;
            this.addCollidingTargetInfo(statusInfo, target, nextNameToCheck);
            success = false;
        }
        THashMap nameToPhysicalRecursiveElementOfTarget = new THashMap();
        for (PhysicalRecursiveElement next : target.getChildren(PhysicalRecursiveElement.class)) {
            nameToPhysicalRecursiveElementOfTarget.put(this.getRelevantRenameName(next), next);
        }
        for (PhysicalRecursiveElement next : source.getChildren(PhysicalRecursiveElement.class)) {
            String nextName = this.getRelevantRenameName(next);
            PhysicalRecursiveElement nextCollidingInTarget = (PhysicalRecursiveElement)nameToPhysicalRecursiveElementOfTarget.get(nextName);
            if (nextCollidingInTarget == null || this.performCollisionCheckRecursively(next, nextCollidingInTarget, statusInfo)) continue;
            success = false;
        }
        return success;
    }

    protected final <T extends PhysicalRecursiveElement> T findByRelevantRenameName(final String name, NamedElement in, Class<T> clazz) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'findByRelevantRenameName' must not be empty";
        assert (in != null) : "Parameter 'in' of method 'findByRelevantRenameName' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'findByRelevantRenameName' must not be null";
        return (T)((PhysicalRecursiveElement)in.getFirstChild(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!$assertionsDisabled && namedElement == null) {
                    throw new AssertionError((Object)"Parameter 'namedElement' of method 'accept' must not be null");
                }
                return LanguageProviderRefactoringAdapter.this.getRelevantRenameName(namedElement).equals(name);
            }
        }, clazz));
    }

    protected final <T extends PhysicalRecursiveElement> void moveChildrenTo(T source, ICloneable toNewParent, RefactoringStateHandler refactoringStateHandler, Class<T> clazz) {
        assert (source != null) : "Parameter 'sourcePackage' of method 'moveChildrenTo' must not be null";
        assert (toNewParent != null) : "Parameter 'toNewParent' of method 'moveChildrenTo' must not be null";
        assert (source != toNewParent.getNamedElement()) : "Same instances";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'moveChildrenTo' must not be null";
        THashMap sourceToExistingTarget = new THashMap();
        for (PhysicalRecursiveElement physicalRecursiveElement : ((NamedElement)source).getChildren(clazz)) {
            T nextExistingTargetPackage = this.findByRelevantRenameName(this.getRelevantRenameName(physicalRecursiveElement), toNewParent.getNamedElement(), clazz);
            if (nextExistingTargetPackage != null) {
                sourceToExistingTarget.put(physicalRecursiveElement, nextExistingTargetPackage);
                continue;
            }
            refactoringStateHandler.moveToNewParent((ICloneable)source, physicalRecursiveElement, toNewParent);
        }
        for (IComponent iComponent : ((NamedElement)source).getChildren(IComponent.class)) {
            NamedElement nextComponentAsNamedElement = iComponent.getNamedElement();
            assert (nextComponentAsNamedElement != null && nextComponentAsNamedElement instanceof IRefactorable) : "Unexpected class in method 'moveChildrenTo': " + String.valueOf(nextComponentAsNamedElement);
            refactoringStateHandler.moveToNewParent((ICloneable)source, (IRefactorable)((Object)nextComponentAsNamedElement), toNewParent);
        }
        if (!sourceToExistingTarget.isEmpty()) {
            for (Map.Entry entry : sourceToExistingTarget.entrySet()) {
                this.moveChildrenTo((PhysicalRecursiveElement)entry.getKey(), (ICloneable)entry.getValue(), refactoringStateHandler, clazz);
            }
        }
    }

    protected final NamedElement getOrCreateComponentParent(IModelServiceProvider msp, RootDirectoryPath underneathTargetRootDirectory, String recursiveParentName, final RefactoringStateHandler refactoringStateHandler, final PhysicalRecursiveElement skip) {
        assert (msp != null) : "Parameter 'msp' of method 'getOrCreateComponentParent' must not be null";
        assert (underneathTargetRootDirectory != null) : "Parameter 'underneathTargetRootDirectory' of method 'getOrCreateComponentParent' must not be null";
        assert (recursiveParentName != null) : "Parameter 'recursiveParentName' of method 'getOrCreateComponentParent' must not be null";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'getOrCreateComponentParent' must not be null";
        NamedElement parent = this.getLanguage().namespaceAndDirectoryStructureMatches() ? NamespaceFragment.getNamespaceFragmentOrSpecifiedParent(msp, underneathTargetRootDirectory, recursiveParentName, new NamespaceFragment.INamespaceFragmentCreator(){

            @Override
            public NamespaceFragment create(IModelServiceProvider msp, NamedElement parent, String name) {
                if (!($assertionsDisabled || parent != null && parent instanceof ICloneable)) {
                    throw new AssertionError((Object)("Unexpected class in method 'create': " + String.valueOf(parent)));
                }
                NamedElement useAsParent = parent;
                if (!refactoringStateHandler.hasBeenAddedAsCreated(parent)) {
                    ICloneable clone = refactoringStateHandler.getModifiableVersionOf((ICloneable)((Object)parent));
                    useAsParent = clone.getNamedElement();
                }
                NamespaceFragment created = LanguageProviderRefactoringAdapter.this.createNamespaceFragment(msp, useAsParent, name);
                refactoringStateHandler.addCreated(created);
                return created;
            }

            @Override
            public boolean accept(NamespaceFragment found) {
                if (!$assertionsDisabled && found == null) {
                    throw new AssertionError((Object)"Parameter 'found' of method 'accept' must not be null");
                }
                return skip == null ? true : skip.getRepresentative() != found.getRepresentative();
            }
        }) : DirectoryFragment.getDirectoryFragmentOrSpecifiedParent(msp, underneathTargetRootDirectory, recursiveParentName, new DirectoryFragment.IDirectoryFragmentCreator(){

            @Override
            public DirectoryFragment create(IModelServiceProvider msp, NamedElement parent, String name) {
                if (!($assertionsDisabled || parent != null && parent instanceof ICloneable)) {
                    throw new AssertionError((Object)("Unexpected class in method 'create': " + String.valueOf(parent)));
                }
                NamedElement useAsParent = parent;
                if (!refactoringStateHandler.hasBeenAddedAsCreated(parent)) {
                    ICloneable clone = refactoringStateHandler.getModifiableVersionOf((ICloneable)((Object)parent));
                    useAsParent = clone.getNamedElement();
                }
                DirectoryFragment created = LanguageProviderRefactoringAdapter.this.createDirectoryFragment(msp, useAsParent, name);
                refactoringStateHandler.addCreated(created);
                return created;
            }

            @Override
            public boolean accept(DirectoryFragment found) {
                if (!$assertionsDisabled && found == null) {
                    throw new AssertionError((Object)"Parameter 'found' of method 'accept' must not be null");
                }
                return skip == null ? true : skip.getRepresentative() != found.getRepresentative();
            }
        }).getNamedElement();
        assert (parent != null && parent instanceof ICloneable) : "Unexpected class in method 'getOrCreateComponentParent': " + String.valueOf(parent);
        return parent;
    }

    protected final NamedElement getOrCreateTypeParent(IModelServiceProvider msp, ICloneable underneathParent, String recursiveParentName, final RefactoringStateHandler refactoringStateHandler, final PhysicalRecursiveElement skip) {
        assert (msp != null) : "Parameter 'msp' of method 'getOrCreateTypeParent' must not be null";
        assert (underneathParent != null) : "Parameter 'underneathParent' of method 'getOrCreateTypeParent' must not be null";
        assert (recursiveParentName != null) : "Parameter 'typeParentName' of method 'getOrCreateTypeParent' must not be null";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'getOrCreateTypeParent' must not be null";
        NamedElement parent = NamespaceFragment.getNamespaceFragmentOrSpecifiedParent(msp, underneathParent.getNamedElement(), recursiveParentName, new NamespaceFragment.INamespaceFragmentCreator(){

            @Override
            public NamespaceFragment create(IModelServiceProvider msp, NamedElement parent, String name) {
                if (!($assertionsDisabled || parent != null && parent instanceof ICloneable)) {
                    throw new AssertionError((Object)("Unexpected class in method 'create': " + String.valueOf(parent)));
                }
                NamedElement useAsParent = parent;
                if (!refactoringStateHandler.hasBeenAddedAsCreated(parent)) {
                    ICloneable clone = refactoringStateHandler.getModifiableVersionOf((ICloneable)((Object)parent));
                    useAsParent = clone.getNamedElement();
                }
                NamespaceFragment created = LanguageProviderRefactoringAdapter.this.createNamespaceFragment(msp, useAsParent, name);
                refactoringStateHandler.addCreated(created);
                return created;
            }

            @Override
            public boolean accept(NamespaceFragment found) {
                if (!$assertionsDisabled && found == null) {
                    throw new AssertionError((Object)"Parameter 'found' of method 'accept' must not be null");
                }
                return skip == null ? true : skip.getRepresentative() != found.getRepresentative();
            }
        });
        assert (parent != null && parent instanceof ICloneable) : "Unexpected class in method 'getOrCreateTypeParent': " + String.valueOf(parent);
        return parent;
    }

    public final IRefactoringTarget isPossibleMoveRefactoringTarget(List<NamedElement> toBeMovedRenamed, Element potentialTarget, Map<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>> refactorableToPossibleMoveRefactoringTargets, final Set<String> collidingInfo) {
        assert (toBeMovedRenamed != null && !toBeMovedRenamed.isEmpty()) : "Parameter 'toBeMovedRenamed' of method 'isPossibleMoveRefactoringTarget' must not be empty";
        assert (potentialTarget != null) : "Parameter 'potentialTarget' of method 'isPossibleMoveRefactoringTarget' must not be null";
        assert (refactorableToPossibleMoveRefactoringTargets != null) : "Parameter 'refactorableToPossibleMoveRefactoringTargets' of method 'isPossibleMoveRefactoringTarget' must not be null";
        if (potentialTarget instanceof INamedElementNode) {
            potentialTarget = ((INamedElementNode)((Object)potentialTarget)).getNamedElement();
        }
        if (!(potentialTarget instanceof NamedElement) || potentialTarget.isExternal()) {
            return null;
        }
        IDomainRoot.Domain domain = ((NamedElement)potentialTarget).getDomain();
        if (domain == null) {
            return null;
        }
        IRefactoringTarget refactoringTarget = null;
        switch (domain) {
            case LOGICAL_SYSTEM_SCOPE: 
            case LOGICAL_MODULE_SCOPE: 
            case ARCHITECTURE_LOGICAL: {
                break;
            }
            case ARCHITECTURE_PHYSICAL: {
                Object namedElementInPhysicalModel;
                if (!(potentialTarget instanceof ArchitectureElementContainer) || !((namedElementInPhysicalModel = ((ArchitectureElementContainer)potentialTarget).getRepresentedElement()) instanceof IRefactoringTarget)) break;
                refactoringTarget = (IRefactoringTarget)namedElementInPhysicalModel;
                break;
            }
            case PHYSICAL: {
                if (!(potentialTarget instanceof IRefactoringTarget)) break;
                refactoringTarget = (IRefactoringTarget)((Object)potentialTarget);
                break;
            }
            default: {
                assert (false) : "Unhandled domain: " + String.valueOf((Object)domain);
                break;
            }
        }
        if (refactoringTarget != null) {
            for (NamedElement sourceElement : toBeMovedRenamed) {
                Class<?> clazz = sourceElement.getClass();
                assert (IRefactorable.class.isAssignableFrom(clazz)) : "Unexpected class " + String.valueOf(clazz);
                boolean isPotentialTargetForElement = false;
                for (Class<? extends IRefactoringTarget> targetClass : refactorableToPossibleMoveRefactoringTargets.get(clazz)) {
                    if (targetClass == null || !targetClass.isAssignableFrom(refactoringTarget.getClass())) continue;
                    isPotentialTargetForElement = true;
                    break;
                }
                if (isPotentialTargetForElement) continue;
                return null;
            }
            if (!MoveRenameElementCheck.check(toBeMovedRenamed, refactoringTarget.getNamedElement(), new MoveRenameElementCheck.IConsumer(){

                @Override
                public void elementsInvalid(String info) {
                    if (!($assertionsDisabled || info != null && info.length() > 0)) {
                        throw new AssertionError((Object)"Parameter 'info' of method 'elementsInvalid' must not be empty");
                    }
                    if (collidingInfo != null) {
                        collidingInfo.add(info);
                    }
                }
            })) {
                return null;
            }
            return refactoringTarget;
        }
        return null;
    }

    private ICollisionValidator getCollsionValidator(final MoveRenameRefactoringElementType elementType, final List<NamedElement> toBeMovedRenamed, final Map<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>> refactorableToPossibleMoveRefactoringTargets) {
        assert (elementType != null) : "Parameter 'elementType' of method 'getCollsionValidator' must not be null";
        assert (toBeMovedRenamed != null && !toBeMovedRenamed.isEmpty()) : "Parameter 'toBeMovedRenamed' of method 'getCollsionValidator' must not be empty";
        return new ICollisionValidator(){

            @Override
            public ValidationResult isValid(RootDirectoryPath targetDirectory, String targetParentName, String targetName) {
                if (!$assertionsDisabled && targetDirectory == null) {
                    throw new AssertionError((Object)"Parameter 'targetDirectory' of method 'isValid' must not be null");
                }
                if (!$assertionsDisabled && targetParentName == null) {
                    throw new AssertionError((Object)"Parameter 'targetParentName' of method 'isValid' must not be null");
                }
                if (!$assertionsDisabled && targetName == null) {
                    throw new AssertionError((Object)"Parameter 'targetName' of method 'isValid' must not be null");
                }
                ValidationResult validationResult = new ValidationResult(true);
                IRefactoringTarget targetParent = LanguageProviderRefactoringAdapter.this.getMoveToParent(targetDirectory, targetParentName);
                if (targetParent != null) {
                    final TreeSet<String> collidingInfo = new TreeSet<String>();
                    switch (elementType) {
                        case ELEMENT: {
                            if (LanguageProviderRefactoringAdapter.this.getLanguage().namespaceAndDirectoryStructureMatches()) {
                                for (IComponent nextComponent : targetParent.getNamedElement().getChildren(IComponent.class)) {
                                    for (NamedElement next : toBeMovedRenamed) {
                                        NamedElement nextExistingTarget = LanguageProviderRefactoringAdapter.this.getExisting(nextComponent.getNamedElement(), next.getClass(), targetName);
                                        if (nextExistingTarget == null) continue;
                                        collidingInfo.add("Colliding target type '" + targetName + "'");
                                    }
                                }
                            } else {
                                for (NamedElement next : toBeMovedRenamed) {
                                    NamedElement nextExistingTarget = LanguageProviderRefactoringAdapter.this.getExisting(targetParent.getNamedElement(), next.getClass(), targetName);
                                    if (nextExistingTarget == null) continue;
                                    collidingInfo.add("Colliding target type '" + targetName + "'");
                                }
                            }
                            break;
                        }
                        case COMPONENT: {
                            for (NamedElement next : toBeMovedRenamed) {
                                NamedElement nextExistingTarget = LanguageProviderRefactoringAdapter.this.getExisting(targetParent.getNamedElement(), next.getClass(), targetName);
                                if (nextExistingTarget == null) continue;
                                collidingInfo.add("Colliding target component '" + targetName + "'");
                            }
                            break;
                        }
                        case NAMESPACE: 
                        case DIRECTORY: {
                            for (NamedElement nextNamedElement : toBeMovedRenamed) {
                                NamedElement nextExistingTarget = LanguageProviderRefactoringAdapter.this.getExisting(targetParent.getNamedElement(), nextNamedElement.getClass(), targetName);
                                if (nextExistingTarget != null) {
                                    if (LanguageProviderRefactoringAdapter.this.isPossibleMoveRefactoringTarget(toBeMovedRenamed, nextExistingTarget, refactorableToPossibleMoveRefactoringTargets, collidingInfo) == null) continue;
                                    LanguageProviderRefactoringAdapter.this.performCollisionCheckRecursively(nextNamedElement, nextExistingTarget, collidingInfo, elementType);
                                    continue;
                                }
                                MoveRenameElementCheck.checkRecursiveElement((IRecursiveElement)((Object)nextNamedElement), targetName, targetParent, new MoveRenameElementCheck.IConsumer(){

                                    @Override
                                    public void elementsInvalid(String info) {
                                        if (!($assertionsDisabled || info != null && info.length() > 0)) {
                                            throw new AssertionError((Object)"Parameter 'info' of method 'getCollsionValidator' must not be empty");
                                        }
                                        collidingInfo.add(info);
                                    }
                                });
                            }
                            break;
                        }
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)("Unhandled element type: " + String.valueOf((Object)elementType)));
                            }
                            break;
                        }
                    }
                    if (collidingInfo.isEmpty()) {
                        LanguageProviderRefactoringAdapter.this.checkAdditionalCollisions(elementType, toBeMovedRenamed, targetDirectory, targetParentName, targetName, collidingInfo, null);
                    }
                    collidingInfo.forEach(c -> validationResult.addError((String)c));
                }
                return validationResult;
            }

            @Override
            public ValidationResult isValid(RootDirectoryPath targetDirectory, String targetParentName) {
                if (!$assertionsDisabled && targetDirectory == null) {
                    throw new AssertionError((Object)"Parameter 'targetDirectory' of method 'isValid' must not be null");
                }
                if (!$assertionsDisabled && targetParentName == null) {
                    throw new AssertionError((Object)"Parameter 'targetParentName' of method 'isValid' must not be null");
                }
                ValidationResult validationResult = new ValidationResult(true);
                IRefactoringTarget targetParent = LanguageProviderRefactoringAdapter.this.getMoveToParent(targetDirectory, targetParentName);
                if (targetParent != null) {
                    TreeSet<String> collidingInfo = new TreeSet<String>();
                    if (elementType == MoveRenameRefactoringElementType.ELEMENT) {
                        if (LanguageProviderRefactoringAdapter.this.getLanguage().namespaceAndDirectoryStructureMatches()) {
                            for (IComponent nextComponent : targetParent.getNamedElement().getChildren(IComponent.class)) {
                                for (NamedElement next : toBeMovedRenamed) {
                                    NamedElement nextExistingTarget = LanguageProviderRefactoringAdapter.this.getExisting(nextComponent.getNamedElement(), next.getClass(), LanguageProviderRefactoringAdapter.this.getRelevantRenameName(next));
                                    if (nextExistingTarget == null) continue;
                                    collidingInfo.add("Colliding target type '" + nextExistingTarget.getShortName() + "'");
                                }
                            }
                        } else {
                            for (NamedElement next : toBeMovedRenamed) {
                                nextExistingTarget = LanguageProviderRefactoringAdapter.this.getExisting(targetParent.getNamedElement(), next.getClass(), LanguageProviderRefactoringAdapter.this.getRelevantRenameName(next));
                                if (nextExistingTarget == null) continue;
                                collidingInfo.add("Colliding target type '" + nextExistingTarget.getShortName() + "'");
                            }
                        }
                    } else if (elementType == MoveRenameRefactoringElementType.COMPONENT) {
                        for (NamedElement next : toBeMovedRenamed) {
                            nextExistingTarget = LanguageProviderRefactoringAdapter.this.getExisting(targetParent.getNamedElement(), next.getClass(), LanguageProviderRefactoringAdapter.this.getRelevantRenameName(next));
                            if (nextExistingTarget == null) continue;
                            collidingInfo.add("Colliding target component '" + nextExistingTarget.getShortName() + "'");
                        }
                    } else {
                        if (!$assertionsDisabled && elementType != MoveRenameRefactoringElementType.DIRECTORY && elementType != MoveRenameRefactoringElementType.NAMESPACE) {
                            throw new AssertionError((Object)("Unexpected refactoring element type in isValid() move: " + String.valueOf((Object)elementType)));
                        }
                        for (NamedElement nextNamedElement : toBeMovedRenamed) {
                            nextExistingTarget = LanguageProviderRefactoringAdapter.this.getExisting(targetParent.getNamedElement(), nextNamedElement.getClass(), LanguageProviderRefactoringAdapter.this.getRelevantRenameName(nextNamedElement));
                            if (nextExistingTarget == null) continue;
                            if (nextExistingTarget == nextNamedElement) {
                                collidingInfo.add("Colliding target '" + LanguageProviderRefactoringAdapter.this.getRelevantRenameName(nextNamedElement) + "'");
                                continue;
                            }
                            LanguageProviderRefactoringAdapter.this.performCollisionCheckRecursively(nextNamedElement, nextExistingTarget, collidingInfo, elementType);
                        }
                    }
                    if (collidingInfo.isEmpty()) {
                        Object cache = null;
                        for (NamedElement nextNamedElement : toBeMovedRenamed) {
                            cache = LanguageProviderRefactoringAdapter.this.checkAdditionalCollisions(elementType, Collections.singletonList(nextNamedElement), targetDirectory, targetParentName, LanguageProviderRefactoringAdapter.this.getRelevantRenameName(nextNamedElement), collidingInfo, cache);
                        }
                    }
                    collidingInfo.forEach(c -> validationResult.addError((String)c));
                }
                return validationResult;
            }
        };
    }

    final RefactoringData getMoveRenameRefactoringData(Workspace workspace, MoveRenameRefactoringInfo info, Map<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>> refactorableToPossibleMoveRefactoringTargets) {
        assert (workspace != null) : "Parameter 'workspace' of method 'getMoveRenameRefactoringData' must not be null";
        assert (info != null) : "Parameter 'info' of method 'getMoveRenameRefactoringData' must not be null";
        assert (refactorableToPossibleMoveRefactoringTargets != null) : "Parameter 'refactorableToPossibleMoveRefactoringTargets' of method 'getMoveRenameRefactoringData' must not be null";
        LOGGER.debug("Create move/rename refactoring data\n" + String.valueOf(info));
        List<NamedElement> namedElements = info.getElements();
        RootDirectoryPath rootDirectoryPath = namedElements.get(0).getParent(RootDirectoryPath.class, new Class[0]);
        assert (rootDirectoryPath != null) : "'rootDirectoryPath' of method 'getMoveRenameRefactoringData' must not be null";
        String moveToParentName = RefactoringUtilities.getMoveToParentName(namedElements, null, info.getRefactoringElementType(), this.getLanguage());
        String parentKind = RefactoringUtilities.getPhysicalRecursiveElementKind(info.getRefactoringElementType(), this.getLanguage());
        String parentImageResourceName = RefactoringUtilities.getPhysicalRecursiveElementImageResourceName(info.getRefactoringElementType(), this.getLanguage());
        String elementImageResourceName = namedElements.get(0).getImageResourceName();
        ICollisionValidator collisionValidator = this.getCollsionValidator(info.getRefactoringElementType(), namedElements, refactorableToPossibleMoveRefactoringTargets);
        RefactoringData data = switch (info.getRefactoringType()) {
            case RefactoringType.MOVE -> {
                Map<Module, List<RootDirectoryPath>> availableTargetRootDirectories = this.getAvailableTargetRootDirectories(workspace);
                yield new MoveRefactoringData(info, rootDirectoryPath, moveToParentName, collisionValidator, parentKind, parentImageResourceName, elementImageResourceName, availableTargetRootDirectories, RefactoringUtilities.getAvailableMoveToParentNames(availableTargetRootDirectories, info.getRefactoringElementType(), info.getLanguage()), this.getMoveToParentNameRefactoringValidator(namedElements, info.getRefactoringElementType()));
            }
            case RefactoringType.MOVE_RENAME -> {
                Map<Module, List<RootDirectoryPath>> availableTargetRootDirectories = this.getAvailableTargetRootDirectories(workspace);
                yield new MoveRenameRefactoringData(info, rootDirectoryPath, moveToParentName, collisionValidator, parentKind, parentImageResourceName, elementImageResourceName, availableTargetRootDirectories, RefactoringUtilities.getAvailableMoveToParentNames(availableTargetRootDirectories, info.getRefactoringElementType(), info.getLanguage()), this.getMoveToParentNameRefactoringValidator(namedElements, info.getRefactoringElementType()), this.getRenameRefactoringValidator(namedElements.get(0)), this.getRelevantRenameName(namedElements.get(0)));
            }
            case RefactoringType.RENAME -> new RenameRefactoringData(info, rootDirectoryPath, moveToParentName, collisionValidator, parentKind, parentImageResourceName, elementImageResourceName, this.getRenameRefactoringValidator(namedElements.get(0)), this.getRelevantRenameName(namedElements.get(0)));
            case RefactoringType.NONE, RefactoringType.DELETE -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Move/rename refactoring not possible");
                }
                yield null;
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unhandled refactoring type: " + String.valueOf((Object)info.getRefactoringType())));
                }
                yield null;
            }
        };
        LOGGER.debug("Create move/rename refactoring data - done: " + String.valueOf(data));
        return data;
    }
}

