/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.IssueFilter;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.DependencyToExcludedInternalComponent;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import java.util.ArrayList;
import java.util.List;

final class FinishModelVisitor
implements Module.IVisitor,
External.IVisitor {
    private final List<IComponent> m_excludedInternalComponents = new ArrayList<IComponent>();
    private final List<IComponent> m_externalComponents = new ArrayList<IComponent>();
    private final SoftwareSystem m_softwareSystem;
    private final LanguageProviderAccessor m_accessor;
    private final ProductionCodeFilter m_productionCodeFilter;
    private final IssueFilter m_issueFilter;
    private Module m_currentModule;
    private External m_external;

    private FinishModelVisitor(SoftwareSystem softwareSystem, LanguageProviderAccessor accessor, ProductionCodeFilter productionCodeFilter, IssueFilter issueFilter) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'FinishModelVisitor' must not be null";
        assert (accessor != null) : "Parameter 'accessor' of method 'FinishModelVisitor' must not be null";
        assert (productionCodeFilter != null) : "Parameter 'productionCodeFilter' of method 'FinishModelVisitor' must not be null";
        assert (issueFilter != null) : "Parameter 'issueFilter' of method 'FinishModelVisitor' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_accessor = accessor;
        this.m_productionCodeFilter = productionCodeFilter;
        this.m_issueFilter = issueFilter;
    }

    @Override
    public void visitChildrenOf(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'visitChildrenOf' must not be null";
        for (NamedElement next : namedElement.getChildren()) {
            next.accept(this);
        }
    }

    private void finishVisitingNamedElement(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'finishVisitingNamedElement' must not be null";
        namedElement.finishModification();
        NamedElement originalNamedElement = namedElement.getOriginal();
        if (originalNamedElement != namedElement) {
            originalNamedElement.finishModification();
        }
        this.visitChildrenOf(namedElement);
    }

    @Override
    public void visitNamedElement(NamedElement namedElement) {
        IBaseDirectory baseDirectory;
        FilePath filePath;
        assert (namedElement != null) : "Parameter 'namedElement' of method 'visitNamedElement' must not be null";
        if (namedElement instanceof IComponent) {
            IComponent component = (IComponent)((Object)namedElement);
            if (this.m_external != null) {
                this.m_externalComponents.add(component);
                this.m_external.incrementNumberOfComponents();
                component.setIgnoreIssues(false);
            } else {
                assert (this.m_currentModule != null) : "'m_currentModule' of method 'visitNamedElement' must not be null";
                assert (!component.isExternal()) : "Unexpected external component: " + String.valueOf(component);
                String workspaceFilterName = component.getWorkspaceFilterName();
                boolean excluded = !this.m_productionCodeFilter.includeComponent(workspaceFilterName);
                component.setIsExcluded(excluded);
                if (!excluded) {
                    this.m_currentModule.incrementNumberOfComponents();
                    this.m_softwareSystem.incrementNumberOfInternalComponents();
                    this.m_accessor.incrementSize(this.m_currentModule.getType().getLanguage(), component.getSize());
                    component.setIgnoreIssues(!this.m_issueFilter.includeComponent(workspaceFilterName));
                } else {
                    component.setIgnoreIssues(false);
                    this.m_excludedInternalComponents.add(component);
                }
            }
        }
        if (namedElement instanceof FilePath && !(filePath = (FilePath)namedElement).isArtificial() && (baseDirectory = filePath.getBaseDirectory()) instanceof RootDirectoryPath) {
            RootDirectoryPath nextOriginalRootDirectoryPath = (RootDirectoryPath)baseDirectory;
            RootDirectoryPath nextRepresentativeRootDirectoryPath = nextOriginalRootDirectoryPath.getRepresentative();
            nextOriginalRootDirectoryPath.incrementNumberOfFiles();
            if (nextOriginalRootDirectoryPath != nextRepresentativeRootDirectoryPath) {
                nextRepresentativeRootDirectoryPath.incrementNumberOfFiles();
            }
        }
        this.finishVisitingNamedElement(namedElement);
    }

    @Override
    public void visitModule(Module module) {
        assert (module != null) : "Parameter 'module' of method 'visitModule' must not be null";
        this.m_external = null;
        this.m_currentModule = module;
        this.finishVisitingNamedElement(module);
    }

    @Override
    public void visitExternal(External external) {
        assert (external != null) : "Parameter 'external' of method 'visitExternal' must not be null";
        this.m_currentModule = null;
        this.m_external = external;
        this.finishVisitingNamedElement(external);
    }

    List<IComponent> getExcludedInternalComponents() {
        return this.m_excludedInternalComponents;
    }

    List<IComponent> getExternalComponents() {
        return this.m_externalComponents;
    }

    static void reset(LanguageProviderAccessor accessor, SoftwareSystem softwareSystem) {
        assert (accessor != null) : "Parameter 'accessor' of method 'reset' must not be null";
        accessor.resetSizes();
        if (softwareSystem != null) {
            RootDirectoryPath nextOriginal;
            softwareSystem.getCurrentModel().removeElementIssues(CoreIssueId.DEPENDENCY_TO_EXCLUDED_INTERNAL_COMPONENT);
            softwareSystem.clearNumberOfInternalComponents();
            Workspace workspace = softwareSystem.getUniqueExistingChild(Workspace.class);
            workspace.getProductionCodeFilter().clear();
            workspace.getIssueFilter().clear();
            for (Module nextModule : workspace.getChildren(Module.class)) {
                nextModule.clearNumberOfComponents();
                for (RootDirectoryPath nextDirectory : nextModule.getChildren(RootDirectoryPath.class)) {
                    nextOriginal = nextDirectory.getOriginal();
                    nextOriginal.clearCounter();
                    if (nextOriginal == nextDirectory) continue;
                    nextDirectory.clearCounter();
                }
            }
            for (External nextExternal : workspace.getChildren(External.class)) {
                nextExternal.clearNumberOfComponents();
                for (RootDirectoryPath nextDirectory : nextExternal.getChildren(RootDirectoryPath.class)) {
                    nextOriginal = nextDirectory.getOriginal();
                    nextOriginal.clearCounter();
                    if (nextOriginal == nextDirectory) continue;
                    nextDirectory.clearCounter();
                }
            }
        }
    }

    static void process(SoftwareSystem softwareSystem, LanguageProviderAccessor accessor, IWorkerContext workerContext) {
        Object nextOriginal;
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'process' must not be null";
        assert (accessor != null) : "Parameter 'accessor' of method 'process' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'process' must not be null";
        Workspace workspace = softwareSystem.getUniqueExistingChild(Workspace.class);
        ProductionCodeFilter componentFilter = workspace.getProductionCodeFilter();
        IssueFilter issueFilter = workspace.getIssueFilter();
        accessor.resetSizes();
        softwareSystem.getCurrentModel().removeElementIssues(CoreIssueId.DEPENDENCY_TO_EXCLUDED_INTERNAL_COMPONENT);
        softwareSystem.initializeNumberOfInternalComponents();
        componentFilter.initialize();
        issueFilter.initialize();
        for (Module nextModule : workspace.getChildren(Module.class)) {
            nextModule.initializeNumberOfComponents();
            for (RootDirectoryPath nextDirectory : nextModule.getChildren(RootDirectoryPath.class)) {
                nextOriginal = nextDirectory.getOriginal();
                ((RootDirectoryPath)nextOriginal).initializeCounter();
                if (nextOriginal == nextDirectory) continue;
                nextDirectory.initializeCounter();
            }
        }
        for (External nextExternal : workspace.getChildren(External.class)) {
            nextExternal.initializeNumberOfComponents();
            for (RootDirectoryPath nextDirectory : nextExternal.getChildren(RootDirectoryPath.class)) {
                nextOriginal = nextDirectory.getOriginal();
                ((RootDirectoryPath)nextOriginal).initializeCounter();
                if (nextOriginal == nextDirectory) continue;
                nextDirectory.initializeCounter();
            }
        }
        FinishModelVisitor visitor = new FinishModelVisitor(softwareSystem, accessor, componentFilter, issueFilter);
        softwareSystem.getUniqueExistingChild(Workspace.class).accept(visitor);
        for (IComponent nextExcludedInternalComponent : visitor.getExcludedInternalComponents()) {
            for (ProgrammingElement nextProgrammingElement : nextExcludedInternalComponent.getNamedElement().getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                for (ParserDependency nextIncomingDependency : nextProgrammingElement.getIncomingDependencies(new IStandardEnumeration[0])) {
                    if (nextIncomingDependency.isExcluded()) continue;
                    nextIncomingDependency.addIssue(new DependencyToExcludedInternalComponent(nextIncomingDependency, "Component: " + nextExcludedInternalComponent.getWorkspaceFilterName()));
                }
            }
        }
        for (IComponent nextExternalComponent : visitor.getExternalComponents()) {
            boolean hasIncomingDependencies = false;
            boolean hasNonExcludedIncomingDependencies = false;
            for (ProgrammingElement nextProgrammingElement : nextExternalComponent.getNamedElement().getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                for (ParserDependency nextIncomingDependency : nextProgrammingElement.getIncomingDependencies(new IStandardEnumeration[0])) {
                    hasIncomingDependencies = true;
                    if (nextIncomingDependency.isExcluded()) continue;
                    hasNonExcludedIncomingDependencies = true;
                    break;
                }
                if (hasNonExcludedIncomingDependencies) break;
            }
            nextExternalComponent.setIsExcluded(hasIncomingDependencies && !hasNonExcludedIncomingDependencies);
        }
        for (LanguageProvider nextLanguageProvider : accessor.getLanguageProviders(softwareSystem.getUsedLanguages())) {
            nextLanguageProvider.workspaceFilterApplied(workerContext, softwareSystem);
        }
    }
}

