/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.base;

import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.foundation.utilities.Result;

public abstract class SoftwareSystemBasedCommand<T extends ICommandInteraction>
extends SonargraphCommand {
    private final T m_interaction;
    private final SoftwareSystem m_createdForSoftwareSystem;

    public SoftwareSystemBasedCommand(ISoftwareSystemProvider provider, T interaction) {
        super(provider);
        assert (provider.hasSoftwareSystem()) : "No system available";
        assert (interaction != null) : "Parameter 'interaction' of method 'SoftwareSystemBasedCommand' must not be null";
        this.m_interaction = interaction;
        this.m_createdForSoftwareSystem = provider.getSoftwareSystem();
        assert (this.m_createdForSoftwareSystem != null) : "'m_createdForSoftwareSystem' of method 'SoftwareSystemBasedCommand' must not be null";
    }

    @Override
    protected boolean isUndoable() {
        return true;
    }

    @Override
    public final INavigationState getNavigationState() {
        return this.m_interaction.getNavigationState();
    }

    protected final T getInteraction() {
        return this.m_interaction;
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return this.m_createdForSoftwareSystem;
    }

    private boolean isCreatedForSoftwareSystemInValidState() {
        return this.m_createdForSoftwareSystem.getState() != SoftwareSystemState.CLOSED && this.m_createdForSoftwareSystem.getState() != SoftwareSystemState.UNDEFINED;
    }

    @Override
    public Result isEnabled() {
        Result result = new Result();
        if (!this.getController().hasSoftwareSystem()) {
            result.addErrorMessage("No system available");
        } else if (this.getController().getSoftwareSystem() != this.m_createdForSoftwareSystem) {
            result.addErrorMessage("Command was created for different system");
        } else if (!this.isCreatedForSoftwareSystemInValidState()) {
            result.addErrorMessage("System is not in a valid 'Open' state");
        } else if (!SoftwareSystemBasedCommand.isAvailable(this.getId().getCategory(), this.m_createdForSoftwareSystem.getMode())) {
            result.addErrorMessage("Command not available '" + String.valueOf(this.getId()) + "' for system mode:" + String.valueOf((Object)this.m_createdForSoftwareSystem.getMode()));
        }
        return result;
    }
}

