/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewOperationExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DeleteOperationsCommand
extends ArchitecturalViewCommand<IDeleteOperationsInteraction> {
    public DeleteOperationsCommand(ISoftwareSystemProvider provider, IDeleteOperationsInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DELETE_ARCHITECTURAL_VIEW_OPERATIONS;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        DeleteOperationsData data = new DeleteOperationsData();
        if (!((IDeleteOperationsInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewOperationExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewOperationExtension.class);
        OperationResult result = extension.deleteOperations(workerContext, data.getOperations());
        ((IDeleteOperationsInteraction)this.getInteraction()).processDeleteOperationsResult(result);
    }

    public static final class DeleteOperationsData
    implements IArchitecturalViewCommandInteractionData {
        private List<ArchitecturalViewOperation> m_operations;

        DeleteOperationsData() {
        }

        public void setOperations(List<ArchitecturalViewOperation> operations) {
            assert (operations != null && !operations.isEmpty()) : "Parameter 'operations' of method 'setOperations' must not be empty";
            this.m_operations = new ArrayList<ArchitecturalViewOperation>(operations);
        }

        List<ArchitecturalViewOperation> getOperations() {
            assert (this.m_operations != null && !this.m_operations.isEmpty()) : "'m_operations' of method 'getOperations' must not be empty";
            return Collections.unmodifiableList(this.m_operations);
        }
    }

    public static interface IDeleteOperationsInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(DeleteOperationsData var1);

        public void processDeleteOperationsResult(OperationResult var1);
    }
}

