/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceProfileExtension;
import com.hello2morrow.sonargraph.core.model.system.FilterModification;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfilePattern;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.List;

public final class ModifyWorkspaceProfileCommand
extends SoftwareSystemBasedCommand<IModifyInteraction> {
    public static final ICommandId ID = CoreCommandId.MODIFY_WORKSPACE_PROFILE_PATTERN_BASED;

    public ModifyWorkspaceProfileCommand(ISoftwareSystemProvider provider, IModifyInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return ID;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        ModifyData data;
        IModifyInteraction interaction = (IModifyInteraction)this.getInteraction();
        if (!interaction.collect(data = new ModifyData())) {
            return;
        }
        IWorkspaceProfileExtension extension = this.getController().getSoftwareSystem().getExtension(IWorkspaceProfileExtension.class);
        interaction.processModificationResult(extension.modify(workerContext, data.getProfile(), data.getName(), data.getDescription(), data.getPatterns(), data.getFilters()));
    }

    public static interface IModifyInteraction
    extends ICommandInteraction {
        public boolean collect(ModifyData var1);

        public void processModificationResult(OperationResult var1);
    }

    public static final class ModifyData
    implements ICommandInteractionData {
        private WorkspaceProfile m_profile;
        private String m_name;
        private String m_description = "";
        private final List<IWorkspaceProfilePattern> m_patterns = new ArrayList<IWorkspaceProfilePattern>();
        private FilterModification m_filters;

        public void setProfile(WorkspaceProfile profile) {
            assert (profile != null) : "Parameter 'profile' of method 'setProfile' must not be null";
            this.m_profile = profile;
        }

        public WorkspaceProfile getProfile() {
            return this.m_profile;
        }

        public List<IWorkspaceProfilePattern> getPatterns() {
            return this.m_patterns;
        }

        public void setPatterns(List<IWorkspaceProfilePattern> patterns) {
            assert (patterns != null) : "Parameter 'patterns' of method 'setPatterns' must not be null";
            this.m_patterns.clear();
            this.m_patterns.addAll(patterns);
        }

        public void setFilters(FilterModification filters) {
            assert (filters != null) : "Parameter 'filters' of method 'setFilters' must not be null";
            this.m_filters = filters;
        }

        public FilterModification getFilters() {
            return this.m_filters;
        }

        public String getName() {
            return this.m_name;
        }

        public void setModifiedName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name;
        }

        public void setDescription(String description) {
            assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
            this.m_description = description;
        }

        public String getDescription() {
            return this.m_description;
        }
    }
}

