/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SimpleSoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Result;

public final class EditModuleCommand
extends SimpleSoftwareSystemBasedCommand {
    private final Module m_module;
    private final String m_description;
    private final String m_name;

    public EditModuleCommand(ISoftwareSystemProvider provider, SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction interaction, Module module, String name, String description) {
        super(provider, interaction);
        assert (module != null) : "Parameter 'module' of method 'EditModuleCommand' must not be null";
        assert (name != null) : "Parameter 'name' of method 'EditModuleCommand' must not be null";
        assert (description != null) : "Parameter 'description' of method 'EditModuleCommand' must not be null";
        this.m_module = module;
        this.m_name = name;
        this.m_description = description;
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.EDIT_MODULE;
    }

    @Override
    public Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isSuccess() && this.m_module.getName().equals(this.m_name) && this.m_module.getDescription().equals(this.m_description)) {
            enabled.addErrorMessage("Neither name nor description changed");
        }
        return enabled;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        OperationResult result = this.getSoftwareSystem().getExtension(IWorkspaceExtension.class).editModule(workerContext, this.m_module, this.m_name, this.m_description);
        ((SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction)this.getInteraction()).process(result);
    }
}

