/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceProfileExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DeleteWorkspaceProfileCommand
extends SoftwareSystemBasedCommand<IDeleteInteraction> {
    public DeleteWorkspaceProfileCommand(ISoftwareSystemProvider provider, IDeleteInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DELETE_WORKSPACE_PROFILE;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        DeleteData data;
        IDeleteInteraction deleteInteraction = (IDeleteInteraction)this.getInteraction();
        if (!deleteInteraction.collect(data = new DeleteData())) {
            return;
        }
        SoftwareSystem softwareSystem = this.getController().getSoftwareSystem();
        IWorkspaceProfileExtension profileExtension = softwareSystem.getExtension(IWorkspaceProfileExtension.class);
        List<WorkspaceProfile> profiles = data.getProfiles();
        assert (profiles != null && !profiles.isEmpty()) : "'profiles' of method 'internalRun' must not be empty";
        StringBuilder question = new StringBuilder();
        question.append("Deleting workspace profiles cannot be undone.").append(StringUtility.LINE_SEPARATOR).append(StringUtility.LINE_SEPARATOR).append("Do you want to continue?");
        if (!deleteInteraction.confirmDeletion(question.toString())) {
            return;
        }
        deleteInteraction.processDeleteResult(profileExtension.delete(workerContext, profiles));
    }

    public static final class DeleteData
    implements ICommandInteractionData {
        private final List<WorkspaceProfile> m_profiles = new ArrayList<WorkspaceProfile>();

        public void addProfile(WorkspaceProfile profile) {
            assert (profile != null) : "Parameter 'profile' of method 'setProfile' must not be null";
            assert (!this.m_profiles.contains(profile)) : "Already added: " + String.valueOf(profile);
            this.m_profiles.add(profile);
        }

        public List<WorkspaceProfile> getProfiles() {
            return Collections.unmodifiableList(this.m_profiles);
        }
    }

    public static interface IDeleteInteraction
    extends ICommandInteraction {
        public boolean collect(DeleteData var1);

        public void processDeleteResult(OperationResult var1);

        public boolean confirmDeletion(String var1);
    }
}

