/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.system.base.DynamicCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IDependenciesExtension;
import com.hello2morrow.sonargraph.core.model.context.ContextParserDependencyCollector;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CollectParserDependenciesCommand
extends DynamicCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectParserDependenciesCommand.class);
    private final IContext m_context;
    private final Element m_element;
    private ContextParserDependencyCollector m_result;

    public CollectParserDependenciesCommand(ISoftwareSystemProvider provider, IContext context, Element element) {
        super(provider);
        assert (context != null) : "Parameter 'context' of method 'CollectParserDependenciesCommand' must not be null";
        assert (element != null) : "Parameter 'element' of method 'CollectParserDependenciesCommand' must not be null";
        this.m_context = context;
        this.m_element = element;
    }

    @Override
    public final Result isEnabled() {
        Result result = super.isEnabled();
        if (result.isSuccess() && !this.m_element.isValid()) {
            result.addErrorMessage("Element is not valid");
        }
        return result;
    }

    protected abstract ContextParserDependencyCollector collect(IDependenciesExtension var1, IWorkerContext var2, IContext var3, Element var4);

    @Override
    protected final void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        LOGGER.debug("Execute '" + this.getClass().getSimpleName() + "'");
        this.m_result = this.collect(this.getSoftwareSystem().getExtension(IDependenciesExtension.class), workerContext, this.m_context, this.m_element);
        LOGGER.debug("Execute '" + this.getClass().getSimpleName() + "' - done" + (workerContext.hasBeenCanceled() ? " [cancelled]" : ""));
    }

    public final ContextParserDependencyCollector getResult() {
        return this.m_result;
    }
}

